/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementAction;
import com.intellij.codeInsight.lookup.impl.LookupCellRenderer;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.ui.popup.ClosableByLeftArrow;
import com.intellij.util.ui.EmptyIcon;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class LookupActionsStep
extends BaseListPopupStep<LookupElementAction>
implements ClosableByLeftArrow {
    private final LookupImpl myLookup;
    private final LookupElement myLookupElement;
    private final Icon myEmptyIcon;

    public LookupActionsStep(Collection<LookupElementAction> actions, LookupImpl lookup, LookupElement lookupElement) {
        super(null, new ArrayList<LookupElementAction>(actions));
        this.myLookup = lookup;
        this.myLookupElement = lookupElement;
        int w = 0;
        int h = 0;
        for (LookupElementAction action : actions) {
            Icon icon = action.getIcon();
            if (icon == null) continue;
            w = Math.max(w, icon.getIconWidth());
            h = Math.max(h, icon.getIconHeight());
        }
        this.myEmptyIcon = new EmptyIcon(w, h);
    }

    public PopupStep onChosen(LookupElementAction selectedValue, boolean finalChoice) {
        LookupElementAction.Result result = selectedValue.performLookupAction();
        if (result == LookupElementAction.Result.HIDE_LOOKUP) {
            this.myLookup.hideLookup(true);
        } else if (result == LookupElementAction.Result.REFRESH_ITEM) {
            this.myLookup.updateLookupWidth(this.myLookupElement);
            this.myLookup.requestResize();
            this.myLookup.refreshUi(false, true);
        } else if (result instanceof LookupElementAction.Result.ChooseItem) {
            this.myLookup.setCurrentItem(((LookupElementAction.Result.ChooseItem)result).item);
            CommandProcessor.getInstance().executeCommand(this.myLookup.getProject(), new Runnable(){

                @Override
                public void run() {
                    LookupActionsStep.this.myLookup.finishLookup('\u0000');
                }
            }, null, null);
        }
        return FINAL_CHOICE;
    }

    public Icon getIconFor(LookupElementAction aValue) {
        return LookupCellRenderer.augmentIcon(aValue.getIcon(), this.myEmptyIcon);
    }

    @NotNull
    public String getTextFor(LookupElementAction value) {
        String string = value.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/lookup/impl/LookupActionsStep", "getTextFor"));
        }
        return string;
    }
}

