/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.impl.TemplateContext;
import com.intellij.codeInsight.template.impl.TemplateOptionalProcessor;
import com.intellij.codeInsight.template.impl.TemplateTextLexer;
import com.intellij.codeInsight.template.impl.TemplateTokenType;
import com.intellij.codeInsight.template.impl.Variable;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.SchemeElement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateImpl
extends Template
implements SchemeElement {
    private String myKey;
    private String myString;
    private String myDescription;
    private String myGroupName;
    private char myShortcutChar;
    private final ArrayList<Variable> myVariables;
    private ArrayList<Segment> mySegments;
    private String myTemplateText;
    private String myId;
    private boolean isToReformat;
    private boolean isToShortenLongNames;
    private boolean toParseSegments;
    private TemplateContext myTemplateContext;
    @NonNls
    public static final String END = "END";
    @NonNls
    public static final String SELECTION = "SELECTION";
    @NonNls
    public static final String SELECTION_START = "SELECTION_START";
    @NonNls
    public static final String SELECTION_END = "SELECTION_END";
    @NonNls
    public static final String ARG = "ARG";
    public static final Set<String> INTERNAL_VARS_SET = new HashSet<String>(Arrays.asList("END", "SELECTION", "SELECTION_START", "SELECTION_END"));
    private boolean isDeactivated;
    private boolean isToIndent;
    private boolean myIsInline;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TemplateImpl)) {
            return false;
        }
        TemplateImpl template = (TemplateImpl)o;
        if (this.myId != null && template.myId != null && this.myId.equals(template.myId)) {
            return true;
        }
        if (this.isToReformat != template.isToReformat) {
            return false;
        }
        if (this.isToShortenLongNames != template.isToShortenLongNames) {
            return false;
        }
        if (this.myShortcutChar != template.myShortcutChar) {
            return false;
        }
        if (this.myDescription != null ? !this.myDescription.equals(template.myDescription) : template.myDescription != null) {
            return false;
        }
        if (this.myGroupName != null ? !this.myGroupName.equals(template.myGroupName) : template.myGroupName != null) {
            return false;
        }
        if (this.myKey != null ? !this.myKey.equals(template.myKey) : template.myKey != null) {
            return false;
        }
        if (this.myString != null ? !this.myString.equals(template.myString) : template.myString != null) {
            return false;
        }
        if (this.myTemplateText != null ? !this.myTemplateText.equals(template.myTemplateText) : template.myTemplateText != null) {
            return false;
        }
        if (!new HashSet<Variable>(this.myVariables).equals(new HashSet<Variable>(template.myVariables))) {
            return false;
        }
        return this.isDeactivated == template.isDeactivated;
    }

    public int hashCode() {
        if (this.myId != null) {
            return this.myId.hashCode();
        }
        int result = this.myKey.hashCode();
        result = 29 * result + (this.myString == null ? 0 : this.myString.hashCode());
        result = 29 * result + this.myGroupName.hashCode();
        return result;
    }

    public boolean isInline() {
        return this.myIsInline;
    }

    @Override
    public void setInline(boolean isInline) {
        this.myIsInline = isInline;
    }

    public TemplateImpl(@NotNull String key, @NotNull String group) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInsight/template/impl/TemplateImpl", "<init>"));
        }
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/codeInsight/template/impl/TemplateImpl", "<init>"));
        }
        this(key, null, group);
        this.toParseSegments = false;
        this.myTemplateText = "";
        this.mySegments = new ArrayList();
    }

    public TemplateImpl(@NotNull String key, String string, @NotNull String group) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInsight/template/impl/TemplateImpl", "<init>"));
        }
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/codeInsight/template/impl/TemplateImpl", "<init>"));
        }
        this.myString = null;
        this.myShortcutChar = (char)68;
        this.myVariables = new ArrayList();
        this.mySegments = null;
        this.myTemplateText = null;
        this.isToReformat = false;
        this.isToShortenLongNames = true;
        this.toParseSegments = true;
        this.myTemplateContext = new TemplateContext();
        this.isDeactivated = false;
        this.isToIndent = true;
        this.myIsInline = false;
        this.myKey = key;
        this.myString = string;
        this.myGroupName = group;
    }

    @Override
    public void addTextSegment(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/template/impl/TemplateImpl", "addTextSegment"));
        }
        text = StringUtil.convertLineSeparators((String)text);
        this.myTemplateText = this.myTemplateText + text;
    }

    @Override
    public void addVariableSegment(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInsight/template/impl/TemplateImpl", "addVariableSegment"));
        }
        this.mySegments.add(new Segment(name, this.myTemplateText.length()));
    }

    @Override
    public Variable addVariable(Expression expression, boolean isAlwaysStopAt) {
        return this.addVariable("__Variable" + this.myVariables.size(), expression, isAlwaysStopAt);
    }

    @Override
    public Variable addVariable(@NotNull String name, Expression expression, Expression defaultValueExpression, boolean isAlwaysStopAt, boolean skipOnStart) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInsight/template/impl/TemplateImpl", "addVariable"));
        }
        if (this.mySegments != null) {
            Segment segment = new Segment(name, this.myTemplateText.length());
            this.mySegments.add(segment);
        }
        Variable variable = new Variable(name, expression, defaultValueExpression, isAlwaysStopAt, skipOnStart);
        this.myVariables.add(variable);
        return variable;
    }

    @Override
    public void addEndVariable() {
        Segment segment = new Segment(END, this.myTemplateText.length());
        this.mySegments.add(segment);
    }

    @Override
    public void addSelectionStartVariable() {
        Segment segment = new Segment(SELECTION_START, this.myTemplateText.length());
        this.mySegments.add(segment);
    }

    @Override
    public void addSelectionEndVariable() {
        Segment segment = new Segment(SELECTION_END, this.myTemplateText.length());
        this.mySegments.add(segment);
    }

    @Override
    public String getId() {
        return this.myId;
    }

    @NotNull
    public TemplateImpl copy() {
        TemplateImpl template = new TemplateImpl(this.myKey, this.myString, this.myGroupName);
        template.resetFrom(this);
        TemplateImpl templateImpl = template;
        if (templateImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/impl/TemplateImpl", "copy"));
        }
        return templateImpl;
    }

    public void resetFrom(TemplateImpl another) {
        this.removeAllParsed();
        this.toParseSegments = another.toParseSegments;
        this.myKey = another.getKey();
        this.myString = another.myString;
        this.myTemplateText = another.myTemplateText;
        this.myGroupName = another.myGroupName;
        this.myId = another.myId;
        this.myDescription = another.myDescription;
        this.myShortcutChar = another.myShortcutChar;
        this.isToReformat = another.isToReformat;
        this.isToShortenLongNames = another.isToShortenLongNames;
        this.myIsInline = another.myIsInline;
        this.myTemplateContext = another.myTemplateContext.createCopy();
        this.isDeactivated = another.isDeactivated;
        for (Template.Property property : Template.Property.values()) {
            boolean value = another.getValue(property);
            if (value == Template.getDefaultValue(property)) continue;
            this.setValue(property, value);
        }
        for (Variable variable : another.myVariables) {
            this.addVariable(variable.getName(), variable.getExpressionString(), variable.getDefaultValueString(), variable.isAlwaysStopAt());
        }
    }

    @Override
    public boolean isToReformat() {
        return this.isToReformat;
    }

    @Override
    public void setToReformat(boolean toReformat) {
        this.isToReformat = toReformat;
    }

    @Override
    public void setToIndent(boolean toIndent) {
        this.isToIndent = toIndent;
    }

    public boolean isToIndent() {
        return this.isToIndent;
    }

    @Override
    public boolean isToShortenLongNames() {
        return this.isToShortenLongNames;
    }

    @Override
    public void setToShortenLongNames(boolean toShortenLongNames) {
        this.isToShortenLongNames = toShortenLongNames;
    }

    public void setDeactivated(boolean isDeactivated) {
        this.isDeactivated = isDeactivated;
    }

    public boolean isDeactivated() {
        return this.isDeactivated;
    }

    public TemplateContext getTemplateContext() {
        return this.myTemplateContext;
    }

    public int getEndSegmentNumber() {
        return this.getVariableSegmentNumber(END);
    }

    public int getSelectionStartSegmentNumber() {
        return this.getVariableSegmentNumber(SELECTION_START);
    }

    public int getSelectionEndSegmentNumber() {
        return this.getVariableSegmentNumber(SELECTION_END);
    }

    public int getVariableSegmentNumber(String variableName) {
        this.parseSegments();
        for (int i = 0; i < this.mySegments.size(); ++i) {
            Segment segment = this.mySegments.get(i);
            if (!segment.name.equals(variableName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String getTemplateText() {
        this.parseSegments();
        return this.myTemplateText;
    }

    @Override
    public String getSegmentName(int i) {
        this.parseSegments();
        return this.mySegments.get((int)i).name;
    }

    @Override
    public int getSegmentOffset(int i) {
        this.parseSegments();
        return this.mySegments.get((int)i).offset;
    }

    @Override
    public int getSegmentsCount() {
        this.parseSegments();
        return this.mySegments.size();
    }

    public void parseSegments() {
        IElementType tokenType;
        if (!this.toParseSegments) {
            return;
        }
        if (this.mySegments != null) {
            return;
        }
        if (this.myString == null) {
            this.myString = "";
        }
        this.myString = StringUtil.convertLineSeparators((String)this.myString);
        this.mySegments = new ArrayList();
        StringBuilder buffer = new StringBuilder("");
        TemplateTextLexer lexer = new TemplateTextLexer();
        lexer.start(this.myString);
        while ((tokenType = lexer.getTokenType()) != null) {
            int start = lexer.getTokenStart();
            int end = lexer.getTokenEnd();
            String token = this.myString.substring(start, end);
            if (tokenType == TemplateTokenType.VARIABLE) {
                String name = token.substring(1, token.length() - 1);
                Segment segment = new Segment(name, buffer.length());
                this.mySegments.add(segment);
            } else if (tokenType == TemplateTokenType.ESCAPE_DOLLAR) {
                buffer.append("$");
            } else {
                buffer.append(token);
            }
            lexer.advance();
        }
        this.myTemplateText = buffer.toString();
    }

    public void removeAllParsed() {
        this.myVariables.clear();
        this.mySegments = null;
    }

    @Override
    public Variable addVariable(@NotNull String name, String expression, String defaultValue, boolean isAlwaysStopAt) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInsight/template/impl/TemplateImpl", "addVariable"));
        }
        Variable variable = new Variable(name, expression, defaultValue, isAlwaysStopAt);
        this.myVariables.add(variable);
        return variable;
    }

    public void removeVariable(int i) {
        this.myVariables.remove(i);
    }

    public int getVariableCount() {
        return this.myVariables.size();
    }

    public String getVariableNameAt(int i) {
        return this.myVariables.get(i).getName();
    }

    public String getExpressionStringAt(int i) {
        return this.myVariables.get(i).getExpressionString();
    }

    public Expression getExpressionAt(int i) {
        return this.myVariables.get(i).getExpression();
    }

    public String getDefaultValueStringAt(int i) {
        return this.myVariables.get(i).getDefaultValueString();
    }

    public Expression getDefaultValueAt(int i) {
        return this.myVariables.get(i).getDefaultValueExpression();
    }

    public boolean isAlwaysStopAt(int i) {
        return this.myVariables.get(i).isAlwaysStopAt();
    }

    @Override
    public String getKey() {
        return this.myKey;
    }

    public void setKey(String key) {
        this.myKey = key;
    }

    public String getString() {
        this.parseSegments();
        return this.myString;
    }

    public void setString(String string) {
        this.myString = string;
    }

    @Override
    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(String description) {
        this.myDescription = description;
    }

    public char getShortcutChar() {
        return this.myShortcutChar;
    }

    public void setShortcutChar(char shortcutChar) {
        this.myShortcutChar = shortcutChar;
    }

    public String getGroupName() {
        return this.myGroupName;
    }

    public void setGroupName(@NotNull String groupName) {
        if (groupName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupName", "com/intellij/codeInsight/template/impl/TemplateImpl", "setGroupName"));
        }
        this.myGroupName = groupName;
    }

    public boolean isSelectionTemplate() {
        this.parseSegments();
        for (Segment v : this.mySegments) {
            if (!SELECTION.equals(v.name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasArgument() {
        for (Variable v : this.myVariables) {
            if (!v.getName().equals(ARG)) continue;
            return true;
        }
        return false;
    }

    public void setId(@Nullable String id) {
        this.myId = id;
    }

    public Map<TemplateOptionalProcessor, Boolean> createOptions() {
        LinkedHashMap<TemplateOptionalProcessor, Boolean> context = new LinkedHashMap<TemplateOptionalProcessor, Boolean>();
        for (TemplateOptionalProcessor processor2 : (TemplateOptionalProcessor[])Extensions.getExtensions(TemplateOptionalProcessor.EP_NAME)) {
            context.put(processor2, processor2.isEnabled(this));
        }
        return context;
    }

    public TemplateContext createContext() {
        return this.getTemplateContext().createCopy();
    }

    public boolean contextsEqual(TemplateImpl defaultTemplate) {
        return this.getTemplateContext().getDifference(defaultTemplate.getTemplateContext()).isEmpty();
    }

    public void applyOptions(Map<TemplateOptionalProcessor, Boolean> context) {
        for (Map.Entry<TemplateOptionalProcessor, Boolean> entry : context.entrySet()) {
            entry.getKey().setEnabled(this, entry.getValue());
        }
    }

    public void applyContext(TemplateContext context) {
        this.myTemplateContext = context.createCopy();
    }

    public boolean skipOnStart(int i) {
        return this.myVariables.get(i).skipOnStart();
    }

    public ArrayList<Variable> getVariables() {
        return this.myVariables;
    }

    public String toString() {
        return this.myGroupName + "/" + this.myKey;
    }

    private static class Segment {
        public final String name;
        public final int offset;

        private Segment(@NotNull String name, int offset) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInsight/template/impl/TemplateImpl$Segment", "<init>"));
            }
            this.name = name;
            this.offset = offset;
        }
    }
}

