/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.unwrap;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.unwrap.LanguageUnwrappers;
import com.intellij.codeInsight.unwrap.ScopeHighlighter;
import com.intellij.codeInsight.unwrap.UnwrapDescriptor;
import com.intellij.codeInsight.unwrap.Unwrapper;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.ui.components.JBList;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;

public class UnwrapHandler
implements CodeInsightActionHandler {
    public static final int HIGHLIGHTER_LEVEL = 6001;

    public boolean startInWriteAction() {
        return true;
    }

    public void invoke(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/unwrap/UnwrapHandler", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/unwrap/UnwrapHandler", "invoke"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/unwrap/UnwrapHandler", "invoke"));
        }
        if (!CodeInsightUtilBase.prepareEditorForWrite(editor)) {
            return;
        }
        List<AnAction> options = this.collectOptions(project2, editor, file2);
        this.selectOption(options, editor, file2);
    }

    private List<AnAction> collectOptions(Project project2, Editor editor, PsiFile file2) {
        ArrayList<AnAction> result = new ArrayList<AnAction>();
        UnwrapDescriptor d = UnwrapHandler.getUnwrapDescription(file2);
        for (Pair<PsiElement, Unwrapper> each : d.collectUnwrappers(project2, editor, file2)) {
            result.add(this.createUnwrapAction((Unwrapper)each.getSecond(), (PsiElement)each.getFirst(), editor, project2));
        }
        return result;
    }

    private static UnwrapDescriptor getUnwrapDescription(PsiFile file2) {
        return (UnwrapDescriptor)LanguageUnwrappers.INSTANCE.forLanguage(file2.getLanguage());
    }

    private AnAction createUnwrapAction(Unwrapper u, PsiElement el, Editor ed, Project p) {
        return new MyUnwrapAction(p, ed, u, el);
    }

    protected void selectOption(List<AnAction> options, Editor editor, PsiFile file2) {
        if (options.isEmpty()) {
            return;
        }
        if (!UnwrapHandler.getUnwrapDescription(file2).showOptionsDialog() || ApplicationManager.getApplication().isUnitTestMode()) {
            options.get(0).actionPerformed(null);
            return;
        }
        this.showPopup(options, editor);
    }

    private void showPopup(final List<AnAction> options, Editor editor) {
        final ScopeHighlighter highlighter = new ScopeHighlighter(editor);
        DefaultListModel<String> m = new DefaultListModel<String>();
        for (AnAction a : options) {
            m.addElement(((MyUnwrapAction)a).getName());
        }
        JBList list = new JBList(m);
        list.setSelectionMode(0);
        list.setVisibleRowCount(options.size());
        list.addListSelectionListener(new ListSelectionListener((JList)list, options, highlighter){
            final /* synthetic */ JList val$list;
            final /* synthetic */ List val$options;
            final /* synthetic */ ScopeHighlighter val$highlighter;
            {
                this.val$list = jList;
                this.val$options = list;
                this.val$highlighter = scopeHighlighter;
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = this.val$list.getSelectedIndex();
                if (index < 0) {
                    return;
                }
                MyUnwrapAction a = (MyUnwrapAction)((Object)this.val$options.get(index));
                ArrayList<PsiElement> toExtract = new ArrayList<PsiElement>();
                PsiElement wholeRange = a.collectAffectedElements(toExtract);
                this.val$highlighter.highlight(wholeRange, toExtract);
            }
        });
        PopupChooserBuilder builder = JBPopupFactory.getInstance().createListPopupBuilder((JList)list);
        builder.setTitle(CodeInsightBundle.message((String)"unwrap.popup.title", (Object[])new Object[0])).setMovable(false).setResizable(false).setRequestFocus(true).setItemChoosenCallback(new Runnable((JList)list){
            final /* synthetic */ JList val$list;
            {
                this.val$list = jList;
            }

            @Override
            public void run() {
                MyUnwrapAction a = (MyUnwrapAction)((Object)options.get(this.val$list.getSelectedIndex()));
                a.actionPerformed(null);
            }
        }).addListener((JBPopupListener)new JBPopupAdapter(){

            public void onClosed(LightweightWindowEvent event) {
                highlighter.dropHighlight();
            }
        });
        JBPopup popup = builder.createPopup();
        popup.showInBestPositionFor(editor);
    }

    public static TextAttributes getTestAttributesForExtract() {
        EditorColorsManager manager = EditorColorsManager.getInstance();
        return manager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
    }

    private static class MyUnwrapAction
    extends AnAction {
        private static final Key<Integer> CARET_POS_KEY = new Key("UNWRAP_HANDLER_CARET_POSITION");
        private final Project myProject;
        private final Editor myEditor;
        private final Unwrapper myUnwrapper;
        private final PsiElement myElement;

        public MyUnwrapAction(Project project2, Editor editor, Unwrapper unwrapper, PsiElement element) {
            super(unwrapper.getDescription(element));
            this.myProject = project2;
            this.myEditor = editor;
            this.myUnwrapper = unwrapper;
            this.myElement = element;
        }

        public void actionPerformed(AnActionEvent e) {
            final PsiFile file2 = this.myElement.getContainingFile();
            if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
                return;
            }
            CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                UnwrapDescriptor d = UnwrapHandler.getUnwrapDescription(file2);
                                if (d.shouldTryToRestoreCaretPosition()) {
                                    MyUnwrapAction.this.saveCaretPosition(file2);
                                }
                                int scrollOffset = MyUnwrapAction.this.myEditor.getScrollingModel().getVerticalScrollOffset();
                                List<PsiElement> extractedElements = MyUnwrapAction.this.myUnwrapper.unwrap(MyUnwrapAction.this.myEditor, MyUnwrapAction.this.myElement);
                                if (d.shouldTryToRestoreCaretPosition()) {
                                    MyUnwrapAction.this.restoreCaretPosition(file2);
                                }
                                MyUnwrapAction.this.myEditor.getScrollingModel().scrollVertically(scrollOffset);
                                MyUnwrapAction.this.highlightExtractedElements(extractedElements);
                            }
                            catch (IncorrectOperationException ex) {
                                throw new RuntimeException(ex);
                            }
                        }
                    });
                }
            }, null, (Object)this.myEditor.getDocument());
        }

        private void saveCaretPosition(PsiFile file2) {
            int offset = this.myEditor.getCaretModel().getOffset();
            PsiElement el = file2.findElementAt(offset);
            int innerOffset = offset - el.getTextOffset();
            el.putCopyableUserData(CARET_POS_KEY, (Object)innerOffset);
        }

        private void restoreCaretPosition(PsiFile file2) {
            ((TreeElement)file2.getNode()).acceptTree(new RecursiveTreeElementWalkingVisitor(){

                @Override
                protected void visitNode(TreeElement element) {
                    PsiElement el = element.getPsi();
                    Integer offset = (Integer)el.getCopyableUserData(CARET_POS_KEY);
                    if (offset != null) {
                        MyUnwrapAction.this.myEditor.getCaretModel().moveToOffset(el.getTextOffset() + offset);
                        el.putCopyableUserData(CARET_POS_KEY, null);
                        return;
                    }
                    super.visitNode(element);
                }
            });
        }

        private void highlightExtractedElements(List<PsiElement> extractedElements) {
            for (PsiElement each : extractedElements) {
                HighlightManager.getInstance((Project)this.myProject).addRangeHighlight(this.myEditor, each.getTextOffset(), each.getTextOffset() + each.getTextLength(), UnwrapHandler.getTestAttributesForExtract(), false, true, null);
            }
        }

        public String getName() {
            return this.myUnwrapper.getDescription(this.myElement);
        }

        public PsiElement collectAffectedElements(List<PsiElement> toExtract) {
            return this.myUnwrapper.collectAffectedElements(this.myElement, toExtract);
        }
    }
}

