/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerMessageImpl;
import com.intellij.compiler.CompilerWorkspaceConfiguration;
import com.intellij.compiler.ProblemsView;
import com.intellij.compiler.impl.CompositeScope;
import com.intellij.compiler.impl.ProjectCompileScope;
import com.intellij.compiler.progress.CompilerTask;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.compiler.ex.CompileContextEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.pom.Navigatable;
import com.intellij.util.containers.HashMap;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompileContextImpl
extends UserDataHolderBase
implements CompileContextEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.impl.CompileContextImpl");
    private final Project myProject;
    private final CompilerTask myBuildSession;
    private final Map<CompilerMessageCategory, Collection<CompilerMessage>> myMessages;
    private final boolean myShouldUpdateProblemsView;
    private CompileScope myCompileScope;
    private final boolean myMake;
    private final boolean myIsRebuild;
    private final boolean myIsAnnotationProcessorsEnabled;
    private boolean myRebuildRequested;
    private String myRebuildReason;
    private final Map<VirtualFile, Module> myRootToModuleMap;
    private final Map<Module, Set<VirtualFile>> myModuleToRootsMap;
    private final Set<VirtualFile> myGeneratedTestRoots;
    private final ProjectFileIndex myProjectFileIndex;
    private final ProjectCompileScope myProjectCompileScope;
    private final long myStartCompilationStamp;
    private final UUID mySessionId;
    private final Map<Module, VirtualFile[]> myModuleToRootsCache;

    public CompileContextImpl(@NotNull Project project2, @NotNull CompilerTask compilerSession, @NotNull CompileScope compileScope, boolean isMake, boolean isRebuild) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/compiler/impl/CompileContextImpl", "<init>"));
        }
        if (compilerSession == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerSession", "com/intellij/compiler/impl/CompileContextImpl", "<init>"));
        }
        if (compileScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compileScope", "com/intellij/compiler/impl/CompileContextImpl", "<init>"));
        }
        this.myMessages = new EnumMap<CompilerMessageCategory, Collection<CompilerMessage>>(CompilerMessageCategory.class);
        this.myRootToModuleMap = new HashMap();
        this.myModuleToRootsMap = new HashMap();
        this.myGeneratedTestRoots = new HashSet<VirtualFile>();
        this.mySessionId = UUID.randomUUID();
        this.myModuleToRootsCache = new HashMap();
        this.myProject = project2;
        this.myBuildSession = compilerSession;
        this.myCompileScope = compileScope;
        this.myMake = isMake;
        this.myIsRebuild = isRebuild;
        this.myStartCompilationStamp = System.currentTimeMillis();
        this.myProjectFileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        this.myProjectCompileScope = new ProjectCompileScope(this.myProject);
        this.myIsAnnotationProcessorsEnabled = CompilerConfiguration.getInstance((Project)project2).isAnnotationProcessorsEnabled();
        Object sessionId = ExecutionManagerImpl.EXECUTION_SESSION_ID_KEY.get((UserDataHolder)compileScope);
        if (sessionId != null) {
            compilerSession.setSessionId(sessionId);
        }
        CompilerWorkspaceConfiguration workspaceConfig = CompilerWorkspaceConfiguration.getInstance((Project)this.myProject);
        this.myShouldUpdateProblemsView = workspaceConfig.MAKE_PROJECT_ON_SAVE;
    }

    @NotNull
    public CompilerTask getBuildSession() {
        CompilerTask compilerTask = this.myBuildSession;
        if (compilerTask == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/CompileContextImpl", "getBuildSession"));
        }
        return compilerTask;
    }

    public boolean shouldUpdateProblemsView() {
        return this.myShouldUpdateProblemsView;
    }

    public long getStartCompilationStamp() {
        return this.myStartCompilationStamp;
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/CompileContextImpl", "getProject"));
        }
        return project2;
    }

    public CompilerMessage[] getMessages(CompilerMessageCategory category) {
        Collection<CompilerMessage> collection = this.myMessages.get(category);
        if (collection == null) {
            return CompilerMessage.EMPTY_ARRAY;
        }
        return collection.toArray(new CompilerMessage[collection.size()]);
    }

    public void addMessage(CompilerMessageCategory category, String message, String url, int lineNum, int columnNum) {
        CompilerMessageImpl msg = new CompilerMessageImpl(this.myProject, category, message, CompileContextImpl.findFileByUrl(url), lineNum, columnNum, null);
        this.addMessage(msg);
    }

    public void addMessage(CompilerMessageCategory category, String message, String url, int lineNum, int columnNum, Navigatable navigatable) {
        CompilerMessageImpl msg = new CompilerMessageImpl(this.myProject, category, message, CompileContextImpl.findFileByUrl(url), lineNum, columnNum, navigatable);
        this.addMessage(msg);
    }

    @Nullable
    private static VirtualFile findFileByUrl(@Nullable String url) {
        if (url == null) {
            return null;
        }
        VirtualFile file2 = VirtualFileManager.getInstance().findFileByUrl(url);
        if (file2 == null) {
            return VirtualFileManager.getInstance().refreshAndFindFileByUrl(url);
        }
        return file2;
    }

    @Override
    public void addMessage(CompilerMessage msg) {
        Collection<CompilerMessage> messages;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.info("addMessage: " + msg + " this=" + this);
        }
        if ((messages = this.myMessages.get(msg.getCategory())) == null) {
            messages = new LinkedHashSet<CompilerMessage>();
            this.myMessages.put(msg.getCategory(), messages);
        }
        if (messages.add(msg)) {
            this.myBuildSession.addMessage(msg);
        }
        if (this.myShouldUpdateProblemsView && msg.getCategory() == CompilerMessageCategory.ERROR) {
            ProblemsView.SERVICE.getInstance(this.myProject).addMessage(msg, this.mySessionId);
        }
    }

    public int getMessageCount(CompilerMessageCategory category) {
        if (category != null) {
            Collection<CompilerMessage> collection = this.myMessages.get(category);
            return collection != null ? collection.size() : 0;
        }
        int count = 0;
        for (Collection<CompilerMessage> collection : this.myMessages.values()) {
            if (collection == null) continue;
            count += collection.size();
        }
        return count;
    }

    public CompileScope getCompileScope() {
        return this.myCompileScope;
    }

    public CompileScope getProjectCompileScope() {
        return this.myProjectCompileScope;
    }

    public void requestRebuildNextTime(String message) {
        if (!this.myRebuildRequested) {
            this.myRebuildRequested = true;
            this.myRebuildReason = message;
        }
    }

    public boolean isRebuildRequested() {
        return this.myRebuildRequested;
    }

    @Nullable
    public String getRebuildReason() {
        return this.myRebuildReason;
    }

    @NotNull
    public ProgressIndicator getProgressIndicator() {
        ProgressIndicator progressIndicator = this.myBuildSession.getIndicator();
        if (progressIndicator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/CompileContextImpl", "getProgressIndicator"));
        }
        return progressIndicator;
    }

    public Module getModuleByFile(VirtualFile file2) {
        Module module2 = this.myProjectFileIndex.getModuleForFile(file2);
        if (module2 != null) {
            LOG.assertTrue(!module2.isDisposed());
            return module2;
        }
        for (VirtualFile root : this.myRootToModuleMap.keySet()) {
            if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file2, (boolean)false)) continue;
            Module mod = this.myRootToModuleMap.get(root);
            if (mod != null) {
                LOG.assertTrue(!mod.isDisposed());
            }
            return mod;
        }
        return null;
    }

    public VirtualFile[] getSourceRoots(Module module2) {
        VirtualFile[] cachedRoots = this.myModuleToRootsCache.get(module2);
        if (cachedRoots != null) {
            if (CompileContextImpl.areFilesValid(cachedRoots)) {
                return cachedRoots;
            }
            this.myModuleToRootsCache.remove(module2);
        }
        Set<VirtualFile> additionalRoots = this.myModuleToRootsMap.get(module2);
        VirtualFile[] moduleRoots = ModuleRootManager.getInstance((Module)module2).getSourceRoots();
        if (additionalRoots == null || additionalRoots.isEmpty()) {
            this.myModuleToRootsCache.put(module2, moduleRoots);
            return moduleRoots;
        }
        VirtualFile[] allRoots = new VirtualFile[additionalRoots.size() + moduleRoots.length];
        System.arraycopy(moduleRoots, 0, allRoots, 0, moduleRoots.length);
        int index = moduleRoots.length;
        for (VirtualFile additionalRoot : additionalRoots) {
            allRoots[index++] = additionalRoot;
        }
        this.myModuleToRootsCache.put(module2, allRoots);
        return allRoots;
    }

    private static boolean areFilesValid(VirtualFile[] files) {
        for (VirtualFile file2 : files) {
            if (file2.isValid()) continue;
            return false;
        }
        return true;
    }

    public VirtualFile getModuleOutputDirectory(Module module2) {
        return CompilerPaths.getModuleOutputDirectory((Module)module2, (boolean)false);
    }

    public VirtualFile getModuleOutputDirectoryForTests(Module module2) {
        return CompilerPaths.getModuleOutputDirectory((Module)module2, (boolean)true);
    }

    public boolean isMake() {
        return this.myMake;
    }

    public boolean isRebuild() {
        return this.myIsRebuild;
    }

    public boolean isAnnotationProcessorsEnabled() {
        return this.myIsAnnotationProcessorsEnabled;
    }

    @Override
    public void addScope(CompileScope additionalScope) {
        this.myCompileScope = new CompositeScope(this.myCompileScope, additionalScope);
    }

    @Override
    public boolean isInTestSourceContent(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "com/intellij/compiler/impl/CompileContextImpl", "isInTestSourceContent"));
        }
        if (this.myProjectFileIndex.isInTestSourceContent(fileOrDir)) {
            return true;
        }
        return VfsUtilCore.isUnder((VirtualFile)fileOrDir, this.myGeneratedTestRoots);
    }

    @Override
    public boolean isInSourceContent(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "com/intellij/compiler/impl/CompileContextImpl", "isInSourceContent"));
        }
        if (this.myProjectFileIndex.isInSourceContent(fileOrDir)) {
            return true;
        }
        return VfsUtilCore.isUnder((VirtualFile)fileOrDir, this.myRootToModuleMap.keySet());
    }

    public UUID getSessionId() {
        return this.mySessionId;
    }
}

