/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.FileBasedStorageKt;
import com.intellij.configurationStore.StateMap;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.configurationStore.XmlElementStorage;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtilKt;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.LineSeparator;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001:\u0001)BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\b\u0010\u001f\u001a\u0004\u0018\u00010\u0011J\n\u0010 \u001a\u0004\u0018\u00010!H\u0014J\u0012\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0002J\u001a\u0010\u0015\u001a\u00020#2\b\u0010&\u001a\u0004\u0018\u00010\u00112\b\u0010'\u001a\u0004\u0018\u00010\u0003J\b\u0010(\u001a\u00020\u0005H\u0016R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u00118\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00038\u0006@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u000fX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/configurationStore/FileBasedStorage;", "Lcom/intellij/configurationStore/XmlElementStorage;", "file", "Ljava/io/File;", "fileSpec", "", "rootElementName", "pathMacroManager", "Lcom/intellij/openapi/components/TrackingPathMacroSubstitutor;", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "provider", "Lcom/intellij/configurationStore/StreamProvider;", "(Ljava/io/File;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/components/TrackingPathMacroSubstitutor;Lcom/intellij/openapi/components/RoamingType;Lcom/intellij/configurationStore/StreamProvider;)V", "blockSavingTheContent", "", "cachedVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "<set-?>", "getFile", "()Ljava/io/File;", "setFile", "(Ljava/io/File;)V", "isUseXmlProlog", "()Z", "lineSeparator", "Lcom/intellij/util/LineSeparator;", "createSaveSession", "Lcom/intellij/configurationStore/FileBasedStorage$FileSaveSession;", "states", "Lcom/intellij/configurationStore/StateMap;", "getVirtualFile", "loadLocalData", "Lorg/jdom/Element;", "processReadException", "", "e", "Ljava/lang/Exception;", "virtualFile", "ioFileIfChanged", "toString", "FileSaveSession", "configuration-store-impl"})
@KotlinClass(version={1, 1, 0}, data={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001:\u0001)BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\b\u0010\u001f\u001a\u0004\u0018\u00010\u0011J\n\u0010 \u001a\u0004\u0018\u00010!H\u0014J\u0012\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0002J\u001a\u0010\u0015\u001a\u00020#2\b\u0010&\u001a\u0004\u0018\u00010\u00112\b\u0010'\u001a\u0004\u0018\u00010\u0003J\b\u0010(\u001a\u00020\u0005H\u0016R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u00118\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00038\u0006@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u000fX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, strings={"Lcom/intellij/configurationStore/FileBasedStorage;", "Lcom/intellij/configurationStore/XmlElementStorage;", "file", "Ljava/io/File;", "fileSpec", "", "rootElementName", "pathMacroManager", "Lcom/intellij/openapi/components/TrackingPathMacroSubstitutor;", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "provider", "Lcom/intellij/configurationStore/StreamProvider;", "(Ljava/io/File;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/components/TrackingPathMacroSubstitutor;Lcom/intellij/openapi/components/RoamingType;Lcom/intellij/configurationStore/StreamProvider;)V", "blockSavingTheContent", "", "cachedVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "<set-?>", "getFile", "()Ljava/io/File;", "setFile", "(Ljava/io/File;)V", "isUseXmlProlog", "()Z", "lineSeparator", "Lcom/intellij/util/LineSeparator;", "createSaveSession", "Lcom/intellij/configurationStore/FileBasedStorage$FileSaveSession;", "states", "Lcom/intellij/configurationStore/StateMap;", "getVirtualFile", "loadLocalData", "Lorg/jdom/Element;", "processReadException", "", "e", "Ljava/lang/Exception;", "virtualFile", "ioFileIfChanged", "toString", "FileSaveSession", "configuration-store-impl"})
public class FileBasedStorage
extends XmlElementStorage {
    private volatile VirtualFile cachedVirtualFile;
    private LineSeparator lineSeparator;
    private boolean blockSavingTheContent;
    @NotNull
    private volatile File file;
    private final boolean isUseXmlProlog = false;

    @NotNull
    public final File getFile() {
        return this.file;
    }

    private final void setFile(File file2) {
        this.file = file2;
    }

    protected boolean isUseXmlProlog() {
        return this.isUseXmlProlog;
    }

    public final void setFile(@Nullable VirtualFile virtualFile, @Nullable File ioFileIfChanged) {
        this.cachedVirtualFile = virtualFile;
        if (ioFileIfChanged != null) {
            this.file = ioFileIfChanged;
        }
    }

    @Override
    @NotNull
    protected FileSaveSession createSaveSession(@NotNull StateMap states) {
        Intrinsics.checkParameterIsNotNull((Object)states, (String)"states");
        return new FileSaveSession(states, this);
    }

    @Nullable
    public final VirtualFile getVirtualFile() {
        VirtualFile result = this.cachedVirtualFile;
        if (result == null) {
            this.cachedVirtualFile = result = LocalFileSystem.getInstance().findFileByIoFile(this.file);
        }
        return this.cachedVirtualFile;
    }

    @Override
    @Nullable
    protected Element loadLocalData() {
        block6: {
            this.blockSavingTheContent = false;
            try {
                VirtualFile file2 = this.getVirtualFile();
                if (file2 == null || file2.isDirectory() || !file2.isValid()) {
                    Logger $receiver$iv = ComponentStoreImplKt.getLOG();
                    if ($receiver$iv.isDebugEnabled()) {
                        Logger logger = $receiver$iv;
                        String string = "Document was not loaded for " + this.getFileSpec() + " file is " + (file2 == null ? "null" : "directory");
                        logger.debug(string);
                    }
                    break block6;
                }
                if (file2.getLength() == 0L) {
                    this.processReadException(null);
                    break block6;
                }
                CharBuffer charBuffer = CharsetToolkit.UTF8_CHARSET.decode(ByteBuffer.wrap(file2.contentsToByteArray()));
                CharSequence charSequence = charBuffer;
                Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"charBuffer");
                this.lineSeparator = FileBasedStorageKt.detectLineSeparators(charSequence, this.isUseXmlProlog() ? (LineSeparator)null : LineSeparator.LF);
                return JDOMUtil.loadDocument((CharSequence)charBuffer).detachRootElement();
            }
            catch (JDOMException e) {
                this.processReadException((Exception)((Object)e));
            }
            catch (IOException e) {
                this.processReadException(e);
            }
        }
        return null;
    }

    private final void processReadException(Exception e) {
        boolean contentTruncated = e == null;
        boolean bl = this.blockSavingTheContent = !contentTruncated && (FileBasedStorageKt.isProjectOrModuleFile(this.getFileSpec()) || Intrinsics.areEqual((Object)this.getFileSpec(), (Object)"$WORKSPACE_FILE$"));
        if (!ApplicationManager.getApplication().isUnitTestMode() && !ApplicationManager.getApplication().isHeadlessEnvironment()) {
            String string;
            if (e != null) {
                ComponentStoreImplKt.getLOG().info((Throwable)e);
            }
            StringBuilder stringBuilder = new StringBuilder().append("Cannot load settings from file '").append(this.file).append("': ");
            if (contentTruncated) {
                string = "content truncated";
            } else {
                Exception exception = e;
                if (exception == null) {
                    Intrinsics.throwNpe();
                }
                string = exception.getMessage();
            }
            new Notification("System Messages", "Load Settings", stringBuilder.append(string).append("\n").append(this.blockSavingTheContent ? "Please correct the file content" : "File content will be recreated").toString(), NotificationType.WARNING).notify((Project)null);
        }
    }

    @NotNull
    public String toString() {
        return FileUtilKt.getSystemIndependentPath(this.file);
    }

    public FileBasedStorage(@NotNull File file2, @NotNull String fileSpec, @NotNull String rootElementName, @Nullable TrackingPathMacroSubstitutor pathMacroManager, @Nullable RoamingType roamingType, @Nullable StreamProvider provider) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkParameterIsNotNull((Object)rootElementName, (String)"rootElementName");
        super(fileSpec, rootElementName, pathMacroManager, roamingType, provider);
        this.file = file2;
        if (ApplicationManager.getApplication().isUnitTestMode() && StringsKt.startsWith$default((CharSequence)file2.getPath(), (char)'$', (boolean)false, (int)2, null)) {
            throw (Throwable)((Object)new AssertionError((Object)("It seems like some macros were not expanded for path: " + file2)));
        }
    }

    public /* synthetic */ FileBasedStorage(File file2, String string, String string2, TrackingPathMacroSubstitutor trackingPathMacroSubstitutor, RoamingType roamingType, StreamProvider streamProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            trackingPathMacroSubstitutor = null;
        }
        if ((n & 0x10) != 0) {
            roamingType = null;
        }
        if ((n & 0x20) != 0) {
            streamProvider = null;
        }
        this(file2, string, string2, trackingPathMacroSubstitutor, roamingType, streamProvider);
    }

    public static final /* synthetic */ void access$setBlockSavingTheContent$p(FileBasedStorage $this, boolean bl) {
        $this.blockSavingTheContent = bl;
    }

    @NotNull
    public static final /* synthetic */ File access$getFile$p(FileBasedStorage $this) {
        return $this.file;
    }

    public static final /* synthetic */ void access$setFile$p(FileBasedStorage $this, @NotNull File file2) {
        $this.file = file2;
    }

    @Nullable
    public static final /* synthetic */ VirtualFile access$getCachedVirtualFile$p(FileBasedStorage $this) {
        return $this.cachedVirtualFile;
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0014\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0014\u00a8\u0006\f"}, d2={"Lcom/intellij/configurationStore/FileBasedStorage$FileSaveSession;", "Lcom/intellij/configurationStore/XmlElementStorage$XmlElementStorageSaveSession;", "Lcom/intellij/configurationStore/FileBasedStorage;", "storageData", "Lcom/intellij/configurationStore/StateMap;", "storage", "(Lcom/intellij/configurationStore/StateMap;Lcom/intellij/configurationStore/FileBasedStorage;)V", "save", "", "saveLocally", "element", "Lorg/jdom/Element;", "configuration-store-impl"})
    @KotlinClass(version={1, 1, 0}, data={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0014\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0014\u00a8\u0006\f"}, strings={"Lcom/intellij/configurationStore/FileBasedStorage$FileSaveSession;", "Lcom/intellij/configurationStore/XmlElementStorage$XmlElementStorageSaveSession;", "Lcom/intellij/configurationStore/FileBasedStorage;", "storageData", "Lcom/intellij/configurationStore/StateMap;", "storage", "(Lcom/intellij/configurationStore/StateMap;Lcom/intellij/configurationStore/FileBasedStorage;)V", "save", "", "saveLocally", "element", "Lorg/jdom/Element;", "configuration-store-impl"})
    protected static class FileSaveSession
    extends XmlElementStorage.XmlElementStorageSaveSession<FileBasedStorage> {
        @Override
        public void save() {
            if (!((FileBasedStorage)this.getStorage()).blockSavingTheContent) {
                super.save();
            }
        }

        @Override
        protected void saveLocally(@Nullable Element element) {
            if (((FileBasedStorage)this.getStorage()).lineSeparator == null) {
                LineSeparator lineSeparator;
                FileBasedStorage fileBasedStorage = (FileBasedStorage)this.getStorage();
                if (((FileBasedStorage)this.getStorage()).isUseXmlProlog()) {
                    lineSeparator = LineSeparator.LF;
                } else {
                    LineSeparator lineSeparator2 = LineSeparator.getSystemLineSeparator();
                    lineSeparator = lineSeparator2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)lineSeparator2, (String)"LineSeparator.getSystemLineSeparator()");
                }
                fileBasedStorage.lineSeparator = lineSeparator;
            }
            VirtualFile virtualFile = ((FileBasedStorage)this.getStorage()).getVirtualFile();
            if (element == null) {
                FileBasedStorageKt.access$deleteFile(((FileBasedStorage)this.getStorage()).getFile(), this, virtualFile);
                ((FileBasedStorage)this.getStorage()).cachedVirtualFile = null;
            } else {
                LineSeparator lineSeparator;
                FileBasedStorage fileBasedStorage = (FileBasedStorage)this.getStorage();
                File file2 = ((FileBasedStorage)this.getStorage()).getFile();
                if (((FileBasedStorage)this.getStorage()).isUseXmlProlog()) {
                    lineSeparator = ((FileBasedStorage)this.getStorage()).lineSeparator;
                    if (lineSeparator == null) {
                        Intrinsics.throwNpe();
                    }
                } else {
                    lineSeparator = LineSeparator.LF;
                }
                fileBasedStorage.cachedVirtualFile = FileBasedStorageKt.writeFile(file2, this, virtualFile, element, lineSeparator, ((FileBasedStorage)this.getStorage()).isUseXmlProlog());
            }
        }

        public FileSaveSession(@NotNull StateMap storageData, @NotNull FileBasedStorage storage2) {
            Intrinsics.checkParameterIsNotNull((Object)storageData, (String)"storageData");
            Intrinsics.checkParameterIsNotNull((Object)storage2, (String)"storage");
            super(storageData, (XmlElementStorage)storage2);
        }
    }
}

