/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.SmartList;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.io.NoSuchFileException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u001a1\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\u0010\u0010\u001a\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u0012\u0010\u0015\u001a\n \u0016*\u0004\u0018\u00010\u00010\u0001*\u00020\u0001\u001a\f\u0010\u0017\u001a\u00020\u0012*\u00020\u0001H\u0002\u001a\f\u0010\u0018\u001a\u00020\u0019*\u00020\u0001H\u0002\u001a\u0014\u0010\u001a\u001a\n \u0016*\u0004\u0018\u00010\u001b0\u001b*\u00020\u0001H\u0002\u001a\f\u0010\u001c\u001a\u00020\u0019*\u00020\u0001H\u0002\u001a\u0014\u0010\u001d\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006 "}, d2={"nameFile", "Ljava/nio/file/Path;", "Lcom/intellij/openapi/components/impl/stores/IProjectStore;", "getNameFile", "(Lcom/intellij/openapi/components/impl/stores/IProjectStore;)Ljava/nio/file/Path;", "composeWsPath", "", "filePath", "selectDefaultStorages", "", "Lcom/intellij/openapi/components/Storage;", "storages", "operation", "Lcom/intellij/openapi/components/StateStorageOperation;", "scheme", "Lcom/intellij/openapi/components/StorageScheme;", "([Lcom/intellij/openapi/components/Storage;Lcom/intellij/openapi/components/StateStorageOperation;Lcom/intellij/openapi/components/StorageScheme;)[Lcom/intellij/openapi/components/Storage;", "useOldWorkspaceContent", "", "ws", "Ljava/io/File;", "createDirectories", "kotlin.jvm.PlatformType", "delete", "exists", "", "inputStream", "Ljava/io/InputStream;", "isDirectory", "write", "data", "", "configuration-store-impl"})
@KotlinFileFacade(version={1, 1, 0}, data={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u001a1\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\u0010\u0010\u001a\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u0012\u0010\u0015\u001a\n \u0016*\u0004\u0018\u00010\u00010\u0001*\u00020\u0001\u001a\f\u0010\u0017\u001a\u00020\u0012*\u00020\u0001H\u0002\u001a\f\u0010\u0018\u001a\u00020\u0019*\u00020\u0001H\u0002\u001a\u0014\u0010\u001a\u001a\n \u0016*\u0004\u0018\u00010\u001b0\u001b*\u00020\u0001H\u0002\u001a\f\u0010\u001c\u001a\u00020\u0019*\u00020\u0001H\u0002\u001a\u0014\u0010\u001d\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006 "}, strings={"nameFile", "Ljava/nio/file/Path;", "Lcom/intellij/openapi/components/impl/stores/IProjectStore;", "getNameFile", "(Lcom/intellij/openapi/components/impl/stores/IProjectStore;)Ljava/nio/file/Path;", "composeWsPath", "", "filePath", "selectDefaultStorages", "", "Lcom/intellij/openapi/components/Storage;", "storages", "operation", "Lcom/intellij/openapi/components/StateStorageOperation;", "scheme", "Lcom/intellij/openapi/components/StorageScheme;", "([Lcom/intellij/openapi/components/Storage;Lcom/intellij/openapi/components/StateStorageOperation;Lcom/intellij/openapi/components/StorageScheme;)[Lcom/intellij/openapi/components/Storage;", "useOldWorkspaceContent", "", "ws", "Ljava/io/File;", "createDirectories", "kotlin.jvm.PlatformType", "delete", "exists", "", "inputStream", "Ljava/io/InputStream;", "isDirectory", "write", "data", "", "configuration-store-impl"})
public final class ProjectStoreImplKt {
    @NotNull
    public static final Path getNameFile(IProjectStore $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Path path = Paths.get($receiver.getProjectBasePath(), ".idea", ".name");
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"Paths.get(projectBasePat\u2026R, ProjectImpl.NAME_FILE)");
        return path;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Storage[] selectDefaultStorages(@NotNull Storage[] storages, @NotNull StateStorageOperation operation, @NotNull StorageScheme scheme) {
        Intrinsics.checkParameterIsNotNull((Object)storages, (String)"storages");
        Intrinsics.checkParameterIsNotNull((Object)operation, (String)"operation");
        Intrinsics.checkParameterIsNotNull((Object)scheme, (String)"scheme");
        if (operation == StateStorageOperation.READ) {
            void $receiver$iv;
            SmartList result = new SmartList();
            IntProgression intProgression = RangesKt.reversed((IntProgression)((IntProgression)ArraysKt.getIndices((Object[])storages)));
            int n = intProgression.getFirst();
            int n2 = intProgression.getLast();
            int n3 = intProgression.getStep();
            int n4 = n;
            int n5 = n2;
            if (n3 > 0 ? n4 <= n5 : n4 >= n5) {
                while (true) {
                    void i;
                    Storage storage2;
                    if (Intrinsics.areEqual((Object)(storage2 = storages[i]).scheme(), (Object)scheme)) {
                        result.add((Object)storage2);
                    }
                    if (i == n2) break;
                    i += n3;
                }
            }
            for (n2 = 0; n2 < storages.length; ++n2) {
                Storage storage3 = storages[n2];
                if (!Intrinsics.areEqual((Object)storage3.scheme(), (Object)StorageScheme.DEFAULT) || result.contains((Object)storage3)) continue;
                result.add((Object)storage3);
            }
            Collection storage3 = (Collection)result;
            Collection thisCollection$iv = (Collection)$receiver$iv;
            Storage[] storageArray = thisCollection$iv.toArray(new Storage[thisCollection$iv.size()]);
            if (storageArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            return (Storage[])((Object[])storageArray);
        }
        if (Intrinsics.areEqual((Object)operation, (Object)StateStorageOperation.WRITE)) {
            void $receiver$iv;
            Object storage4;
            int thisCollection$iv;
            SmartList result = new SmartList();
            for (thisCollection$iv = 0; thisCollection$iv < storages.length; ++thisCollection$iv) {
                storage4 = storages[thisCollection$iv];
                if (!Intrinsics.areEqual((Object)storage4.scheme(), (Object)scheme)) continue;
                result.add(storage4);
            }
            if (result.isEmpty()) {
                for (thisCollection$iv = 0; thisCollection$iv < storages.length; ++thisCollection$iv) {
                    storage4 = storages[thisCollection$iv];
                    if (!Intrinsics.areEqual((Object)storage4.scheme(), (Object)StorageScheme.DEFAULT)) continue;
                    result.add(storage4);
                }
            }
            storage4 = (Collection)result;
            Collection thisCollection$iv2 = (Collection)$receiver$iv;
            Storage[] storageArray = thisCollection$iv2.toArray(new Storage[thisCollection$iv2.size()]);
            if (storageArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            return (Storage[])((Object[])storageArray);
        }
        return (Storage[])((Object[])new Storage[0]);
    }

    private static final String composeWsPath(String filePath) {
        return FileUtilRt.getNameWithoutExtension((String)filePath) + ".iws";
    }

    private static final void useOldWorkspaceContent(String filePath, File ws) {
        File oldWs = new File(ProjectStoreImplKt.composeWsPath(filePath));
        if (!oldWs.exists()) {
            return;
        }
        try {
            FileUtil.copyContent((File)oldWs, (File)ws);
        }
        catch (IOException e) {
            ComponentStoreImplKt.getLOG().error((Throwable)e);
        }
    }

    private static final boolean exists(Path $receiver) {
        return Files.exists($receiver, new LinkOption[0]);
    }

    private static final boolean isDirectory(Path $receiver) {
        return Files.isDirectory($receiver, new LinkOption[0]);
    }

    private static final InputStream inputStream(Path $receiver) {
        return Files.newInputStream($receiver, new OpenOption[0]);
    }

    public static final Path createDirectories(Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Files.createDirectories($receiver, new FileAttribute[0]);
    }

    private static final Path write(Path $receiver, byte[] data) {
        Path path = $receiver.getParent();
        Path path2 = path != null ? ProjectStoreImplKt.createDirectories(path) : null;
        Path path3 = Files.write($receiver, data, new OpenOption[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)path3, (String)"Files.write(this, data)");
        return path3;
    }

    private static final void delete(Path $receiver) {
        try {
            Files.delete($receiver);
        }
        catch (NoSuchFileException ignored) {
        }
        catch (Exception e) {
            FileUtil.delete((File)$receiver.toFile());
        }
    }

    @NotNull
    public static final /* synthetic */ String access$composeWsPath(@NotNull String filePath) {
        return ProjectStoreImplKt.composeWsPath(filePath);
    }

    public static final /* synthetic */ void access$useOldWorkspaceContent(@NotNull String filePath, @NotNull File ws) {
        ProjectStoreImplKt.useOldWorkspaceContent(filePath, ws);
    }

    public static final /* synthetic */ boolean access$exists(Path $receiver) {
        return ProjectStoreImplKt.exists($receiver);
    }

    public static final /* synthetic */ InputStream access$inputStream(Path $receiver) {
        return ProjectStoreImplKt.inputStream($receiver);
    }

    public static final /* synthetic */ void access$delete(Path $receiver) {
        ProjectStoreImplKt.delete($receiver);
    }

    public static final /* synthetic */ boolean access$isDirectory(Path $receiver) {
        return ProjectStoreImplKt.isDirectory($receiver);
    }

    @NotNull
    public static final /* synthetic */ Path access$write(Path $receiver, @NotNull byte[] data) {
        return ProjectStoreImplKt.write($receiver, data);
    }
}

