/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.SchemeManagerFactoryBase;
import com.intellij.configurationStore.SchemeManagerFactoryImplKt;
import com.intellij.configurationStore.SchemeManagerImpl;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.SettingsSavingComponent;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.options.SchemesManagerFactory;
import com.intellij.openapi.project.Project;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.CompoundRuntimeException;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b6\u0018\u00002\u00020\u00012\u00020\u0002:\u0002%&B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016JD\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u0002H\u00160\u0014\"\b\b\u0000\u0010\u0015*\u00020\u000b\"\b\b\u0001\u0010\u0016*\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00112\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00160\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 H&J&\u0010!\u001a\u00020\"2\u001e\u0010\u0018\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u0012\u0004\u0012\u00020\"0#J\u0006\u0010$\u001a\u00020\"R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007Rj\u0010\b\u001a^\u0012$\u0012\"\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f \r*\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\n0\n \r*-\u0012$\u0012\"\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f \r*\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\n0\n0\u000f\u00a2\u0006\u0002\b\u000e0\t\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/configurationStore/SchemeManagerFactoryBase;", "Lcom/intellij/openapi/options/SchemesManagerFactory;", "Lcom/intellij/openapi/components/SettingsSavingComponent;", "()V", "componentManager", "Lcom/intellij/openapi/components/ComponentManager;", "getComponentManager", "()Lcom/intellij/openapi/components/ComponentManager;", "managers", "", "Lcom/intellij/configurationStore/SchemeManagerImpl;", "Lcom/intellij/openapi/options/Scheme;", "Lcom/intellij/openapi/options/ExternalizableScheme;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "checkPath", "", "originalPath", "createSchemesManager", "Lcom/intellij/openapi/options/SchemesManager;", "T", "E", "directoryName", "processor", "Lcom/intellij/openapi/options/SchemeProcessor;", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "pathToFile", "Ljava/io/File;", "path", "storageManager", "Lcom/intellij/openapi/components/impl/stores/StateStorageManager;", "process", "", "Lkotlin/Function1;", "save", "ApplicationSchemeManagerFactory", "ProjectSchemeManagerFactory", "configuration-store-impl"})
@KotlinClass(version={1, 1, 0}, data={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b6\u0018\u00002\u00020\u00012\u00020\u0002:\u0002%&B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016JD\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u0002H\u00160\u0014\"\b\b\u0000\u0010\u0015*\u00020\u000b\"\b\b\u0001\u0010\u0016*\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00112\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00160\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 H&J&\u0010!\u001a\u00020\"2\u001e\u0010\u0018\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u0012\u0004\u0012\u00020\"0#J\u0006\u0010$\u001a\u00020\"R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007Rj\u0010\b\u001a^\u0012$\u0012\"\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f \r*\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\n0\n \r*-\u0012$\u0012\"\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f \r*\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\n0\n0\u000f\u00a2\u0006\u0002\b\u000e0\t\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, strings={"Lcom/intellij/configurationStore/SchemeManagerFactoryBase;", "Lcom/intellij/openapi/options/SchemesManagerFactory;", "Lcom/intellij/openapi/components/SettingsSavingComponent;", "()V", "componentManager", "Lcom/intellij/openapi/components/ComponentManager;", "getComponentManager", "()Lcom/intellij/openapi/components/ComponentManager;", "managers", "", "Lcom/intellij/configurationStore/SchemeManagerImpl;", "Lcom/intellij/openapi/options/Scheme;", "Lcom/intellij/openapi/options/ExternalizableScheme;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "checkPath", "", "originalPath", "createSchemesManager", "Lcom/intellij/openapi/options/SchemesManager;", "T", "E", "directoryName", "processor", "Lcom/intellij/openapi/options/SchemeProcessor;", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "pathToFile", "Ljava/io/File;", "path", "storageManager", "Lcom/intellij/openapi/components/impl/stores/StateStorageManager;", "process", "", "Lkotlin/Function1;", "save", "ApplicationSchemeManagerFactory", "ProjectSchemeManagerFactory", "configuration-store-impl"})
public abstract class SchemeManagerFactoryBase
extends SchemesManagerFactory
implements SettingsSavingComponent {
    private final List<SchemeManagerImpl<Scheme, ExternalizableScheme>> managers = ContainerUtil.createLockFreeCopyOnWriteList();

    @NotNull
    public abstract ComponentManager getComponentManager();

    @NotNull
    public final <T extends Scheme, E extends ExternalizableScheme> SchemesManager<T, E> createSchemesManager(@NotNull String directoryName, @NotNull SchemeProcessor<E> processor2, @NotNull RoamingType roamingType) {
        Intrinsics.checkParameterIsNotNull((Object)directoryName, (String)"directoryName");
        Intrinsics.checkParameterIsNotNull(processor2, (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
        StateStorageManager storageManager2 = ServiceKt.getStateStore(this.getComponentManager()).getStateStorageManager();
        String path = this.checkPath(directoryName);
        StateStorageManager stateStorageManager = storageManager2;
        if (!(stateStorageManager instanceof StateStorageManagerImpl)) {
            stateStorageManager = null;
        }
        StateStorageManagerImpl stateStorageManagerImpl = (StateStorageManagerImpl)stateStorageManager;
        StreamProvider streamProvider = stateStorageManagerImpl != null ? stateStorageManagerImpl.getStreamProvider() : null;
        StateStorageManager stateStorageManager2 = storageManager2;
        Intrinsics.checkExpressionValueIsNotNull((Object)stateStorageManager2, (String)"storageManager");
        SchemeManagerImpl manager = new SchemeManagerImpl(path, processor2, streamProvider, this.pathToFile(path, stateStorageManager2), roamingType, (Disposable)this.getComponentManager());
        this.managers.add(manager);
        return manager;
    }

    @NotNull
    public String checkPath(@NotNull String originalPath) {
        Intrinsics.checkParameterIsNotNull((Object)originalPath, (String)"originalPath");
        checkPath.1 error$ = checkPath.1.INSTANCE;
        if (StringsKt.contains$default((CharSequence)originalPath, (char)'\\', (boolean)false, (int)2, null)) {
            error$.invoke("Path must be system-independent, use forward slash instead of backslash");
        } else if (StringsKt.isEmpty((CharSequence)originalPath)) {
            error$.invoke("Path must not be empty");
        }
        return originalPath;
    }

    @NotNull
    public abstract File pathToFile(@NotNull String var1, @NotNull StateStorageManager var2);

    public final void process(@NotNull Function1<? super SchemeManagerImpl<Scheme, ExternalizableScheme>, Unit> processor2) {
        Intrinsics.checkParameterIsNotNull(processor2, (String)"processor");
        for (SchemeManagerImpl<Scheme, ExternalizableScheme> manager : this.managers) {
            try {
                SchemeManagerImpl<Scheme, ExternalizableScheme> schemeManagerImpl = manager;
                Intrinsics.checkExpressionValueIsNotNull(schemeManagerImpl, (String)"manager");
                processor2.invoke(schemeManagerImpl);
            }
            catch (Throwable e) {
                ComponentStoreImplKt.getLOG().error("Cannot reload settings for " + ((Object)manager).getClass().getName(), e);
            }
        }
    }

    public final void save() {
        SmartList errors = new SmartList();
        for (SchemeManagerImpl<Scheme, ExternalizableScheme> registeredManager : this.managers) {
            try {
                registeredManager.save((List)errors);
            }
            catch (Throwable e) {
                errors.add((Object)e);
            }
        }
        CompoundRuntimeException.throwIfNotEmpty((List)((List)errors));
    }

    private SchemeManagerFactoryBase() {
    }

    public /* synthetic */ SchemeManagerFactoryBase(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/intellij/configurationStore/SchemeManagerFactoryBase$ApplicationSchemeManagerFactory;", "Lcom/intellij/configurationStore/SchemeManagerFactoryBase;", "()V", "componentManager", "Lcom/intellij/openapi/components/ComponentManager;", "getComponentManager", "()Lcom/intellij/openapi/components/ComponentManager;", "checkPath", "", "originalPath", "pathToFile", "Ljava/io/File;", "path", "storageManager", "Lcom/intellij/openapi/components/impl/stores/StateStorageManager;", "configuration-store-impl"})
    @KotlinClass(version={1, 1, 0}, data={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, strings={"Lcom/intellij/configurationStore/SchemeManagerFactoryBase$ApplicationSchemeManagerFactory;", "Lcom/intellij/configurationStore/SchemeManagerFactoryBase;", "()V", "componentManager", "Lcom/intellij/openapi/components/ComponentManager;", "getComponentManager", "()Lcom/intellij/openapi/components/ComponentManager;", "checkPath", "", "originalPath", "pathToFile", "Ljava/io/File;", "path", "storageManager", "Lcom/intellij/openapi/components/impl/stores/StateStorageManager;", "configuration-store-impl"})
    private static final class ApplicationSchemeManagerFactory
    extends SchemeManagerFactoryBase {
        @Override
        @NotNull
        public ComponentManager getComponentManager() {
            ComponentManager componentManager = (ComponentManager)ApplicationManager.getApplication();
            Intrinsics.checkExpressionValueIsNotNull((Object)componentManager, (String)"ApplicationManager.getApplication()");
            return componentManager;
        }

        @Override
        @NotNull
        public String checkPath(@NotNull String originalPath) {
            Intrinsics.checkParameterIsNotNull((Object)originalPath, (String)"originalPath");
            String path = super.checkPath(originalPath);
            if (StringsKt.startsWith$default((String)path, (String)SchemeManagerFactoryImplKt.ROOT_CONFIG, (boolean)false, (int)2, null)) {
                path = StringsKt.substring((String)path, (int)(SchemeManagerFactoryImplKt.ROOT_CONFIG.length() + 1));
                String message = "Path must not contains ROOT_CONFIG macro, corrected: " + path;
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    throw (Throwable)((Object)new AssertionError((Object)message));
                }
                ComponentStoreImplKt.getLOG().warn(message);
            }
            return path;
        }

        @Override
        @NotNull
        public File pathToFile(@NotNull String path, @NotNull StateStorageManager storageManager2) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            Intrinsics.checkParameterIsNotNull((Object)storageManager2, (String)"storageManager");
            return new File(storageManager2.expandMacros(SchemeManagerFactoryImplKt.ROOT_CONFIG + "/" + path));
        }

        public ApplicationSchemeManagerFactory() {
            super(null);
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/configurationStore/SchemeManagerFactoryBase$ProjectSchemeManagerFactory;", "Lcom/intellij/configurationStore/SchemeManagerFactoryBase;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "componentManager", "getComponentManager", "()Lcom/intellij/openapi/project/Project;", "pathToFile", "Ljava/io/File;", "path", "", "storageManager", "Lcom/intellij/openapi/components/impl/stores/StateStorageManager;", "configuration-store-impl"})
    @KotlinClass(version={1, 1, 0}, data={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, strings={"Lcom/intellij/configurationStore/SchemeManagerFactoryBase$ProjectSchemeManagerFactory;", "Lcom/intellij/configurationStore/SchemeManagerFactoryBase;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "componentManager", "getComponentManager", "()Lcom/intellij/openapi/project/Project;", "pathToFile", "Ljava/io/File;", "path", "", "storageManager", "Lcom/intellij/openapi/components/impl/stores/StateStorageManager;", "configuration-store-impl"})
    private static final class ProjectSchemeManagerFactory
    extends SchemeManagerFactoryBase {
        @NotNull
        private final Project componentManager;
        private final Project project;

        @NotNull
        public Project getComponentManager() {
            return this.componentManager;
        }

        @Override
        @NotNull
        public File pathToFile(@NotNull String path, @NotNull StateStorageManager storageManager2) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            Intrinsics.checkParameterIsNotNull((Object)storageManager2, (String)"storageManager");
            return new File(this.project.getBasePath(), ProjectUtil.isDirectoryBased(this.project) ? ".idea" + "/" + path : "." + path);
        }

        public ProjectSchemeManagerFactory(@NotNull Project project2) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            super(null);
            this.componentManager = this.project = project2;
        }
    }
}

