/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.ThreadDumpAction;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointCategory;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.java.stubs.index.JavaFullClassNameIndex;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidLineNumberException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.request.BreakpointRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class LineBreakpoint<P extends JavaBreakpointProperties>
extends BreakpointWithHighlighter<P> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.breakpoints.LineBreakpoint");
    @NonNls
    public static final Key<LineBreakpoint> CATEGORY = BreakpointCategory.lookup("line_breakpoints");
    private static final Pattern ourAnonymousPattern = Pattern.compile(".*\\$\\d*$");

    protected LineBreakpoint(Project project2, XBreakpoint xBreakpoint) {
        super(project2, xBreakpoint);
    }

    @Override
    protected Icon getDisabledIcon(boolean isMuted) {
        Breakpoint master = DebuggerManagerEx.getInstanceEx(this.myProject).getBreakpointManager().findMasterBreakpoint(this);
        if (isMuted) {
            return master == null ? AllIcons.Debugger.Db_muted_disabled_breakpoint : AllIcons.Debugger.Db_muted_dep_line_breakpoint;
        }
        return master == null ? AllIcons.Debugger.Db_disabled_breakpoint : AllIcons.Debugger.Db_dep_line_breakpoint;
    }

    @Override
    protected Icon getSetIcon(boolean isMuted) {
        if (this.isRemoveAfterHit()) {
            return isMuted ? AllIcons.Debugger.Db_muted_temporary_breakpoint : AllIcons.Debugger.Db_temporary_breakpoint;
        }
        return isMuted ? AllIcons.Debugger.Db_muted_breakpoint : AllIcons.Debugger.Db_set_breakpoint;
    }

    @Override
    protected Icon getInvalidIcon(boolean isMuted) {
        return isMuted ? AllIcons.Debugger.Db_muted_invalid_breakpoint : AllIcons.Debugger.Db_invalid_breakpoint;
    }

    @Override
    protected Icon getVerifiedIcon(boolean isMuted) {
        if (this.isRemoveAfterHit()) {
            return isMuted ? AllIcons.Debugger.Db_muted_temporary_breakpoint : AllIcons.Debugger.Db_temporary_breakpoint;
        }
        return isMuted ? AllIcons.Debugger.Db_muted_verified_breakpoint : AllIcons.Debugger.Db_verified_breakpoint;
    }

    @Override
    protected Icon getVerifiedWarningsIcon(boolean isMuted) {
        return isMuted ? AllIcons.Debugger.Db_muted_verified_warning_breakpoint : AllIcons.Debugger.Db_verified_warning_breakpoint;
    }

    @Override
    public Key<LineBreakpoint> getCategory() {
        return CATEGORY;
    }

    @Override
    protected void createOrWaitPrepare(DebugProcessImpl debugProcess, String classToBeLoaded) {
        if (this.isInScopeOf(debugProcess, classToBeLoaded)) {
            super.createOrWaitPrepare(debugProcess, classToBeLoaded);
        }
    }

    @Override
    protected void createRequestForPreparedClass(DebugProcessImpl debugProcess, ReferenceType classType) {
        if (!this.isInScopeOf(debugProcess, classType.name())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(classType.name() + " is out of debug-process scope, breakpoint request won't be created for line " + this.getLineIndex());
            }
            return;
        }
        try {
            List<Location> locations = debugProcess.getPositionManager().locationsOfLine(classType, this.getSourcePosition());
            if (!locations.isEmpty()) {
                for (Location loc : locations) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Found location [codeIndex=" + loc.codeIndex() + "] for reference type " + classType.name() + " at line " + this.getLineIndex() + "; isObsolete: " + (debugProcess.getVirtualMachineProxy().versionHigher("1.4") && loc.method().isObsolete()));
                    }
                    if (!this.acceptLocation(debugProcess, classType, loc)) continue;
                    BreakpointRequest request = debugProcess.getRequestsManager().createBreakpointRequest(this, loc);
                    debugProcess.getRequestsManager().enableRequest(request);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Created breakpoint request for reference type " + classType.name() + " at line " + this.getLineIndex() + "; codeIndex=" + loc.codeIndex());
                }
            } else {
                debugProcess.getRequestsManager().setInvalid(this, DebuggerBundle.message((String)"error.invalid.breakpoint.no.executable.code", (Object[])new Object[]{this.getLineIndex() + 1, classType.name()}));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No locations of type " + classType.name() + " found at line " + this.getLineIndex());
                }
            }
        }
        catch (ClassNotPreparedException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ClassNotPreparedException: " + ex.getMessage());
            }
        }
        catch (ObjectCollectedException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ObjectCollectedException: " + ex.getMessage());
            }
        }
        catch (InvalidLineNumberException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("InvalidLineNumberException: " + ex.getMessage());
            }
            debugProcess.getRequestsManager().setInvalid(this, DebuggerBundle.message((String)"error.invalid.breakpoint.bad.line.number", (Object[])new Object[0]));
        }
        catch (InternalException ex) {
            LOG.info((Throwable)ex);
        }
        catch (Exception ex) {
            LOG.info((Throwable)ex);
        }
        this.updateUI();
    }

    private static boolean isAnonymousClass(ReferenceType classType) {
        if (classType instanceof ClassType) {
            return ourAnonymousPattern.matcher(classType.name()).matches();
        }
        return false;
    }

    protected boolean acceptLocation(final DebugProcessImpl debugProcess, ReferenceType classType, final Location loc) {
        Method method = loc.method();
        if (LineBreakpoint.isAnonymousClass(classType) && (method.isConstructor() && loc.codeIndex() == 0L || method.isBridge())) {
            return false;
        }
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                SourcePosition position = debugProcess.getPositionManager().getSourcePosition(loc);
                if (position == null) {
                    return false;
                }
                JavaLineBreakpointType type = LineBreakpoint.this.getXBreakpointType();
                if (type == null) {
                    return true;
                }
                return type.matchesPosition(LineBreakpoint.this, position);
            }
        });
    }

    @Nullable
    protected JavaLineBreakpointType getXBreakpointType() {
        XBreakpointType type = this.myXBreakpoint.getType();
        if (type instanceof JavaLineBreakpointType) {
            return (JavaLineBreakpointType)type;
        }
        return null;
    }

    private boolean isInScopeOf(DebugProcessImpl debugProcess, String className) {
        SourcePosition position = this.getSourcePosition();
        if (position != null) {
            VirtualFile breakpointFile = position.getFile().getVirtualFile();
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
            if (breakpointFile != null && fileIndex.isUnderSourceRootOfType(breakpointFile, JavaModuleSourceRootTypes.SOURCES)) {
                if (debugProcess.getSearchScope().contains(breakpointFile)) {
                    return true;
                }
                Collection<VirtualFile> candidates = this.findClassCandidatesInSourceContent(className, debugProcess.getSearchScope(), fileIndex);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found " + (candidates == null ? "null" : Integer.valueOf(candidates.size())) + " candidate containing files for class " + className);
                }
                if (candidates == null) {
                    return true;
                }
                if (LOG.isDebugEnabled()) {
                    GlobalSearchScope scope = debugProcess.getSearchScope();
                    boolean contains = scope.contains(breakpointFile);
                    Project project2 = this.getProject();
                    List files = ContainerUtil.map(JavaFullClassNameIndex.getInstance().get(className.hashCode(), project2, scope), (Function)new Function<PsiClass, VirtualFile>(){

                        public VirtualFile fun(PsiClass aClass) {
                            return aClass.getContainingFile().getVirtualFile();
                        }
                    });
                    List allFiles = ContainerUtil.map(JavaFullClassNameIndex.getInstance().get(className.hashCode(), project2, (GlobalSearchScope)new EverythingGlobalScope(project2)), (Function)new Function<PsiClass, VirtualFile>(){

                        public VirtualFile fun(PsiClass aClass) {
                            return aClass.getContainingFile().getVirtualFile();
                        }
                    });
                    VirtualFile contentRoot = fileIndex.getContentRootForFile(breakpointFile);
                    Module module2 = fileIndex.getModuleForFile(breakpointFile);
                    LOG.debug("Did not find '" + className + "' in " + scope + "; contains=" + contains + "; contentRoot=" + contentRoot + "; module = " + module2 + "; all files in index are: " + files + "; all possible files are: " + allFiles);
                }
                return false;
            }
        }
        return true;
    }

    @Nullable
    private Collection<VirtualFile> findClassCandidatesInSourceContent(String className, final GlobalSearchScope scope, final ProjectFileIndex fileIndex) {
        int dollarIndex = className.indexOf("$");
        final String topLevelClassName = dollarIndex >= 0 ? className.substring(0, dollarIndex) : className;
        return (Collection)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Collection<VirtualFile>>(){

            @Nullable
            public Collection<VirtualFile> compute() {
                PsiClass[] classes = JavaPsiFacade.getInstance((Project)LineBreakpoint.this.myProject).findClasses(topLevelClassName, scope);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found " + classes.length + " classes " + topLevelClassName + " in scope " + scope);
                }
                if (classes.length == 0) {
                    return null;
                }
                ArrayList<VirtualFile> list = new ArrayList<VirtualFile>(classes.length);
                for (PsiClass aClass : classes) {
                    PsiFile psiFile = aClass.getContainingFile();
                    if (LOG.isDebugEnabled()) {
                        StringBuilder msg = new StringBuilder();
                        msg.append("Checking class ").append(aClass.getQualifiedName());
                        msg.append("\n\t").append("PsiFile=").append(psiFile);
                        if (psiFile != null) {
                            VirtualFile vFile = psiFile.getVirtualFile();
                            msg.append("\n\t").append("VirtualFile=").append(vFile);
                            if (vFile != null) {
                                msg.append("\n\t").append("isInSourceContent=").append(fileIndex.isUnderSourceRootOfType(vFile, JavaModuleSourceRootTypes.SOURCES));
                            }
                        }
                        LOG.debug(msg.toString());
                    }
                    if (psiFile == null) {
                        return null;
                    }
                    VirtualFile vFile = psiFile.getVirtualFile();
                    if (vFile == null || !fileIndex.isUnderSourceRootOfType(vFile, JavaModuleSourceRootTypes.SOURCES)) {
                        return null;
                    }
                    list.add(vFile);
                }
                return list;
            }
        });
    }

    @Override
    protected String calculateEventClass(EvaluationContextImpl context, LocatableEvent event) throws EvaluateException {
        String className = null;
        ObjectReference thisObject = (ObjectReference)context.getThisObject();
        if (thisObject != null) {
            className = thisObject.referenceType().name();
        } else {
            StackFrameProxyImpl frame = context.getFrameProxy();
            if (frame != null) {
                className = frame.location().declaringType().name();
            }
        }
        return className;
    }

    @Override
    public String getShortName() {
        return this.getDisplayInfoInternal(false, 30);
    }

    @Override
    public String getDisplayName() {
        return this.getDisplayInfoInternal(true, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDisplayInfoInternal(boolean showPackageInfo, int totalTextLength) {
        if (this.isValid()) {
            boolean hasMethodInfo;
            int lineNumber = this.myXBreakpoint.getSourcePosition().getLine() + 1;
            String className = this.getClassName();
            boolean hasClassInfo = className != null && className.length() > 0;
            String methodName = this.getMethodName();
            String displayName = methodName != null ? methodName + "()" : null;
            boolean bl = hasMethodInfo = displayName != null && displayName.length() > 0;
            if (hasClassInfo || hasMethodInfo) {
                StringBuilder info = StringBuilderSpinAllocator.alloc();
                try {
                    boolean isFile = this.myXBreakpoint.getSourcePosition().getFile().getName().equals(className);
                    String packageName = null;
                    if (hasClassInfo) {
                        int offset;
                        int dotIndex = className.lastIndexOf(".");
                        if (dotIndex >= 0 && !isFile) {
                            packageName = className.substring(0, dotIndex);
                            className = className.substring(dotIndex + 1);
                        }
                        if (totalTextLength != -1 && className.length() + (hasMethodInfo ? displayName.length() : 0) > totalTextLength + 3 && (offset = totalTextLength - (hasMethodInfo ? displayName.length() : 0)) > 0 && offset < className.length()) {
                            className = className.substring(className.length() - offset);
                            info.append("...");
                        }
                        info.append(className);
                    }
                    if (hasMethodInfo) {
                        if (isFile) {
                            info.append(":");
                        } else if (hasClassInfo) {
                            info.append(".");
                        }
                        info.append(displayName);
                    }
                    if (showPackageInfo && packageName != null) {
                        info.append(" (").append(packageName).append(")");
                    }
                    String string = DebuggerBundle.message((String)"line.breakpoint.display.name.with.class.or.method", (Object[])new Object[]{lineNumber, info.toString()});
                    return string;
                }
                finally {
                    StringBuilderSpinAllocator.dispose((StringBuilder)info);
                }
            }
            return DebuggerBundle.message((String)"line.breakpoint.display.name", (Object[])new Object[]{lineNumber});
        }
        return DebuggerBundle.message((String)"status.breakpoint.invalid", (Object[])new Object[0]);
    }

    @Nullable
    private static String findOwnerMethod(final PsiFile file2, final int offset) {
        if (offset < 0 || file2 instanceof JspFile) {
            return null;
        }
        if (file2 instanceof PsiClassOwner) {
            return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                public String compute() {
                    PsiMethod method = DebuggerUtilsEx.findPsiMethod(file2, offset);
                    return method != null ? method.getName() : null;
                }
            });
        }
        return null;
    }

    @Override
    public String getEventMessage(LocatableEvent event) {
        String sourceName;
        Location location = event.location();
        try {
            sourceName = location.sourceName();
        }
        catch (AbsentInformationException e) {
            sourceName = this.getFileName();
        }
        boolean printFullTrace = Registry.is((String)"debugger.breakpoint.message.full.trace");
        StringBuilder builder = new StringBuilder();
        if (printFullTrace) {
            builder.append(DebuggerBundle.message((String)"status.line.breakpoint.reached.full.trace", (Object[])new Object[]{DebuggerUtilsEx.getLocationMethodQName(location)}));
            try {
                List<StackFrame> frames = event.thread().frames();
                LineBreakpoint.renderTrace(frames, builder);
            }
            catch (IncompatibleThreadStateException e) {
                builder.append("Stacktrace not available: ").append(e.getMessage());
            }
        } else {
            builder.append(DebuggerBundle.message((String)"status.line.breakpoint.reached", (Object[])new Object[]{DebuggerUtilsEx.getLocationMethodQName(location), sourceName, this.getLineIndex() + 1}));
        }
        return builder.toString();
    }

    private static void renderTrace(List<StackFrame> frames, StringBuilder buffer) {
        for (StackFrame stackFrame : frames) {
            Location location = stackFrame.location();
            buffer.append("\n\t  ").append(ThreadDumpAction.renderLocation(location));
        }
    }

    @Override
    public PsiElement getEvaluationElement() {
        return ContextUtil.getContextElement(this.getSourcePosition());
    }

    public static LineBreakpoint create(@NotNull Project project2, XBreakpoint xBreakpoint) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/ui/breakpoints/LineBreakpoint", "create"));
        }
        LineBreakpoint breakpoint = new LineBreakpoint(project2, xBreakpoint);
        return (LineBreakpoint)breakpoint.init();
    }

    public static boolean canAddLineBreakpoint(Project project2, final Document document, final int lineIndex) {
        if (lineIndex < 0 || lineIndex >= document.getLineCount()) {
            return false;
        }
        BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx(project2).getBreakpointManager();
        LineBreakpoint breakpointAtLine = breakpointManager.findBreakpoint(document, document.getLineStartOffset(lineIndex), CATEGORY);
        if (breakpointAtLine != null) {
            return false;
        }
        PsiDocumentManager.getInstance((Project)project2).commitDocument(document);
        final boolean[] canAdd = new boolean[]{false};
        XDebuggerUtil.getInstance().iterateLine(project2, document, lineIndex, (Processor)new Processor<PsiElement>(){

            public boolean process(PsiElement element) {
                PsiStatement[] statements;
                PsiCodeBlock body;
                int offset;
                if (element instanceof PsiWhiteSpace || PsiTreeUtil.getParentOfType((PsiElement)element, PsiComment.class, (boolean)false) != null) {
                    return true;
                }
                PsiElement child = element;
                while (element != null && ((offset = element.getTextOffset()) < 0 || document.getLineNumber(offset) == lineIndex)) {
                    child = element;
                    element = element.getParent();
                }
                canAdd[0] = child instanceof PsiMethod && child.getTextRange().getEndOffset() >= document.getLineEndOffset(lineIndex) ? ((body = ((PsiMethod)child).getBody()) == null ? false : (statements = body.getStatements()).length > 0 && document.getLineNumber(statements[0].getTextOffset()) == lineIndex) : true;
                return false;
            }
        });
        return canAdd[0];
    }

    @Nullable
    public String getMethodName() {
        XSourcePosition position = this.myXBreakpoint.getSourcePosition();
        if (position != null) {
            int offset = position.getOffset();
            return LineBreakpoint.findOwnerMethod(this.getPsiFile(), offset);
        }
        return null;
    }
}

