/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.CachedEvaluator;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.ReferenceRenderer;
import com.intellij.debugger.ui.tree.render.ValueLabelRenderer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.Value;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class LabelRenderer
extends ReferenceRenderer
implements ValueLabelRenderer {
    @NonNls
    public static final String UNIQUE_ID = "LabelRenderer";
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.impl.watch.render.ClassLabelRenderer");
    private CachedEvaluator myLabelExpression = this.createCachedEvaluator();

    @Override
    public String getUniqueId() {
        return UNIQUE_ID;
    }

    @Override
    public LabelRenderer clone() {
        LabelRenderer clone = (LabelRenderer)super.clone();
        clone.myLabelExpression = this.createCachedEvaluator();
        clone.setLabelExpression(this.getLabelExpression());
        return clone;
    }

    @Override
    public Icon calcValueIcon(ValueDescriptor descriptor, EvaluationContext evaluationContext, DescriptorLabelListener listener) throws EvaluateException {
        return null;
    }

    @Override
    public String calcLabel(ValueDescriptor descriptor, EvaluationContext evaluationContext, DescriptorLabelListener labelListener) throws EvaluateException {
        String result;
        Value value = descriptor.getValue();
        LOG.assertTrue(!(value instanceof PrimitiveValue));
        DebugProcess debugProcess = evaluationContext.getDebugProcess();
        if (value != null) {
            try {
                ExpressionEvaluator evaluator = this.myLabelExpression.getEvaluator(debugProcess.getProject());
                if (!debugProcess.isAttached()) {
                    throw EvaluateExceptionUtil.PROCESS_EXITED;
                }
                EvaluationContext thisEvaluationContext = evaluationContext.createEvaluationContext(value);
                Value labelValue = evaluator.evaluate(thisEvaluationContext);
                result = DebuggerUtils.getValueAsString((EvaluationContext)thisEvaluationContext, (Value)labelValue);
            }
            catch (EvaluateException ex) {
                throw new EvaluateException(DebuggerBundle.message((String)"error.unable.to.evaluate.expression", (Object[])new Object[0]) + " " + ex.getMessage(), (Throwable)ex);
            }
        } else {
            result = "null";
        }
        return result;
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        TextWithImports labelExpression = DebuggerUtils.getInstance().readTextWithImports(element, "LABEL_EXPRESSION");
        if (labelExpression != null) {
            this.setLabelExpression(labelExpression);
        }
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        DebuggerUtils.getInstance().writeTextWithImports(element, "LABEL_EXPRESSION", this.getLabelExpression());
    }

    public TextWithImports getLabelExpression() {
        return this.myLabelExpression.getReferenceExpression();
    }

    public void setLabelExpression(TextWithImports expression) {
        this.myLabelExpression.setReferenceExpression(expression);
    }
}

