/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.util.MergeRange;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.openapi.progress.ProgressIndicator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ComparisonMergeUtil {
    @NotNull
    public static List<MergeRange> buildFair(@NotNull FairDiffIterable fragments1, @NotNull FairDiffIterable fragments2, @NotNull ProgressIndicator indicator) {
        if (fragments1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragments1", "com/intellij/diff/comparison/ComparisonMergeUtil", "buildFair"));
        }
        if (fragments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragments2", "com/intellij/diff/comparison/ComparisonMergeUtil", "buildFair"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/comparison/ComparisonMergeUtil", "buildFair"));
        }
        assert (fragments1.getLength1() == fragments2.getLength1());
        FairMergeBuilder builder = new FairMergeBuilder();
        PeekIterator<Range> unchanged1 = new PeekIterator<Range>(fragments1.unchanged());
        PeekIterator<Range> unchanged2 = new PeekIterator<Range>(fragments2.unchanged());
        while (!unchanged1.atEnd() || !unchanged2.atEnd()) {
            boolean left;
            indicator.checkCanceled();
            if (unchanged1.atEnd()) {
                left = false;
            } else if (unchanged2.atEnd()) {
                left = true;
            } else {
                Range range1 = unchanged1.peek();
                Range range2 = unchanged2.peek();
                boolean bl = left = range1.start1 < range2.start1;
            }
            if (left) {
                builder.add(unchanged1.peek(), Side.LEFT);
                unchanged1.advance();
                continue;
            }
            builder.add(unchanged2.peek(), Side.RIGHT);
            unchanged2.advance();
        }
        List<MergeRange> list = builder.finish(fragments1.getLength2(), fragments1.getLength1(), fragments2.getLength2());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonMergeUtil", "buildFair"));
        }
        return list;
    }

    private static class PeekIterator<T> {
        @NotNull
        private final Iterator<T> myIterator;
        private T myValue;

        public PeekIterator(@NotNull Iterator<T> iterator) {
            if (iterator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/diff/comparison/ComparisonMergeUtil$PeekIterator", "<init>"));
            }
            this.myValue = null;
            this.myIterator = iterator;
            this.advance();
        }

        public boolean atEnd() {
            return this.myValue == null;
        }

        public boolean hasNext() {
            return this.myIterator.hasNext();
        }

        public T peek() {
            return this.myValue;
        }

        public void advance() {
            this.myValue = this.myIterator.hasNext() ? this.myIterator.next() : null;
        }
    }

    private static class EqualPair {
        private int myBaseStart;
        private int myVersionStart;
        private int myLength;
        @NotNull
        private final Side mySide;

        public EqualPair(@NotNull Range range, @NotNull Side side) {
            if (range == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/diff/comparison/ComparisonMergeUtil$EqualPair", "<init>"));
            }
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/comparison/ComparisonMergeUtil$EqualPair", "<init>"));
            }
            this.myBaseStart = range.start1;
            this.myVersionStart = range.start2;
            this.myLength = range.end1 - range.start1;
            this.mySide = side;
        }

        public int getBaseStart() {
            return this.myBaseStart;
        }

        public int getBaseEnd() {
            return this.myBaseStart + this.myLength;
        }

        public int getVersionStart() {
            return this.myVersionStart;
        }

        public int getVersionEnd() {
            return this.myVersionStart + this.myLength;
        }

        public int getLength() {
            return this.myLength;
        }

        public boolean startsFrom(int[] bound) {
            return this.myVersionStart == bound[this.mySide.getIndex()] && this.myBaseStart == bound[2];
        }

        public boolean cutHead(int delta) {
            assert (this.myLength >= delta);
            assert (delta >= 0);
            this.myBaseStart += delta;
            this.myVersionStart += delta;
            this.myLength -= delta;
            return this.myLength > 0;
        }
    }

    private static class FairMergeBuilder {
        @NotNull
        private final ArrayList<MergeRange> myResult = new ArrayList();
        @NotNull
        private final EqualPair[] myPairs = new EqualPair[2];
        @NotNull
        private final int[] myProcessed = new int[]{0, 0, 0};

        private FairMergeBuilder() {
        }

        public void add(@NotNull Range range, @NotNull Side side) {
            if (range == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/diff/comparison/ComparisonMergeUtil$FairMergeBuilder", "add"));
            }
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/comparison/ComparisonMergeUtil$FairMergeBuilder", "add"));
            }
            int index = side.getIndex();
            int otherIndex = side.other().getIndex();
            EqualPair pair = new EqualPair(range, side);
            assert (this.myPairs[index] == null || pair.getBaseStart() - this.myPairs[index].getBaseEnd() >= 0);
            assert (this.myPairs[otherIndex] == null || pair.getBaseStart() >= this.myPairs[otherIndex].getBaseStart());
            this.myPairs[index] = pair;
            if (this.myPairs[otherIndex] != null && this.myPairs[index].getBaseStart() >= this.myPairs[otherIndex].getBaseEnd()) {
                this.myPairs[otherIndex] = null;
            }
            this.process();
        }

        @NotNull
        public List<MergeRange> finish(int leftLength, int baseLength, int rightLength) {
            if (!FairMergeBuilder.compare(new int[]{leftLength, rightLength, baseLength}, this.myProcessed)) {
                this.processConflict(leftLength, baseLength, rightLength);
            }
            ArrayList<MergeRange> arrayList = this.myResult;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonMergeUtil$FairMergeBuilder", "finish"));
            }
            return arrayList;
        }

        private void process() {
            while (this.myPairs[0] != null && this.myPairs[1] != null) {
                if (this.myPairs[0].startsFrom(this.myProcessed) && this.myPairs[1].startsFrom(this.myProcessed)) {
                    int len = Math.min(this.myPairs[0].getLength(), this.myPairs[1].getLength());
                    if (!this.myPairs[0].cutHead(len)) {
                        this.myPairs[0] = null;
                    }
                    if (!this.myPairs[1].cutHead(len)) {
                        this.myPairs[1] = null;
                    }
                    this.myProcessed[0] = this.myProcessed[0] + len;
                    this.myProcessed[1] = this.myProcessed[1] + len;
                    this.myProcessed[2] = this.myProcessed[2] + len;
                    continue;
                }
                int nextBase = Math.max(this.myPairs[0].getBaseStart(), this.myPairs[1].getBaseStart());
                int[] nextVersion = new int[]{nextBase - this.myPairs[0].getBaseStart() + this.myPairs[0].getVersionStart(), nextBase - this.myPairs[1].getBaseStart() + this.myPairs[1].getVersionStart()};
                this.processConflict(nextVersion[0], nextBase, nextVersion[1]);
                if (!this.myPairs[0].cutHead(nextBase - this.myPairs[0].getBaseStart())) {
                    this.myPairs[0] = null;
                }
                if (this.myPairs[1].cutHead(nextBase - this.myPairs[1].getBaseStart())) continue;
                this.myPairs[1] = null;
            }
        }

        private void processConflict(int nextLeft, int nextBase, int nextRight) {
            this.myResult.add(new MergeRange(this.myProcessed[0], nextLeft, this.myProcessed[2], nextBase, this.myProcessed[1], nextRight));
            this.myProcessed[0] = nextLeft;
            this.myProcessed[2] = nextBase;
            this.myProcessed[1] = nextRight;
        }

        private static boolean compare(@NotNull int[] lengths, @NotNull int[] processed2) {
            if (lengths == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lengths", "com/intellij/diff/comparison/ComparisonMergeUtil$FairMergeBuilder", "compare"));
            }
            if (processed2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processed", "com/intellij/diff/comparison/ComparisonMergeUtil$FairMergeBuilder", "compare"));
            }
            for (int i = 0; i < lengths.length; ++i) {
                if (lengths[i] == processed2[i]) continue;
                return false;
            }
            return true;
        }
    }
}

