/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.debugger.impl.GenericDebuggerRunnerSettings;
import com.intellij.execution.CantRunException;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.JUnitPatcher;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.SearchForTestsTask;
import com.intellij.execution.testframework.SourceScope;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.TestProxyRoot;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.execution.testframework.actions.AbstractRerunFailedTestsAction;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.SMRunnerConsolePropertiesProvider;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.testframework.sm.runner.ui.SMTestRunnerResultsForm;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.util.PathUtil;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.PathMacroUtil;

public abstract class JavaTestFrameworkRunnableState<T extends ModuleBasedConfiguration<JavaRunConfigurationModule> & SMRunnerConsolePropertiesProvider>
extends JavaCommandLineState {
    private static final Logger LOG = Logger.getInstance((String)("#" + JavaTestFrameworkRunnableState.class.getName()));
    protected ServerSocket myServerSocket;
    protected File myTempFile;
    protected File myWorkingDirsFile = null;
    private ServerSocket myForkSocket = null;

    public JavaTestFrameworkRunnableState(ExecutionEnvironment environment) {
        super(environment);
    }

    @NotNull
    protected abstract String getFrameworkName();

    @NotNull
    protected abstract String getFrameworkId();

    protected abstract void passTempFile(ParametersList var1, String var2);

    @NotNull
    protected abstract T getConfiguration();

    @Nullable
    protected abstract TestSearchScope getScope();

    @NotNull
    protected abstract String getForkMode();

    @NotNull
    protected abstract OSProcessHandler createHandler(Executor var1) throws ExecutionException;

    public SearchForTestsTask createSearchingForTestsTask() {
        return null;
    }

    protected boolean configureByModule(Module module2) {
        return module2 != null;
    }

    protected ExecutionResult startSMRunner(Executor executor) throws ExecutionException {
        if (!this.isSmRunnerUsed()) {
            return null;
        }
        this.getJavaParameters().getVMParametersList().addProperty("idea." + this.getFrameworkId() + ".sm_runner");
        RunnerSettings runnerSettings = this.getRunnerSettings();
        SMTRunnerConsoleProperties testConsoleProperties = ((SMRunnerConsolePropertiesProvider)this.getConfiguration()).createTestConsoleProperties(executor);
        testConsoleProperties.setIfUndefined((AbstractProperty<Boolean>)TestConsoleProperties.HIDE_PASSED_TESTS, false);
        BaseTestsOutputConsoleView consoleView = SMTestRunnerConnectionUtil.createConsole(this.getFrameworkName(), testConsoleProperties);
        final SMTestRunnerResultsForm viewer = ((SMTRunnerConsoleView)consoleView).getResultsViewer();
        Disposer.register((Disposable)this.getConfiguration().getProject(), (Disposable)consoleView);
        final OSProcessHandler handler2 = this.createHandler(executor);
        consoleView.attachToProcess((ProcessHandler)handler2);
        final AbstractTestProxy root = viewer.getRoot();
        if (root instanceof TestProxyRoot) {
            ((TestProxyRoot)((Object)root)).setHandler((ProcessHandler)handler2);
        }
        handler2.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void startNotified(ProcessEvent event) {
                if (JavaTestFrameworkRunnableState.this.getConfiguration().isSaveOutputToFile()) {
                    root.setOutputFilePath(JavaTestFrameworkRunnableState.this.getConfiguration().getOutputFilePath());
                }
            }

            public void processTerminated(ProcessEvent event) {
                Runnable runnable2 = new Runnable(){

                    @Override
                    public void run() {
                        root.flush();
                        JavaTestFrameworkRunnableState.this.deleteTempFiles();
                        JavaTestFrameworkRunnableState.this.clear();
                    }
                };
                UIUtil.invokeLaterIfNeeded((Runnable)runnable2);
                handler2.removeProcessListener((ProcessListener)this);
            }
        });
        AbstractRerunFailedTestsAction rerunFailedTestsAction = testConsoleProperties.createRerunFailedTestsAction(consoleView);
        LOG.assertTrue(rerunFailedTestsAction != null);
        rerunFailedTestsAction.setModelProvider(new Getter<TestFrameworkRunningModel>(){

            public TestFrameworkRunningModel get() {
                return viewer;
            }
        });
        DefaultExecutionResult result = new DefaultExecutionResult((ExecutionConsole)consoleView, (ProcessHandler)handler2);
        result.setRestartActions(new AnAction[]{rerunFailedTestsAction});
        JavaRunConfigurationExtensionManager.getInstance().attachExtensionsToProcess((RunConfigurationBase)this.getConfiguration(), (ProcessHandler)handler2, runnerSettings);
        return result;
    }

    protected boolean isSmRunnerUsed() {
        return Registry.is((String)(this.getFrameworkId() + "_sm"));
    }

    protected abstract void configureRTClasspath(JavaParameters var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JavaParameters createJavaParameters() throws ExecutionException {
        Object[] patchers;
        JavaParameters javaParameters = new JavaParameters();
        javaParameters.setUseClasspathJar(true);
        Module module2 = ((JavaRunConfigurationModule)this.getConfiguration().getConfigurationModule()).getModule();
        Project project2 = this.getConfiguration().getProject();
        Sdk jdk = module2 == null ? ProjectRootManager.getInstance((Project)project2).getProjectSdk() : ModuleRootManager.getInstance((Module)module2).getSdk();
        javaParameters.setJdk(jdk);
        String parameters = ((CommonProgramRunConfigurationParameters)this.getConfiguration()).getProgramParameters();
        ((CommonProgramRunConfigurationParameters)this.getConfiguration()).setProgramParameters(null);
        try {
            JavaParametersUtil.configureConfiguration((SimpleJavaParameters)javaParameters, (CommonJavaRunConfigurationParameters)this.getConfiguration());
        }
        finally {
            ((CommonProgramRunConfigurationParameters)this.getConfiguration()).setProgramParameters(parameters);
        }
        javaParameters.getClassPath().addFirst(JavaSdkUtil.getIdeaRtJarPath());
        this.configureClasspath(javaParameters);
        for (Object patcher : patchers = Extensions.getExtensions((String)"com.intellij.junitPatcher")) {
            ((JUnitPatcher)patcher).patchJavaParameters(module2, javaParameters);
        }
        for (RunConfigurationExtension ext : (RunConfigurationExtension[])Extensions.getExtensions(RunConfigurationExtension.EP_NAME)) {
            ext.updateJavaParameters(this.getConfiguration(), javaParameters, this.getRunnerSettings());
        }
        if (!StringUtil.isEmptyOrSpaces((String)parameters)) {
            javaParameters.getProgramParametersList().addAll(this.getNamedParams(parameters));
        }
        return javaParameters;
    }

    protected List<String> getNamedParams(String parameters) {
        return Collections.singletonList("@name" + parameters);
    }

    @Nullable
    public ServerSocket getForkSocket() {
        if (this.myForkSocket == null && (!Comparing.strEqual((String)this.getForkMode(), (String)"none") || this.forkPerModule()) && this.getRunnerSettings() != null) {
            try {
                this.myForkSocket = new ServerSocket(0, 0, InetAddress.getByName("127.0.0.1"));
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        return this.myForkSocket;
    }

    private boolean isExecutorDisabledInForkedMode() {
        RunnerSettings settings = this.getRunnerSettings();
        return settings != null && !(settings instanceof GenericDebuggerRunnerSettings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void appendForkInfo(Executor executor) throws ExecutionException {
        JavaParameters javaParameters;
        Sdk jdk;
        String forkMode = this.getForkMode();
        if (Comparing.strEqual((String)forkMode, (String)"none")) {
            if (!this.forkPerModule()) return;
            if (this.isExecutorDisabledInForkedMode()) {
                String actionName = UIUtil.removeMnemonic((String)executor.getStartActionText());
                throw new CantRunException("'" + actionName + "' is disabled when per-module working directory is configured.<br/>" + "Please specify single working directory, or change test scope to single module.");
            }
        } else if (this.isExecutorDisabledInForkedMode()) {
            String actionName = executor.getActionName();
            throw new CantRunException(actionName + " is disabled in fork mode.<br/>Please change fork mode to &lt;none&gt; to " + actionName.toLowerCase(Locale.ENGLISH) + ".");
        }
        if ((jdk = (javaParameters = this.getJavaParameters()).getJdk()) == null) {
            throw new ExecutionException(ExecutionBundle.message((String)"run.configuration.error.no.jdk.specified", (Object[])new Object[0]));
        }
        try {
            File tempFile2 = FileUtil.createTempFile((String)"command.line", (String)"", (boolean)true);
            PrintWriter writer = new PrintWriter(tempFile2, "UTF-8");
            try {
                if (JdkUtil.useDynamicClasspath((Project)this.getConfiguration().getProject())) {
                    writer.println("use classpath jar");
                } else {
                    writer.println("");
                }
                writer.println(((JavaSdkType)jdk.getSdkType()).getVMExecutablePath(jdk));
                for (String vmParameter : javaParameters.getVMParametersList().getList()) {
                    writer.println(vmParameter);
                }
            }
            finally {
                writer.close();
            }
            this.passForkMode(this.getForkMode(), tempFile2, javaParameters);
            return;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    protected abstract void passForkMode(String var1, File var2, JavaParameters var3) throws ExecutionException;

    protected void collectListeners(JavaParameters javaParameters, StringBuilder buf, String epName, String delimiter) {
        Object[] listeners;
        T configuration = this.getConfiguration();
        for (Object listener : listeners = Extensions.getExtensions((String)epName)) {
            boolean enabled = true;
            for (RunConfigurationExtension ext : (RunConfigurationExtension[])Extensions.getExtensions(RunConfigurationExtension.EP_NAME)) {
                if (!ext.isListenerDisabled((RunConfigurationBase)configuration, listener, this.getRunnerSettings())) continue;
                enabled = false;
                break;
            }
            if (!enabled) continue;
            if (buf.length() > 0) {
                buf.append(delimiter);
            }
            Class<?> classListener = listener.getClass();
            buf.append(classListener.getName());
            javaParameters.getClassPath().add(PathUtil.getJarPathForClass(classListener));
        }
    }

    protected void configureClasspath(JavaParameters javaParameters) throws CantRunException {
        this.configureRTClasspath(javaParameters);
        RunConfigurationModule module2 = this.getConfiguration().getConfigurationModule();
        String jreHome = ((CommonJavaRunConfigurationParameters)this.getConfiguration()).isAlternativeJrePathEnabled() ? ((CommonJavaRunConfigurationParameters)this.getConfiguration()).getAlternativeJrePath() : null;
        int pathType = 7;
        if (this.configureByModule(module2.getModule())) {
            JavaParametersUtil.configureModule(module2, javaParameters, 7, jreHome);
        } else {
            JavaParametersUtil.configureProject(this.getConfiguration().getProject(), javaParameters, 7, jreHome);
        }
    }

    protected void createServerSocket(JavaParameters javaParameters) {
        try {
            this.myServerSocket = new ServerSocket(0, 0, InetAddress.getByName("127.0.0.1"));
            javaParameters.getProgramParametersList().add("-socket" + this.myServerSocket.getLocalPort());
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    protected boolean spansMultipleModules(String qualifiedName) {
        SourceScope sourceScope;
        TestSearchScope scope;
        Project project2;
        PsiPackage aPackage;
        if (qualifiedName != null && (aPackage = JavaPsiFacade.getInstance((Project)(project2 = this.getConfiguration().getProject())).findPackage(qualifiedName)) != null && (scope = this.getScope()) != null && (sourceScope = scope.getSourceScope((ModuleBasedConfiguration)this.getConfiguration())) != null) {
            GlobalSearchScope configurationSearchScope = GlobalSearchScopesCore.projectTestScope((Project)project2).intersectWith(sourceScope.getGlobalSearchScope());
            PsiDirectory[] directories = aPackage.getDirectories(configurationSearchScope);
            return directories.length > 1;
        }
        return false;
    }

    protected boolean forkPerModule() {
        String workingDirectory = ((CommonProgramRunConfigurationParameters)this.getConfiguration()).getWorkingDirectory();
        return this.getScope() != TestSearchScope.SINGLE_MODULE && "$MODULE_DIR$".equals(workingDirectory) && this.spansMultipleModules(((CommonJavaRunConfigurationParameters)this.getConfiguration()).getPackage());
    }

    protected void createTempFiles(JavaParameters javaParameters) {
        try {
            this.myWorkingDirsFile = FileUtil.createTempFile((String)("idea_working_dirs_" + this.getFrameworkId()), (String)".tmp");
            this.myWorkingDirsFile.deleteOnExit();
            javaParameters.getProgramParametersList().add("@w@" + this.myWorkingDirsFile.getAbsolutePath());
            this.myTempFile = FileUtil.createTempFile((String)("idea_" + this.getFrameworkId()), (String)".tmp");
            this.myTempFile.deleteOnExit();
            this.passTempFile(javaParameters.getProgramParametersList(), this.myTempFile.getAbsolutePath());
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeClassesPerModule(String packageName, JavaParameters javaParameters, Map<Module, List<String>> perModule) throws FileNotFoundException, UnsupportedEncodingException, CantRunException {
        if (perModule != null && perModule.size() > 1) {
            String classpath = this.getScope() == TestSearchScope.WHOLE_PROJECT ? null : javaParameters.getClassPath().getPathsString();
            PrintWriter wWriter = new PrintWriter(this.myWorkingDirsFile, "UTF-8");
            try {
                wWriter.println(packageName);
                for (Module module2 : perModule.keySet()) {
                    wWriter.println(PathMacroUtil.getModuleDir((String)module2.getModuleFilePath()));
                    wWriter.println(module2.getName());
                    if (classpath == null) {
                        JavaParameters parameters = new JavaParameters();
                        parameters.getClassPath().add(JavaSdkUtil.getIdeaRtJarPath());
                        this.configureRTClasspath(parameters);
                        JavaParametersUtil.configureModule(module2, parameters, 7, ((CommonJavaRunConfigurationParameters)this.getConfiguration()).isAlternativeJrePathEnabled() ? ((CommonJavaRunConfigurationParameters)this.getConfiguration()).getAlternativeJrePath() : null);
                        wWriter.println(parameters.getClassPath().getPathsString());
                    } else {
                        wWriter.println(classpath);
                    }
                    List<String> classNames = perModule.get(module2);
                    wWriter.println(classNames.size());
                    for (String className : classNames) {
                        wWriter.println(className);
                    }
                }
            }
            finally {
                wWriter.close();
            }
        }
    }

    protected void deleteTempFiles() {
        if (this.myTempFile != null) {
            FileUtil.delete((File)this.myTempFile);
        }
        if (this.myWorkingDirsFile != null) {
            FileUtil.delete((File)this.myWorkingDirsFile);
        }
    }
}

