/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process.impl;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.impl.CSVReader;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntObjectHashMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProcessListUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.process.impl.ProcessListUtil");

    @NotNull
    public static ProcessInfo[] getProcessList() {
        List<ProcessInfo> result = ProcessListUtil.doGetProcessList();
        ProcessInfo[] processInfoArray = result.isEmpty() ? ProcessInfo.EMPTY_ARRAY : result.toArray(new ProcessInfo[result.size()]);
        if (processInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/impl/ProcessListUtil", "getProcessList"));
        }
        return processInfoArray;
    }

    @NotNull
    private static List<ProcessInfo> doGetProcessList() {
        if (SystemInfo.isWindows) {
            List<ProcessInfo> result = ProcessListUtil.getProcessList_WindowsWMIC();
            if (result != null) {
                List<ProcessInfo> list = result;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/impl/ProcessListUtil", "doGetProcessList"));
                }
                return list;
            }
            LOG.info("Cannot get process list via wmic, fallback to tasklist");
            result = ProcessListUtil.getProcessList_WindowsTaskList();
            if (result != null) {
                List<ProcessInfo> list = result;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/impl/ProcessListUtil", "doGetProcessList"));
                }
                return list;
            }
            LOG.error("Cannot get process list via wmic and tasklist");
        } else if (SystemInfo.isUnix) {
            List<ProcessInfo> result = SystemInfo.isMac ? ProcessListUtil.getProcessList_Mac() : ProcessListUtil.getProcessList_Unix();
            if (result != null) {
                List<ProcessInfo> list = result;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/impl/ProcessListUtil", "doGetProcessList"));
                }
                return list;
            }
            LOG.error("Cannot get process list");
        } else {
            LOG.error("Cannot get process list, unexpected platform: " + SystemInfo.OS_NAME);
        }
        List<ProcessInfo> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/impl/ProcessListUtil", "doGetProcessList"));
        }
        return list;
    }

    @Nullable
    private static List<ProcessInfo> parseCommandOutput(@NotNull List<String> command, @NotNull NullableFunction<String, List<ProcessInfo>> parser) {
        String output;
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/execution/process/impl/ProcessListUtil", "parseCommandOutput"));
        }
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parser", "com/intellij/execution/process/impl/ProcessListUtil", "parseCommandOutput"));
        }
        try {
            ProcessOutput processOutput = ExecUtil.execAndGetOutput((GeneralCommandLine)new GeneralCommandLine(command));
            int exitCode = processOutput.getExitCode();
            if (exitCode != 0) {
                LOG.error("Cannot get process list, 'ps' exited with code " + exitCode + ", stdout:\n" + processOutput.getStdout() + "\nstderr:\n" + processOutput.getStderr());
            }
            output = processOutput.getStdout();
        }
        catch (ExecutionException e) {
            LOG.error("Cannot get process list", (Throwable)e);
            return null;
        }
        return (List)parser.fun((Object)output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static List<ProcessInfo> getProcessList_Unix() {
        File proc = new File("/proc");
        File[] processes = proc.listFiles();
        if (processes == null) {
            return null;
        }
        ArrayList<ProcessInfo> result = new ArrayList<ProcessInfo>();
        for (File each : processes) {
            List cmdline;
            int pid = StringUtil.parseInt((String)each.getName(), (int)-1);
            if (pid == -1) continue;
            try {
                FileInputStream stream = new FileInputStream(new File(each, "cmdline"));
                try {
                    String cmdlineString = new String(FileUtil.loadBytes((InputStream)stream));
                    cmdline = StringUtil.split((String)cmdlineString, (String)"\u0000");
                }
                finally {
                    stream.close();
                }
            }
            catch (IOException e) {
                continue;
            }
            if (cmdline.isEmpty()) continue;
            result.add(new ProcessInfo(pid, StringUtil.join((Collection)cmdline, (String)" "), PathUtil.getFileName((String)((String)cmdline.get(0))), StringUtil.join(cmdline.subList(1, cmdline.size()), (String)" ")));
        }
        return result;
    }

    @Nullable
    private static List<ProcessInfo> getProcessList_Mac() {
        return ProcessListUtil.parseCommandOutput(Arrays.asList("/bin/ps", "-a", "-x", "-o", "pid,state,user,comm"), new NullableFunction<String, List<ProcessInfo>>(){

            @Nullable
            public List<ProcessInfo> fun(final String commandOnly) {
                return ProcessListUtil.parseCommandOutput(Arrays.asList("/bin/ps", "-a", "-x", "-o", "pid,state,user,command"), (NullableFunction<String, List<ProcessInfo>>)((NullableFunction)new NullableFunction<String, List<ProcessInfo>>(){

                    @Nullable
                    public List<ProcessInfo> fun(String full) {
                        return ProcessListUtil.parseMacOutput(commandOnly, full);
                    }
                }));
            }
        });
    }

    @Nullable
    static List<ProcessInfo> parseMacOutput(String commandOnly, String full) {
        List<MacProcessInfo> commands = ProcessListUtil.doParseMacOutput(commandOnly);
        List<MacProcessInfo> fulls = ProcessListUtil.doParseMacOutput(full);
        if (commands == null || fulls == null) {
            return null;
        }
        TIntObjectHashMap idToCommand = new TIntObjectHashMap();
        for (MacProcessInfo each : commands) {
            idToCommand.put(each.pid, (Object)each.commandLine);
        }
        ArrayList<ProcessInfo> result = new ArrayList<ProcessInfo>();
        for (MacProcessInfo each : fulls) {
            String command;
            if (!idToCommand.containsKey(each.pid) || !each.commandLine.equals(command = (String)idToCommand.get(each.pid)) && !each.commandLine.startsWith(command + " ")) continue;
            String name = PathUtil.getFileName((String)command);
            String args = each.commandLine.substring(command.length()).trim();
            result.add(new ProcessInfo(each.pid, each.commandLine, name, args));
        }
        return result;
    }

    @Nullable
    private static List<MacProcessInfo> doParseMacOutput(String output) {
        ArrayList result = ContainerUtil.newArrayList();
        String[] lines = StringUtil.splitByLinesDontTrim((String)output);
        if (lines.length == 0) {
            return null;
        }
        String header = lines[0];
        int pidStart = header.indexOf("PID");
        if (pidStart == -1) {
            return null;
        }
        int statStart = header.indexOf("S", pidStart);
        if (statStart == -1) {
            return null;
        }
        int userStart = header.indexOf("USER", statStart);
        if (userStart == -1) {
            return null;
        }
        int commandStart = header.indexOf("COMM", userStart);
        if (commandStart == -1) {
            return null;
        }
        for (int i = 1; i < lines.length; ++i) {
            String state;
            String line = lines[i];
            int pid = StringUtil.parseInt((String)line.substring(0, statStart).trim(), (int)-1);
            if (pid == -1 || (state = line.substring(statStart, userStart).trim()).contains("Z")) continue;
            String user = line.substring(userStart, commandStart).trim();
            String commandLine = line.substring(commandStart).trim();
            result.add(new MacProcessInfo(pid, commandLine, user, state));
        }
        return result;
    }

    @Nullable
    static List<ProcessInfo> getProcessList_WindowsWMIC() {
        return ProcessListUtil.parseCommandOutput(Arrays.asList("wmic.exe", "path", "win32_process", "get", "Caption,Processid,Commandline"), new NullableFunction<String, List<ProcessInfo>>(){

            @Nullable
            public List<ProcessInfo> fun(String output) {
                return ProcessListUtil.parseWMICOutput(output);
            }
        });
    }

    @Nullable
    static List<ProcessInfo> parseWMICOutput(@NotNull String output) {
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "com/intellij/execution/process/impl/ProcessListUtil", "parseWMICOutput"));
        }
        ArrayList result = ContainerUtil.newArrayList();
        String[] lines = StringUtil.splitByLinesDontTrim((String)output);
        if (lines.length == 0) {
            return null;
        }
        String header = lines[0];
        int commandLineStart = header.indexOf("CommandLine");
        if (commandLineStart == -1) {
            return null;
        }
        int pidStart = header.indexOf("ProcessId");
        if (pidStart == -1) {
            return null;
        }
        for (int i = 1; i < lines.length; ++i) {
            String name;
            String line = lines[i];
            int pid = StringUtil.parseInt((String)line.substring(pidStart, line.length()).trim(), (int)-1);
            if (pid == -1 || pid == 0 || (name = line.substring(0, commandLineStart).trim()).isEmpty()) continue;
            String commandLine = line.substring(commandLineStart, pidStart).trim();
            String args = "";
            if (commandLine.isEmpty()) {
                commandLine = name;
            } else {
                int nameIndex = StringUtil.indexOfIgnoreCase((String)commandLine, (String)name, (int)0);
                if (nameIndex != -1) {
                    args = commandLine.substring(nameIndex + name.length()).trim();
                }
            }
            result.add(new ProcessInfo(pid, commandLine, name, args));
        }
        return result;
    }

    @Nullable
    static List<ProcessInfo> getProcessList_WindowsTaskList() {
        return ProcessListUtil.parseCommandOutput(Arrays.asList("tasklist.exe", "/fo", "csv", "/nh", "/v"), new NullableFunction<String, List<ProcessInfo>>(){

            @Nullable
            public List<ProcessInfo> fun(String output) {
                return ProcessListUtil.parseListTasksOutput(output);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    static List<ProcessInfo> parseListTasksOutput(@NotNull String output) {
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "com/intellij/execution/process/impl/ProcessListUtil", "parseListTasksOutput"));
        }
        ArrayList result = ContainerUtil.newArrayList();
        CSVReader reader = new CSVReader(new StringReader(output));
        try {
            while (true) {
                String[] next;
                if ((next = reader.readNext()) != null) {
                    String name;
                    if (next.length < 2) {
                        List<ProcessInfo> list = null;
                        return list;
                    }
                    int pid = StringUtil.parseInt((String)next[1], (int)-1);
                    if (pid == -1 || (name = next[0]).isEmpty()) continue;
                    result.add(new ProcessInfo(pid, name, name, ""));
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            LOG.error("Cannot parse listtasks output", (Throwable)e);
            List<ProcessInfo> list = null;
            return list;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    private static class MacProcessInfo {
        final int pid;
        final String commandLine;
        final String user;
        final String state;

        public MacProcessInfo(int pid, String commandLine, String user, String state) {
            this.pid = pid;
            this.commandLine = commandLine;
            this.user = user;
            this.state = state;
        }
    }
}

