/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetManagerAdapter;
import com.intellij.facet.FacetModificationTrackingService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.ModificationTrackerListener;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.util.EventDispatcher;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class FacetModificationTrackingServiceImpl
extends FacetModificationTrackingService {
    private final Map<Facet, Pair<SimpleModificationTracker, EventDispatcher<ModificationTrackerListener>>> myModificationsTrackers = new THashMap();

    public FacetModificationTrackingServiceImpl(Module module2) {
        module2.getMessageBus().connect().subscribe(FacetManager.FACETS_TOPIC, (Object)new FacetModificationTrackingListener());
    }

    @NotNull
    public ModificationTracker getFacetModificationTracker(@NotNull Facet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/facet/impl/FacetModificationTrackingServiceImpl", "getFacetModificationTracker"));
        }
        ModificationTracker modificationTracker = (ModificationTracker)this.getFacetInfo((Facet)facet).first;
        if (modificationTracker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/FacetModificationTrackingServiceImpl", "getFacetModificationTracker"));
        }
        return modificationTracker;
    }

    private Pair<SimpleModificationTracker, EventDispatcher<ModificationTrackerListener>> getFacetInfo(Facet facet) {
        Pair pair = this.myModificationsTrackers.get(facet);
        if (pair == null) {
            pair = Pair.create((Object)new SimpleModificationTracker(), (Object)EventDispatcher.create(ModificationTrackerListener.class));
            this.myModificationsTrackers.put(facet, (Pair<SimpleModificationTracker, EventDispatcher<ModificationTrackerListener>>)pair);
        }
        return pair;
    }

    public void incFacetModificationTracker(@NotNull Facet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/facet/impl/FacetModificationTrackingServiceImpl", "incFacetModificationTracker"));
        }
        Pair<SimpleModificationTracker, EventDispatcher<ModificationTrackerListener>> pair = this.getFacetInfo(facet);
        ((SimpleModificationTracker)pair.first).incModificationCount();
        ((ModificationTrackerListener)((EventDispatcher)pair.second).getMulticaster()).modificationCountChanged((Object)facet);
    }

    public <T extends Facet> void addModificationTrackerListener(T facet, ModificationTrackerListener<? super T> listener, Disposable parent) {
        ((EventDispatcher)this.getFacetInfo(facet).second).addListener(listener, parent);
    }

    public void removeModificationTrackerListener(Facet facet, ModificationTrackerListener<?> listener) {
        ((EventDispatcher)this.getFacetInfo((Facet)facet).second).removeListener(listener);
    }

    private class FacetModificationTrackingListener
    extends FacetManagerAdapter {
        private FacetModificationTrackingListener() {
        }

        public void facetConfigurationChanged(@NotNull Facet facet) {
            if (facet == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/facet/impl/FacetModificationTrackingServiceImpl$FacetModificationTrackingListener", "facetConfigurationChanged"));
            }
            Pair pair = (Pair)FacetModificationTrackingServiceImpl.this.myModificationsTrackers.get(facet);
            if (pair != null) {
                ((SimpleModificationTracker)pair.first).incModificationCount();
                ((ModificationTrackerListener)((EventDispatcher)pair.second).getMulticaster()).modificationCountChanged((Object)facet);
            }
        }

        public void facetRemoved(@NotNull Facet facet) {
            if (facet == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/facet/impl/FacetModificationTrackingServiceImpl$FacetModificationTrackingListener", "facetRemoved"));
            }
            FacetModificationTrackingServiceImpl.this.myModificationsTrackers.remove(facet);
        }
    }
}

