/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.GeneralSettings;
import com.intellij.ide.GeneralSettingsConfigurableEP;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.CompositeConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneralSettingsConfigurable
extends CompositeConfigurable<SearchableConfigurable>
implements SearchableConfigurable,
Configurable.NoScroll {
    private static final ExtensionPointName<GeneralSettingsConfigurableEP> EP_NAME = ExtensionPointName.create((String)"com.intellij.generalOptionsProvider");
    private MyComponent myComponent = new MyComponent();

    @Override
    public void apply() throws ConfigurationException {
        super.apply();
        GeneralSettings settings = GeneralSettings.getInstance();
        settings.setReopenLastProject(this.myComponent.myChkReopenLastProject.isSelected());
        settings.setSyncOnFrameActivation(this.myComponent.myChkSyncOnFrameActivation.isSelected());
        settings.setSaveOnFrameDeactivation(this.myComponent.myChkSaveOnFrameDeactivation.isSelected());
        settings.setConfirmExit(this.myComponent.myConfirmExit.isSelected());
        settings.setConfirmOpenNewProject(this.getConfirmOpenNewProject());
        settings.setAutoSaveIfInactive(this.myComponent.myChkAutoSaveIfInactive.isSelected());
        try {
            int newInactiveTimeout = Integer.parseInt(this.myComponent.myTfInactiveTimeout.getText());
            if (newInactiveTimeout > 0) {
                settings.setInactiveTimeout(newInactiveTimeout);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        settings.setUseSafeWrite(this.myComponent.myChkUseSafeWrite.isSelected());
    }

    private int getConfirmOpenNewProject() {
        if (this.myComponent.myConfirmWindowToOpenProject.isSelected()) {
            return -1;
        }
        if (this.myComponent.myOpenProjectInNewWindow.isSelected()) {
            return 0;
        }
        return 1;
    }

    @Override
    public boolean isModified() {
        if (super.isModified()) {
            return true;
        }
        boolean isModified = false;
        GeneralSettings settings = GeneralSettings.getInstance();
        isModified |= settings.isReopenLastProject() != this.myComponent.myChkReopenLastProject.isSelected();
        isModified |= settings.isSyncOnFrameActivation() != this.myComponent.myChkSyncOnFrameActivation.isSelected();
        isModified |= settings.isSaveOnFrameDeactivation() != this.myComponent.myChkSaveOnFrameDeactivation.isSelected();
        isModified |= settings.isAutoSaveIfInactive() != this.myComponent.myChkAutoSaveIfInactive.isSelected();
        isModified |= settings.isConfirmExit() != this.myComponent.myConfirmExit.isSelected();
        isModified |= settings.getConfirmOpenNewProject() != this.getConfirmOpenNewProject();
        int inactiveTimeout = -1;
        try {
            inactiveTimeout = Integer.parseInt(this.myComponent.myTfInactiveTimeout.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        isModified |= inactiveTimeout > 0 && settings.getInactiveTimeout() != inactiveTimeout;
        return isModified |= settings.isUseSafeWrite() != this.myComponent.myChkUseSafeWrite.isSelected();
    }

    public JComponent createComponent() {
        if (this.myComponent == null) {
            this.myComponent = new MyComponent();
        }
        this.myComponent.myChkAutoSaveIfInactive.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GeneralSettingsConfigurable.this.myComponent.myTfInactiveTimeout.setEditable(GeneralSettingsConfigurable.this.myComponent.myChkAutoSaveIfInactive.isSelected());
            }
        });
        List list = this.getConfigurables();
        if (!list.isEmpty()) {
            this.myComponent.myPluginOptionsPanel.setLayout(new GridLayout(list.size(), 1));
            for (Configurable c : list) {
                this.myComponent.myPluginOptionsPanel.add(c.createComponent());
            }
        }
        return this.myComponent.myPanel;
    }

    public String getDisplayName() {
        return IdeBundle.message((String)"title.general", (Object[])new Object[0]);
    }

    @Override
    public void reset() {
        super.reset();
        GeneralSettings settings = GeneralSettings.getInstance();
        this.myComponent.myChkReopenLastProject.setSelected(settings.isReopenLastProject());
        this.myComponent.myChkSyncOnFrameActivation.setSelected(settings.isSyncOnFrameActivation());
        this.myComponent.myChkSaveOnFrameDeactivation.setSelected(settings.isSaveOnFrameDeactivation());
        this.myComponent.myChkAutoSaveIfInactive.setSelected(settings.isAutoSaveIfInactive());
        this.myComponent.myTfInactiveTimeout.setText(Integer.toString(settings.getInactiveTimeout()));
        this.myComponent.myTfInactiveTimeout.setEditable(settings.isAutoSaveIfInactive());
        this.myComponent.myChkUseSafeWrite.setSelected(settings.isUseSafeWrite());
        this.myComponent.myConfirmExit.setSelected(settings.isConfirmExit());
        switch (settings.getConfirmOpenNewProject()) {
            case -1: {
                this.myComponent.myConfirmWindowToOpenProject.setSelected(true);
                break;
            }
            case 0: {
                this.myComponent.myOpenProjectInNewWindow.setSelected(true);
                break;
            }
            case 1: {
                this.myComponent.myOpenProjectInSameWindow.setSelected(true);
            }
        }
    }

    @Override
    public void disposeUIResources() {
        super.disposeUIResources();
        this.myComponent = null;
    }

    @NotNull
    public String getHelpTopic() {
        if ("preferences.general" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/GeneralSettingsConfigurable", "getHelpTopic"));
        }
        return "preferences.general";
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/GeneralSettingsConfigurable", "getId"));
        }
        return string;
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    @Override
    protected List<SearchableConfigurable> createConfigurables() {
        return ConfigurableWrapper.createConfigurables(EP_NAME);
    }

    private static class MyComponent {
        private JPanel myPanel;
        private JCheckBox myChkReopenLastProject;
        private JCheckBox myChkSyncOnFrameActivation;
        private JCheckBox myChkSaveOnFrameDeactivation;
        private JCheckBox myChkAutoSaveIfInactive;
        private JTextField myTfInactiveTimeout;
        private JCheckBox myChkUseSafeWrite;
        private JCheckBox myConfirmExit;
        private JPanel myPluginOptionsPanel;
        private JBRadioButton myOpenProjectInNewWindow;
        private JBRadioButton myOpenProjectInSameWindow;
        private JBRadioButton myConfirmWindowToOpenProject;

        public MyComponent() {
            this.$$$setupUI$$$();
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JBRadioButton jBRadioButton;
            JBRadioButton jBRadioButton2;
            JBRadioButton jBRadioButton3;
            JPanel jPanel;
            JCheckBox jCheckBox;
            JTextField jTextField;
            JCheckBox jCheckBox2;
            JCheckBox jCheckBox3;
            JCheckBox jCheckBox4;
            JCheckBox jCheckBox5;
            JCheckBox jCheckBox6;
            JPanel jPanel2;
            this.myPanel = jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            Spacer spacer = new Spacer();
            jPanel2.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
            jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Startup/Shutdown", (int)0, (int)0, null, null));
            this.myChkReopenLastProject = jCheckBox6 = new JCheckBox();
            jCheckBox6.setSelected(true);
            this.$$$loadButtonText$$$(jCheckBox6, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.reopen.last.project.on.startup"));
            jPanel3.add((Component)jCheckBox6, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            Spacer spacer2 = new Spacer();
            jPanel3.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            this.myConfirmExit = jCheckBox5 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.confirm.application.exit"));
            jPanel3.add((Component)jCheckBox5, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
            jPanel2.add((Component)jPanel4, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            jPanel4.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Synchronization", (int)0, (int)0, null, null));
            this.myChkSyncOnFrameActivation = jCheckBox4 = new JCheckBox();
            jCheckBox4.setSelected(true);
            this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.synchronize.files.on.frame.activation"));
            jPanel4.add((Component)jCheckBox4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            Spacer spacer3 = new Spacer();
            jPanel4.add((Component)spacer3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
            Spacer spacer4 = new Spacer();
            jPanel4.add((Component)spacer4, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            this.myChkSaveOnFrameDeactivation = jCheckBox3 = new JCheckBox();
            jCheckBox3.setSelected(true);
            this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.save.files.on.frame.deactivation"));
            jPanel4.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myChkAutoSaveIfInactive = jCheckBox2 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.save.files.automatically"));
            jPanel4.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel4.add((Component)jPanel5, new GridConstraints(2, 1, 1, 1, 8, 2, 0, 3, null, null, null));
            JLabel jLabel = new JLabel();
            this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/IdeBundle").getString("label.inactive.timeout.sec"));
            jPanel5.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myTfInactiveTimeout = jTextField = new JTextField();
            jTextField.setMargin(new Insets(0, 2, 0, 4));
            jTextField.setColumns(10);
            jPanel5.add((Component)jTextField, new GridConstraints(0, 0, 1, 1, 8, 1, 0, 0, new Dimension(50, -1), new Dimension(50, -1), new Dimension(50, -1)));
            this.myChkUseSafeWrite = jCheckBox = new JCheckBox();
            jCheckBox.setToolTipText("<html>If this check box is selected, a changed file will be first saved to a temporary file;<br>if the save operation is completed successfully, the original file is deleted, and the temporary file is renamed.</html> ");
            jCheckBox.setSelected(true);
            jCheckBox.setText("Use \"safe write\" (save changes to a temporary file first)");
            jPanel4.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 2, 8, 0, 3, 0, null, null, null));
            Spacer spacer5 = new Spacer();
            jPanel2.add((Component)spacer5, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 1, null, null, null));
            this.myPluginOptionsPanel = jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout(0, 0));
            jPanel2.add((Component)jPanel, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            JPanel jPanel6 = new JPanel();
            jPanel6.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel6.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
            jPanel2.add((Component)jPanel6, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            jPanel6.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Project Opening", (int)0, (int)0, null, null));
            this.myOpenProjectInSameWindow = jBRadioButton3 = new JBRadioButton();
            jBRadioButton3.setText("Open project in the same window");
            jPanel6.add((Component)jBRadioButton3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myConfirmWindowToOpenProject = jBRadioButton2 = new JBRadioButton();
            jBRadioButton2.setText("Confirm window to open project in");
            jPanel6.add((Component)jBRadioButton2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            Spacer spacer6 = new Spacer();
            jPanel6.add((Component)spacer6, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            this.myOpenProjectInNewWindow = jBRadioButton = new JBRadioButton();
            jBRadioButton.setText("Open project in new window");
            jPanel6.add((Component)jBRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup = new ButtonGroup();
            buttonGroup.add((AbstractButton)jBRadioButton);
            buttonGroup.add((AbstractButton)jBRadioButton3);
            buttonGroup.add((AbstractButton)jBRadioButton2);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myPanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

