/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actions.ActivateToolWindowAction;
import com.intellij.ide.actions.SwitcherToolWindowsListRenderer;
import com.intellij.ide.actions.ToolWindowsGroup;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.EditorTabbedContainer;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.Gray;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.SpeedSearchObjectWithWeight;
import com.intellij.ui.components.JBList;
import com.intellij.ui.speedSearch.NameFilteringListModel;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Switcher
extends AnAction
implements DumbAware {
    private static volatile SwitcherPanel SWITCHER;
    private static final Color BORDER_COLOR;
    private static final Color SEPARATOR_COLOR;
    @NonNls
    private static final String SWITCHER_FEATURE_ID = "switcher";
    private static final Color ON_MOUSE_OVER_BG_COLOR;
    private static int CTRL_KEY;
    private static int ALT_KEY;
    @Nullable
    public static final Runnable CHECKER;
    @NotNull
    private static final CustomShortcutSet TW_SHORTCUT;
    @NonNls
    private static final String SWITCHER_TITLE = "Switcher";
    @NonNls
    private static InputEvent INIT_EVENT;

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/Switcher", "update"));
        }
        e.getPresentation().setEnabled(e.getProject() != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/Switcher", "actionPerformed"));
        }
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        if (project2 == null) {
            return;
        }
        boolean isNewSwitcher = false;
        Class<Switcher> clazz = Switcher.class;
        synchronized (Switcher.class) {
            INIT_EVENT = e.getInputEvent();
            if (SWITCHER != null && SWITCHER.isPinnedMode()) {
                Switcher.SWITCHER.cancel();
                SWITCHER = null;
            }
            if (SWITCHER == null) {
                isNewSwitcher = true;
                SWITCHER = Switcher.createAndShowSwitcher(e, SWITCHER_TITLE, false, null);
                FeatureUsageTracker.getInstance().triggerFeatureUsed(SWITCHER_FEATURE_ID);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            assert (SWITCHER != null);
            if (!SWITCHER.isPinnedMode()) {
                if (e.getInputEvent().isShiftDown()) {
                    SWITCHER.goBack();
                } else if (isNewSwitcher && !FileEditorManagerEx.getInstanceEx(project2).hasOpenedFile()) {
                    Switcher.SWITCHER.files.setSelectedIndex(0);
                } else {
                    SWITCHER.goForward();
                }
            }
            return;
        }
    }

    @Nullable
    public static SwitcherPanel createAndShowSwitcher(@NotNull AnActionEvent e, @NotNull String title, boolean pinned, @Nullable VirtualFile[] vFiles) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/Switcher", "createAndShowSwitcher"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/ide/actions/Switcher", "createAndShowSwitcher"));
        }
        Project project2 = Switcher.getEventProject((AnActionEvent)e);
        if (SWITCHER != null && Comparing.equal((String)Switcher.SWITCHER.myTitle, (String)title)) {
            SWITCHER.goForward();
            return null;
        }
        return project2 == null ? null : Switcher.createAndShowSwitcher(project2, title, pinned, vFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static SwitcherPanel createAndShowSwitcher(@NotNull Project project2, @NotNull String title, boolean pinned, final @Nullable VirtualFile[] vFiles) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/actions/Switcher", "createAndShowSwitcher"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/ide/actions/Switcher", "createAndShowSwitcher"));
        }
        Class<Switcher> clazz = Switcher.class;
        synchronized (Switcher.class) {
            if (SWITCHER != null) {
                Switcher.SWITCHER.cancel();
            }
            SWITCHER = new SwitcherPanel(project2, title, pinned){

                @Override
                @NotNull
                protected VirtualFile[] getFiles(@NotNull Project project2) {
                    if (project2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/actions/Switcher$3", "getFiles"));
                    }
                    VirtualFile[] virtualFileArray = vFiles != null ? vFiles : super.getFiles(project2);
                    if (virtualFileArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/Switcher$3", "getFiles"));
                    }
                    return virtualFileArray;
                }
            };
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return SWITCHER;
        }
    }

    static {
        char ch;
        SWITCHER = null;
        BORDER_COLOR = Gray._135;
        SEPARATOR_COLOR = new JBColor(BORDER_COLOR.brighter(), (Color)Gray._75);
        ON_MOUSE_OVER_BG_COLOR = new JBColor(new Color(231, 242, 249), new Color(77, 80, 84));
        CHECKER = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<Switcher> clazz = Switcher.class;
                synchronized (Switcher.class) {
                    if (SWITCHER != null) {
                        SWITCHER.navigate(null);
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        };
        Shortcut recentFiles = (Shortcut)ArrayUtil.getFirstElement((Object[])KeymapManager.getInstance().getActiveKeymap().getShortcuts("RecentFiles"));
        ArrayList shortcuts = ContainerUtil.newArrayList();
        for (ch = '0'; ch <= '9'; ch = (char)(ch + '\u0001')) {
            shortcuts.add(CustomShortcutSet.fromString((String[])new String[]{"control " + ch}).getShortcuts()[0]);
        }
        for (ch = 'A'; ch <= 'Z'; ch = (char)(ch + '\u0001')) {
            Shortcut shortcut = CustomShortcutSet.fromString((String[])new String[]{"control " + ch}).getShortcuts()[0];
            if (shortcut.equals(recentFiles)) continue;
            shortcuts.add(shortcut);
        }
        TW_SHORTCUT = new CustomShortcutSet(shortcuts.toArray(new Shortcut[shortcuts.size()]));
        IdeEventQueue.getInstance().addPostprocessor(new IdeEventQueue.EventDispatcher(){

            @Override
            public boolean dispatch(AWTEvent event) {
                if (SWITCHER != null && event instanceof KeyEvent && !SWITCHER.isPinnedMode()) {
                    ToolWindow tw;
                    KeyEvent keyEvent = (KeyEvent)event;
                    if (event.getID() == 402 && keyEvent.getKeyCode() == CTRL_KEY) {
                        SwingUtilities.invokeLater(CHECKER);
                    } else if (event.getID() == 401 && event != INIT_EVENT && (tw = SWITCHER.twShortcuts.get(String.valueOf((char)keyEvent.getKeyCode()))) != null) {
                        SWITCHER.myPopup.closeOk(null);
                        tw.activate(null, true, true);
                    }
                }
                return false;
            }
        }, null);
    }

    private static class FileInfo
    extends Pair<VirtualFile, EditorWindow> {
        private final Project myProject;
        private String myNameForRendering;

        public FileInfo(VirtualFile first, EditorWindow second, Project project2) {
            super((Object)first, (Object)second);
            this.myProject = project2;
        }

        String getNameForRendering() {
            if (this.myNameForRendering == null) {
                this.myNameForRendering = EditorTabbedContainer.calcTabTitle(this.myProject, (VirtualFile)this.first);
            }
            return this.myNameForRendering;
        }
    }

    private static class VirtualFilesRenderer
    extends ColoredListCellRenderer {
        private final SwitcherPanel mySwitcherPanel;
        boolean open;

        public VirtualFilesRenderer(@NotNull SwitcherPanel switcherPanel) {
            if (switcherPanel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "switcherPanel", "com/intellij/ide/actions/Switcher$VirtualFilesRenderer", "<init>"));
            }
            this.mySwitcherPanel = switcherPanel;
        }

        protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            if (value instanceof FileInfo) {
                Project project2 = this.mySwitcherPanel.project;
                VirtualFile virtualFile = (VirtualFile)((FileInfo)((Object)value)).getFirst();
                String renderedName = ((FileInfo)((Object)value)).getNameForRendering();
                this.setIcon(IconUtil.getIcon((VirtualFile)virtualFile, (int)2, (Project)project2));
                FileStatus fileStatus = FileStatusManager.getInstance((Project)project2).getStatus(virtualFile);
                this.open = FileEditorManager.getInstance((Project)project2).isFileOpen(virtualFile);
                TextAttributes attributes = new TextAttributes(fileStatus.getColor(), null, null, EffectType.LINE_UNDERSCORE, 0);
                this.append(renderedName, SimpleTextAttributes.fromTextAttributes((TextAttributes)attributes));
                Color color = EditorTabbedContainer.calcTabColor(project2, virtualFile);
                if (!selected && color != null) {
                    this.setBackground(color);
                }
                SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)this.mySwitcherPanel, (SimpleColoredComponent)this, (boolean)false, (boolean)selected);
            }
        }
    }

    public static class SwitcherPanel
    extends JPanel
    implements KeyListener,
    MouseListener,
    MouseMotionListener {
        final JBPopup myPopup;
        final JBList toolWindows;
        final JBList files;
        final JPanel separator;
        final ToolWindowManager twManager;
        final JLabel pathLabel;
        final JPanel descriptions;
        final Project project;
        private final boolean myPinned;
        final Map<String, ToolWindow> twShortcuts;
        final Alarm myAlarm;
        final SwitcherSpeedSearch mySpeedSearch;
        final String myTitle;
        final ClickListener myClickListener;
        KeyEvent lastEvent;
        private boolean mouseMovedFirstTime;
        private JList mouseMoveSrc;
        private int mouseMoveListIndex;

        SwitcherPanel(@NotNull Project project2, @NotNull String title, boolean pinned) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/actions/Switcher$SwitcherPanel", "<init>"));
            }
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/ide/actions/Switcher$SwitcherPanel", "<init>"));
            }
            this.pathLabel = new JLabel(" ");
            this.myClickListener = new ClickListener(){

                public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/Switcher$SwitcherPanel$1", "onClick"));
                    }
                    if (SwitcherPanel.this.myPinned && (e.isControlDown() || e.isMetaDown() || e.isShiftDown())) {
                        return false;
                    }
                    Object source = e.getSource();
                    if (source instanceof JList) {
                        JList jList = (JList)source;
                        if (jList.getSelectedIndex() == -1 && jList.getAnchorSelectionIndex() != -1) {
                            jList.setSelectedIndex(jList.getAnchorSelectionIndex());
                        }
                        if (jList.getSelectedIndex() != -1) {
                            SwitcherPanel.this.navigate(e);
                        }
                    }
                    return true;
                }
            };
            this.mouseMovedFirstTime = true;
            this.mouseMoveSrc = null;
            this.mouseMoveListIndex = -1;
            this.setLayout(new SwitcherLayouter());
            this.project = project2;
            this.myTitle = title;
            this.myPinned = pinned;
            this.mySpeedSearch = pinned ? new SwitcherSpeedSearch() : null;
            this.setBorder((Border)JBUI.Borders.empty());
            this.setBackground(JBColor.background());
            this.pathLabel.setHorizontalAlignment(2);
            Font font = this.pathLabel.getFont();
            this.pathLabel.setFont(font.deriveFont(Math.max(10.0f, (float)font.getSize() - 4.0f)));
            this.descriptions = new JPanel(new BorderLayout()){

                @Override
                protected void paintComponent(@NotNull Graphics g) {
                    if (g == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/ide/actions/Switcher$SwitcherPanel$2", "paintComponent"));
                    }
                    super.paintComponent(g);
                    g.setColor(UIUtil.isUnderDarcula() ? SEPARATOR_COLOR : BORDER_COLOR);
                    g.drawLine(0, 0, this.getWidth(), 0);
                }
            };
            this.descriptions.setBorder(BorderFactory.createEmptyBorder(1, 4, 1, 4));
            this.descriptions.add((Component)this.pathLabel, "Center");
            this.twManager = ToolWindowManager.getInstance((Project)project2);
            DefaultListModel<ToolWindow> twModel = new DefaultListModel<ToolWindow>();
            List<ActivateToolWindowAction> actions = ToolWindowsGroup.getToolWindowActions(project2, true);
            ArrayList windows = ContainerUtil.newArrayList();
            for (Object action : actions) {
                ToolWindow tw = this.twManager.getToolWindow(action.getToolWindowId());
                if (!tw.isAvailable()) continue;
                windows.add(tw);
            }
            this.twShortcuts = SwitcherPanel.createShortcuts(windows);
            final Map map = ContainerUtil.reverseMap(this.twShortcuts);
            Collections.sort(windows, new Comparator<ToolWindow>(){

                @Override
                public int compare(@NotNull ToolWindow o1, @NotNull ToolWindow o2) {
                    if (o1 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/ide/actions/Switcher$SwitcherPanel$3", "compare"));
                    }
                    if (o2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/ide/actions/Switcher$SwitcherPanel$3", "compare"));
                    }
                    return StringUtil.compare((String)((String)map.get(o1)), (String)((String)map.get(o2)), (boolean)false);
                }
            });
            for (ToolWindow window : windows) {
                twModel.addElement(window);
            }
            this.toolWindows = new JBList(twModel);
            if (pinned) {
                new NameFilteringListModel((JList)this.toolWindows, (Function)new Function<ToolWindow, String>(){

                    @NotNull
                    public String fun(@NotNull ToolWindow window) {
                        if (window == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/ide/actions/Switcher$SwitcherPanel$4", "fun"));
                        }
                        String string = window.getStripeTitle();
                        if (string == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/Switcher$SwitcherPanel$4", "fun"));
                        }
                        return string;
                    }
                }, (Condition)new Condition<String>(){

                    public boolean value(@NotNull String s) {
                        if (s == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/ide/actions/Switcher$SwitcherPanel$5", "value"));
                        }
                        return !SwitcherPanel.this.mySpeedSearch.isPopupActive() || StringUtil.isEmpty((String)SwitcherPanel.this.mySpeedSearch.getEnteredPrefix()) || SwitcherPanel.this.mySpeedSearch.getComparator().matchingFragments(SwitcherPanel.this.mySpeedSearch.getEnteredPrefix(), s) != null;
                    }
                }, (SpeedSearchSupply)this.mySpeedSearch);
            }
            this.toolWindows.setBorder(IdeBorderFactory.createEmptyBorder((int)5, (int)5, (int)5, (int)20));
            this.toolWindows.setSelectionMode(pinned ? 2 : 0);
            this.toolWindows.setCellRenderer((ListCellRenderer)((Object)new SwitcherToolWindowsListRenderer(this.mySpeedSearch, map, this.myPinned){

                @NotNull
                public Component getListCellRendererComponent(@NotNull JList list, Object value, int index, boolean selected, boolean hasFocus) {
                    if (list == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ide/actions/Switcher$SwitcherPanel$6", "getListCellRendererComponent"));
                    }
                    JComponent renderer = (JComponent)super.getListCellRendererComponent(list, value, index, selected, selected);
                    if (selected) {
                        JComponent jComponent = renderer;
                        if (jComponent == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/Switcher$SwitcherPanel$6", "getListCellRendererComponent"));
                        }
                        return jComponent;
                    }
                    Color bgColor = list == SwitcherPanel.this.mouseMoveSrc && index == SwitcherPanel.this.mouseMoveListIndex ? ON_MOUSE_OVER_BG_COLOR : list.getBackground();
                    UIUtil.changeBackGround((Component)renderer, (Color)bgColor);
                    JComponent jComponent = renderer;
                    if (jComponent == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/Switcher$SwitcherPanel$6", "getListCellRendererComponent"));
                    }
                    return jComponent;
                }
            }));
            this.toolWindows.addKeyListener((KeyListener)this);
            ScrollingUtil.installActions((JList)this.toolWindows);
            this.toolWindows.addMouseListener((MouseListener)this);
            this.toolWindows.addMouseMotionListener((MouseMotionListener)this);
            ScrollingUtil.ensureSelectionExists((JList)this.toolWindows);
            this.myClickListener.installOn((Component)this.toolWindows);
            this.toolWindows.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(@NotNull ListSelectionEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/Switcher$SwitcherPanel$7", "valueChanged"));
                    }
                    if (!SwitcherPanel.this.toolWindows.isSelectionEmpty() && !SwitcherPanel.this.files.isSelectionEmpty()) {
                        SwitcherPanel.this.files.clearSelection();
                    }
                }
            });
            this.separator = new JPanel(){

                @Override
                protected void paintComponent(@NotNull Graphics g) {
                    if (g == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/ide/actions/Switcher$SwitcherPanel$8", "paintComponent"));
                    }
                    super.paintComponent(g);
                    g.setColor(SEPARATOR_COLOR);
                    g.drawLine(0, 0, 0, this.getHeight());
                }
            };
            this.separator.setBackground(this.toolWindows.getBackground());
            int selectionIndex = -1;
            FileEditorManagerImpl editorManager = (FileEditorManagerImpl)FileEditorManager.getInstance((Project)project2);
            ArrayList filesData = new ArrayList();
            ArrayList<FileInfo> editors = new ArrayList<FileInfo>();
            if (!pinned && UISettings.getInstance().EDITOR_TAB_PLACEMENT != 0) {
                for (Pair<VirtualFile, EditorWindow> pair : editorManager.getSelectionHistory()) {
                    editors.add(new FileInfo((VirtualFile)pair.first, (EditorWindow)pair.second, project2));
                }
            }
            if (editors.size() < 2 || this.isPinnedMode()) {
                if (this.isPinnedMode() && editors.size() > 1) {
                    filesData.addAll(editors);
                }
                VirtualFile[] recentFiles = (VirtualFile[])ArrayUtil.reverseArray((Object[])this.getFiles(project2));
                int maxFiles = Math.max(editors.size(), recentFiles.length);
                int len = this.isPinnedMode() ? recentFiles.length : Math.min(this.toolWindows.getModel().getSize(), maxFiles);
                boolean firstRecentMarked = false;
                List<VirtualFile> selectedFiles = Arrays.asList(editorManager.getSelectedFiles());
                for (int i = 0; i < len; ++i) {
                    if (this.isPinnedMode() && selectedFiles.contains(recentFiles[i])) continue;
                    FileInfo info = new FileInfo(recentFiles[i], null, project2);
                    boolean add = true;
                    if (this.isPinnedMode()) {
                        for (FileInfo fileInfo : filesData) {
                            if (!((VirtualFile)fileInfo.first).equals(info.first)) continue;
                            add = false;
                            break;
                        }
                    }
                    if (!add) continue;
                    filesData.add(info);
                    if (firstRecentMarked) continue;
                    firstRecentMarked = true;
                    selectionIndex = filesData.size() - 1;
                }
                if (editors.size() == 1 && (filesData.isEmpty() || !((VirtualFile)((FileInfo)((Object)editors.get(0))).getFirst()).equals(((FileInfo)((Object)filesData.get(0))).getFirst()))) {
                    filesData.add(0, editors.get(0));
                }
            } else {
                for (int i = 0; i < Math.min(30, editors.size()); ++i) {
                    filesData.add(editors.get(i));
                }
            }
            DefaultListModel<FileInfo> filesModel = new DefaultListModel<FileInfo>();
            for (FileInfo editor : filesData) {
                filesModel.addElement(editor);
            }
            VirtualFilesRenderer filesRenderer = new VirtualFilesRenderer(this){
                JPanel myPanel;
                JLabel myLabel;
                {
                    this.myPanel = new JPanel(new BorderLayout());
                    this.myLabel = new JLabel(){

                        @Override
                        protected void paintComponent(@NotNull Graphics g) {
                            if (g == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/ide/actions/Switcher$SwitcherPanel$9$1", "paintComponent"));
                            }
                            GraphicsConfig config = new GraphicsConfig(g);
                            ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, 0.3f));
                            super.paintComponent(g);
                            config.restore();
                        }
                    };
                    this.myPanel.setOpaque(false);
                    this.myPanel.setBackground(UIUtil.getListBackground());
                    this.myLabel.setText("* ");
                }

                @NotNull
                public Component getListCellRendererComponent(@NotNull JList list, Object value, int index, boolean selected, boolean hasFocus) {
                    if (list == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ide/actions/Switcher$SwitcherPanel$9", "getListCellRendererComponent"));
                    }
                    assert (value instanceof FileInfo);
                    Component c = super.getListCellRendererComponent(list, value, index, selected, selected);
                    Color bg = UIUtil.getListBackground();
                    Color fg = UIUtil.getListForeground();
                    this.myLabel.setFont(list.getFont());
                    this.myLabel.setForeground(this.open ? fg : bg);
                    this.myPanel.removeAll();
                    this.myPanel.add((Component)this.myLabel, "West");
                    this.myPanel.add(c, "Center");
                    this.myPanel.getAccessibleContext().setAccessibleName(c.getAccessibleContext().getAccessibleName());
                    VirtualFile file2 = (VirtualFile)((FileInfo)((Object)value)).first;
                    String presentableUrl = ((VirtualFile)ObjectUtils.notNull((Object)file2.getParent(), (Object)file2)).getPresentableUrl();
                    String location = FileUtil.getLocationRelativeToUserHome((String)presentableUrl);
                    this.myPanel.getAccessibleContext().setAccessibleDescription(location);
                    JPanel jPanel = this.myPanel;
                    if (jPanel == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/Switcher$SwitcherPanel$9", "getListCellRendererComponent"));
                    }
                    return jPanel;
                }

                @Override
                protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                    this.setPaintFocusBorder(false);
                    super.customizeCellRenderer(list, value, index, selected, hasFocus);
                }
            };
            ListSelectionListener filesSelectionListener = new ListSelectionListener(){

                @Nullable
                private String getTitle2Text(@Nullable String fullText) {
                    int labelWidth = SwitcherPanel.this.pathLabel.getWidth();
                    if (fullText == null || fullText.length() == 0) {
                        return " ";
                    }
                    while (SwitcherPanel.this.pathLabel.getFontMetrics(SwitcherPanel.this.pathLabel.getFont()).stringWidth(fullText) > labelWidth) {
                        int sep = fullText.indexOf(File.separatorChar, 4);
                        if (sep < 0) {
                            return fullText;
                        }
                        fullText = "..." + fullText.substring(sep);
                    }
                    return fullText;
                }

                @Override
                public void valueChanged(@NotNull ListSelectionEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/Switcher$SwitcherPanel$10", "valueChanged"));
                    }
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.updatePathLabel();
                        }
                    });
                }

                private void updatePathLabel() {
                    Object[] values = SwitcherPanel.this.files.getSelectedValues();
                    if (values != null && values.length == 1) {
                        VirtualFile file2 = (VirtualFile)((FileInfo)((Object)values[0])).first;
                        String presentableUrl = ((VirtualFile)ObjectUtils.notNull((Object)file2.getParent(), (Object)file2)).getPresentableUrl();
                        SwitcherPanel.this.pathLabel.setText(this.getTitle2Text(FileUtil.getLocationRelativeToUserHome((String)presentableUrl)));
                    } else {
                        SwitcherPanel.this.pathLabel.setText(" ");
                    }
                }
            };
            this.files = new JBList(filesModel);
            if (pinned) {
                new NameFilteringListModel((JList)this.files, (Function)new Function<FileInfo, String>(){

                    public String fun(@NotNull FileInfo info) {
                        if (info == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/ide/actions/Switcher$SwitcherPanel$11", "fun"));
                        }
                        return info.getNameForRendering();
                    }
                }, (Condition)new Condition<String>(){

                    public boolean value(@NotNull String s) {
                        if (s == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/ide/actions/Switcher$SwitcherPanel$12", "value"));
                        }
                        return !SwitcherPanel.this.mySpeedSearch.isPopupActive() || StringUtil.isEmpty((String)SwitcherPanel.this.mySpeedSearch.getEnteredPrefix()) || SwitcherPanel.this.mySpeedSearch.getComparator().matchingFragments(SwitcherPanel.this.mySpeedSearch.getEnteredPrefix(), s) != null;
                    }
                }, (SpeedSearchSupply)this.mySpeedSearch);
            }
            this.files.setSelectionMode(pinned ? 2 : 0);
            this.files.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(@NotNull ListSelectionEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/Switcher$SwitcherPanel$13", "valueChanged"));
                    }
                    if (!SwitcherPanel.this.files.isSelectionEmpty() && !SwitcherPanel.this.toolWindows.isSelectionEmpty()) {
                        SwitcherPanel.this.toolWindows.getSelectionModel().clearSelection();
                    }
                }
            });
            this.files.getSelectionModel().addListSelectionListener(filesSelectionListener);
            this.files.setCellRenderer((ListCellRenderer)((Object)filesRenderer));
            this.files.setBorder(IdeBorderFactory.createEmptyBorder((int)5, (int)5, (int)5, (int)20));
            this.files.addKeyListener((KeyListener)this);
            ScrollingUtil.installActions((JList)this.files);
            this.files.addMouseListener((MouseListener)this);
            this.files.addMouseMotionListener((MouseMotionListener)this);
            this.myClickListener.installOn((Component)this.files);
            ScrollingUtil.ensureSelectionExists((JList)this.files);
            this.add((Component)this.toolWindows, "West");
            if (filesModel.size() > 0) {
                this.files.setAlignmentY(1.0f);
                if (this.files.getModel().getSize() > 20) {
                    JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)this.files, (boolean)true);
                    pane.setPreferredSize(new Dimension(this.files.getPreferredSize().width + 10, 400));
                    pane.setHorizontalScrollBarPolicy(31);
                    this.add((Component)pane, "East");
                } else {
                    this.add((Component)this.files, "East");
                }
                if (selectionIndex > -1) {
                    this.files.setSelectedIndex(selectionIndex);
                }
                this.add((Component)this.separator, "Center");
            }
            this.add((Component)this.descriptions, "South");
            ShortcutSet shortcutSet = ActionManager.getInstance().getAction(Switcher.SWITCHER_TITLE).getShortcutSet();
            int modifiers = SwitcherPanel.getModifiers(shortcutSet);
            boolean isAlt = (modifiers & 8) != 0;
            ALT_KEY = isAlt ? 17 : 18;
            CTRL_KEY = isAlt ? 18 : 17;
            this.files.addKeyListener((KeyListener)ArrayUtil.getLastElement((Object[])this.getKeyListeners()));
            this.toolWindows.addKeyListener((KeyListener)ArrayUtil.getLastElement((Object[])this.getKeyListeners()));
            this.myPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)this, (JComponent)(filesModel.getSize() > 0 ? this.files : this.toolWindows)).setResizable(pinned).setModalContext(false).setFocusable(true).setRequestFocus(true).setTitle(title).setCancelOnWindowDeactivation(true).setCancelOnOtherWindowOpen(true).setMovable(pinned).setCancelKeyEnabled(false).setCancelCallback((Computable)new Computable<Boolean>(){

                @NotNull
                public Boolean compute() {
                    SWITCHER = null;
                    Boolean bl = true;
                    if (bl == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/Switcher$SwitcherPanel$14", "compute"));
                    }
                    return bl;
                }
            }).createPopup();
            if (this.isPinnedMode()) {
                new AnAction(null, null, null){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/Switcher$SwitcherPanel$15", "actionPerformed"));
                        }
                        SwitcherPanel.this.changeSelection();
                    }
                }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"TAB"}), (JComponent)this, (Disposable)this.myPopup);
                new AnAction(null, null, null){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/Switcher$SwitcherPanel$16", "actionPerformed"));
                        }
                        if (SwitcherPanel.this.mySpeedSearch != null && SwitcherPanel.this.mySpeedSearch.isPopupActive()) {
                            SwitcherPanel.this.mySpeedSearch.hidePopup();
                        } else {
                            SwitcherPanel.this.myPopup.cancel();
                        }
                    }
                }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"ESCAPE"}), (JComponent)this, (Disposable)this.myPopup);
            }
            new AnAction(null, null, null){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/Switcher$SwitcherPanel$17", "actionPerformed"));
                    }
                }
            }.registerCustomShortcutSet((ShortcutSet)TW_SHORTCUT, (JComponent)this, (Disposable)this.myPopup);
            Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
            if (window == null) {
                window = WindowManager.getInstance().getFrame(project2);
            }
            this.myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this.myPopup);
            this.myPopup.showInCenterOf((Component)window);
        }

        @NotNull
        protected VirtualFile[] getFiles(@NotNull Project project2) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/actions/Switcher$SwitcherPanel", "getFiles"));
            }
            VirtualFile[] virtualFileArray = EditorHistoryManager.getInstance(project2).getFiles();
            if (virtualFileArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/Switcher$SwitcherPanel", "getFiles"));
            }
            return virtualFileArray;
        }

        @NotNull
        private static Map<String, ToolWindow> createShortcuts(@NotNull List<ToolWindow> windows) {
            if (windows == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "windows", "com/intellij/ide/actions/Switcher$SwitcherPanel", "createShortcuts"));
            }
            HashMap<String, ToolWindow> keymap = new HashMap<String, ToolWindow>(windows.size());
            ArrayList<ToolWindow> otherTW = new ArrayList<ToolWindow>();
            for (ToolWindow window : windows) {
                int index = ActivateToolWindowAction.getMnemonicForToolWindow(((ToolWindowImpl)window).getId());
                if (index >= 48 && index <= 57) {
                    keymap.put(SwitcherPanel.getIndexShortcut(index - 48), window);
                    continue;
                }
                otherTW.add(window);
            }
            int i = 0;
            for (ToolWindow window : otherTW) {
                while (keymap.get(SwitcherPanel.getIndexShortcut(i)) != null) {
                    ++i;
                }
                keymap.put(SwitcherPanel.getIndexShortcut(i), window);
                ++i;
            }
            HashMap<String, ToolWindow> hashMap = keymap;
            if (hashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/Switcher$SwitcherPanel", "createShortcuts"));
            }
            return hashMap;
        }

        private static String getIndexShortcut(int index) {
            return StringUtil.toUpperCase((String)Integer.toString(index, index + 1));
        }

        private static int getModifiers(@Nullable ShortcutSet shortcutSet) {
            if (shortcutSet == null || shortcutSet.getShortcuts().length == 0 || !(shortcutSet.getShortcuts()[0] instanceof KeyboardShortcut)) {
                return 2;
            }
            return ((KeyboardShortcut)shortcutSet.getShortcuts()[0]).getFirstKeyStroke().getModifiers();
        }

        @Override
        public void keyTyped(@NotNull KeyEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/Switcher$SwitcherPanel", "keyTyped"));
            }
        }

        @Override
        public void keyReleased(@NotNull KeyEvent e) {
            boolean enter;
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/Switcher$SwitcherPanel", "keyReleased"));
            }
            boolean ctrl = e.getKeyCode() == CTRL_KEY;
            boolean bl = enter = e.getKeyCode() == 10;
            if (ctrl && this.isAutoHide() || enter) {
                this.navigate(e);
            } else if (e.getKeyCode() == 37) {
                this.goLeft();
            } else if (e.getKeyCode() == 39) {
                this.goRight();
            }
        }

        @Override
        public void keyPressed(@NotNull KeyEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/Switcher$SwitcherPanel", "keyPressed"));
            }
            if (this.mySpeedSearch != null && this.mySpeedSearch.isPopupActive() || this.lastEvent == e) {
                return;
            }
            this.lastEvent = e;
            switch (e.getKeyCode()) {
                case 8: 
                case 81: 
                case 127: {
                    this.closeTabOrToolWindow();
                }
            }
            if (e.getKeyCode() == ALT_KEY) {
                this.changeSelection();
            }
        }

        private void changeSelection() {
            if (this.isFilesSelected()) {
                this.goLeft();
            } else {
                this.goRight();
            }
        }

        private void closeTabOrToolWindow() {
            final JBList selectedList = this.getSelectedList();
            int[] selected = selectedList.getSelectedIndices();
            Arrays.sort(selected);
            int selectedIndex = 0;
            for (int i = selected.length - 1; i >= 0; --i) {
                selectedIndex = selected[i];
                Object value = selectedList.getModel().getElementAt(selectedIndex);
                if (value instanceof FileInfo) {
                    FileInfo info = (FileInfo)((Object)value);
                    VirtualFile virtualFile = (VirtualFile)info.first;
                    FileEditorManagerImpl editorManager = (FileEditorManagerImpl)FileEditorManager.getInstance((Project)this.project);
                    JBList jList = this.getSelectedList();
                    EditorWindow wnd = SwitcherPanel.findAppropriateWindow(info);
                    if (wnd == null) {
                        editorManager.closeFile(virtualFile, false, false);
                    } else {
                        editorManager.closeFile(virtualFile, wnd, false);
                    }
                    final IdeFocusManager focusManager = IdeFocusManager.getInstance((Project)this.project);
                    this.myAlarm.cancelAllRequests();
                    this.myAlarm.addRequest(new Runnable(){

                        @Override
                        public void run() {
                            JBList focusTarget = selectedList;
                            if (selectedList.getModel().getSize() == 0) {
                                focusTarget = selectedList == SwitcherPanel.this.files ? SwitcherPanel.this.toolWindows : SwitcherPanel.this.files;
                            }
                            focusManager.requestFocus((Component)focusTarget, true);
                        }
                    }, 300);
                    if (jList.getModel().getSize() == 1) {
                        this.goLeft();
                        SwitcherPanel.removeElementAt((JList)jList, selectedIndex);
                        this.remove((Component)jList);
                        this.remove(this.separator);
                        Dimension size = this.toolWindows.getSize();
                        this.myPopup.setSize(new Dimension(size.width, this.myPopup.getSize().height));
                    } else {
                        SwitcherPanel.removeElementAt((JList)jList, selectedIndex);
                        jList.setSize(jList.getPreferredSize());
                    }
                    if (!this.isPinnedMode()) continue;
                    EditorHistoryManager.getInstance(this.project).removeFile(virtualFile);
                    continue;
                }
                if (!(value instanceof ToolWindow)) continue;
                ToolWindow toolWindow = (ToolWindow)value;
                if (this.twManager instanceof ToolWindowManagerImpl) {
                    ToolWindowManagerImpl manager = (ToolWindowManagerImpl)this.twManager;
                    manager.hideToolWindow(((ToolWindowImpl)toolWindow).getId(), false, false);
                    continue;
                }
                toolWindow.hide(null);
            }
            this.pack();
            this.myPopup.getContent().revalidate();
            this.myPopup.getContent().repaint();
            if (this.getSelectedList().getModel().getSize() > selectedIndex) {
                this.getSelectedList().setSelectedIndex(selectedIndex);
                this.getSelectedList().ensureIndexIsVisible(selectedIndex);
            }
        }

        private static void removeElementAt(@NotNull JList jList, int index) {
            if (jList == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jList", "com/intellij/ide/actions/Switcher$SwitcherPanel", "removeElementAt"));
            }
            ListModel model = jList.getModel();
            if (model instanceof DefaultListModel) {
                ((DefaultListModel)model).removeElementAt(index);
            } else if (model instanceof NameFilteringListModel) {
                ((NameFilteringListModel)model).remove(index);
            } else {
                throw new IllegalArgumentException("Wrong list model " + model.getClass());
            }
        }

        private void pack() {
            this.setSize(this.getPreferredSize());
            JRootPane rootPane = SwingUtilities.getRootPane(this);
            Container container = this;
            do {
                container = container.getParent();
                container.setSize(container.getPreferredSize());
            } while (container != rootPane);
            container.getParent().setSize(container.getPreferredSize());
        }

        private boolean isFilesSelected() {
            return this.getSelectedList() == this.files;
        }

        private boolean isFilesVisible() {
            return this.files.getModel().getSize() > 0;
        }

        private boolean isToolWindowsSelected() {
            return this.getSelectedList() == this.toolWindows;
        }

        private void goRight() {
            if ((this.isFilesSelected() || !this.isFilesVisible()) && this.isAutoHide()) {
                this.cancel();
            } else if (this.files.getModel().getSize() > 0) {
                int index = Math.min(this.toolWindows.getSelectedIndex(), this.files.getModel().getSize() - 1);
                this.files.setSelectedIndex(index);
                this.files.ensureIndexIsVisible(index);
                this.toolWindows.getSelectionModel().clearSelection();
                IdeFocusManager.findInstanceByComponent((Component)this.files).requestFocus((Component)this.files, true);
            }
        }

        private void cancel() {
            this.myPopup.cancel();
        }

        private void goLeft() {
            if (this.isToolWindowsSelected() && this.isAutoHide()) {
                this.cancel();
            } else if (this.toolWindows.getModel().getSize() > 0) {
                this.toolWindows.setSelectedIndex(Math.min(this.files.getSelectedIndex(), this.toolWindows.getModel().getSize() - 1));
                this.files.getSelectionModel().clearSelection();
                IdeFocusManager.findInstanceByComponent((Component)this.toolWindows).requestFocus((Component)this.toolWindows, true);
            }
        }

        public void go(boolean forward) {
            JBList selected;
            JBList list = selected = this.getSelectedList();
            int index = list.getSelectedIndex();
            index = forward ? ++index : --index;
            if (forward && index >= list.getModel().getSize() || !forward && index < 0) {
                if (this.isFilesVisible()) {
                    list = this.isFilesSelected() ? this.toolWindows : this.files;
                }
                index = forward ? 0 : list.getModel().getSize() - 1;
            }
            list.setSelectedIndex(index);
            list.ensureIndexIsVisible(index);
            if (selected != list) {
                IdeFocusManager.findInstanceByComponent((Component)list).requestFocus((Component)list, true);
            }
        }

        public void goForward() {
            this.go(true);
        }

        public void goBack() {
            this.go(false);
        }

        public JBList getSelectedList() {
            return this.getSelectedList(this.files);
        }

        @Nullable
        JBList getSelectedList(@Nullable JBList preferable) {
            return this.files.hasFocus() ? this.files : (this.toolWindows.hasFocus() ? this.toolWindows : preferable);
        }

        void navigate(InputEvent e) {
            final boolean openInNewWindow = e != null && e.isShiftDown() && e instanceof KeyEvent && ((KeyEvent)e).getKeyCode() == 10;
            final Object[] values = this.getSelectedList().getSelectedValues();
            String searchQuery = this.mySpeedSearch != null ? this.mySpeedSearch.getEnteredPrefix() : null;
            this.myPopup.cancel(null);
            if (values.length == 0) {
                this.tryToOpenFileSearch(e, searchQuery);
            } else if (values[0] instanceof ToolWindow) {
                final ToolWindow toolWindow = (ToolWindow)values[0];
                IdeFocusManager.getInstance((Project)this.project).doWhenFocusSettlesDown(new Runnable(){

                    @Override
                    public void run() {
                        toolWindow.activate(null, true, true);
                    }
                });
            } else {
                IdeFocusManager.getInstance((Project)this.project).doWhenFocusSettlesDown(new Runnable(){

                    @Override
                    public void run() {
                        FileEditorManagerImpl manager = (FileEditorManagerImpl)FileEditorManager.getInstance((Project)SwitcherPanel.this.project);
                        for (Object value : values) {
                            if (!(value instanceof FileInfo)) continue;
                            FileInfo info = (FileInfo)((Object)value);
                            VirtualFile file2 = (VirtualFile)info.first;
                            if (openInNewWindow) {
                                manager.openFileInNewWindow(file2);
                                continue;
                            }
                            if (info.second != null) {
                                EditorWindow wnd = SwitcherPanel.findAppropriateWindow(info);
                                if (wnd == null) continue;
                                manager.openFileImpl2(wnd, file2, true);
                                manager.addSelectionRecord(file2, wnd);
                                continue;
                            }
                            boolean oldValue = UISettings.getInstance().REUSE_NOT_MODIFIED_TABS;
                            UISettings.getInstance().REUSE_NOT_MODIFIED_TABS = false;
                            manager.openFile(file2, true, true);
                            if (!oldValue) continue;
                            CommandProcessor.getInstance().executeCommand(SwitcherPanel.this.project, new Runnable(){

                                @Override
                                public void run() {
                                    UISettings.getInstance().REUSE_NOT_MODIFIED_TABS = true;
                                }
                            }, "", null);
                        }
                    }
                });
            }
        }

        private void tryToOpenFileSearch(final InputEvent e, final String fileName) {
            AnAction gotoFile = ActionManager.getInstance().getAction("GotoFile");
            if (gotoFile != null && !StringUtil.isEmpty((String)fileName)) {
                this.myPopup.cancel();
                final AnAction action = gotoFile;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DataManager.getInstance().getDataContextFromFocus().doWhenDone((Consumer)new Consumer<DataContext>(){

                            public void consume(final @NotNull DataContext context) {
                                if (context == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/ide/actions/Switcher$SwitcherPanel$21$1", "consume"));
                                }
                                DataContext dataContext = new DataContext(){

                                    @Nullable
                                    public Object getData(@NonNls String dataId) {
                                        if (PlatformDataKeys.PREDEFINED_TEXT.is(dataId)) {
                                            return fileName;
                                        }
                                        return context.getData(dataId);
                                    }
                                };
                                AnActionEvent event = new AnActionEvent(e, dataContext, "EditorPopup", new PresentationFactory().getPresentation(action), ActionManager.getInstance(), 0);
                                action.actionPerformed(event);
                            }
                        });
                    }
                });
            }
        }

        @Nullable
        private static EditorWindow findAppropriateWindow(@NotNull FileInfo info) {
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/ide/actions/Switcher$SwitcherPanel", "findAppropriateWindow"));
            }
            if (info.second == null) {
                return null;
            }
            Object[] windows = ((EditorWindow)info.second).getOwner().getWindows();
            return ArrayUtil.contains((Object)info.second, (Object[])windows) ? (EditorWindow)info.second : (windows.length > 0 ? windows[0] : null);
        }

        @Override
        public void mouseClicked(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/Switcher$SwitcherPanel", "mouseClicked"));
            }
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent e) {
            JList list;
            int index;
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/Switcher$SwitcherPanel", "mouseMoved"));
            }
            if (this.mouseMovedFirstTime) {
                this.mouseMovedFirstTime = false;
                return;
            }
            Object source = e.getSource();
            boolean changed = false;
            if (source instanceof JList && 0 <= (index = (list = (JList)source).locationToIndex(e.getPoint())) && index < list.getModel().getSize()) {
                this.mouseMoveSrc = list;
                this.mouseMoveListIndex = index;
                changed = true;
            }
            if (!changed) {
                this.mouseMoveSrc = null;
                this.mouseMoveListIndex = -1;
            }
            this.repaintLists();
        }

        private void repaintLists() {
            this.toolWindows.repaint();
            this.files.repaint();
        }

        @Override
        public void mousePressed(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/Switcher$SwitcherPanel", "mousePressed"));
            }
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/Switcher$SwitcherPanel", "mouseReleased"));
            }
        }

        @Override
        public void mouseEntered(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/Switcher$SwitcherPanel", "mouseEntered"));
            }
        }

        @Override
        public void mouseExited(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/Switcher$SwitcherPanel", "mouseExited"));
            }
            this.mouseMoveSrc = null;
            this.mouseMoveListIndex = -1;
            this.repaintLists();
        }

        @Override
        public void mouseDragged(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/Switcher$SwitcherPanel", "mouseDragged"));
            }
        }

        public boolean isAutoHide() {
            return !this.myPinned;
        }

        public boolean isPinnedMode() {
            return this.myPinned;
        }

        private class SwitcherLayouter
        extends BorderLayout {
            private Rectangle sBounds;
            private Rectangle tBounds;
            private Rectangle fBounds;
            private Rectangle dBounds;

            private SwitcherLayouter() {
            }

            @Override
            public void layoutContainer(@NotNull Container target) {
                JScrollPane filesPane;
                if (target == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/ide/actions/Switcher$SwitcherPanel$SwitcherLayouter", "layoutContainer"));
                }
                JScrollPane scrollPane = (JScrollPane)UIUtil.getParentOfType(JScrollPane.class, (Component)SwitcherPanel.this.files);
                JScrollPane jScrollPane = filesPane = scrollPane != null ? scrollPane : SwitcherPanel.this.files;
                if (this.sBounds == null || !target.isShowing()) {
                    super.layoutContainer(target);
                    this.sBounds = SwitcherPanel.this.separator.getBounds();
                    this.tBounds = SwitcherPanel.this.toolWindows.getBounds();
                    this.fBounds = filesPane.getBounds();
                    this.dBounds = SwitcherPanel.this.descriptions.getBounds();
                } else {
                    int h = target.getHeight();
                    int w = target.getWidth();
                    this.sBounds.height = h - this.dBounds.height;
                    this.tBounds.height = h - this.dBounds.height;
                    this.fBounds.height = h - this.dBounds.height;
                    this.fBounds.width = w - this.sBounds.width - this.tBounds.width;
                    this.dBounds.width = w;
                    this.dBounds.y = h - this.dBounds.height;
                    SwitcherPanel.this.separator.setBounds(this.sBounds);
                    SwitcherPanel.this.toolWindows.setBounds(this.tBounds);
                    filesPane.setBounds(this.fBounds);
                    SwitcherPanel.this.descriptions.setBounds(this.dBounds);
                }
            }
        }

        private class SwitcherSpeedSearch
        extends SpeedSearchBase<SwitcherPanel>
        implements PropertyChangeListener {
            private Object[] myElements;

            public SwitcherSpeedSearch() {
                super(SwitcherPanel.this);
                this.addChangeListener(this);
                this.setComparator(new SpeedSearchComparator(false, true));
            }

            @Override
            protected void processKeyEvent(@NotNull KeyEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/Switcher$SwitcherPanel$SwitcherSpeedSearch", "processKeyEvent"));
                }
                int keyCode = e.getKeyCode();
                if (keyCode == 10) {
                    SWITCHER.navigate(e);
                    e.consume();
                    return;
                }
                if (keyCode == 37 || keyCode == 39) {
                    return;
                }
                super.processKeyEvent(e);
            }

            @Override
            protected int getSelectedIndex() {
                return SwitcherPanel.this.isFilesSelected() ? SwitcherPanel.this.files.getSelectedIndex() : SwitcherPanel.this.files.getModel().getSize() + SwitcherPanel.this.toolWindows.getSelectedIndex();
            }

            @Override
            protected Object[] getAllElements() {
                SwitcherPanel switcher = SwitcherPanel.this;
                ListModel filesModel = switcher.files.getModel();
                Object[] files = new Object[filesModel.getSize()];
                for (int i = 0; i < files.length; ++i) {
                    files[i] = filesModel.getElementAt(i);
                }
                ListModel twModel = switcher.toolWindows.getModel();
                Object[] toolWindows = new Object[twModel.getSize()];
                for (int i = 0; i < toolWindows.length; ++i) {
                    toolWindows[i] = twModel.getElementAt(i);
                }
                this.myElements = new Object[files.length + toolWindows.length];
                System.arraycopy(files, 0, this.myElements, 0, files.length);
                System.arraycopy(toolWindows, 0, this.myElements, files.length, toolWindows.length);
                return this.myElements;
            }

            @Override
            protected String getElementText(Object element) {
                if (element instanceof ToolWindow) {
                    return ((ToolWindow)element).getStripeTitle();
                }
                if (element instanceof FileInfo) {
                    return ((FileInfo)((Object)element)).getNameForRendering();
                }
                return "";
            }

            @Override
            protected void selectElement(final Object element, String selectedText) {
                if (element instanceof FileInfo) {
                    if (!SwitcherPanel.this.toolWindows.isSelectionEmpty()) {
                        SwitcherPanel.this.toolWindows.clearSelection();
                    }
                    IdeFocusManager.findInstanceByComponent((Component)SwitcherPanel.this.files).requestFocus((Component)SwitcherPanel.this.files, true).doWhenDone(new Runnable(){

                        @Override
                        public void run() {
                            SwitcherPanel.this.files.setSelectedValue(element, true);
                        }
                    });
                } else {
                    if (!SwitcherPanel.this.files.isSelectionEmpty()) {
                        SwitcherPanel.this.files.clearSelection();
                    }
                    IdeFocusManager.findInstanceByComponent((Component)SwitcherPanel.this.toolWindows).requestFocus((Component)SwitcherPanel.this.toolWindows, true).doWhenDone(new Runnable(){

                        @Override
                        public void run() {
                            SwitcherPanel.this.toolWindows.setSelectedValue(element, true);
                        }
                    });
                }
            }

            @Override
            @Nullable
            protected Object findElement(String s) {
                List<SpeedSearchObjectWithWeight> elements = SpeedSearchObjectWithWeight.findElement(s, this);
                return elements.isEmpty() ? null : elements.get((int)0).node;
            }

            @Override
            public void propertyChange(@NotNull PropertyChangeEvent evt) {
                if (evt == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evt", "com/intellij/ide/actions/Switcher$SwitcherPanel$SwitcherSpeedSearch", "propertyChange"));
                }
                if (SwitcherPanel.this.project.isDisposed()) {
                    SwitcherPanel.this.myPopup.cancel();
                    return;
                }
                ((NameFilteringListModel)SwitcherPanel.this.files.getModel()).refilter();
                ((NameFilteringListModel)SwitcherPanel.this.toolWindows.getModel()).refilter();
                if (SwitcherPanel.this.files.getModel().getSize() + SwitcherPanel.this.toolWindows.getModel().getSize() == 0) {
                    SwitcherPanel.this.toolWindows.getEmptyText().setText("");
                    SwitcherPanel.this.files.getEmptyText().setText("Press 'Enter' to search in Project");
                } else {
                    SwitcherPanel.this.files.getEmptyText().setText(StatusText.DEFAULT_EMPTY_TEXT);
                    SwitcherPanel.this.toolWindows.getEmptyText().setText(StatusText.DEFAULT_EMPTY_TEXT);
                }
            }
        }
    }
}

