/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.errorTreeView;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.errorTreeView.ErrorTreeElement;
import com.intellij.ide.errorTreeView.ErrorTreeElementKind;
import com.intellij.ide.errorTreeView.ErrorTreeNodeDescriptor;
import com.intellij.ide.errorTreeView.FixedHotfixGroupElement;
import com.intellij.ide.errorTreeView.GroupingElement;
import com.intellij.ide.errorTreeView.HotfixData;
import com.intellij.ide.errorTreeView.HotfixGate;
import com.intellij.ide.errorTreeView.HotfixGroupElement;
import com.intellij.ide.errorTreeView.NavigatableMessageElement;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.ide.errorTreeView.SimpleErrorData;
import com.intellij.ide.errorTreeView.SimpleMessageElement;
import com.intellij.ide.errorTreeView.impl.ErrorTreeViewConfiguration;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.CustomizeColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ui.MutableErrorTreeView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ErrorViewStructure
extends AbstractTreeStructure {
    private final ErrorTreeElement myRoot = new MyRootElement();
    private final List<String> myGroupNames = new ArrayList<String>();
    private final Map<String, GroupingElement> myGroupNameToElementMap = new HashMap<String, GroupingElement>();
    private final Map<String, List<NavigatableMessageElement>> myGroupNameToMessagesMap = new HashMap<String, List<NavigatableMessageElement>>();
    private final Map<ErrorTreeElementKind, List<ErrorTreeElement>> mySimpleMessages = new EnumMap<ErrorTreeElementKind, List<ErrorTreeElement>>(ErrorTreeElementKind.class);
    private final Object myLock = new Object();
    private static final ErrorTreeElementKind[] ourMessagesOrder = new ErrorTreeElementKind[]{ErrorTreeElementKind.INFO, ErrorTreeElementKind.ERROR, ErrorTreeElementKind.WARNING, ErrorTreeElementKind.NOTE, ErrorTreeElementKind.GENERIC};
    private final Project myProject;
    private final boolean myCanHideWarnings;

    public ErrorViewStructure(Project project2, boolean canHideWarnings) {
        this.myProject = project2;
        this.myCanHideWarnings = canHideWarnings;
    }

    public Object getRootElement() {
        return this.myRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMessages(@NotNull Set<ErrorTreeElementKind> kinds) {
        if (kinds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kinds", "com/intellij/ide/errorTreeView/ErrorViewStructure", "hasMessages"));
        }
        Object object = this.myLock;
        synchronized (object) {
            List<ErrorTreeElement> messages;
            for (Map.Entry<ErrorTreeElementKind, List<ErrorTreeElement>> entry : this.mySimpleMessages.entrySet()) {
                if (!kinds.contains(entry.getKey()) || (messages = entry.getValue()) == null || messages.isEmpty()) continue;
                return true;
            }
            for (Map.Entry<Object, List<ErrorTreeElement>> entry : this.myGroupNameToMessagesMap.entrySet()) {
                messages = entry.getValue();
                if (messages == null || messages.isEmpty()) continue;
                for (NavigatableMessageElement navigatableMessageElement : messages) {
                    if (!kinds.contains(navigatableMessageElement.getKind())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ErrorTreeElement[] getChildElements(Object element) {
        if (element == this.myRoot) {
            ArrayList<ErrorTreeElement> children2 = new ArrayList<ErrorTreeElement>();
            Object object = this.myLock;
            synchronized (object) {
                for (ErrorTreeElementKind kind : ourMessagesOrder) {
                    List<ErrorTreeElement> elems;
                    if (this.myCanHideWarnings && (ErrorTreeElementKind.WARNING.equals((Object)kind) || ErrorTreeElementKind.NOTE.equals((Object)kind)) && ErrorTreeViewConfiguration.getInstance(this.myProject).isHideWarnings() || (elems = this.mySimpleMessages.get(kind)) == null) continue;
                    children2.addAll(elems);
                }
                for (String myGroupName : this.myGroupNames) {
                    GroupingElement groupingElement = this.myGroupNameToElementMap.get(myGroupName);
                    if (!this.shouldShowFileElement(groupingElement)) continue;
                    children2.add(groupingElement);
                }
            }
            return (ErrorTreeElement[])ArrayUtil.toObjectArray(children2, ErrorTreeElement.class);
        }
        if (element instanceof GroupingElement) {
            Object object = this.myLock;
            synchronized (object) {
                List<NavigatableMessageElement> children3 = this.myGroupNameToMessagesMap.get(((GroupingElement)element).getName());
                if (children3 != null && !children3.isEmpty()) {
                    if (this.myCanHideWarnings && ErrorTreeViewConfiguration.getInstance(this.myProject).isHideWarnings()) {
                        ArrayList<NavigatableMessageElement> filtered = new ArrayList<NavigatableMessageElement>(children3.size());
                        for (NavigatableMessageElement navigatableMessageElement : children3) {
                            ErrorTreeElementKind kind = navigatableMessageElement.getKind();
                            if (ErrorTreeElementKind.WARNING.equals((Object)kind) || ErrorTreeElementKind.NOTE.equals((Object)kind)) continue;
                            filtered.add(navigatableMessageElement);
                        }
                        return (ErrorTreeElement[])ArrayUtil.toObjectArray(filtered, ErrorTreeElement.class);
                    }
                    return (ErrorTreeElement[])ArrayUtil.toObjectArray(children3, NavigatableMessageElement.class);
                }
            }
        }
        return ErrorTreeElement.EMPTY_ARRAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldShowFileElement(GroupingElement groupingElement) {
        if (!this.myCanHideWarnings || !ErrorTreeViewConfiguration.getInstance(this.myProject).isHideWarnings()) {
            return this.getChildCount(groupingElement) > 0;
        }
        Object object = this.myLock;
        synchronized (object) {
            List<NavigatableMessageElement> children2 = this.myGroupNameToMessagesMap.get(groupingElement.getName());
            if (children2 != null) {
                for (NavigatableMessageElement child : children2) {
                    ErrorTreeElementKind kind = child.getKind();
                    if (ErrorTreeElementKind.WARNING.equals((Object)kind) || ErrorTreeElementKind.NOTE.equals((Object)kind)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Object getParentElement(Object element) {
        if (element instanceof GroupingElement || element instanceof SimpleMessageElement) {
            return this.myRoot;
        }
        if (element instanceof NavigatableMessageElement) {
            GroupingElement result = ((NavigatableMessageElement)element).getParent();
            return result == null ? this.myRoot : result;
        }
        return null;
    }

    @NotNull
    public NodeDescriptor createDescriptor(Object element, NodeDescriptor parentDescriptor) {
        ErrorTreeNodeDescriptor errorTreeNodeDescriptor = new ErrorTreeNodeDescriptor(this.myProject, parentDescriptor, (ErrorTreeElement)element);
        if (errorTreeNodeDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/errorTreeView/ErrorViewStructure", "createDescriptor"));
        }
        return errorTreeNodeDescriptor;
    }

    public final void commit() {
    }

    public final boolean hasSomethingToCommit() {
        return false;
    }

    public void addMessage(@NotNull ErrorTreeElementKind kind, @NotNull String[] text, @Nullable VirtualFile underFileGroup, @Nullable VirtualFile file2, int line, int column, @Nullable Object data) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/ide/errorTreeView/ErrorViewStructure", "addMessage"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ide/errorTreeView/ErrorViewStructure", "addMessage"));
        }
        if (underFileGroup != null || file2 != null) {
            if (file2 == null) {
                column = -1;
                line = -1;
            }
            int guiline = line < 0 ? -1 : line + 1;
            int guicolumn = column < 0 ? -1 : column + 1;
            VirtualFile group = underFileGroup != null ? underFileGroup : file2;
            VirtualFile nav = file2 != null ? file2 : underFileGroup;
            this.addNavigatableMessage(group.getPresentableUrl(), (Navigatable)new OpenFileDescriptor(this.myProject, nav, line, column), kind, text, data, NewErrorTreeViewPanel.createExportPrefix(guiline), NewErrorTreeViewPanel.createRendererPrefix(guiline, guicolumn), group);
        } else {
            this.addSimpleMessage(kind, text, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> getGroupChildrenData(String groupName) {
        Object object = this.myLock;
        synchronized (object) {
            List<NavigatableMessageElement> children2 = this.myGroupNameToMessagesMap.get(groupName);
            if (children2 == null || children2.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Object> result = new ArrayList<Object>();
            for (NavigatableMessageElement child : children2) {
                Object data = child.getData();
                if (data == null) continue;
                result.add(data);
            }
            return result;
        }
    }

    public void addFixedHotfixGroup(String text, List<SimpleErrorData> children2) {
        FixedHotfixGroupElement group = new FixedHotfixGroupElement(text, null, null);
        this.addGroupPlusElements(text, group, children2);
    }

    public void addHotfixGroup(HotfixData hotfixData, List<SimpleErrorData> children2, MutableErrorTreeView view) {
        String text = hotfixData.getErrorText();
        HotfixGroupElement group = new HotfixGroupElement(text, null, null, (Consumer<HotfixGate>)hotfixData.getFix(), hotfixData.getFixComment(), view);
        this.addGroupPlusElements(text, group, children2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addGroupPlusElements(String text, GroupingElement group, List<SimpleErrorData> children2) {
        ArrayList<MyNavigatableWithDataElement> elements = new ArrayList<MyNavigatableWithDataElement>();
        for (SimpleErrorData child : children2) {
            elements.add(new MyNavigatableWithDataElement(this.myProject, child.getKind(), group, child.getMessages(), child.getVf(), NewErrorTreeViewPanel.createExportPrefix(-1), NewErrorTreeViewPanel.createRendererPrefix(-1, -1)));
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myGroupNames.add(text);
            this.myGroupNameToElementMap.put(text, group);
            this.myGroupNameToMessagesMap.put(text, elements);
        }
    }

    public void addMessage(@NotNull ErrorTreeElementKind kind, String[] text, Object data) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/ide/errorTreeView/ErrorViewStructure", "addMessage"));
        }
        this.addSimpleMessage(kind, text, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNavigatableMessage(@Nullable String groupName, Navigatable navigatable, @NotNull ErrorTreeElementKind kind, String[] message, Object data, String exportText, String rendererTextPrefix, VirtualFile file2) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/ide/errorTreeView/ErrorViewStructure", "addNavigatableMessage"));
        }
        if (groupName == null) {
            this.addSimpleMessageElement(new NavigatableMessageElement(kind, null, message, navigatable, exportText, rendererTextPrefix));
        } else {
            Object object = this.myLock;
            synchronized (object) {
                List<NavigatableMessageElement> elements = this.myGroupNameToMessagesMap.get(groupName);
                if (elements == null) {
                    elements = new ArrayList<NavigatableMessageElement>();
                    this.myGroupNameToMessagesMap.put(groupName, elements);
                }
                elements.add(new NavigatableMessageElement(kind, this.getGroupingElement(groupName, data, file2), message, navigatable, exportText, rendererTextPrefix));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNavigatableMessage(@NotNull String groupName, @NotNull NavigatableMessageElement navigatableMessageElement) {
        if (groupName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupName", "com/intellij/ide/errorTreeView/ErrorViewStructure", "addNavigatableMessage"));
        }
        if (navigatableMessageElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigatableMessageElement", "com/intellij/ide/errorTreeView/ErrorViewStructure", "addNavigatableMessage"));
        }
        Object object = this.myLock;
        synchronized (object) {
            List<NavigatableMessageElement> elements = this.myGroupNameToMessagesMap.get(groupName);
            if (elements == null) {
                elements = new ArrayList<NavigatableMessageElement>();
                this.myGroupNameToMessagesMap.put(groupName, elements);
            }
            if (!this.myGroupNameToElementMap.containsKey(groupName)) {
                this.myGroupNames.add(groupName);
                this.myGroupNameToElementMap.put(groupName, navigatableMessageElement.getParent());
            }
            elements.add(navigatableMessageElement);
        }
    }

    private void addSimpleMessage(@NotNull ErrorTreeElementKind kind, String[] text, Object data) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/ide/errorTreeView/ErrorViewStructure", "addSimpleMessage"));
        }
        this.addSimpleMessageElement(new SimpleMessageElement(kind, text, data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSimpleMessageElement(ErrorTreeElement element) {
        Object object = this.myLock;
        synchronized (object) {
            List<ErrorTreeElement> elements = this.mySimpleMessages.get(element.getKind());
            if (elements == null) {
                elements = new ArrayList<ErrorTreeElement>();
                this.mySimpleMessages.put(element.getKind(), elements);
            }
            elements.add(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public GroupingElement lookupGroupingElement(String groupName) {
        Object object = this.myLock;
        synchronized (object) {
            return this.myGroupNameToElementMap.get(groupName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupingElement getGroupingElement(String groupName, Object data, VirtualFile file2) {
        Object object = this.myLock;
        synchronized (object) {
            GroupingElement element = this.myGroupNameToElementMap.get(groupName);
            if (element != null) {
                return element;
            }
            element = new GroupingElement(groupName, data, file2);
            this.myGroupNames.add(groupName);
            this.myGroupNameToElementMap.put(groupName, element);
            return element;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChildCount(GroupingElement groupingElement) {
        Object object = this.myLock;
        synchronized (object) {
            List<NavigatableMessageElement> children2 = this.myGroupNameToMessagesMap.get(groupingElement.getName());
            return children2 == null ? 0 : children2.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.myLock;
        synchronized (object) {
            this.myGroupNames.clear();
            this.myGroupNameToElementMap.clear();
            this.myGroupNameToMessagesMap.clear();
            this.mySimpleMessages.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ErrorTreeElement getFirstMessage(@NotNull ErrorTreeElementKind kind) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/ide/errorTreeView/ErrorViewStructure", "getFirstMessage"));
        }
        if (this.myCanHideWarnings && (ErrorTreeElementKind.WARNING.equals((Object)kind) || ErrorTreeElementKind.NOTE.equals((Object)kind)) && ErrorTreeViewConfiguration.getInstance(this.myProject).isHideWarnings()) {
            return null;
        }
        Object object = this.myLock;
        synchronized (object) {
            List<ErrorTreeElement> simpleMessages = this.mySimpleMessages.get(kind);
            if (simpleMessages != null && !simpleMessages.isEmpty()) {
                return simpleMessages.get(0);
            }
            for (String path : this.myGroupNames) {
                List<NavigatableMessageElement> messages = this.myGroupNameToMessagesMap.get(path);
                if (messages == null) continue;
                for (NavigatableMessageElement navigatableMessageElement : messages) {
                    if (!kind.equals((Object)navigatableMessageElement.getKind())) continue;
                    return navigatableMessageElement;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGroup(String name) {
        Object object = this.myLock;
        synchronized (object) {
            this.myGroupNames.remove(name);
            this.myGroupNameToElementMap.remove(name);
            this.myGroupNameToMessagesMap.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeElement(ErrorTreeElement element) {
        if (element == this.myRoot) {
            return;
        }
        if (element instanceof GroupingElement) {
            GroupingElement groupingElement = (GroupingElement)element;
            this.removeGroup(groupingElement.getName());
            final VirtualFile virtualFile = groupingElement.getFile();
            if (virtualFile != null) {
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        PsiFile psiFile;
                        PsiFile psiFile2 = psiFile = virtualFile.isValid() ? PsiManager.getInstance((Project)ErrorViewStructure.this.myProject).findFile(virtualFile) : null;
                        if (psiFile != null) {
                            DaemonCodeAnalyzer.getInstance((Project)ErrorViewStructure.this.myProject).restart(psiFile);
                        }
                    }
                });
            }
        } else if (element instanceof NavigatableMessageElement) {
            NavigatableMessageElement navElement = (NavigatableMessageElement)element;
            GroupingElement parent = navElement.getParent();
            if (parent != null) {
                Object object = this.myLock;
                synchronized (object) {
                    List<NavigatableMessageElement> groupMessages = this.myGroupNameToMessagesMap.get(parent.getName());
                    if (groupMessages != null) {
                        groupMessages.remove(navElement);
                    }
                }
            }
        } else {
            Object object = this.myLock;
            synchronized (object) {
                List<ErrorTreeElement> simples = this.mySimpleMessages.get(element.getKind());
                if (simples != null) {
                    simples.remove(element);
                }
            }
        }
    }

    private static class MyNavigatableWithDataElement
    extends NavigatableMessageElement {
        private final VirtualFile myVf;
        private final CustomizeColoredTreeCellRenderer myCustomizeColoredTreeCellRenderer;

        private MyNavigatableWithDataElement(Project project2, @NotNull ErrorTreeElementKind kind, GroupingElement parent, String[] message, final @NotNull VirtualFile vf, String exportText, String rendererTextPrefix) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/ide/errorTreeView/ErrorViewStructure$MyNavigatableWithDataElement", "<init>"));
            }
            if (vf == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vf", "com/intellij/ide/errorTreeView/ErrorViewStructure$MyNavigatableWithDataElement", "<init>"));
            }
            super(kind, parent, message, (Navigatable)new OpenFileDescriptor(project2, vf, -1, -1), exportText, rendererTextPrefix);
            this.myVf = vf;
            this.myCustomizeColoredTreeCellRenderer = new CustomizeColoredTreeCellRenderer(){

                public void customizeCellRenderer(SimpleColoredComponent renderer, JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                    Icon icon = MyNavigatableWithDataElement.this.myVf.getFileType().getIcon();
                    renderer.setIcon(icon);
                    String[] messages = MyNavigatableWithDataElement.this.getText();
                    String text = messages == null || messages.length == 0 ? vf.getPath() : messages[0];
                    renderer.append(text);
                }
            };
        }

        @Override
        public Object getData() {
            return this.myVf;
        }

        @Override
        public CustomizeColoredTreeCellRenderer getLeftSelfRenderer() {
            return this.myCustomizeColoredTreeCellRenderer;
        }
    }

    private static class MyRootElement
    extends ErrorTreeElement {
        private MyRootElement() {
        }

        @Override
        public String[] getText() {
            return null;
        }

        @Override
        public Object getData() {
            return null;
        }

        @Override
        public String getExportTextPrefix() {
            return "";
        }
    }
}

