/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.favoritesTreeView.AbstractUrlFavoriteAdapter;
import com.intellij.ide.favoritesTreeView.FavoriteNodeProvider;
import com.intellij.ide.favoritesTreeView.FavoritesListNode;
import com.intellij.ide.favoritesTreeView.FavoritesListProvider;
import com.intellij.ide.favoritesTreeView.FavoritesListener;
import com.intellij.ide.favoritesTreeView.FavoritesTreeNodeDescriptor;
import com.intellij.ide.favoritesTreeView.FavoritesViewSettings;
import com.intellij.ide.favoritesTreeView.TaskDefaultFavoriteListProvider;
import com.intellij.ide.favoritesTreeView.actions.AddToFavoritesAction;
import com.intellij.ide.projectView.impl.AbstractUrl;
import com.intellij.ide.projectView.impl.DirectoryUrl;
import com.intellij.ide.projectView.impl.LibraryModuleGroupUrl;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.ModuleGroupUrl;
import com.intellij.ide.projectView.impl.ModuleUrl;
import com.intellij.ide.projectView.impl.NamedLibraryUrl;
import com.intellij.ide.projectView.impl.PsiFileUrl;
import com.intellij.ide.projectView.impl.nodes.LibraryGroupElement;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.TreeItem;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FavoritesManager
implements ProjectComponent,
JDOMExternalizable {
    private final Map<String, List<TreeItem<Pair<AbstractUrl, String>>>> myName2FavoritesRoots = new TreeMap<String, List<TreeItem<Pair<AbstractUrl, String>>>>();
    private final Map<String, String> myDescriptions = new HashMap<String, String>();
    private final Project myProject;
    private final List<FavoritesListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final FavoritesViewSettings myViewSettings = new FavoritesViewSettings();
    private final Map<String, FavoritesListProvider> myProviders = new HashMap<String, FavoritesListProvider>();
    @NonNls
    private static final String CLASS_NAME = "klass";
    @NonNls
    private static final String FAVORITES_ROOT = "favorite_root";
    @NonNls
    private static final String ELEMENT_FAVORITES_LIST = "favorites_list";
    @NonNls
    private static final String ATTRIBUTE_NAME = "name";
    private static final ArrayList<AbstractUrl> ourAbstractUrlProviders = new ArrayList();
    @NonNls
    private static final String ATTRIBUTE_TYPE = "type";
    @NonNls
    private static final String ATTRIBUTE_URL = "url";
    @NonNls
    private static final String ATTRIBUTE_MODULE = "module";

    private void rootsChanged() {
        for (FavoritesListener listener : this.myListeners) {
            listener.rootsChanged();
        }
    }

    private void listAdded(String listName) {
        for (FavoritesListener listener : this.myListeners) {
            listener.listAdded(listName);
        }
    }

    private void listRemoved(String listName) {
        for (FavoritesListener listener : this.myListeners) {
            listener.listRemoved(listName);
        }
    }

    public void renameList(final Project project2, @NotNull String listName) {
        if (listName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listName", "com/intellij/ide/favoritesTreeView/FavoritesManager", "renameList"));
        }
        String newName = Messages.showInputDialog((Project)project2, (String)IdeBundle.message((String)"prompt.input.favorites.list.new.name", (Object[])new Object[]{listName}), (String)IdeBundle.message((String)"title.rename.favorites.list", (Object[])new Object[0]), (Icon)Messages.getInformationIcon(), (String)listName, (InputValidator)new InputValidator(){

            public boolean checkInput(String inputString) {
                return inputString != null && inputString.trim().length() > 0;
            }

            public boolean canClose(String inputString) {
                inputString = inputString.trim();
                if (FavoritesManager.this.myName2FavoritesRoots.keySet().contains(inputString) || FavoritesManager.this.myProviders.keySet().contains(inputString)) {
                    Messages.showErrorDialog((Project)project2, (String)IdeBundle.message((String)"error.favorites.list.already.exists", (Object[])new Object[]{inputString.trim()}), (String)IdeBundle.message((String)"title.unable.to.add.favorites.list", (Object[])new Object[0]));
                    return false;
                }
                return !inputString.isEmpty();
            }
        });
        if (newName != null && this.renameFavoritesList(listName, newName)) {
            this.rootsChanged();
        }
    }

    public void addFavoritesListener(FavoritesListener listener) {
        this.myListeners.add(listener);
        listener.rootsChanged();
    }

    public void addFavoritesListener(final FavoritesListener listener, @NotNull Disposable parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/ide/favoritesTreeView/FavoritesManager", "addFavoritesListener"));
        }
        this.myListeners.add(listener);
        listener.rootsChanged();
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                FavoritesManager.this.removeFavoritesListener(listener);
            }
        });
    }

    public void removeFavoritesListener(FavoritesListener listener) {
        this.myListeners.remove(listener);
    }

    List<AbstractTreeNode> createRootNodes() {
        ArrayList<AbstractTreeNode> result = new ArrayList<AbstractTreeNode>();
        for (String listName : this.myName2FavoritesRoots.keySet()) {
            result.add(new FavoritesListNode(this.myProject, listName, this.myDescriptions.get(listName)));
        }
        ArrayList<FavoritesListProvider> providers = new ArrayList<FavoritesListProvider>(this.myProviders.values());
        Collections.sort(providers);
        for (FavoritesListProvider provider : providers) {
            result.add(provider.createFavoriteListNode(this.myProject));
        }
        return result;
    }

    public static FavoritesManager getInstance(Project project2) {
        return (FavoritesManager)project2.getComponent(FavoritesManager.class);
    }

    public FavoritesManager(Project project2) {
        this.myProject = project2;
    }

    @NotNull
    public List<String> getAvailableFavoritesListNames() {
        ArrayList<String> arrayList = new ArrayList<String>(this.myName2FavoritesRoots.keySet());
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/FavoritesManager", "getAvailableFavoritesListNames"));
        }
        return arrayList;
    }

    public synchronized void createNewList(@NotNull String listName) {
        if (listName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listName", "com/intellij/ide/favoritesTreeView/FavoritesManager", "createNewList"));
        }
        this.myName2FavoritesRoots.put(listName, new ArrayList());
        this.listAdded(listName);
    }

    public synchronized void fireListeners(@NotNull String listName) {
        if (listName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listName", "com/intellij/ide/favoritesTreeView/FavoritesManager", "fireListeners"));
        }
        this.rootsChanged();
    }

    public FavoritesViewSettings getViewSettings() {
        return this.myViewSettings;
    }

    public synchronized boolean removeFavoritesList(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTRIBUTE_NAME, "com/intellij/ide/favoritesTreeView/FavoritesManager", "removeFavoritesList"));
        }
        boolean result = this.myName2FavoritesRoots.remove(name) != null;
        this.myDescriptions.remove(name);
        this.listRemoved(name);
        return result;
    }

    @NotNull
    public List<TreeItem<Pair<AbstractUrl, String>>> getFavoritesListRootUrls(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTRIBUTE_NAME, "com/intellij/ide/favoritesTreeView/FavoritesManager", "getFavoritesListRootUrls"));
        }
        ArrayList<TreeItem<Pair<AbstractUrl, String>>> pairs = this.myName2FavoritesRoots.get(name);
        ArrayList<TreeItem<Pair<AbstractUrl, String>>> arrayList = pairs == null ? new ArrayList<TreeItem<Pair<AbstractUrl, String>>>() : pairs;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/FavoritesManager", "getFavoritesListRootUrls"));
        }
        return arrayList;
    }

    public synchronized boolean addRoots(@NotNull String name, Module moduleContext, @NotNull Object elements) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTRIBUTE_NAME, "com/intellij/ide/favoritesTreeView/FavoritesManager", "addRoots"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/ide/favoritesTreeView/FavoritesManager", "addRoots"));
        }
        Collection<AbstractTreeNode> nodes = AddToFavoritesAction.createNodes(this.myProject, moduleContext, elements, true, this.getViewSettings());
        return !nodes.isEmpty() && this.addRoots(name, nodes);
    }

    public synchronized Comparator<FavoritesTreeNodeDescriptor> getCustomComparator(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTRIBUTE_NAME, "com/intellij/ide/favoritesTreeView/FavoritesManager", "getCustomComparator"));
        }
        return this.myProviders.get(name);
    }

    private Pair<AbstractUrl, String> createPairForNode(AbstractTreeNode node) {
        String className = node.getClass().getName();
        Object value = node.getValue();
        AbstractUrl url = FavoritesManager.createUrlByElement(value, this.myProject);
        if (url == null) {
            return null;
        }
        return Pair.create((Object)url, (Object)className);
    }

    public boolean addRoots(String name, Collection<AbstractTreeNode> nodes) {
        List<TreeItem<Pair<AbstractUrl, String>>> list = this.getFavoritesListRootUrls(name);
        HashSet<Object> set = new HashSet<Object>(ContainerUtil.map(list, (Function)new Function<TreeItem<Pair<AbstractUrl, String>>, AbstractUrl>(){

            public AbstractUrl fun(TreeItem<Pair<AbstractUrl, String>> item) {
                return (AbstractUrl)((Pair)item.getData()).getFirst();
            }
        }));
        for (AbstractTreeNode node : nodes) {
            Pair<AbstractUrl, String> pair = this.createPairForNode(node);
            if (pair == null || set.contains(pair.getFirst())) continue;
            TreeItem treeItem = new TreeItem(pair);
            list.add((TreeItem<Pair<AbstractUrl, String>>)treeItem);
            set.add(pair.getFirst());
            this.appendChildNodes(node, (TreeItem<Pair<AbstractUrl, String>>)treeItem);
        }
        this.rootsChanged();
        return true;
    }

    public boolean canAddRoots(@NotNull String name, @NotNull Collection<AbstractTreeNode> nodes) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTRIBUTE_NAME, "com/intellij/ide/favoritesTreeView/FavoritesManager", "canAddRoots"));
        }
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/ide/favoritesTreeView/FavoritesManager", "canAddRoots"));
        }
        List<TreeItem<Pair<AbstractUrl, String>>> list = this.getFavoritesListRootUrls(name);
        HashSet set = new HashSet(ContainerUtil.map(list, (Function)new Function<TreeItem<Pair<AbstractUrl, String>>, AbstractUrl>(){

            public AbstractUrl fun(TreeItem<Pair<AbstractUrl, String>> item) {
                return (AbstractUrl)((Pair)item.getData()).getFirst();
            }
        }));
        for (AbstractTreeNode node : nodes) {
            Pair<AbstractUrl, String> pair = this.createPairForNode(node);
            if (pair == null || set.contains(pair.getFirst())) continue;
            return true;
        }
        return false;
    }

    private void appendChildNodes(AbstractTreeNode node, TreeItem<Pair<AbstractUrl, String>> treeItem) {
        Collection children2 = node.getChildren();
        for (AbstractTreeNode child : children2) {
            TreeItem childTreeItem = new TreeItem(this.createPairForNode(child));
            treeItem.addChild(childTreeItem);
            this.appendChildNodes(child, (TreeItem<Pair<AbstractUrl, String>>)childTreeItem);
        }
    }

    public synchronized boolean addRoot(@NotNull String name, @NotNull List<AbstractTreeNode> parentElements, AbstractTreeNode newElement, @Nullable AbstractTreeNode sibling) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTRIBUTE_NAME, "com/intellij/ide/favoritesTreeView/FavoritesManager", "addRoot"));
        }
        if (parentElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentElements", "com/intellij/ide/favoritesTreeView/FavoritesManager", "addRoot"));
        }
        List items = this.myName2FavoritesRoots.get(name);
        if (items == null) {
            return false;
        }
        AbstractUrl url = FavoritesManager.createUrlByElement(newElement.getValue(), this.myProject);
        if (url == null) {
            return false;
        }
        TreeItem newItem = new TreeItem((Object)Pair.create((Object)url, (Object)newElement.getClass().getName()));
        if (parentElements.isEmpty()) {
            if (sibling != null) {
                Object after2 = null;
                AbstractUrl siblingUrl = FavoritesManager.createUrlByElement(sibling.getValue(), this.myProject);
                int idx = -1;
                for (int i = 0; i < items.size(); ++i) {
                    TreeItem<Pair<AbstractUrl, String>> item = items.get(i);
                    if (!((AbstractUrl)((Pair)item.getData()).getFirst()).equals(siblingUrl)) continue;
                    idx = i;
                    break;
                }
                if (idx != -1) {
                    items.add(idx, (TreeItem<Pair<AbstractUrl, String>>)newItem);
                } else {
                    items.add((TreeItem<Pair<AbstractUrl, String>>)newItem);
                }
            } else {
                items.add((TreeItem<Pair<AbstractUrl, String>>)newItem);
            }
            this.rootsChanged();
            return true;
        }
        List list = items;
        TreeItem<Pair<AbstractUrl, String>> item = null;
        for (AbstractTreeNode obj : parentElements) {
            AbstractUrl objUrl = FavoritesManager.createUrlByElement(obj.getValue(), this.myProject);
            item = this.findNextItem(objUrl, list);
            if (item == null) {
                return false;
            }
            list = item.getChildren();
        }
        if (sibling != null) {
            TreeItem after3 = null;
            AbstractUrl siblingUrl = FavoritesManager.createUrlByElement(sibling.getValue(), this.myProject);
            for (TreeItem treeItem : list) {
                if (!((AbstractUrl)((Pair)treeItem.getData()).getFirst()).equals(siblingUrl)) continue;
                after3 = treeItem;
                break;
            }
            if (after3 == null) {
                item.addChild(newItem);
            } else {
                item.addChildAfter(newItem, after3);
            }
        } else {
            item.addChild(newItem);
        }
        this.rootsChanged();
        return true;
    }

    private <T> boolean findListToRemoveFrom(@NotNull String name, @NotNull List<T> elements, Convertor<T, AbstractUrl> convertor) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTRIBUTE_NAME, "com/intellij/ide/favoritesTreeView/FavoritesManager", "findListToRemoveFrom"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/ide/favoritesTreeView/FavoritesManager", "findListToRemoveFrom"));
        }
        List list = this.getFavoritesListRootUrls(name);
        if (elements.size() > 1) {
            List<T> sublist = elements.subList(0, elements.size() - 1);
            for (T obj : sublist) {
                AbstractUrl objUrl = (AbstractUrl)convertor.convert(obj);
                TreeItem<Pair<AbstractUrl, String>> item = this.findNextItem(objUrl, list);
                if (item == null || item.getChildren() == null) {
                    return false;
                }
                list = item.getChildren();
            }
        }
        TreeItem found = null;
        AbstractUrl url = (AbstractUrl)convertor.convert(elements.get(elements.size() - 1));
        if (url == null) {
            return false;
        }
        for (TreeItem pair : list) {
            if (!url.equals(((Pair)pair.getData()).getFirst())) continue;
            found = pair;
            break;
        }
        if (found != null) {
            list.remove(found);
            this.rootsChanged();
            return true;
        }
        return false;
    }

    public synchronized boolean removeRoot(@NotNull String name, @NotNull List<AbstractTreeNode> elements) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTRIBUTE_NAME, "com/intellij/ide/favoritesTreeView/FavoritesManager", "removeRoot"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/ide/favoritesTreeView/FavoritesManager", "removeRoot"));
        }
        Convertor<AbstractTreeNode, AbstractUrl> convertor = new Convertor<AbstractTreeNode, AbstractUrl>(){

            public AbstractUrl convert(AbstractTreeNode obj) {
                return FavoritesManager.createUrlByElement(obj.getValue(), FavoritesManager.this.myProject);
            }
        };
        boolean result = true;
        for (AbstractTreeNode element : elements) {
            List<AbstractTreeNode> path = TaskDefaultFavoriteListProvider.getPathToUsualNode(element);
            result &= this.findListToRemoveFrom(name, path.subList(1, path.size()), convertor);
        }
        return result;
    }

    private TreeItem<Pair<AbstractUrl, String>> findNextItem(AbstractUrl url, Collection<TreeItem<Pair<AbstractUrl, String>>> list) {
        for (TreeItem<Pair<AbstractUrl, String>> pair : list) {
            if (!url.equals(((Pair)pair.getData()).getFirst())) continue;
            return pair;
        }
        return null;
    }

    private boolean renameFavoritesList(@NotNull String oldName, @NotNull String newName) {
        if (oldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldName", "com/intellij/ide/favoritesTreeView/FavoritesManager", "renameFavoritesList"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/ide/favoritesTreeView/FavoritesManager", "renameFavoritesList"));
        }
        List<TreeItem<Pair<AbstractUrl, String>>> list = this.myName2FavoritesRoots.remove(oldName);
        if (list != null && newName.length() > 0) {
            this.myName2FavoritesRoots.put(newName, list);
            String description = this.myDescriptions.remove(oldName);
            if (description != null) {
                this.myDescriptions.put(newName, description);
            }
            this.rootsChanged();
            return true;
        }
        return false;
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public void projectOpened() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            StartupManager.getInstance((Project)this.myProject).registerPostStartupActivity((Runnable)new DumbAwareRunnable(){

                public void run() {
                    FavoritesListProvider[] providers;
                    for (FavoritesListProvider provider : providers = (FavoritesListProvider[])Extensions.getExtensions(FavoritesListProvider.EP_NAME, (AreaInstance)FavoritesManager.this.myProject)) {
                        FavoritesManager.this.myProviders.put(provider.getListName(FavoritesManager.this.myProject), provider);
                    }
                    MyRootsChangeAdapter myPsiTreeChangeAdapter = new MyRootsChangeAdapter();
                    PsiManager.getInstance((Project)FavoritesManager.this.myProject).addPsiTreeChangeListener((PsiTreeChangeListener)myPsiTreeChangeAdapter, (Disposable)FavoritesManager.this.myProject);
                    if (FavoritesManager.this.myName2FavoritesRoots.isEmpty()) {
                        FavoritesManager.this.myDescriptions.put(FavoritesManager.this.myProject.getName(), "auto-added");
                        FavoritesManager.this.createNewList(FavoritesManager.this.myProject.getName());
                    }
                }
            });
        }
    }

    public void projectClosed() {
    }

    @NotNull
    public String getComponentName() {
        if ("FavoritesManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/FavoritesManager", "getComponentName"));
        }
        return "FavoritesManager";
    }

    @Nullable
    public FavoritesListProvider getListProvider(@Nullable String name) {
        return this.myProviders.get(name);
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.myName2FavoritesRoots.clear();
        for (Object list : element.getChildren(ELEMENT_FAVORITES_LIST)) {
            String name = ((Element)list).getAttributeValue(ATTRIBUTE_NAME);
            List<TreeItem<Pair<AbstractUrl, String>>> roots = FavoritesManager.readRoots((Element)list, this.myProject);
            this.myName2FavoritesRoots.put(name, roots);
        }
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
    }

    private static List<TreeItem<Pair<AbstractUrl, String>>> readRoots(Element list, Project project2) {
        ArrayList<TreeItem<Pair<AbstractUrl, String>>> result = new ArrayList<TreeItem<Pair<AbstractUrl, String>>>();
        FavoritesManager.readFavoritesOneLevel(list, project2, result);
        return result;
    }

    private static void readFavoritesOneLevel(Element list, Project project2, Collection<TreeItem<Pair<AbstractUrl, String>>> result) {
        List listChildren = list.getChildren(FAVORITES_ROOT);
        if (listChildren == null || listChildren.isEmpty()) {
            return;
        }
        for (Object favorite : listChildren) {
            Element favoriteElement = (Element)favorite;
            String className = favoriteElement.getAttributeValue(CLASS_NAME);
            AbstractUrl abstractUrl = FavoritesManager.readUrlFromElement(favoriteElement, project2);
            if (abstractUrl == null) continue;
            TreeItem treeItem = new TreeItem((Object)Pair.create((Object)abstractUrl, (Object)className));
            result.add((TreeItem<Pair<AbstractUrl, String>>)treeItem);
            FavoritesManager.readFavoritesOneLevel(favoriteElement, project2, treeItem.getChildren());
        }
    }

    @Nullable
    private static AbstractUrl readUrlFromElement(Element element, Project project2) {
        String type = element.getAttributeValue(ATTRIBUTE_TYPE);
        String urlValue = element.getAttributeValue(ATTRIBUTE_URL);
        String moduleName = element.getAttributeValue(ATTRIBUTE_MODULE);
        for (FavoriteNodeProvider nodeProvider : (FavoriteNodeProvider[])Extensions.getExtensions((ExtensionPointName)FavoriteNodeProvider.EP_NAME, (AreaInstance)project2)) {
            if (!nodeProvider.getFavoriteTypeId().equals(type)) continue;
            return new AbstractUrlFavoriteAdapter(urlValue, moduleName, nodeProvider);
        }
        for (AbstractUrl urlProvider : ourAbstractUrlProviders) {
            AbstractUrl url = urlProvider.createUrl(type, moduleName, urlValue);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    public void writeExternal(Element element) throws WriteExternalException {
        for (String name : this.myName2FavoritesRoots.keySet()) {
            Element list = new Element(ELEMENT_FAVORITES_LIST);
            list.setAttribute(ATTRIBUTE_NAME, name);
            FavoritesManager.writeRoots(list, (Collection<TreeItem<Pair<AbstractUrl, String>>>)this.myName2FavoritesRoots.get(name));
            element.addContent(list);
        }
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
    }

    @Nullable
    public static AbstractUrl createUrlByElement(Object element, Project project2) {
        if (element instanceof SmartPsiElementPointer) {
            element = ((SmartPsiElementPointer)element).getElement();
        }
        for (FavoriteNodeProvider nodeProvider : (FavoriteNodeProvider[])Extensions.getExtensions((ExtensionPointName)FavoriteNodeProvider.EP_NAME, (AreaInstance)project2)) {
            String url = nodeProvider.getElementUrl(element);
            if (url == null) continue;
            return new AbstractUrlFavoriteAdapter(url, nodeProvider.getElementModuleName(element), nodeProvider);
        }
        for (AbstractUrl urlProvider : ourAbstractUrlProviders) {
            AbstractUrl url = urlProvider.createUrlByElement(element);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    private static void writeRoots(Element element, Collection<TreeItem<Pair<AbstractUrl, String>>> roots) {
        for (TreeItem<Pair<AbstractUrl, String>> root : roots) {
            AbstractUrl url = (AbstractUrl)((Pair)root.getData()).getFirst();
            if (url == null) continue;
            Element list = new Element(FAVORITES_ROOT);
            url.write(list);
            list.setAttribute(CLASS_NAME, (String)((Pair)root.getData()).getSecond());
            element.addContent(list);
            List children2 = root.getChildren();
            if (children2 == null || children2.isEmpty()) continue;
            FavoritesManager.writeRoots(list, children2);
        }
    }

    public String getFavoriteListName(@Nullable String currentSubId, @NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/ide/favoritesTreeView/FavoritesManager", "getFavoriteListName"));
        }
        if (currentSubId != null && this.contains(currentSubId, vFile)) {
            return currentSubId;
        }
        for (String listName : this.myName2FavoritesRoots.keySet()) {
            if (!this.contains(listName, vFile)) continue;
            return listName;
        }
        return null;
    }

    public boolean contains(@NotNull String name, final @NotNull VirtualFile vFile) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTRIBUTE_NAME, "com/intellij/ide/favoritesTreeView/FavoritesManager", "contains"));
        }
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/ide/favoritesTreeView/FavoritesManager", "contains"));
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        final HashSet find = new HashSet();
        ContentIterator contentIterator = new ContentIterator(){

            public boolean processFile(VirtualFile fileOrDir) {
                if (fileOrDir != null && fileOrDir.getPath().equals(vFile.getPath())) {
                    find.add(Boolean.TRUE);
                }
                return true;
            }
        };
        List<TreeItem<Pair<AbstractUrl, String>>> urls = this.getFavoritesListRootUrls(name);
        for (TreeItem treeItem : urls) {
            NamedLibraryElement namedLibraryElement;
            Object[] files;
            VirtualFile virtualFile;
            Object[] path;
            AbstractUrl abstractUrl = (AbstractUrl)((Pair)treeItem.getData()).getFirst();
            if (abstractUrl == null || (path = abstractUrl.createPath(this.myProject)) == null || path.length < 1 || path[0] == null) continue;
            Object element = path[path.length - 1];
            if (element instanceof SmartPsiElementPointer) {
                virtualFile = PsiUtilBase.getVirtualFile((PsiElement)((SmartPsiElementPointer)element).getElement());
                if (virtualFile == null) continue;
                if (vFile.getPath().equals(virtualFile.getPath())) {
                    return true;
                }
                if (!virtualFile.isDirectory()) continue;
                projectFileIndex.iterateContentUnderDirectory(virtualFile, contentIterator);
            }
            if (element instanceof PsiElement) {
                virtualFile = PsiUtilBase.getVirtualFile((PsiElement)((PsiElement)element));
                if (virtualFile == null) continue;
                if (vFile.getPath().equals(virtualFile.getPath())) {
                    return true;
                }
                if (!virtualFile.isDirectory()) continue;
                projectFileIndex.iterateContentUnderDirectory(virtualFile, contentIterator);
            }
            if (element instanceof Module) {
                ModuleRootManager.getInstance((Module)((Module)element)).getFileIndex().iterateContent(contentIterator);
            }
            if (element instanceof LibraryGroupElement) {
                boolean inLibrary;
                boolean bl = inLibrary = ModuleRootManager.getInstance((Module)((LibraryGroupElement)element).getModule()).getFileIndex().isInContent(vFile) && projectFileIndex.isInLibraryClasses(vFile);
                if (inLibrary) {
                    return true;
                }
            }
            if (element instanceof NamedLibraryElement && (files = (namedLibraryElement = (NamedLibraryElement)element).getOrderEntry().getRootFiles(OrderRootType.CLASSES)) != null && ArrayUtil.find((Object[])files, (Object)vFile) > -1) {
                return true;
            }
            if (element instanceof ModuleGroup) {
                ModuleGroup group = (ModuleGroup)element;
                Collection<Module> modules = group.modulesInGroup(this.myProject, true);
                for (Module module2 : modules) {
                    ModuleRootManager.getInstance((Module)module2).getFileIndex().iterateContent(contentIterator);
                }
            }
            for (FavoriteNodeProvider provider : (FavoriteNodeProvider[])Extensions.getExtensions((ExtensionPointName)FavoriteNodeProvider.EP_NAME, (AreaInstance)this.myProject)) {
                if (!provider.elementContainsFile(element, vFile)) continue;
                return true;
            }
            if (find.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static void iterateTreeItems(Collection<TreeItem<Pair<AbstractUrl, String>>> coll, Consumer<TreeItem<Pair<AbstractUrl, String>>> consumer) {
        ArrayDeque<TreeItem<Pair<AbstractUrl, String>>> queue = new ArrayDeque<TreeItem<Pair<AbstractUrl, String>>>();
        queue.addAll(coll);
        while (!queue.isEmpty()) {
            TreeItem item = (TreeItem)queue.removeFirst();
            consumer.consume((Object)item);
            List children2 = item.getChildren();
            if (children2 == null || children2.isEmpty()) continue;
            queue.addAll(children2);
        }
    }

    static {
        ourAbstractUrlProviders.add(new ModuleUrl(null, null));
        ourAbstractUrlProviders.add(new DirectoryUrl(null, null));
        ourAbstractUrlProviders.add(new ModuleGroupUrl(null));
        ourAbstractUrlProviders.add(new PsiFileUrl(null));
        ourAbstractUrlProviders.add(new LibraryModuleGroupUrl(null));
        ourAbstractUrlProviders.add(new NamedLibraryUrl(null, null));
    }

    private class MyRootsChangeAdapter
    extends PsiTreeChangeAdapter {
        private MyRootsChangeAdapter() {
        }

        public void beforeChildMovement(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/favoritesTreeView/FavoritesManager$MyRootsChangeAdapter", "beforeChildMovement"));
            }
            final PsiElement oldParent = event.getOldParent();
            final PsiElement newParent = event.getNewParent();
            final PsiElement child = event.getChild();
            if (newParent instanceof PsiDirectory) {
                Module module2 = ModuleUtil.findModuleForPsiElement((PsiElement)newParent);
                if (module2 == null) {
                    return;
                }
                AbstractUrl childUrl = null;
                if (child instanceof PsiFile) {
                    childUrl = new PsiFileUrl(((PsiDirectory)newParent).getVirtualFile().getUrl() + "/" + ((PsiFile)child).getName());
                } else if (child instanceof PsiDirectory) {
                    childUrl = new DirectoryUrl(((PsiDirectory)newParent).getVirtualFile().getUrl() + "/" + ((PsiDirectory)child).getName(), module2.getName());
                }
                for (String listName : FavoritesManager.this.myName2FavoritesRoots.keySet()) {
                    List roots = (List)FavoritesManager.this.myName2FavoritesRoots.get(listName);
                    final AbstractUrl finalChildUrl = childUrl;
                    FavoritesManager.iterateTreeItems(roots, (Consumer<TreeItem<Pair<AbstractUrl, String>>>)((Consumer)new Consumer<TreeItem<Pair<AbstractUrl, String>>>(){

                        public void consume(TreeItem<Pair<AbstractUrl, String>> item) {
                            Pair root = (Pair)item.getData();
                            Object[] path = ((AbstractUrl)root.first).createPath(FavoritesManager.this.myProject);
                            if (path == null || path.length < 1 || path[0] == null) {
                                return;
                            }
                            Object element = path[path.length - 1];
                            if (element == child && finalChildUrl != null) {
                                item.setData((Object)Pair.create((Object)finalChildUrl, (Object)root.second));
                            } else if (element == oldParent) {
                                item.setData((Object)Pair.create((Object)((AbstractUrl)root.first).createUrlByElement(newParent), (Object)root.second));
                            }
                        }
                    }));
                }
            }
        }

        public void beforePropertyChange(@NotNull PsiTreeChangeEvent event) {
            PsiElement psiElement;
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/favoritesTreeView/FavoritesManager$MyRootsChangeAdapter", "beforePropertyChange"));
            }
            if ((event.getPropertyName().equals("fileName") || event.getPropertyName().equals("directoryName")) && ((psiElement = event.getChild()) instanceof PsiFile || psiElement instanceof PsiDirectory)) {
                Module module2 = ModuleUtil.findModuleForPsiElement((PsiElement)psiElement);
                if (module2 == null) {
                    return;
                }
                String url = ((PsiDirectory)psiElement.getParent()).getVirtualFile().getUrl() + "/" + event.getNewValue();
                final AbstractUrl childUrl = psiElement instanceof PsiFile ? new PsiFileUrl(url) : new DirectoryUrl(url, module2.getName());
                for (String listName : FavoritesManager.this.myName2FavoritesRoots.keySet()) {
                    List roots = (List)FavoritesManager.this.myName2FavoritesRoots.get(listName);
                    FavoritesManager.iterateTreeItems(roots, (Consumer<TreeItem<Pair<AbstractUrl, String>>>)((Consumer)new Consumer<TreeItem<Pair<AbstractUrl, String>>>(){

                        public void consume(TreeItem<Pair<AbstractUrl, String>> item) {
                            Pair root = (Pair)item.getData();
                            Object[] path = ((AbstractUrl)root.first).createPath(FavoritesManager.this.myProject);
                            if (path == null || path.length < 1 || path[0] == null) {
                                return;
                            }
                            Object element = path[path.length - 1];
                            if (element == psiElement && psiElement instanceof PsiFile) {
                                item.setData((Object)Pair.create((Object)childUrl, (Object)root.second));
                            } else {
                                item.setData((Object)root);
                            }
                        }
                    }));
                }
            }
        }
    }
}

