/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.projectWizard.ProjectJdkListRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.ui.ProjectJdksEditor;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.ClickListener;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtil;
import gnu.trove.TIntArrayList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdkChooserPanel
extends JPanel {
    private JList myList = null;
    private DefaultListModel myListModel = null;
    private Sdk myCurrentJdk;
    @Nullable
    private final Project myProject;
    private SdkType[] myAllowedJdkTypes = null;

    public JdkChooserPanel(@Nullable Project project2) {
        super(new BorderLayout());
        this.myProject = project2;
        this.myListModel = new DefaultListModel();
        this.myList = new JBList((ListModel)this.myListModel);
        this.myList.setSelectionMode(0);
        this.myList.setCellRenderer(new ProjectJdkListRenderer());
        this.myList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                JdkChooserPanel.this.myCurrentJdk = (Sdk)JdkChooserPanel.this.myList.getSelectedValue();
            }
        });
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/projectWizard/JdkChooserPanel$2", "onClick"));
                }
                if (JdkChooserPanel.this.myProject == null) {
                    JdkChooserPanel.this.editJdkTable();
                }
                return true;
            }
        }.installOn((Component)this.myList);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myList), "Center");
        this.add((Component)panel, "Center");
        if (this.myListModel.getSize() > 0) {
            this.myList.setSelectedIndex(0);
        }
    }

    public void setAllowedJdkTypes(@Nullable SdkType[] allowedJdkTypes) {
        this.myAllowedJdkTypes = allowedJdkTypes;
    }

    public Sdk getChosenJdk() {
        return this.myCurrentJdk;
    }

    public Object[] getAllJdks() {
        return this.myListModel.toArray();
    }

    public void editJdkTable() {
        ProjectJdksEditor editor = new ProjectJdksEditor((Sdk)this.myList.getSelectedValue(), this.myProject != null ? this.myProject : ProjectManager.getInstance().getDefaultProject(), this.myList);
        if (editor.showAndGet()) {
            Sdk selectedJdk = editor.getSelectedJdk();
            this.updateList(selectedJdk, null);
        }
    }

    public void updateList(Sdk selectedJdk, @Nullable SdkType type) {
        this.updateList(selectedJdk, type, null);
    }

    public void updateList(Sdk selectedJdk, @Nullable SdkType type, @Nullable Sdk[] globalSdks) {
        int[] selectedIndices = this.myList.getSelectedIndices();
        this.fillList(type, globalSdks);
        if (selectedJdk != null) {
            TIntArrayList list = new TIntArrayList();
            for (int i = 0; i < this.myListModel.size(); ++i) {
                Sdk jdk = (Sdk)this.myListModel.getElementAt(i);
                if (!Comparing.strEqual((String)jdk.getName(), (String)selectedJdk.getName())) continue;
                list.add(i);
            }
            int[] indicesToSelect = list.toNativeArray();
            if (indicesToSelect.length > 0) {
                this.myList.setSelectedIndices(indicesToSelect);
            } else if (this.myList.getModel().getSize() > 0) {
                this.myList.setSelectedIndex(0);
            }
        } else if (selectedIndices.length > 0) {
            this.myList.setSelectedIndices(selectedIndices);
        } else {
            this.myList.setSelectedIndex(0);
        }
        this.myCurrentJdk = (Sdk)this.myList.getSelectedValue();
    }

    public JList getPreferredFocusedComponent() {
        return this.myList;
    }

    public void fillList(@Nullable SdkType type, @Nullable Sdk[] globalSdks) {
        Sdk[] jdks;
        this.myListModel.clear();
        if (this.myProject == null || this.myProject.isDefault()) {
            Sdk[] allJdks = globalSdks != null ? globalSdks : ProjectJdkTable.getInstance().getAllJdks();
            jdks = this.getCompatibleJdks(type, Arrays.asList(allJdks));
        } else {
            ProjectSdksModel projectJdksModel = ProjectStructureConfigurable.getInstance(this.myProject).getProjectJdksModel();
            if (!projectJdksModel.isInitialized()) {
                projectJdksModel.reset(this.myProject);
            }
            Collection<Sdk> collection = projectJdksModel.getProjectSdks().values();
            jdks = this.getCompatibleJdks(type, collection);
        }
        Arrays.sort(jdks, new Comparator<Sdk>(){

            @Override
            public int compare(Sdk o1, Sdk o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        for (Sdk jdk : jdks) {
            this.myListModel.addElement(jdk);
        }
    }

    private Sdk[] getCompatibleJdks(@Nullable SdkType type, Collection<Sdk> collection) {
        HashSet<Sdk> compatibleJdks = new HashSet<Sdk>();
        for (Sdk projectJdk : collection) {
            if (!this.isCompatibleJdk(projectJdk, type)) continue;
            compatibleJdks.add(projectJdk);
        }
        return compatibleJdks.toArray(new Sdk[compatibleJdks.size()]);
    }

    private boolean isCompatibleJdk(Sdk projectJdk, @Nullable SdkType type) {
        if (type != null) {
            return projectJdk.getSdkType() == type;
        }
        if (this.myAllowedJdkTypes != null) {
            return ArrayUtil.indexOf((Object[])this.myAllowedJdkTypes, (Object)projectJdk.getSdkType()) >= 0;
        }
        return true;
    }

    public JComponent getDefaultFocusedComponent() {
        return this.myList;
    }

    public void selectJdk(Sdk defaultJdk) {
        int index = this.myListModel.indexOf(defaultJdk);
        if (index >= 0) {
            this.myList.setSelectedIndex(index);
        }
    }

    public void addSelectionListener(ListSelectionListener listener) {
        this.myList.addListSelectionListener(listener);
    }

    private static Sdk showDialog(Project project2, String title, Component parent, Sdk jdkToSelect) {
        JdkChooserPanel jdkChooserPanel = new JdkChooserPanel(project2);
        jdkChooserPanel.fillList(null, null);
        JdkChooserPanel jdkChooserPanel2 = jdkChooserPanel;
        jdkChooserPanel2.getClass();
        final MyDialog dialog = jdkChooserPanel2.new MyDialog(parent);
        if (title != null) {
            dialog.setTitle(title);
        }
        if (jdkToSelect != null) {
            jdkChooserPanel.selectJdk(jdkToSelect);
        } else {
            ScrollingUtil.ensureSelectionExists((JList)jdkChooserPanel.myList);
        }
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                dialog.clickDefaultButton();
                return true;
            }
        }.installOn((Component)jdkChooserPanel.myList);
        return dialog.showAndGet() ? jdkChooserPanel.getChosenJdk() : null;
    }

    public static Sdk chooseAndSetJDK(final Project project2) {
        Sdk projectJdk = ProjectRootManager.getInstance((Project)project2).getProjectSdk();
        final Sdk jdk = JdkChooserPanel.showDialog(project2, ProjectBundle.message((String)"module.libraries.target.jdk.select.title", (Object[])new Object[0]), WindowManagerEx.getInstanceEx().getFrame(project2), projectJdk);
        if (jdk == null) {
            return null;
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                ProjectRootManager.getInstance((Project)project2).setProjectSdk(jdk);
            }
        });
        return jdk;
    }

    public class MyDialog
    extends DialogWrapper
    implements ListSelectionListener {
        public MyDialog(Component parent) {
            super(parent, true);
            this.setTitle(IdeBundle.message((String)"title.select.jdk", (Object[])new Object[0]));
            this.init();
            JdkChooserPanel.this.myList.addListSelectionListener(this);
            this.updateOkButton();
        }

        protected String getDimensionServiceKey() {
            return "#com.intellij.ide.util.projectWizard.JdkChooserPanel.MyDialog";
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateOkButton();
        }

        private void updateOkButton() {
            this.setOKActionEnabled(JdkChooserPanel.this.myList.getSelectedValue() != null);
        }

        public void dispose() {
            JdkChooserPanel.this.myList.removeListSelectionListener(this);
            super.dispose();
        }

        protected JComponent createCenterPanel() {
            return JdkChooserPanel.this;
        }

        @NotNull
        protected Action[] createActions() {
            Action[] actionArray = new Action[]{new ConfigureAction(), this.getOKAction(), this.getCancelAction()};
            if (actionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/projectWizard/JdkChooserPanel$MyDialog", "createActions"));
            }
            return actionArray;
        }

        public JComponent getPreferredFocusedComponent() {
            return JdkChooserPanel.this.myList;
        }

        private final class ConfigureAction
        extends AbstractAction {
            public ConfigureAction() {
                super(IdeBundle.message((String)"button.configure.e", (Object[])new Object[0]));
                this.putValue("MnemonicKey", new Integer(69));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                JdkChooserPanel.this.editJdkTable();
            }
        }
    }
}

