/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.FrameStateManager;
import com.intellij.notification.EventLog;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsAdapter;
import com.intellij.notification.NotificationsManager;
import com.intellij.notification.impl.NotificationActionProvider;
import com.intellij.notification.impl.NotificationSettings;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.notification.impl.ui.NotificationsUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.DialogWrapperDialog;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.ui.BalloonImpl;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.BalloonLayoutData;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.NotificationBalloonActionProvider;
import com.intellij.ui.NotificationBalloonShadowBorderProvider;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.GradientViewport;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.ButtonlessScrollBarUI;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NotificationsManagerImpl
extends NotificationsManager {
    private static final int ACTION_GAP = 16;

    public NotificationsManagerImpl() {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(Notifications.TOPIC, (Object)new MyNotificationListener(null));
    }

    public static boolean newEnabled() {
        return Registry.is((String)"ide.new.notification.enabled", (boolean)false);
    }

    public void expire(final @NotNull Notification notification) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/impl/NotificationsManagerImpl", "expire"));
        }
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                EventLog.expireNotification(notification);
            }
        });
    }

    @NotNull
    public <T extends Notification> T[] getNotificationsOfType(@NotNull Class<T> klass, @Nullable Project project2) {
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "com/intellij/notification/impl/NotificationsManagerImpl", "getNotificationsOfType"));
        }
        ArrayList<Notification> result = new ArrayList<Notification>();
        if (project2 == null || !project2.isDefault() && !project2.isDisposed()) {
            for (Notification notification : EventLog.getLogModel(project2).getNotifications()) {
                if (!klass.isInstance(notification)) continue;
                result.add(notification);
            }
        }
        Notification[] notificationArray = (Notification[])ArrayUtil.toObjectArray(result, klass);
        if (notificationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/impl/NotificationsManagerImpl", "getNotificationsOfType"));
        }
        return notificationArray;
    }

    private static void doNotify(final @NotNull Notification notification, @Nullable NotificationDisplayType displayType, final @Nullable Project project2) {
        boolean willBeShown;
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/impl/NotificationsManagerImpl", "doNotify"));
        }
        NotificationsConfigurationImpl configuration = NotificationsConfigurationImpl.getInstanceImpl();
        if (!configuration.isRegistered(notification.getGroupId())) {
            configuration.register(notification.getGroupId(), displayType == null ? NotificationDisplayType.BALLOON : displayType);
        }
        NotificationSettings settings = NotificationsConfigurationImpl.getSettings(notification.getGroupId());
        boolean shouldLog = settings.isShouldLog();
        boolean displayable = settings.getDisplayType() != NotificationDisplayType.NONE;
        boolean bl = willBeShown = displayable && NotificationsConfigurationImpl.getInstanceImpl().SHOW_BALLOONS;
        if (!shouldLog && !willBeShown) {
            notification.expire();
        }
        if (NotificationsConfigurationImpl.getInstanceImpl().SHOW_BALLOONS) {
            DumbAwareRunnable runnable2 = new DumbAwareRunnable(){

                public void run() {
                    NotificationsManagerImpl.showNotification(notification, project2);
                }
            };
            if (project2 == null) {
                UIUtil.invokeLaterIfNeeded((Runnable)runnable2);
            } else if (!project2.isDisposed()) {
                StartupManager.getInstance((Project)project2).runWhenProjectIsInitialized((Runnable)runnable2);
            }
        }
    }

    private static void showNotification(final @NotNull Notification notification, final @Nullable Project project2) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/impl/NotificationsManagerImpl", "showNotification"));
        }
        Application application = ApplicationManager.getApplication();
        if (application instanceof ApplicationEx && !((ApplicationEx)application).isLoaded()) {
            application.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NotificationsManagerImpl.showNotification(notification, project2);
                }
            }, ModalityState.current());
            return;
        }
        String groupId = notification.getGroupId();
        NotificationSettings settings = NotificationsConfigurationImpl.getSettings(groupId);
        NotificationDisplayType type = settings.getDisplayType();
        String toolWindowId = NotificationsConfigurationImpl.getInstanceImpl().getToolWindowId(groupId);
        if (!(type != NotificationDisplayType.TOOL_WINDOW || toolWindowId != null && project2 != null && ToolWindowManager.getInstance((Project)project2).canShowNotification(toolWindowId))) {
            type = NotificationDisplayType.BALLOON;
        }
        switch (type) {
            case NONE: {
                return;
            }
            default: {
                Balloon balloon = NotificationsManagerImpl.notifyByBalloon(notification, type, project2);
                if (settings.isShouldLog() && type != NotificationDisplayType.STICKY_BALLOON) break;
                if (balloon == null) {
                    notification.expire();
                    break;
                }
                balloon.addListener((JBPopupListener)new JBPopupAdapter(){

                    public void onClosed(LightweightWindowEvent event) {
                        if (!event.isOk()) {
                            notification.expire();
                        }
                    }
                });
                break;
            }
            case TOOL_WINDOW: {
                HyperlinkListener listener;
                MessageType messageType = notification.getType() == NotificationType.ERROR ? MessageType.ERROR : (notification.getType() == NotificationType.WARNING ? MessageType.WARNING : MessageType.INFO);
                final NotificationListener notificationListener = notification.getListener();
                HyperlinkListener hyperlinkListener = listener = notificationListener == null ? null : new HyperlinkListener(){

                    @Override
                    public void hyperlinkUpdate(HyperlinkEvent e) {
                        notificationListener.hyperlinkUpdate(notification, e);
                    }
                };
                assert (toolWindowId != null);
                String msg = notification.getTitle();
                if (StringUtil.isNotEmpty((String)notification.getContent())) {
                    if (StringUtil.isNotEmpty((String)msg)) {
                        msg = msg + "<br>";
                    }
                    msg = msg + notification.getContent();
                }
                ToolWindowManager.getInstance((Project)project2).notifyByBalloon(toolWindowId, messageType, msg, notification.getIcon(), listener);
            }
        }
    }

    @Nullable
    private static Balloon notifyByBalloon(@NotNull Notification notification, @NotNull NotificationDisplayType displayType, @Nullable Project project2) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/impl/NotificationsManagerImpl", "notifyByBalloon"));
        }
        if (displayType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayType", "com/intellij/notification/impl/NotificationsManagerImpl", "notifyByBalloon"));
        }
        if (NotificationsManagerImpl.isDummyEnvironment()) {
            return null;
        }
        Window window = NotificationsManagerImpl.findWindowForBalloon(project2);
        if (window instanceof IdeFrame) {
            final ProjectManager projectManager = ProjectManager.getInstance();
            final boolean noProjects = projectManager.getOpenProjects().length == 0;
            final boolean sticky = NotificationDisplayType.STICKY_BALLOON == displayType || noProjects;
            Ref layoutDataRef = NotificationsManagerImpl.newEnabled() && notification.getIcon() != null ? new Ref() : null;
            final Balloon balloon = NotificationsManagerImpl.createBalloon((IdeFrame)window, notification, false, false, (Ref<Object>)layoutDataRef);
            Disposer.register((Disposable)(project2 != null ? project2 : ApplicationManager.getApplication()), (Disposable)balloon);
            if (notification.isExpired()) {
                return null;
            }
            BalloonLayout layout = ((IdeFrame)window).getBalloonLayout();
            if (layout == null) {
                return null;
            }
            layout.add(balloon, layoutDataRef == null ? null : layoutDataRef.get());
            if (layoutDataRef != null && layoutDataRef.get() instanceof BalloonLayoutData) {
                ((BalloonLayoutData)layoutDataRef.get()).project = project2;
            }
            ((BalloonImpl)balloon).startFadeoutTimer(0);
            if (NotificationDisplayType.BALLOON == displayType) {
                FrameStateManager.getInstance().getApplicationActive().doWhenDone(new Runnable(){

                    @Override
                    public void run() {
                        if (balloon.isDisposed()) {
                            return;
                        }
                        if (!sticky) {
                            ((BalloonImpl)balloon).startFadeoutTimer(0);
                            ((BalloonImpl)balloon).setHideOnClickOutside(true);
                        } else if (noProjects) {
                            projectManager.addProjectManagerListener((ProjectManagerListener)new ProjectManagerAdapter(){

                                public void projectOpened(Project project2) {
                                    projectManager.removeProjectManagerListener((ProjectManagerListener)this);
                                    if (!balloon.isDisposed()) {
                                        ((BalloonImpl)balloon).startFadeoutTimer(300);
                                    }
                                }
                            });
                        }
                    }
                });
            }
            return balloon;
        }
        return null;
    }

    @Nullable
    public static Window findWindowForBalloon(@Nullable Project project2) {
        Window frame = WindowManager.getInstance().getFrame(project2);
        if (frame == null && project2 == null) {
            frame = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            while (frame instanceof DialogWrapperDialog && ((DialogWrapperDialog)frame).getDialogWrapper().isModalProgress()) {
                frame = frame.getOwner();
            }
        }
        if (frame == null && project2 == null) {
            frame = (Window)WelcomeFrame.getInstance();
        }
        return frame;
    }

    @NotNull
    public static Balloon createBalloon(@NotNull IdeFrame window, @NotNull Notification notification, boolean showCallout, boolean hideOnClickOutside, @Nullable Ref<Object> layoutDataRef) {
        if (window == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/notification/impl/NotificationsManagerImpl", "createBalloon"));
        }
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/impl/NotificationsManagerImpl", "createBalloon"));
        }
        Balloon balloon = NotificationsManagerImpl.createBalloon(window.getComponent(), notification, showCallout, hideOnClickOutside, layoutDataRef);
        if (balloon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/impl/NotificationsManagerImpl", "createBalloon"));
        }
        return balloon;
    }

    @NotNull
    public static Balloon createBalloon(@Nullable JComponent windowComponent, @NotNull Notification notification, boolean showCallout, boolean hideOnClickOutside, @Nullable Ref<Object> layoutDataRef) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/impl/NotificationsManagerImpl", "createBalloon"));
        }
        if (layoutDataRef != null) {
            Balloon balloon = NotificationsManagerImpl.createNewBalloon(windowComponent, notification, showCallout, hideOnClickOutside, layoutDataRef);
            if (balloon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/impl/NotificationsManagerImpl", "createBalloon"));
            }
            return balloon;
        }
        JEditorPane text = new JEditorPane();
        text.setEditorKit(UIUtil.getHTMLEditorKit());
        HyperlinkListener listener = NotificationsUtil.wrapListener(notification);
        if (listener != null) {
            text.addHyperlinkListener(listener);
        }
        JLabel label = new JLabel(NotificationsUtil.buildHtml(notification, null));
        text.setText(NotificationsUtil.buildHtml(notification, "width:" + Math.min(JBUI.scale((int)350), label.getPreferredSize().width) + "px;"));
        text.setEditable(false);
        text.setOpaque(false);
        if (UIUtil.isUnderNimbusLookAndFeel()) {
            text.setBackground(UIUtil.TRANSPARENT_COLOR);
        }
        text.setBorder(null);
        NonOpaquePanel content = new NonOpaquePanel((LayoutManager)new BorderLayout((int)((double)label.getIconTextGap() * 1.5), (int)((double)label.getIconTextGap() * 1.5)));
        if (text.getCaret() != null) {
            text.setCaretPosition(0);
        }
        JScrollPane pane = new JScrollPane(text);
        pane.setBorder(BorderFactory.createEmptyBorder());
        pane.setOpaque(false);
        pane.getViewport().setOpaque(false);
        content.add((Component)pane, "Center");
        NonOpaquePanel north = new NonOpaquePanel((LayoutManager)new BorderLayout());
        north.add((Component)new JLabel(NotificationsUtil.getIcon(notification)), (Object)"North");
        content.add((Component)north, "West");
        content.setBorder(new EmptyBorder(2, 4, 2, 4));
        JPanel buttons = NotificationsManagerImpl.createButtons(notification, (JPanel)content, listener);
        Dimension preferredSize = text.getPreferredSize();
        text.setSize(preferredSize);
        Dimension paneSize = new Dimension(text.getPreferredSize());
        int maxHeight = JBUI.scale((int)400);
        int maxWidth = JBUI.scale((int)600);
        if (windowComponent != null) {
            maxHeight = Math.min(maxHeight, windowComponent.getHeight() - 20);
            maxWidth = Math.min(maxWidth, windowComponent.getWidth() - 20);
        }
        if (paneSize.height > maxHeight) {
            pane.setPreferredSize(new Dimension(Math.min(maxWidth, paneSize.width + UIUtil.getScrollBarWidth()), maxHeight));
        } else if (paneSize.width > maxWidth) {
            pane.setPreferredSize(new Dimension(maxWidth, paneSize.height + UIUtil.getScrollBarWidth()));
        }
        BalloonBuilder builder = JBPopupFactory.getInstance().createBalloonBuilder((JComponent)content);
        builder.setFillColor((Color)new JBColor((Color)Gray._234, (Color)Gray._92)).setCloseButtonEnabled(buttons == null).setShowCallout(showCallout).setShadow(false).setHideOnClickOutside(hideOnClickOutside).setHideOnAction(hideOnClickOutside).setHideOnKeyOutside(hideOnClickOutside).setHideOnFrameResize(false).setBorderColor((Color)new JBColor((Color)Gray._180, (Color)Gray._110));
        Balloon balloon = builder.createBalloon();
        balloon.setAnimationEnabled(false);
        notification.setBalloon(balloon);
        Balloon balloon2 = balloon;
        if (balloon2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/impl/NotificationsManagerImpl", "createBalloon"));
        }
        return balloon2;
    }

    @Nullable
    private static JPanel createButtons(@NotNull Notification notification, @NotNull JPanel content, @Nullable HyperlinkListener listener) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/impl/NotificationsManagerImpl", "createButtons"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/notification/impl/NotificationsManagerImpl", "createButtons"));
        }
        if (notification instanceof NotificationActionProvider) {
            NotificationActionProvider provider = (NotificationActionProvider)notification;
            JPanel buttons = new JPanel((LayoutManager)new HorizontalLayout(5));
            buttons.setOpaque(false);
            content.add("South", buttons);
            for (NotificationActionProvider.Action action : provider.getActions(listener)) {
                JButton button = new JButton(action);
                button.setOpaque(false);
                buttons.add("RIGHT", button);
            }
            return buttons;
        }
        return null;
    }

    @NotNull
    private static Balloon createNewBalloon(@Nullable JComponent windowComponent, @NotNull Notification notification, boolean showCallout, boolean hideOnClickOutside, @NotNull Ref<Object> layoutDataRef) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/impl/NotificationsManagerImpl", "createNewBalloon"));
        }
        if (layoutDataRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layoutDataRef", "com/intellij/notification/impl/NotificationsManagerImpl", "createNewBalloon"));
        }
        final BalloonLayoutData layoutData = new BalloonLayoutData();
        layoutDataRef.set((Object)layoutData);
        boolean isTitle = !StringUtil.isEmpty((String)notification.getTitle()) || !StringUtil.isEmpty((String)notification.getSubtitle());
        JBColor foreground = new JBColor((Color)Gray._0, (Color)Gray._191);
        final JBColor fillColor = new JBColor((Color)Gray._242, new Color(78, 80, 82));
        final JEditorPane text = new JEditorPane(){

            @Override
            protected void paintComponent(Graphics g) {
                Point location;
                super.paintComponent(g);
                if (layoutData.showMinSize && (location = NotificationsManagerImpl.getCollapsedTextEndLocation(this, layoutData)) != null) {
                    g.setColor(this.getForeground());
                    g.drawString("...", location.x, location.y + g.getFontMetrics().getAscent());
                }
            }
        };
        text.setEditorKit(UIUtil.getHTMLEditorKit());
        text.setForeground((Color)foreground);
        HyperlinkListener listener = NotificationsUtil.wrapListener(notification);
        if (listener != null) {
            text.addHyperlinkListener(listener);
        }
        JLabel label = new JLabel(NotificationsUtil.buildHtml(notification, null, true, null));
        int maxSize = JBUI.scale((int)350);
        String style = label.getPreferredSize().width > maxSize ? "width:" + maxSize + "px;" : null;
        text.setText(NotificationsUtil.buildHtml(notification, style, true, (Color)foreground));
        text.setEditable(false);
        text.setOpaque(false);
        if (UIUtil.isUnderNimbusLookAndFeel()) {
            text.setBackground(UIUtil.TRANSPARENT_COLOR);
        }
        text.setBorder(null);
        int gap = (int)((double)label.getIconTextGap() * 1.5);
        NonOpaquePanel content = new NonOpaquePanel((LayoutManager)new BorderLayout(gap, gap));
        if (text.getCaret() != null) {
            text.setCaretPosition(0);
        }
        final JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)text, (boolean)true);
        pane.setOpaque(false);
        pane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                JScrollBar scrollBar = pane.getVerticalScrollBar();
                if (layoutData.showMinSize && scrollBar.getValue() > 0) {
                    scrollBar.removeAdjustmentListener(this);
                    scrollBar.setValue(0);
                    scrollBar.addAdjustmentListener(this);
                }
            }
        });
        List actions = notification.getActions();
        LinkLabel expandAction = null;
        int lines = 3;
        if (isTitle) {
            --lines;
        }
        if (!actions.isEmpty()) {
            --lines;
        }
        layoutData.fullHeight = text.getPreferredSize().height;
        layoutData.twoLineHeight = NotificationsManagerImpl.calculateContentHeight(lines);
        layoutData.maxScrollHeight = Math.min(layoutData.fullHeight, NotificationsManagerImpl.calculateContentHeight(10));
        if (layoutData.maxScrollHeight != layoutData.fullHeight) {
            pane.setViewport(new GradientViewport(text, (Insets)JBUI.insets((int)10, (int)0), true){

                @Override
                @Nullable
                protected Color getViewColor() {
                    return fillColor;
                }

                @Override
                protected void paintGradient(Graphics g) {
                    if (!layoutData.showMinSize) {
                        super.paintGradient(g);
                    }
                }
            });
        }
        pane.getViewport().setOpaque(false);
        if (!Registry.is((String)"ide.scroll.new.layout")) {
            pane.getVerticalScrollBar().setUI(ButtonlessScrollBarUI.createTransparent());
        }
        pane.setBackground((Color)fillColor);
        pane.getViewport().setBackground((Color)fillColor);
        pane.getVerticalScrollBar().setBackground((Color)fillColor);
        if (layoutData.twoLineHeight < layoutData.fullHeight) {
            text.setPreferredSize(null);
            Dimension size = text.getPreferredSize();
            size.height = layoutData.twoLineHeight;
            text.setPreferredSize(size);
            text.setSize(size);
            layoutData.showMinSize = true;
            pane.setHorizontalScrollBarPolicy(31);
            pane.setVerticalScrollBarPolicy(21);
            pane.setPreferredSize(size);
            expandAction = new LinkLabel(null, NotificationBalloonActionProvider.icon(AllIcons.Ide.Notification.Expand), (LinkListener)new LinkListener<Void>((JPanel)content){
                final /* synthetic */ JPanel val$content;
                {
                    this.val$content = jPanel;
                }

                public void linkSelected(LinkLabel link, Void ignored) {
                    layoutData.showMinSize = !layoutData.showMinSize;
                    text.setPreferredSize(null);
                    Dimension size = text.getPreferredSize();
                    if (layoutData.showMinSize) {
                        size.height = layoutData.twoLineHeight;
                        pane.setVerticalScrollBarPolicy(21);
                        link.setIcon(NotificationBalloonActionProvider.icon(AllIcons.Ide.Notification.Expand));
                        link.setHoveringIcon(NotificationBalloonActionProvider.icon(AllIcons.Ide.Notification.ExpandHover));
                    } else {
                        size.height = layoutData.fullHeight;
                        pane.setVerticalScrollBarPolicy(20);
                        link.setIcon(NotificationBalloonActionProvider.icon(AllIcons.Ide.Notification.Collapse));
                        link.setHoveringIcon(NotificationBalloonActionProvider.icon(AllIcons.Ide.Notification.CollapseHover));
                    }
                    text.setPreferredSize(size);
                    text.setSize(size);
                    if (!layoutData.showMinSize) {
                        size = new Dimension(size.width, layoutData.maxScrollHeight);
                    }
                    pane.setPreferredSize(size);
                    this.val$content.doLayout();
                    layoutData.doLayout.run();
                }
            });
            expandAction.setHoveringIcon(NotificationBalloonActionProvider.icon(AllIcons.Ide.Notification.ExpandHover));
        }
        final CenteredLayoutWithActions layout = new CenteredLayoutWithActions(gap, text, layoutData);
        NonOpaquePanel centerPanel = new NonOpaquePanel(layout){

            protected void paintChildren(Graphics g) {
                super.paintChildren(g);
                Component title = layout.getTitle();
                if (title != null && layoutData.showActions != null && ((Boolean)layoutData.showActions.compute()).booleanValue()) {
                    Insets insets = this.getInsets();
                    int width = NotificationBalloonActionProvider.getAllActionsOffset();
                    int x = this.getWidth() - insets.right - width;
                    int y = insets.top;
                    int height = title instanceof JEditorPane ? NotificationsManagerImpl.getFirstLineHeight((JEditorPane)title) : title.getHeight();
                    g.setColor((Color)fillColor);
                    g.fillRect(x, y, width, height);
                    width = 15;
                    ((Graphics2D)g).setPaint(new GradientPaint(x -= width, y, ColorUtil.withAlpha((Color)fillColor, (double)0.2), x + width, y, (Color)fillColor));
                    g.fillRect(x, y, width, height);
                }
            }
        };
        content.add((Component)centerPanel, "Center");
        if (isTitle) {
            JLabel title = new JLabel(NotificationsUtil.buildHtml(notification, "white-space: nowrap;", false, (Color)foreground));
            title.setOpaque(false);
            if (UIUtil.isUnderNimbusLookAndFeel()) {
                title.setBackground(UIUtil.TRANSPARENT_COLOR);
            }
            title.setForeground((Color)foreground);
            centerPanel.add((Component)title, "North");
        }
        if (expandAction != null) {
            centerPanel.add((Component)expandAction, "East");
        }
        if (!StringUtil.isEmptyOrSpaces((String)notification.getContent())) {
            centerPanel.add((Component)pane, "Center");
        }
        NonOpaquePanel iconPanel = new NonOpaquePanel((LayoutManager)new BorderLayout());
        iconPanel.add((Component)new JLabel(NotificationsUtil.getIcon(notification)), (Object)"North");
        content.add((Component)iconPanel, "West");
        content.setBorder(new EmptyBorder(2, 4, 2, 4));
        JPanel buttons = NotificationsManagerImpl.createButtons(notification, (JPanel)content, listener);
        if (buttons == null && !actions.isEmpty()) {
            NotificationsManagerImpl.createActionPanel(notification, (JPanel)centerPanel);
        }
        text.setSize(text.getPreferredSize());
        Dimension paneSize = new Dimension(text.getPreferredSize());
        int maxWidth = JBUI.scale((int)600);
        if (windowComponent != null) {
            maxWidth = Math.min(maxWidth, windowComponent.getWidth() - 20);
        }
        if (paneSize.width > maxWidth) {
            pane.setPreferredSize(new Dimension(maxWidth, paneSize.height + UIUtil.getScrollBarWidth()));
        }
        BalloonBuilder builder = JBPopupFactory.getInstance().createBalloonBuilder((JComponent)content);
        builder.setFillColor((Color)fillColor).setCloseButtonEnabled(buttons == null).setShowCallout(showCallout).setShadow(false).setHideOnClickOutside(hideOnClickOutside).setHideOnAction(hideOnClickOutside).setHideOnKeyOutside(hideOnClickOutside).setHideOnFrameResize(false).setBorderColor((Color)new JBColor(Gray._178.withAlpha(205), new Color(86, 90, 92, 205))).setBorderInsets(new Insets(0, 0, 0, 0));
        BalloonImpl balloon = (BalloonImpl)builder.createBalloon();
        balloon.setAnimationEnabled(false);
        notification.setBalloon((Balloon)balloon);
        balloon.setShadowBorderProvider(new NotificationBalloonShadowBorderProvider());
        if (buttons == null) {
            balloon.setActionProvider(new NotificationBalloonActionProvider(balloon, layout.getTitle(), layoutData, notification.getGroupId()));
        }
        BalloonImpl balloonImpl = balloon;
        if (balloonImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/impl/NotificationsManagerImpl", "createNewBalloon"));
        }
        return balloonImpl;
    }

    private static void createActionPanel(@NotNull Notification notification, @NotNull JPanel centerPanel) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/impl/NotificationsManagerImpl", "createActionPanel"));
        }
        if (centerPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "centerPanel", "com/intellij/notification/impl/NotificationsManagerImpl", "createActionPanel"));
        }
        NonOpaquePanel actionPanel = new NonOpaquePanel((LayoutManager)new HorizontalLayout(16, 0));
        centerPanel.add("South", (Component)actionPanel);
        List actions = notification.getActions();
        if (actions.size() > 2) {
            DropDownAction action = new DropDownAction(notification.getDropDownText(), new LinkListener<Void>(){

                public void linkSelected(LinkLabel link, Void ignored) {
                    Container parent = link.getParent();
                    int size = parent.getComponentCount();
                    DefaultActionGroup group = new DefaultActionGroup();
                    for (int i = 1; i < size; ++i) {
                        Component component = parent.getComponent(i);
                        if (component.isVisible()) continue;
                        group.add((AnAction)((LinkLabel)component).getLinkData());
                    }
                    ActionPopupMenu menu = ActionManager.getInstance().createActionPopupMenu("unknown", (ActionGroup)group);
                    menu.getComponent().show((Component)link, -10, link.getHeight() + 2);
                }
            });
            action.setVisible(false);
            actionPanel.add((Component)((Object)action));
        }
        for (AnAction action : actions) {
            Presentation presentation = action.getTemplatePresentation();
            actionPanel.add("LEFT", (Component)new LinkLabel(presentation.getText(), presentation.getIcon(), (LinkListener)new LinkListener<AnAction>(){

                public void linkSelected(LinkLabel aSource, AnAction action) {
                    Notification.fire((AnAction)action);
                }
            }, (Object)action));
        }
    }

    private static int calculateContentHeight(int lines) {
        JEditorPane text = new JEditorPane();
        text.setEditorKit(UIUtil.getHTMLEditorKit());
        text.setText(NotificationsUtil.buildHtml(null, null, "Content" + StringUtil.repeat((String)"<br>\nContent", (int)(lines - 1)), null));
        text.setEditable(false);
        text.setOpaque(false);
        text.setBorder(null);
        return text.getPreferredSize().height;
    }

    private static boolean isDummyEnvironment() {
        Application application = ApplicationManager.getApplication();
        return application.isUnitTestMode() || application.isCommandLine();
    }

    @Nullable
    private static Point getCollapsedTextEndLocation(@NotNull JEditorPane text, @NotNull BalloonLayoutData layoutData) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/notification/impl/NotificationsManagerImpl", "getCollapsedTextEndLocation"));
        }
        if (layoutData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layoutData", "com/intellij/notification/impl/NotificationsManagerImpl", "getCollapsedTextEndLocation"));
        }
        try {
            int end = text.viewToModel(new Point(10, layoutData.twoLineHeight + 5));
            if (end == -1) {
                end = text.getDocument().getLength();
            }
            for (int i = end - 1; i >= 0; --i) {
                Rectangle r = text.modelToView(i);
                if (r == null || r.y >= layoutData.twoLineHeight) continue;
                return r.getLocation();
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return null;
    }

    private static int getFirstLineHeight(@NotNull JEditorPane text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/notification/impl/NotificationsManagerImpl", "getFirstLineHeight"));
        }
        try {
            int end = text.getDocument().getLength();
            for (int i = 0; i < end; ++i) {
                Rectangle r = text.modelToView(i);
                if (r == null || r.height <= 0) continue;
                return r.height;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return 16;
    }

    private static class CenteredLayoutWithActions
    extends BorderLayout {
        private final int myVerticalGap;
        private final JEditorPane myText;
        private final BalloonLayoutData myLayoutData;
        private Component myTitleComponent;
        private Component myCenteredComponent;
        private JPanel myActionPanel;
        private Component myExpandAction;

        public CenteredLayoutWithActions(int verticalGap, JEditorPane text, BalloonLayoutData layoutData) {
            this.myVerticalGap = verticalGap;
            this.myText = text;
            this.myLayoutData = layoutData;
        }

        @Nullable
        public Component getTitle() {
            if (this.myTitleComponent != null) {
                return this.myTitleComponent;
            }
            if (this.myCenteredComponent instanceof JScrollPane) {
                return ((JScrollPane)this.myCenteredComponent).getViewport().getView();
            }
            return null;
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
            if ("North".equals(constraints)) {
                this.myTitleComponent = comp;
            } else if ("Center".equals(constraints)) {
                this.myCenteredComponent = comp;
            } else if ("South".equals(constraints)) {
                this.myActionPanel = (JPanel)comp;
            } else if ("East".equals(constraints)) {
                this.myExpandAction = comp;
            }
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            this.addLayoutComponent(comp, name);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.layoutSize(parent, new Function<Component, Dimension>(){

                public Dimension fun(Component component) {
                    return component.getPreferredSize();
                }
            });
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.layoutSize(parent, new Function<Component, Dimension>(){

                public Dimension fun(Component component) {
                    return component.getMinimumSize();
                }
            });
        }

        private Dimension layoutSize(@NotNull Container parent, @NotNull Function<Component, Dimension> size) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/notification/impl/NotificationsManagerImpl$CenteredLayoutWithActions", "layoutSize"));
            }
            if (size == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "size", "com/intellij/notification/impl/NotificationsManagerImpl$CenteredLayoutWithActions", "layoutSize"));
            }
            Dimension titleSize = this.myTitleComponent == null ? new Dimension() : (Dimension)size.fun((Object)this.myTitleComponent);
            Dimension centeredSize = this.myCenteredComponent == null ? new Dimension() : (Dimension)size.fun((Object)this.myCenteredComponent);
            int height = titleSize.height;
            if (height > 0 && centeredSize.height > 0) {
                height += this.myVerticalGap;
            }
            Dimension actionSize = this.myActionPanel == null ? new Dimension() : (Dimension)size.fun((Object)this.myActionPanel);
            int expandHeight = this.myExpandAction == null || this.myLayoutData.showMinSize ? 0 : ((Dimension)size.fun((Object)this.myExpandAction)).height;
            int bottomHeight = Math.max(actionSize.height, expandHeight);
            if ((height += centeredSize.height) > 0 && bottomHeight > 0) {
                height += this.myVerticalGap;
            }
            height += bottomHeight;
            int width = centeredSize.width;
            if (width < titleSize.width || width < actionSize.width) {
                width = Math.min(JBUI.scale((int)350), Math.max(titleSize.width, actionSize.width));
            }
            Dimension result = new Dimension(Math.max(width, JBUI.scale((int)100)), height);
            JBInsets.addTo((Dimension)result, (Insets)parent.getInsets());
            return result;
        }

        @Override
        public void layoutContainer(Container parent) {
            Dimension centeredSize;
            Insets insets = parent.getInsets();
            int top = insets.top;
            int height = parent.getHeight() - insets.bottom - top;
            int left = insets.left;
            int width = parent.getWidth() - insets.right - left;
            Dimension dimension = centeredSize = this.myCenteredComponent == null ? new Dimension() : this.myCenteredComponent.getPreferredSize();
            if (this.myTitleComponent != null) {
                int titleHeight = this.myTitleComponent.getPreferredSize().height;
                this.myTitleComponent.setBounds(left, top, width - NotificationBalloonActionProvider.getCloseOffset(), titleHeight);
                top += titleHeight + this.myVerticalGap;
                height -= titleHeight + this.myVerticalGap;
            }
            if (this.myCenteredComponent != null) {
                this.myCenteredComponent.setBounds(left, top, width, centeredSize.height);
            }
            int bottomY = top + centeredSize.height;
            int bottomHeight = height - centeredSize.height;
            if (centeredSize.height > 0) {
                bottomY += this.myVerticalGap;
                bottomHeight -= this.myVerticalGap;
            }
            if (this.myExpandAction != null) {
                Dimension size = this.myExpandAction.getPreferredSize();
                if (this.myLayoutData.showMinSize) {
                    Point location = NotificationsManagerImpl.getCollapsedTextEndLocation(this.myText, this.myLayoutData);
                    if (location != null) {
                        int y = SwingUtilities.convertPoint((Component)this.myText, (int)location.x, (int)location.y, (Component)parent).y;
                        this.myExpandAction.setBounds(width - size.width, y, size.width, size.height);
                    }
                } else {
                    this.myExpandAction.setBounds(width - size.width, bottomY, size.width, size.height);
                }
            }
            if (this.myActionPanel != null) {
                int expandWidth = this.myExpandAction == null || this.myLayoutData.showMinSize ? 0 : this.myExpandAction.getPreferredSize().width + 16;
                width -= expandWidth;
                int components = this.myActionPanel.getComponentCount();
                if (components > 2) {
                    Component component;
                    int i;
                    this.myActionPanel.getComponent(0).setVisible(false);
                    for (i = 1; i < components && !(component = this.myActionPanel.getComponent(i)).isVisible(); ++i) {
                        component.setVisible(true);
                    }
                    this.myActionPanel.doLayout();
                    if (this.myActionPanel.getPreferredSize().width > width) {
                        this.myActionPanel.getComponent(0).setVisible(true);
                        this.myActionPanel.getComponent(1).setVisible(false);
                        this.myActionPanel.getComponent(2).setVisible(false);
                        this.myActionPanel.doLayout();
                        for (i = 3; i < components - 1 && this.myActionPanel.getPreferredSize().width > width; ++i) {
                            this.myActionPanel.getComponent(i).setVisible(false);
                            this.myActionPanel.doLayout();
                        }
                    }
                }
                this.myActionPanel.setBounds(left, bottomY, width, bottomHeight);
            }
        }
    }

    private static class MyNotificationListener
    extends NotificationsAdapter {
        private final Project myProject;

        private MyNotificationListener(@Nullable Project project2) {
            this.myProject = project2;
        }

        public void notify(@NotNull Notification notification) {
            if (notification == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/impl/NotificationsManagerImpl$MyNotificationListener", "notify"));
            }
            NotificationsManagerImpl.doNotify(notification, null, this.myProject);
        }
    }

    private static class DropDownAction
    extends LinkLabel<Void> {
        public DropDownAction(String text, @Nullable LinkListener<Void> listener) {
            super(text, null, listener);
            this.setHorizontalTextPosition(10);
            this.setIconTextGap(0);
            this.setIcon(new Icon(){

                @Override
                public void paintIcon(Component c, Graphics g, int x, int y) {
                    Icon icon = AllIcons.Ide.Notification.DropTriangle;
                    int lineY = DropDownAction.this.getUI().getBaseline((JComponent)((Object)DropDownAction.this), DropDownAction.this.getWidth(), DropDownAction.this.getHeight()) - icon.getIconHeight();
                    IconUtil.colorize((Icon)icon, (Color)DropDownAction.this.getTextColor()).paintIcon(c, g, x - 1, lineY);
                }

                @Override
                public int getIconWidth() {
                    return 16;
                }

                @Override
                public int getIconHeight() {
                    return 16;
                }
            });
        }

        @NotNull
        protected Rectangle getTextBounds() {
            Rectangle bounds = super.getTextBounds();
            bounds.x -= this.getIcon().getIconWidth();
            bounds.width += 8;
            Rectangle rectangle = bounds;
            if (rectangle == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/impl/NotificationsManagerImpl$DropDownAction", "getTextBounds"));
            }
            return rectangle;
        }
    }

    public static class ProjectNotificationsComponent {
        public ProjectNotificationsComponent(@NotNull Project project2) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/notification/impl/NotificationsManagerImpl$ProjectNotificationsComponent", "<init>"));
            }
            if (NotificationsManagerImpl.isDummyEnvironment()) {
                return;
            }
            project2.getMessageBus().connect().subscribe(Notifications.TOPIC, (Object)new MyNotificationListener(project2));
        }
    }
}

