/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.impl.CannotUndoReportDialog;
import com.intellij.openapi.command.impl.DocumentReferenceByDocument;
import com.intellij.openapi.command.impl.EditorAndState;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.impl.UndoRedoStacksHolder;
import com.intellij.openapi.command.impl.UndoableGroup;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.swing.Icon;

abstract class UndoRedo {
    protected final UndoManagerImpl myManager;
    protected final FileEditor myEditor;
    protected final UndoableGroup myUndoableGroup;

    protected UndoRedo(UndoManagerImpl manager, FileEditor editor) {
        this.myManager = manager;
        this.myEditor = editor;
        this.myUndoableGroup = this.getLastAction();
    }

    private UndoableGroup getLastAction() {
        return this.getStackHolder().getLastAction(this.getDecRefs());
    }

    boolean isTransparent() {
        return this.myUndoableGroup.isTransparent();
    }

    boolean hasMoreActions() {
        return this.getStackHolder().canBeUndoneOrRedone(this.getDecRefs());
    }

    private Set<DocumentReference> getDecRefs() {
        return this.myEditor == null ? Collections.emptySet() : UndoManagerImpl.getDocumentReferences(this.myEditor);
    }

    protected abstract UndoRedoStacksHolder getStackHolder();

    protected abstract UndoRedoStacksHolder getReverseStackHolder();

    protected abstract String getActionName();

    protected abstract String getActionName(String var1);

    protected abstract EditorAndState getBeforeState();

    protected abstract EditorAndState getAfterState();

    protected abstract void performAction();

    protected abstract void setBeforeState(EditorAndState var1);

    public boolean execute(boolean drop, boolean isInsideStartFinishGroup) {
        Collection<Document> readOnlyDocuments;
        Collection<VirtualFile> readOnlyFiles;
        if (!this.myUndoableGroup.isUndoable()) {
            this.reportCannotUndo(CommonBundle.message((String)"cannot.undo.error.contains.nonundoable.changes.message", (Object[])new Object[0]), this.myUndoableGroup.getAffectedDocuments());
            return false;
        }
        Set<DocumentReference> clashing = this.getStackHolder().collectClashingActions(this.myUndoableGroup);
        if (!clashing.isEmpty()) {
            this.reportCannotUndo(CommonBundle.message((String)"cannot.undo.error.other.affected.files.changed.message", (Object[])new Object[0]), clashing);
            return false;
        }
        if (!isInsideStartFinishGroup && this.myUndoableGroup.shouldAskConfirmation(this.isRedo())) {
            if (!this.askUser()) {
                return false;
            }
        } else if (this.restore(this.getBeforeState())) {
            this.setBeforeState(new EditorAndState(this.myEditor, this.myEditor.getState(FileEditorStateLevel.UNDO)));
            return true;
        }
        if (!(readOnlyFiles = this.collectReadOnlyAffectedFiles()).isEmpty()) {
            Project project2 = this.myManager.getProject();
            VirtualFile[] files = VfsUtil.toVirtualFileArray(readOnlyFiles);
            if (project2 == null) {
                return false;
            }
            ReadonlyStatusHandler.OperationStatus operationStatus = ReadonlyStatusHandler.getInstance((Project)project2).ensureFilesWritable(files);
            if (operationStatus.hasReadonlyFiles()) {
                return false;
            }
        }
        if (!(readOnlyDocuments = this.collectReadOnlyDocuments()).isEmpty()) {
            for (Document document : readOnlyDocuments) {
                document.fireReadOnlyModificationAttempt();
            }
            return false;
        }
        this.getStackHolder().removeFromStacks(this.myUndoableGroup);
        if (!drop) {
            this.getReverseStackHolder().addToStacks(this.myUndoableGroup);
        }
        this.performAction();
        this.restore(this.getAfterState());
        return true;
    }

    protected abstract boolean isRedo();

    private Collection<Document> collectReadOnlyDocuments() {
        Collection<DocumentReference> affectedDocument = this.myUndoableGroup.getAffectedDocuments();
        ArrayList<Document> readOnlyDocs = new ArrayList<Document>();
        for (DocumentReference ref : affectedDocument) {
            Document doc;
            if (!(ref instanceof DocumentReferenceByDocument) || (doc = ref.getDocument()) == null || doc.isWritable()) continue;
            readOnlyDocs.add(doc);
        }
        return readOnlyDocs;
    }

    private Collection<VirtualFile> collectReadOnlyAffectedFiles() {
        Collection<DocumentReference> affectedDocument = this.myUndoableGroup.getAffectedDocuments();
        ArrayList<VirtualFile> readOnlyFiles = new ArrayList<VirtualFile>();
        for (DocumentReference documentReference : affectedDocument) {
            VirtualFile file2 = documentReference.getFile();
            if (file2 == null || !file2.isValid() || file2.isWritable()) continue;
            readOnlyFiles.add(file2);
        }
        return readOnlyFiles;
    }

    private void reportCannotUndo(String message, Collection<DocumentReference> problemFiles) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw new RuntimeException(message + "\n" + StringUtil.join(problemFiles, (Function)StringUtil.createToStringFunction(DocumentReference.class), (String)"\n"));
        }
        new CannotUndoReportDialog(this.myManager.getProject(), message, problemFiles).show();
    }

    private boolean askUser() {
        String actionText = this.getActionName(this.myUndoableGroup.getCommandName());
        if (actionText.length() > 80) {
            actionText = actionText.substring(0, 80) + "... ";
        }
        return Messages.showOkCancelDialog((Project)this.myManager.getProject(), (String)(actionText + "?"), (String)this.getActionName(), (Icon)Messages.getQuestionIcon()) == 0;
    }

    private boolean restore(EditorAndState pair) {
        if (this.myEditor == null || pair == null || pair.getEditor() == null) {
            return false;
        }
        if (!this.myEditor.getClass().equals(pair.getEditor().getClass())) {
            return false;
        }
        FileEditorState currentState = this.myEditor.getState(FileEditorStateLevel.UNDO);
        if (currentState.equals(pair.getState())) {
            return false;
        }
        this.myEditor.setState(pair.getState());
        return true;
    }
}

