/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.settings;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.EditorSchemeAttributeDescriptor;
import com.intellij.application.options.colors.FontOptions;
import com.intellij.application.options.colors.OptionsPanel;
import com.intellij.diff.util.TextDiffTypeFactory;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColorPanel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffOptionsPanel
implements OptionsPanel {
    @NotNull
    private final ColorAndFontOptions myOptions;
    private final EventDispatcher<ColorAndFontSettingsListener> myDispatcher;
    private ColorPanel myBackgroundColorPanel;
    private ColorPanel myIgnoredColorPanel;
    private ColorPanel myStripeMarkColorPanel;
    private JBCheckBox myInheritIgnoredCheckBox;
    private JList myOptionsList;
    private JPanel myWholePanel;
    private final CollectionListModel<MyDescription> myOptionsModel;

    public DiffOptionsPanel(@NotNull ColorAndFontOptions options) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/openapi/diff/impl/settings/DiffOptionsPanel", "<init>"));
        }
        this.$$$setupUI$$$();
        this.myDispatcher = EventDispatcher.create(ColorAndFontSettingsListener.class);
        this.myOptionsModel = new CollectionListModel((Object[])new MyDescription[0]);
        this.myOptions = options;
        this.myOptionsList.setCellRenderer(new MyCellRenderer());
        this.myOptionsList.setModel(this.myOptionsModel);
        ListSelectionModel selectionModel = this.myOptionsList.getSelectionModel();
        selectionModel.setSelectionMode(0);
        selectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                MyDescription description = DiffOptionsPanel.this.getSelectedDescription();
                if (description == null) {
                    DiffOptionsPanel.this.myBackgroundColorPanel.setEnabled(false);
                    DiffOptionsPanel.this.myIgnoredColorPanel.setEnabled(false);
                    DiffOptionsPanel.this.myStripeMarkColorPanel.setEnabled(false);
                    DiffOptionsPanel.this.myInheritIgnoredCheckBox.setEnabled(false);
                } else {
                    DiffOptionsPanel.this.myBackgroundColorPanel.setEnabled(true);
                    DiffOptionsPanel.this.myIgnoredColorPanel.setEnabled(!description.isInheritIgnoredColor());
                    DiffOptionsPanel.this.myStripeMarkColorPanel.setEnabled(true);
                    DiffOptionsPanel.this.myInheritIgnoredCheckBox.setEnabled(true);
                    DiffOptionsPanel.this.myBackgroundColorPanel.setSelectedColor(description.getBackgroundColor());
                    DiffOptionsPanel.this.myIgnoredColorPanel.setSelectedColor(description.getIgnoredColor());
                    DiffOptionsPanel.this.myStripeMarkColorPanel.setSelectedColor(description.getStripeMarkColor());
                    DiffOptionsPanel.this.myInheritIgnoredCheckBox.setSelected(description.isInheritIgnoredColor());
                }
                ((ColorAndFontSettingsListener)DiffOptionsPanel.this.myDispatcher.getMulticaster()).selectedOptionChanged(description);
            }
        });
        this.myBackgroundColorPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyDescription selectedDescription = DiffOptionsPanel.this.getSelectedDescription();
                if (selectedDescription == null) {
                    return;
                }
                if (!DiffOptionsPanel.this.checkModifiableScheme()) {
                    DiffOptionsPanel.this.myBackgroundColorPanel.setSelectedColor(selectedDescription.getBackgroundColor());
                } else {
                    selectedDescription.setBackgroundColor(DiffOptionsPanel.this.myBackgroundColorPanel.getSelectedColor());
                    ((ColorAndFontSettingsListener)DiffOptionsPanel.this.myDispatcher.getMulticaster()).settingsChanged();
                }
            }
        });
        this.myIgnoredColorPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyDescription selectedDescription = DiffOptionsPanel.this.getSelectedDescription();
                if (selectedDescription == null) {
                    return;
                }
                if (!DiffOptionsPanel.this.checkModifiableScheme()) {
                    DiffOptionsPanel.this.myIgnoredColorPanel.setSelectedColor(selectedDescription.getIgnoredColor());
                } else {
                    selectedDescription.setIgnoredColor(DiffOptionsPanel.this.myIgnoredColorPanel.getSelectedColor());
                    ((ColorAndFontSettingsListener)DiffOptionsPanel.this.myDispatcher.getMulticaster()).settingsChanged();
                }
            }
        });
        this.myStripeMarkColorPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyDescription selectedDescription = DiffOptionsPanel.this.getSelectedDescription();
                if (selectedDescription == null) {
                    return;
                }
                if (!DiffOptionsPanel.this.checkModifiableScheme()) {
                    DiffOptionsPanel.this.myStripeMarkColorPanel.setSelectedColor(selectedDescription.getStripeMarkColor());
                } else {
                    selectedDescription.setStripeMarkColor(DiffOptionsPanel.this.myStripeMarkColorPanel.getSelectedColor());
                    ((ColorAndFontSettingsListener)DiffOptionsPanel.this.myDispatcher.getMulticaster()).settingsChanged();
                }
            }
        });
        this.myInheritIgnoredCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyDescription selectedDescription = DiffOptionsPanel.this.getSelectedDescription();
                if (selectedDescription == null) {
                    return;
                }
                if (!DiffOptionsPanel.this.checkModifiableScheme()) {
                    DiffOptionsPanel.this.myInheritIgnoredCheckBox.setSelected(selectedDescription.isInheritIgnoredColor());
                } else {
                    selectedDescription.setInheritIgnoredColor(DiffOptionsPanel.this.myInheritIgnoredCheckBox.isSelected());
                    DiffOptionsPanel.this.myIgnoredColorPanel.setEnabled(!DiffOptionsPanel.this.myInheritIgnoredCheckBox.isSelected());
                    DiffOptionsPanel.this.myIgnoredColorPanel.setSelectedColor(selectedDescription.myIgnoredColor);
                    ((ColorAndFontSettingsListener)DiffOptionsPanel.this.myDispatcher.getMulticaster()).settingsChanged();
                }
            }
        });
    }

    @Override
    public void addListener(ColorAndFontSettingsListener listener) {
        this.myDispatcher.addListener((EventListener)listener);
    }

    @Override
    public JPanel getPanel() {
        return this.myWholePanel;
    }

    @Override
    public void updateOptionsList() {
        this.myOptionsModel.removeAll();
        for (int i = 0; i < this.myOptions.getCurrentDescriptions().length; ++i) {
            EditorSchemeAttributeDescriptor description = this.myOptions.getCurrentDescriptions()[i];
            if (!ColorAndFontOptions.DIFF_GROUP.equals(description.getGroup()) || !(description instanceof MyDescription)) continue;
            this.myOptionsModel.add((Object)((MyDescription)description));
        }
        ScrollingUtil.ensureSelectionExists((JList)this.myOptionsList);
    }

    @Override
    public Runnable showOption(String option) {
        for (int i = 0; i < this.myOptionsModel.getSize(); ++i) {
            MyDescription description = (MyDescription)this.myOptionsModel.getElementAt(i);
            if (!StringUtil.containsIgnoreCase((String)description.getDisplayName(), (String)option)) continue;
            final int index = i;
            return new Runnable(){

                @Override
                public void run() {
                    ScrollingUtil.selectItem((JList)DiffOptionsPanel.this.myOptionsList, (int)index);
                }
            };
        }
        return null;
    }

    @Override
    public Set<String> processListOptions() {
        HashSet result = ContainerUtil.newHashSet();
        for (int i = 0; i < this.myOptions.getCurrentDescriptions().length; ++i) {
            EditorSchemeAttributeDescriptor description = this.myOptions.getCurrentDescriptions()[i];
            if (!ColorAndFontOptions.DIFF_GROUP.equals(description.getGroup()) || !(description instanceof MyDescription)) continue;
            result.add(((MyDescription)description).getDisplayName());
        }
        return result;
    }

    @Override
    public void applyChangesToScheme() {
        MyDescription description = this.getSelectedDescription();
        if (description != null) {
            description.apply(this.myOptions.getSelectedScheme());
        }
    }

    @Override
    public void selectOption(String typeToSelect) {
        for (int i = 0; i < this.myOptionsModel.getItems().size(); ++i) {
            MyDescription description = (MyDescription)this.myOptionsModel.getElementAt(i);
            if (!typeToSelect.equals(description.getDisplayName())) continue;
            ScrollingUtil.selectItem((JList)this.myOptionsList, (int)i);
            return;
        }
    }

    private boolean checkModifiableScheme() {
        boolean isReadOnly = this.myOptions.currentSchemeIsReadOnly();
        if (isReadOnly) {
            FontOptions.showReadOnlyMessage(this.myWholePanel, this.myOptions.currentSchemeIsShared());
        }
        return !isReadOnly;
    }

    @Nullable
    private MyDescription getSelectedDescription() {
        return (MyDescription)this.myOptionsList.getSelectedValue();
    }

    public static void addSchemeDescriptions(@NotNull List<EditorSchemeAttributeDescriptor> descriptions, @NotNull EditorColorsScheme scheme) {
        if (descriptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptions", "com/intellij/openapi/diff/impl/settings/DiffOptionsPanel", "addSchemeDescriptions"));
        }
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/diff/impl/settings/DiffOptionsPanel", "addSchemeDescriptions"));
        }
        for (TextDiffTypeFactory.TextDiffTypeImpl diffType : TextDiffTypeFactory.getInstance().getAllDiffTypes()) {
            descriptions.add(new MyDescription(diffType, scheme));
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        ColorPanel colorPanel;
        ColorPanel colorPanel2;
        ColorPanel colorPanel3;
        JPanel jPanel;
        this.myWholePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        JBList jBList = new JBList();
        this.myOptionsList = jBList;
        jBScrollPane.setViewportView((Component)jBList);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 9, 1, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/DiffBundle").getString("merge.color.options.background.color.label"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myBackgroundColorPanel = colorPanel3 = new ColorPanel();
        jPanel3.add((Component)colorPanel3, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.color.error.stripe.mark"));
        jPanel3.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myStripeMarkColorPanel = colorPanel2 = new ColorPanel();
        jPanel3.add((Component)colorPanel2, new GridConstraints(2, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/DiffBundle").getString("merge.color.options.ignored.color.label"));
        jPanel3.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myIgnoredColorPanel = colorPanel = new ColorPanel();
        jPanel3.add((Component)colorPanel, new GridConstraints(1, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        this.myInheritIgnoredCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Inherit ignored color");
        jPanel3.add((Component)jBCheckBox, new GridConstraints(3, 0, 1, 2, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static class MyDescription
    implements EditorSchemeAttributeDescriptor {
        private final EditorColorsScheme myScheme;
        private final TextDiffTypeFactory.TextDiffTypeImpl myDiffType;
        private final Color myOriginalBackground;
        private final Color myOriginalIgnored;
        private final Color myOriginalStripe;
        private Color myBackgroundColor;
        private Color myIgnoredColor;
        private Color myStripeColor;

        public MyDescription(@NotNull TextDiffTypeFactory.TextDiffTypeImpl diffType, @NotNull EditorColorsScheme scheme) {
            if (diffType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffType", "com/intellij/openapi/diff/impl/settings/DiffOptionsPanel$MyDescription", "<init>"));
            }
            if (scheme == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/diff/impl/settings/DiffOptionsPanel$MyDescription", "<init>"));
            }
            this.myScheme = scheme;
            this.myDiffType = diffType;
            TextAttributes textAttributes = this.getAttributes();
            this.myBackgroundColor = textAttributes.getBackgroundColor();
            this.myIgnoredColor = textAttributes.getForegroundColor();
            this.myStripeColor = textAttributes.getErrorStripeColor();
            this.myOriginalBackground = this.myBackgroundColor;
            this.myOriginalIgnored = this.myIgnoredColor;
            this.myOriginalStripe = this.myStripeColor;
        }

        @NotNull
        public String getDisplayName() {
            String string = this.myDiffType.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/settings/DiffOptionsPanel$MyDescription", "getDisplayName"));
            }
            return string;
        }

        @NotNull
        public TextAttributes getAttributes() {
            TextAttributes textAttributes = this.myScheme.getAttributes(this.myDiffType.getKey());
            if (textAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/settings/DiffOptionsPanel$MyDescription", "getAttributes"));
            }
            return textAttributes;
        }

        @Override
        public void apply(EditorColorsScheme scheme) {
            TextAttributesKey key = this.myDiffType.getKey();
            TextAttributes attrs = new TextAttributes();
            attrs.setBackgroundColor(this.myBackgroundColor);
            attrs.setForegroundColor(this.myIgnoredColor);
            attrs.setErrorStripeColor(this.myStripeColor);
            scheme.setAttributes(key, attrs);
        }

        @Override
        public String getGroup() {
            return ColorAndFontOptions.DIFF_GROUP;
        }

        @Override
        public EditorColorsScheme getScheme() {
            return this.myScheme;
        }

        @Override
        public String getType() {
            return this.myDiffType.getKey().getExternalName();
        }

        @Override
        public boolean isModified() {
            TextAttributes textAttributes = this.getAttributes();
            return !Comparing.equal((Object)this.myOriginalBackground, (Object)textAttributes.getBackgroundColor()) || !Comparing.equal((Object)this.myOriginalIgnored, (Object)textAttributes.getForegroundColor()) || !Comparing.equal((Object)this.myOriginalStripe, (Object)textAttributes.getErrorStripeColor());
        }

        public void setBackgroundColor(Color selectedColor) {
            this.myBackgroundColor = selectedColor;
        }

        public Color getBackgroundColor() {
            return this.myBackgroundColor;
        }

        public void setIgnoredColor(Color selectedColor) {
            this.myIgnoredColor = selectedColor;
        }

        public Color getIgnoredColor() {
            return this.myIgnoredColor;
        }

        public void setStripeMarkColor(Color selectedColor) {
            this.myStripeColor = selectedColor;
        }

        public Color getStripeMarkColor() {
            return this.myStripeColor;
        }

        public boolean isInheritIgnoredColor() {
            return this.myIgnoredColor == null;
        }

        public void setInheritIgnoredColor(boolean value) {
            this.myIgnoredColor = value ? null : TextDiffTypeFactory.getMiddleColor(this.myBackgroundColor, this.myScheme.getDefaultBackground());
        }
    }

    private static class MyCellRenderer
    extends ColoredListCellRenderer {
        private MyCellRenderer() {
        }

        protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            MyDescription description = (MyDescription)value;
            this.append(description.getDisplayName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }
}

