/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorLinePainter;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.LineExtensionInfo;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.ClipDetector;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.impl.ImmediatePainter;
import com.intellij.openapi.editor.impl.SoftWrapModelImpl;
import com.intellij.openapi.editor.impl.TextDrawingCallback;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapDrawingType;
import com.intellij.openapi.editor.impl.view.EditorSizeManager;
import com.intellij.openapi.editor.impl.view.EditorView;
import com.intellij.openapi.editor.impl.view.IterationState;
import com.intellij.openapi.editor.impl.view.LineLayout;
import com.intellij.openapi.editor.impl.view.VisualLineFragmentsIterator;
import com.intellij.openapi.editor.impl.view.VisualLinesIterator;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.LineSeparatorRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.IdeBackgroundUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.Processor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TFloatArrayList;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class EditorPainter
implements TextDrawingCallback {
    private static final Color CARET_LIGHT = Gray._255;
    private static final Color CARET_DARK = Gray._0;
    private static final Stroke IME_COMPOSED_TEXT_UNDERLINE_STROKE = new BasicStroke(1.0f, 1, 1, 0.0f, new float[]{0.0f, 2.0f, 0.0f, 2.0f}, 0.0f);
    private static final int CARET_DIRECTION_MARK_SIZE = 5;
    private final EditorView myView;
    private final EditorImpl myEditor;
    private final Document myDocument;

    EditorPainter(EditorView view) {
        this.myView = view;
        this.myEditor = view.getEditor();
        this.myDocument = this.myEditor.getDocument();
    }

    void paint(Graphics2D g) {
        Rectangle clip = g.getClipBounds();
        if (this.myEditor.getContentComponent().isOpaque()) {
            g.setColor(this.myEditor.getBackgroundColor());
            g.fillRect(clip.x, clip.y, clip.width, clip.height);
        }
        if (this.paintPlaceholderText(g)) {
            this.paintCaret(g);
            return;
        }
        int startLine = this.myView.yToVisualLine(Math.max(clip.y, 0));
        int endLine = this.myView.yToVisualLine(Math.max(clip.y + clip.height, 0));
        int startOffset = this.myView.visualLineToOffset(startLine);
        int endOffset = this.myView.visualLineToOffset(endLine + 1);
        ClipDetector clipDetector = new ClipDetector(this.myEditor, clip);
        this.paintBackground(g, clip, startLine, endLine);
        this.paintRightMargin(g, clip);
        this.paintCustomRenderers(g, startOffset, endOffset);
        MarkupModelEx docMarkup = (MarkupModelEx)DocumentMarkupModel.forDocument(this.myDocument, this.myEditor.getProject(), true);
        this.paintLineMarkersSeparators(g, clip, docMarkup, startOffset, endOffset);
        this.paintLineMarkersSeparators(g, clip, this.myEditor.getMarkupModel(), startOffset, endOffset);
        this.paintTextWithEffects(g, clip, startLine, endLine);
        this.paintHighlightersAfterEndOfLine(g, docMarkup, startOffset, endOffset);
        this.paintHighlightersAfterEndOfLine(g, this.myEditor.getMarkupModel(), startOffset, endOffset);
        this.paintBorderEffect(g, clipDetector, this.myEditor.getHighlighter(), startOffset, endOffset);
        this.paintBorderEffect(g, clipDetector, docMarkup, startOffset, endOffset);
        this.paintBorderEffect(g, clipDetector, this.myEditor.getMarkupModel(), startOffset, endOffset);
        this.paintCaret(g);
        this.paintComposedTextDecoration(g);
    }

    private boolean paintPlaceholderText(Graphics2D g) {
        CharSequence hintText = this.myEditor.getPlaceholder();
        EditorComponentImpl editorComponent = this.myEditor.getContentComponent();
        if (this.myDocument.getTextLength() > 0 || hintText == null || hintText.length() == 0 || KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() == editorComponent && !this.myEditor.getShowPlaceholderWhenFocused()) {
            return false;
        }
        hintText = SwingUtilities.layoutCompoundLabel(g.getFontMetrics(), hintText.toString(), null, 0, 0, 0, 0, editorComponent.getBounds(), new Rectangle(), new Rectangle(), 0);
        g.setColor(this.myEditor.getFoldingModel().getPlaceholderAttributes().getForegroundColor());
        g.setFont(this.myEditor.getColorsScheme().getFont(EditorFontType.PLAIN));
        g.drawString(hintText.toString(), 0, this.myView.getAscent());
        return true;
    }

    private void paintRightMargin(Graphics g, Rectangle clip) {
        EditorSettings settings = this.myEditor.getSettings();
        Color rightMargin = this.myEditor.getColorsScheme().getColor(EditorColors.RIGHT_MARGIN_COLOR);
        if (!settings.isRightMarginShown() || rightMargin == null) {
            return;
        }
        int x = settings.getRightMargin(this.myEditor.getProject()) * this.myView.getPlainSpaceWidth();
        g.setColor(rightMargin);
        UIUtil.drawLine((Graphics)g, (int)x, (int)clip.y, (int)x, (int)(clip.y + clip.height));
    }

    private void paintBackground(Graphics2D g, Rectangle clip, int startVisualLine, int endVisualLine) {
        int visualLine;
        int lineCount = this.myEditor.getVisibleLineCount();
        final Map<Integer, Couple<Integer>> virtualSelectionMap = this.createVirtualSelectionMap(startVisualLine, endVisualLine);
        final VisualPosition primarySelectionStart = this.myEditor.getSelectionModel().getSelectionStartPosition();
        final VisualPosition primarySelectionEnd = this.myEditor.getSelectionModel().getSelectionEndPosition();
        LineLayout prefixLayout = this.myView.getPrefixLayout();
        if (startVisualLine == 0 && prefixLayout != null) {
            this.paintBackground(g, this.myView.getPrefixAttributes(), 0.0f, 0, prefixLayout.getWidth());
        }
        VisualLinesIterator visLinesIterator = new VisualLinesIterator(this.myView, startVisualLine);
        while (!visLinesIterator.atEnd() && (visualLine = visLinesIterator.getVisualLine()) <= endVisualLine && visualLine < lineCount) {
            int y = this.myView.visualLineToY(visualLine);
            this.paintLineFragments(g, clip, visLinesIterator, y, new LineFragmentPainter(){

                @Override
                public void paintBeforeLineStart(Graphics2D g, TextAttributes attributes, int columnEnd, float xEnd, int y) {
                    EditorPainter.this.paintBackground(g, attributes, 0.0f, y, xEnd);
                    EditorPainter.this.paintSelectionOnSecondSoftWrapLineIfNecessary(g, columnEnd, xEnd, y, primarySelectionStart, primarySelectionEnd);
                }

                @Override
                public void paint(Graphics2D g, VisualLineFragmentsIterator.Fragment fragment, int start, int end, TextAttributes attributes, float xStart, float xEnd, int y) {
                    EditorPainter.this.paintBackground(g, attributes, xStart, y, xEnd - xStart);
                }

                @Override
                public void paintAfterLineEnd(Graphics2D g, Rectangle clip, IterationState it, int columnStart, float x, int y) {
                    EditorPainter.this.paintBackground(g, it.getPastLineEndBackgroundAttributes(), x, y, (float)(clip.x + clip.width) - x);
                    int offset = it.getEndOffset();
                    SoftWrap softWrap = EditorPainter.this.myEditor.getSoftWrapModel().getSoftWrap(offset);
                    if (softWrap == null) {
                        EditorPainter.this.paintVirtualSelectionIfNecessary(g, virtualSelectionMap, columnStart, x, clip.x + clip.width, y);
                    } else {
                        EditorPainter.this.paintSelectionOnFirstSoftWrapLineIfNecessary(g, columnStart, x, clip.x + clip.width, y, primarySelectionStart, primarySelectionEnd);
                    }
                }
            });
            visLinesIterator.advance();
        }
    }

    private Map<Integer, Couple<Integer>> createVirtualSelectionMap(int startVisualLine, int endVisualLine) {
        HashMap<Integer, Couple<Integer>> map = new HashMap<Integer, Couple<Integer>>();
        for (Caret caret : this.myEditor.getCaretModel().getAllCarets()) {
            int line;
            if (!caret.hasSelection()) continue;
            VisualPosition selectionStart = caret.getSelectionStartPosition();
            VisualPosition selectionEnd = caret.getSelectionEndPosition();
            if (selectionStart.line != selectionEnd.line || (line = selectionStart.line) < startVisualLine || line > endVisualLine) continue;
            map.put(line, (Couple<Integer>)Couple.of((Object)selectionStart.column, (Object)selectionEnd.column));
        }
        return map;
    }

    private void paintVirtualSelectionIfNecessary(Graphics2D g, Map<Integer, Couple<Integer>> virtualSelectionMap, int columnStart, float xStart, float xEnd, int y) {
        int visualLine = this.myView.yToVisualLine(y);
        Couple<Integer> selectionRange = virtualSelectionMap.get(visualLine);
        if (selectionRange == null || (Integer)selectionRange.second <= columnStart) {
            return;
        }
        float startX = (Integer)selectionRange.first <= columnStart ? xStart : (float)this.myView.visualPositionToXY((VisualPosition)new VisualPosition((int)visualLine, (int)((Integer)selectionRange.first).intValue())).x;
        float endX = Math.min(xEnd, (float)this.myView.visualPositionToXY((VisualPosition)new VisualPosition((int)visualLine, (int)((Integer)selectionRange.second).intValue())).x);
        this.paintBackground(g, this.myEditor.getColorsScheme().getColor(EditorColors.SELECTION_BACKGROUND_COLOR), startX, y, endX - startX);
    }

    private void paintSelectionOnSecondSoftWrapLineIfNecessary(Graphics2D g, int columnEnd, float xEnd, int y, VisualPosition selectionStartPosition, VisualPosition selectionEndPosition) {
        int visualLine = this.myView.yToVisualLine(y);
        if (selectionStartPosition.equals((Object)selectionEndPosition) || visualLine < selectionStartPosition.line || visualLine > selectionEndPosition.line || visualLine == selectionStartPosition.line && selectionStartPosition.column >= columnEnd) {
            return;
        }
        float startX = selectionStartPosition.line == visualLine && selectionStartPosition.column > 0 ? (float)this.myView.visualPositionToXY((VisualPosition)selectionStartPosition).x : 0.0f;
        float endX = selectionEndPosition.line == visualLine && selectionEndPosition.column < columnEnd ? (float)this.myView.visualPositionToXY((VisualPosition)selectionEndPosition).x : xEnd;
        this.paintBackground(g, this.myEditor.getColorsScheme().getColor(EditorColors.SELECTION_BACKGROUND_COLOR), startX, y, endX - startX);
    }

    private void paintSelectionOnFirstSoftWrapLineIfNecessary(Graphics2D g, int columnStart, float xStart, float xEnd, int y, VisualPosition selectionStartPosition, VisualPosition selectionEndPosition) {
        int visualLine = this.myView.yToVisualLine(y);
        if (selectionStartPosition.equals((Object)selectionEndPosition) || visualLine < selectionStartPosition.line || visualLine > selectionEndPosition.line || visualLine == selectionEndPosition.line && selectionEndPosition.column <= columnStart) {
            return;
        }
        float startX = selectionStartPosition.line == visualLine && selectionStartPosition.column > columnStart ? (float)this.myView.visualPositionToXY((VisualPosition)selectionStartPosition).x : xStart;
        float endX = selectionEndPosition.line == visualLine ? (float)this.myView.visualPositionToXY((VisualPosition)selectionEndPosition).x : xEnd;
        this.paintBackground(g, this.myEditor.getColorsScheme().getColor(EditorColors.SELECTION_BACKGROUND_COLOR), startX, y, endX - startX);
    }

    private void paintBackground(Graphics2D g, TextAttributes attributes, float x, int y, float width) {
        if (attributes == null) {
            return;
        }
        this.paintBackground(g, attributes.getBackgroundColor(), x, y, width);
    }

    private void paintBackground(Graphics2D g, Color color, float x, int y, float width) {
        if (width <= 0.0f || color == null || color.equals(this.myEditor.getColorsScheme().getDefaultBackground()) || color.equals(this.myEditor.getBackgroundColor())) {
            return;
        }
        g.setColor(color);
        int xStartRounded = (int)x;
        int xEndRounded = (int)(x + width);
        g.fillRect(xStartRounded, y, xEndRounded - xStartRounded, this.myView.getLineHeight());
    }

    private void paintCustomRenderers(final Graphics2D g, final int startOffset, final int endOffset) {
        this.myEditor.getMarkupModel().processRangeHighlightersOverlappingWith(startOffset, endOffset, (Processor<? super RangeHighlighterEx>)new Processor<RangeHighlighterEx>(){

            public boolean process(RangeHighlighterEx highlighter) {
                CustomHighlighterRenderer customRenderer;
                if (highlighter.getEditorFilter().avaliableIn((Editor)EditorPainter.this.myEditor) && (customRenderer = highlighter.getCustomRenderer()) != null && startOffset < highlighter.getEndOffset() && highlighter.getStartOffset() < endOffset) {
                    customRenderer.paint((Editor)EditorPainter.this.myEditor, (RangeHighlighter)highlighter, (Graphics)g);
                }
                return true;
            }
        });
    }

    private void paintLineMarkersSeparators(final Graphics g, final Rectangle clip, MarkupModelEx markupModel, int startOffset, int endOffset) {
        markupModel.processRangeHighlightersOverlappingWith(startOffset, endOffset, (Processor<? super RangeHighlighterEx>)new Processor<RangeHighlighterEx>(){

            public boolean process(RangeHighlighterEx highlighter) {
                if (highlighter.getEditorFilter().avaliableIn((Editor)EditorPainter.this.myEditor)) {
                    EditorPainter.this.paintLineMarkerSeparator(highlighter, clip, g);
                }
                return true;
            }
        });
    }

    private void paintLineMarkerSeparator(RangeHighlighter marker, Rectangle clip, Graphics g) {
        Color separatorColor = marker.getLineSeparatorColor();
        LineSeparatorRenderer lineSeparatorRenderer = marker.getLineSeparatorRenderer();
        if (separatorColor == null && lineSeparatorRenderer == null) {
            return;
        }
        int line = this.myDocument.getLineNumber(marker.getLineSeparatorPlacement() == SeparatorPlacement.TOP ? marker.getStartOffset() : marker.getEndOffset());
        int visualLine = this.myView.logicalToVisualPosition((LogicalPosition)new LogicalPosition((int)(line + (marker.getLineSeparatorPlacement() == SeparatorPlacement.TOP ? 0 : 1)), (int)0), (boolean)false).line;
        int y = this.myView.visualLineToY(visualLine) - 1;
        int endShift = clip.x + clip.width;
        EditorSettings settings = this.myEditor.getSettings();
        if (settings.isRightMarginShown() && this.myEditor.getColorsScheme().getColor(EditorColors.RIGHT_MARGIN_COLOR) != null) {
            endShift = Math.min(endShift, settings.getRightMargin(this.myEditor.getProject()) * this.myView.getPlainSpaceWidth());
        }
        g.setColor(separatorColor);
        if (lineSeparatorRenderer != null) {
            lineSeparatorRenderer.drawLine(g, 0, endShift, y);
        } else {
            UIUtil.drawLine((Graphics)g, (int)0, (int)y, (int)endShift, (int)y);
        }
    }

    private void paintTextWithEffects(Graphics2D g, Rectangle clip, int startVisualLine, int endVisualLine) {
        int visualLine;
        final CharSequence text = this.myDocument.getImmutableCharSequence();
        final EditorImpl.LineWhitespacePaintingStrategy whitespacePaintingStrategy = this.myEditor.new EditorImpl.LineWhitespacePaintingStrategy();
        boolean paintAllSoftWraps = this.myEditor.getSettings().isAllSoftWrapsShown();
        int lineCount = this.myEditor.getVisibleLineCount();
        final int whiteSpaceStrokeWidth = JBUI.scale((int)1);
        final BasicStroke whiteSpaceStroke = new BasicStroke(whiteSpaceStrokeWidth);
        LineLayout prefixLayout = this.myView.getPrefixLayout();
        if (startVisualLine == 0 && prefixLayout != null) {
            g.setColor(this.myView.getPrefixAttributes().getForegroundColor());
            this.paintLineLayoutWithEffect(g, prefixLayout, 0.0f, this.myView.getAscent(), this.myView.getPrefixAttributes().getEffectColor(), this.myView.getPrefixAttributes().getEffectType());
        }
        VisualLinesIterator visLinesIterator = new VisualLinesIterator(this.myView, startVisualLine);
        while (!visLinesIterator.atEnd() && (visualLine = visLinesIterator.getVisualLine()) <= endVisualLine && visualLine < lineCount) {
            int y = this.myView.visualLineToY(visualLine) + this.myView.getAscent();
            final boolean paintSoftWraps = paintAllSoftWraps || this.myEditor.getCaretModel().getLogicalPosition().line == visLinesIterator.getStartLogicalLine();
            final int[] currentLogicalLine = new int[]{-1};
            this.paintLineFragments(g, clip, visLinesIterator, y, new LineFragmentPainter(){

                @Override
                public void paintBeforeLineStart(Graphics2D g, TextAttributes attributes, int columnEnd, float xEnd, int y) {
                    if (paintSoftWraps) {
                        SoftWrapModelImpl softWrapModel = EditorPainter.this.myEditor.getSoftWrapModel();
                        int symbolWidth = softWrapModel.getMinDrawingWidthInPixels(SoftWrapDrawingType.AFTER_SOFT_WRAP);
                        softWrapModel.doPaint(g, SoftWrapDrawingType.AFTER_SOFT_WRAP, (int)xEnd - symbolWidth, y - EditorPainter.this.myView.getAscent(), EditorPainter.this.myView.getLineHeight());
                    }
                }

                @Override
                public void paint(Graphics2D g, VisualLineFragmentsIterator.Fragment fragment, int start, int end, TextAttributes attributes, float xStart, float xEnd, int y) {
                    boolean allowBorder;
                    if (attributes != null && attributes.getForegroundColor() != null) {
                        g.setColor(attributes.getForegroundColor());
                        fragment.draw(g, xStart, y, start, end);
                    }
                    if (fragment.getCurrentFoldRegion() == null) {
                        int logicalLine = fragment.getStartLogicalLine();
                        if (logicalLine != currentLogicalLine[0]) {
                            whitespacePaintingStrategy.update(text, EditorPainter.this.myDocument.getLineStartOffset(logicalLine), EditorPainter.this.myDocument.getLineEndOffset(logicalLine));
                            currentLogicalLine[0] = logicalLine;
                        }
                        EditorPainter.this.paintWhitespace(g, text, xStart, y, start, end, whitespacePaintingStrategy, fragment, whiteSpaceStroke, whiteSpaceStrokeWidth);
                    }
                    boolean bl = allowBorder = fragment.getCurrentFoldRegion() != null;
                    if (attributes != null && EditorPainter.hasTextEffect(attributes.getEffectColor(), attributes.getEffectType(), allowBorder)) {
                        EditorPainter.this.paintTextEffect(g, xStart, xEnd, y, attributes.getEffectColor(), attributes.getEffectType(), allowBorder);
                    }
                }

                @Override
                public void paintAfterLineEnd(Graphics2D g, Rectangle clip, IterationState iterationState, int columnStart, float x, int y) {
                    int offset = iterationState.getEndOffset();
                    SoftWrapModelImpl softWrapModel = EditorPainter.this.myEditor.getSoftWrapModel();
                    if (softWrapModel.getSoftWrap(offset) == null) {
                        int logicalLine = EditorPainter.this.myDocument.getLineNumber(offset);
                        EditorPainter.this.paintLineExtensions(g, logicalLine, x, y);
                    } else if (paintSoftWraps) {
                        softWrapModel.doPaint(g, SoftWrapDrawingType.BEFORE_SOFT_WRAP_LINE_FEED, (int)x, y - EditorPainter.this.myView.getAscent(), EditorPainter.this.myView.getLineHeight());
                    }
                }
            });
            visLinesIterator.advance();
        }
    }

    private float paintLineLayoutWithEffect(Graphics2D g, LineLayout layout, float x, float y, @Nullable Color effectColor, @Nullable EffectType effectType) {
        float initialX = x;
        for (LineLayout.VisualFragment fragment : layout.getFragmentsInVisualOrder(x)) {
            fragment.draw(g, x, y);
            x = fragment.getEndX();
        }
        if (EditorPainter.hasTextEffect(effectColor, effectType, false)) {
            this.paintTextEffect(g, initialX, x, (int)y, effectColor, effectType, false);
        }
        return x;
    }

    private static boolean hasTextEffect(@Nullable Color effectColor, @Nullable EffectType effectType, boolean allowBorder) {
        return effectColor != null && (effectType == EffectType.LINE_UNDERSCORE || effectType == EffectType.BOLD_LINE_UNDERSCORE || effectType == EffectType.BOLD_DOTTED_LINE || effectType == EffectType.WAVE_UNDERSCORE || effectType == EffectType.STRIKEOUT || allowBorder && (effectType == EffectType.BOXED || effectType == EffectType.ROUNDED_BOX));
    }

    private void paintTextEffect(Graphics2D g, float xFrom, float xTo, int y, Color effectColor, EffectType effectType, boolean allowBorder) {
        int xStart = (int)xFrom;
        int xEnd = (int)xTo;
        g.setColor(effectColor);
        if (effectType == EffectType.LINE_UNDERSCORE) {
            UIUtil.drawLine((Graphics)g, (int)xStart, (int)(y + 1), (int)xEnd, (int)(y + 1));
        } else if (effectType == EffectType.BOLD_LINE_UNDERSCORE) {
            int height = JBUI.scale((int)Registry.intValue((String)"editor.bold.underline.height", (int)2));
            g.fillRect(xStart, y, xEnd - xStart, height);
        } else if (effectType == EffectType.STRIKEOUT) {
            int y1 = y - this.myView.getCharHeight() / 2;
            UIUtil.drawLine((Graphics)g, (int)xStart, (int)y1, (int)xEnd, (int)y1);
        } else if (effectType == EffectType.WAVE_UNDERSCORE) {
            UIUtil.drawWave((Graphics2D)g, (Rectangle)new Rectangle(xStart, y + 1, xEnd - xStart, this.myView.getDescent() - 1));
        } else if (effectType == EffectType.BOLD_DOTTED_LINE) {
            UIUtil.drawBoldDottedLine((Graphics2D)g, (int)xStart, (int)xEnd, (int)(SystemInfo.isMac ? y : y + 1), (Color)this.myEditor.getBackgroundColor(), (Color)g.getColor(), (boolean)false);
        } else if (allowBorder && (effectType == EffectType.BOXED || effectType == EffectType.ROUNDED_BOX)) {
            this.drawSimpleBorder(g, xStart, xEnd - 1, y - this.myView.getAscent(), effectType == EffectType.ROUNDED_BOX);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintWhitespace(Graphics2D g, CharSequence text, float x, int y, int start, int end, EditorImpl.LineWhitespacePaintingStrategy whitespacePaintingStrategy, VisualLineFragmentsIterator.Fragment fragment, Stroke stroke, int strokeWidth) {
        Stroke oldStroke = g.getStroke();
        try {
            g.setColor(this.myEditor.getColorsScheme().getColor(EditorColors.WHITESPACES_COLOR));
            g.setStroke(stroke);
            boolean isRtl = fragment.isRtl();
            int baseStartOffset = fragment.getStartOffset();
            int startOffset = isRtl ? baseStartOffset - start : baseStartOffset + start;
            --y;
            for (int i = start; i < end; ++i) {
                int charOffset = isRtl ? baseStartOffset - i - 1 : baseStartOffset + i;
                char c = text.charAt(charOffset);
                if (" \t\u3000".indexOf(c) < 0 || !whitespacePaintingStrategy.showWhitespaceAtOffset(charOffset)) continue;
                int startX = (int)fragment.offsetToX(x, startOffset, isRtl ? baseStartOffset - i : baseStartOffset + i);
                int endX = (int)fragment.offsetToX(x, startOffset, isRtl ? baseStartOffset - i - 1 : baseStartOffset + i + 1);
                if (c == ' ') {
                    g.fillRect((startX + endX - strokeWidth) / 2, y - strokeWidth + 1, strokeWidth, strokeWidth);
                    continue;
                }
                if (c == '\t') {
                    int height = this.myView.getCharHeight();
                    int halfHeight = height / 2;
                    int mid = y - halfHeight;
                    int top = y - height;
                    UIUtil.drawLine((Graphics)g, (int)startX, (int)mid, (int)(endX -= this.myView.getPlainSpaceWidth() / 4), (int)mid);
                    UIUtil.drawLine((Graphics)g, (int)endX, (int)y, (int)endX, (int)top);
                    g.fillPolygon(new int[]{endX - halfHeight, endX - halfHeight, endX}, new int[]{y, y - height, y - halfHeight}, 3);
                    continue;
                }
                if (c != '\u3000') continue;
                int charHeight = this.myView.getCharHeight();
                g.drawRect(startX + JBUI.scale((int)2) + strokeWidth / 2, y - charHeight + strokeWidth / 2, endX - startX - JBUI.scale((int)4) - (strokeWidth - 1), charHeight - (strokeWidth - 1));
            }
        }
        finally {
            g.setStroke(oldStroke);
        }
    }

    private void paintLineExtensions(Graphics2D g, int line, float x, int y) {
        Project project2 = this.myEditor.getProject();
        VirtualFile virtualFile = this.myEditor.getVirtualFile();
        if (project2 == null || virtualFile == null) {
            return;
        }
        for (EditorLinePainter painter : (EditorLinePainter[])EditorLinePainter.EP_NAME.getExtensions()) {
            Collection<LineExtensionInfo> extensions = painter.getLineExtensions(project2, virtualFile, line);
            if (extensions == null) continue;
            for (LineExtensionInfo info : extensions) {
                EditorSizeManager sizeManager;
                LineLayout layout = LineLayout.create(this.myView, info.getText(), info.getFontType());
                g.setColor(info.getColor());
                int currentLineWidth = (int)(x = this.paintLineLayoutWithEffect(g, layout, x, y, info.getEffectColor(), info.getEffectType()));
                if (currentLineWidth <= (sizeManager = this.myView.getSizeManager()).getMaxLineWithExtensionWidth()) continue;
                sizeManager.setMaxLineWithExtensionWidth(line, currentLineWidth);
            }
        }
    }

    private void paintHighlightersAfterEndOfLine(final Graphics2D g, MarkupModelEx markupModel, final int startOffset, int endOffset) {
        markupModel.processRangeHighlightersOverlappingWith(startOffset, endOffset, (Processor<? super RangeHighlighterEx>)new Processor<RangeHighlighterEx>(){

            public boolean process(RangeHighlighterEx highlighter) {
                if (highlighter.getEditorFilter().avaliableIn((Editor)EditorPainter.this.myEditor) && highlighter.getStartOffset() >= startOffset) {
                    EditorPainter.this.paintHighlighterAfterEndOfLine(g, highlighter);
                }
                return true;
            }
        });
    }

    private void paintHighlighterAfterEndOfLine(Graphics2D g, RangeHighlighterEx highlighter) {
        if (!highlighter.isAfterEndOfLine()) {
            return;
        }
        int startOffset = highlighter.getStartOffset();
        int lineEndOffset = this.myDocument.getLineEndOffset(this.myDocument.getLineNumber(startOffset));
        if (this.myEditor.getFoldingModel().isOffsetCollapsed(lineEndOffset)) {
            return;
        }
        Point lineEnd = this.myView.offsetToXY(lineEndOffset, true, false);
        int x = lineEnd.x;
        int y = lineEnd.y;
        TextAttributes attributes = highlighter.getTextAttributes();
        this.paintBackground(g, attributes, (float)x, y, (float)this.myView.getPlainSpaceWidth());
        if (attributes != null && EditorPainter.hasTextEffect(attributes.getEffectColor(), attributes.getEffectType(), false)) {
            this.paintTextEffect(g, x, x + this.myView.getPlainSpaceWidth() - 1, y + this.myView.getAscent(), attributes.getEffectColor(), attributes.getEffectType(), false);
        }
    }

    private void paintBorderEffect(Graphics2D g, ClipDetector clipDetector, EditorHighlighter highlighter, int clipStartOffset, int clipEndOffset) {
        HighlighterIterator it = highlighter.createIterator(clipStartOffset);
        while (!it.atEnd() && it.getStart() < clipEndOffset) {
            TextAttributes attributes = it.getTextAttributes();
            if (EditorPainter.isBorder(attributes)) {
                this.paintBorderEffect(g, clipDetector, it.getStart(), it.getEnd(), attributes);
            }
            it.advance();
        }
    }

    private void paintBorderEffect(final Graphics2D g, final ClipDetector clipDetector, MarkupModelEx markupModel, int clipStartOffset, int clipEndOffset) {
        markupModel.processRangeHighlightersOverlappingWith(clipStartOffset, clipEndOffset, (Processor<? super RangeHighlighterEx>)new Processor<RangeHighlighterEx>(){

            public boolean process(RangeHighlighterEx rangeHighlighter) {
                TextAttributes attributes;
                if (rangeHighlighter.getEditorFilter().avaliableIn((Editor)EditorPainter.this.myEditor) && EditorPainter.isBorder(attributes = rangeHighlighter.getTextAttributes())) {
                    EditorPainter.this.paintBorderEffect(g, clipDetector, rangeHighlighter.getAffectedAreaStartOffset(), rangeHighlighter.getAffectedAreaEndOffset(), attributes);
                }
                return true;
            }
        });
    }

    private static boolean isBorder(TextAttributes attributes) {
        return attributes != null && (attributes.getEffectType() == EffectType.BOXED || attributes.getEffectType() == EffectType.ROUNDED_BOX) && attributes.getEffectColor() != null;
    }

    private void paintBorderEffect(Graphics2D g, ClipDetector clipDetector, int startOffset, int endOffset, TextAttributes attributes) {
        int endLine;
        if (!clipDetector.rangeCanBeVisible(startOffset, endOffset)) {
            return;
        }
        int startLine = this.myDocument.getLineNumber(startOffset);
        if (startLine + 1 == (endLine = this.myDocument.getLineNumber(endOffset)) && startOffset == this.myDocument.getLineStartOffset(startLine) && endOffset == this.myDocument.getLineStartOffset(endLine)) {
            endOffset = this.myDocument.getLineEndOffset(--endLine);
        }
        boolean rounded = attributes.getEffectType() == EffectType.ROUNDED_BOX;
        g.setColor(attributes.getEffectColor());
        VisualPosition startPosition = this.myView.offsetToVisualPosition(startOffset, true, false);
        VisualPosition endPosition = this.myView.offsetToVisualPosition(endOffset, false, true);
        if (startPosition.line == endPosition.line) {
            int y = this.myView.visualLineToY(startPosition.line);
            TFloatArrayList ranges = this.adjustedLogicalRangeToVisualRanges(startOffset, endOffset);
            for (int i = 0; i < ranges.size() - 1; i += 2) {
                int startX = (int)ranges.get(i);
                int endX = (int)ranges.get(i + 1);
                this.drawSimpleBorder(g, startX, endX, y, rounded);
            }
        } else {
            TFloatArrayList leadingRanges = this.adjustedLogicalRangeToVisualRanges(startOffset, this.myView.visualPositionToOffset(new VisualPosition(startPosition.line, Integer.MAX_VALUE, true)));
            TFloatArrayList trailingRanges = this.adjustedLogicalRangeToVisualRanges(this.myView.visualPositionToOffset(new VisualPosition(endPosition.line, 0)), endOffset);
            if (!leadingRanges.isEmpty() && !trailingRanges.isEmpty()) {
                int maxWidth = Math.max(this.myView.getMaxWidthInLineRange(startPosition.line, endPosition.line - 1) - 1, (int)trailingRanges.get(trailingRanges.size() - 1));
                boolean containsInnerLines = endPosition.line > startPosition.line + 1;
                int lineHeight = this.myView.getLineHeight() - 1;
                int leadingTopY = this.myView.visualLineToY(startPosition.line);
                int leadingBottomY = leadingTopY + lineHeight;
                int trailingTopY = this.myView.visualLineToY(endPosition.line);
                int trailingBottomY = trailingTopY + lineHeight;
                float start = 0.0f;
                float end = 0.0f;
                float leftGap = leadingRanges.get(0) - (containsInnerLines ? 0.0f : trailingRanges.get(0));
                int adjustY = leftGap == 0.0f ? 2 : (leftGap > 0.0f ? 1 : 0);
                for (int i = 0; i < leadingRanges.size() - 1; i += 2) {
                    start = leadingRanges.get(i);
                    end = leadingRanges.get(i + 1);
                    if (i > 0) {
                        EditorPainter.drawLine(g, leadingRanges.get(i - 1), leadingBottomY, start, leadingBottomY, rounded);
                    }
                    EditorPainter.drawLine(g, start, leadingBottomY + (i == 0 ? adjustY : 0), start, leadingTopY, rounded);
                    if (i + 2 >= leadingRanges.size()) continue;
                    EditorPainter.drawLine(g, start, leadingTopY, end, leadingTopY, rounded);
                    EditorPainter.drawLine(g, end, leadingTopY, end, leadingBottomY, rounded);
                }
                end = Math.max(end, (float)maxWidth);
                EditorPainter.drawLine(g, start, leadingTopY, end, leadingTopY, rounded);
                EditorPainter.drawLine(g, end, leadingTopY, end, trailingTopY - 1, rounded);
                float targetX = trailingRanges.get(trailingRanges.size() - 1);
                EditorPainter.drawLine(g, end, trailingTopY - 1, targetX, trailingTopY - 1, rounded);
                adjustY = end == targetX ? -2 : -1;
                for (int i = trailingRanges.size() - 2; i >= 0; i -= 2) {
                    start = trailingRanges.get(i);
                    end = trailingRanges.get(i + 1);
                    EditorPainter.drawLine(g, end, trailingTopY + (i == 0 ? adjustY : 0), end, trailingBottomY, rounded);
                    EditorPainter.drawLine(g, end, trailingBottomY, start, trailingBottomY, rounded);
                    EditorPainter.drawLine(g, start, trailingBottomY, start, trailingTopY, rounded);
                    if (i <= 0) continue;
                    EditorPainter.drawLine(g, start, trailingTopY, trailingRanges.get(i - 1), trailingTopY, rounded);
                }
                float lastX = start;
                if (containsInnerLines) {
                    if (start > 0.0f) {
                        EditorPainter.drawLine(g, start, trailingTopY, start, trailingTopY - 1, rounded);
                        EditorPainter.drawLine(g, start, trailingTopY - 1, 0.0f, trailingTopY - 1, rounded);
                        EditorPainter.drawLine(g, 0.0f, trailingTopY - 1, 0.0f, leadingBottomY + 1, rounded);
                    } else {
                        EditorPainter.drawLine(g, start, trailingTopY, 0.0f, leadingBottomY + 1, rounded);
                    }
                    lastX = 0.0f;
                }
                if (lastX < (targetX = leadingRanges.get(0))) {
                    EditorPainter.drawLine(g, lastX, leadingBottomY + 1, targetX, leadingBottomY + 1, rounded);
                } else {
                    EditorPainter.drawLine(g, lastX, leadingBottomY + 1, lastX, leadingBottomY, rounded);
                    EditorPainter.drawLine(g, lastX, leadingBottomY, targetX, leadingBottomY, rounded);
                }
            }
        }
    }

    private void drawSimpleBorder(Graphics2D g, int xStart, int xEnd, int y, boolean rounded) {
        int height = this.myView.getLineHeight() - 1;
        if (rounded) {
            UIUtil.drawRectPickedOut((Graphics2D)g, (int)xStart, (int)y, (int)(xEnd - xStart), (int)height);
        } else {
            g.drawRect(xStart, y, xEnd - xStart, height);
        }
    }

    private static void drawLine(Graphics2D g, float x1, int y1, float x2, int y2, boolean rounded) {
        if (rounded) {
            UIUtil.drawLinePickedOut((Graphics)g, (int)((int)x1), (int)y1, (int)((int)x2), (int)y2);
        } else {
            UIUtil.drawLine((Graphics)g, (int)((int)x1), (int)y1, (int)((int)x2), (int)y2);
        }
    }

    private TFloatArrayList adjustedLogicalRangeToVisualRanges(int startOffset, int endOffset) {
        TFloatArrayList ranges = this.logicalRangeToVisualRanges(startOffset, endOffset);
        for (int i = 0; i < ranges.size() - 1; i += 2) {
            float endX;
            float startX = ranges.get(i);
            endX = startX == (endX = ranges.get(i + 1)) ? (endX += 1.0f) : (endX -= 1.0f);
            ranges.set(i + 1, endX);
        }
        return ranges;
    }

    private TFloatArrayList logicalRangeToVisualRanges(int startOffset, int endOffset) {
        assert (startOffset <= endOffset);
        TFloatArrayList result = new TFloatArrayList();
        if (this.myDocument.getTextLength() == 0) {
            result.add(0.0f);
            result.add(0.0f);
        } else {
            for (VisualLineFragmentsIterator.Fragment fragment : VisualLineFragmentsIterator.create(this.myView, startOffset, false)) {
                float x2;
                int minOffset = fragment.getMinOffset();
                int maxOffset = fragment.getMaxOffset();
                if (startOffset == endOffset) {
                    if (startOffset < minOffset || startOffset > maxOffset) continue;
                    float x = fragment.offsetToX(startOffset);
                    result.add(x);
                    result.add(x);
                    break;
                }
                if (startOffset >= maxOffset || endOffset <= minOffset) continue;
                float x1 = fragment.offsetToX(Math.max(minOffset, startOffset));
                if (x1 > (x2 = fragment.offsetToX(Math.min(maxOffset, endOffset)))) {
                    float tmp = x1;
                    x1 = x2;
                    x2 = tmp;
                }
                if (result.isEmpty() || x1 > result.get(result.size() - 1)) {
                    result.add(x1);
                    result.add(x2);
                    continue;
                }
                result.set(result.size() - 1, x2);
            }
        }
        return result;
    }

    private void paintComposedTextDecoration(Graphics2D g) {
        TextRange composedTextRange = this.myEditor.getComposedTextRange();
        if (composedTextRange != null) {
            Point p1 = this.myView.offsetToXY(Math.min(composedTextRange.getStartOffset(), this.myDocument.getTextLength()), true, false);
            Point p2 = this.myView.offsetToXY(Math.min(composedTextRange.getEndOffset(), this.myDocument.getTextLength()), false, true);
            int y = p1.y + this.myView.getAscent() + 1;
            g.setStroke(IME_COMPOSED_TEXT_UNDERLINE_STROKE);
            g.setColor(this.myEditor.getColorsScheme().getDefaultForeground());
            UIUtil.drawLine((Graphics)g, (int)p1.x, (int)y, (int)p2.x, (int)y);
        }
    }

    private void paintCaret(Graphics2D g_) {
        EditorImpl.CaretRectangle[] locations = this.myEditor.getCaretLocations(true);
        if (locations == null) {
            return;
        }
        Graphics2D g = IdeBackgroundUtil.getOriginalGraphics(g_);
        int lineHeight = this.myView.getLineHeight();
        EditorSettings settings = this.myEditor.getSettings();
        Color caretColor = this.myEditor.getColorsScheme().getColor(EditorColors.CARET_COLOR);
        if (caretColor == null) {
            caretColor = new JBColor(CARET_DARK, CARET_LIGHT);
        }
        g.setColor(caretColor);
        block0: for (EditorImpl.CaretRectangle location : locations) {
            int x = location.myPoint.x;
            int y = location.myPoint.y;
            Caret caret = location.myCaret;
            boolean isRtl = location.myIsRtl;
            if (this.myEditor.isInsertMode() != settings.isBlockCursor()) {
                int lineWidth = JBUI.scale((int)settings.getLineCursorWidth());
                if (!ImmediatePainter.isZeroLatencyTypingEnabled() && x > 0 && lineWidth > 1) {
                    --x;
                }
                g.fillRect(x, y, lineWidth, lineHeight);
                if (this.myDocument.getTextLength() <= 0 || caret == null || this.myView.getTextLayoutCache().getLineLayout(caret.getLogicalPosition().line).isLtr()) continue;
                g.fillPolygon(new int[]{isRtl ? x + lineWidth : x, isRtl ? x + lineWidth - 5 : x + 5, isRtl ? x + lineWidth : x}, new int[]{y, y, y + 5}, 3);
                continue;
            }
            int width = location.myWidth;
            int startX = Math.max(0, isRtl ? x - width : x);
            g.fillRect(startX, y, width, lineHeight - 1);
            if (this.myDocument.getTextLength() <= 0 || caret == null) continue;
            int targetVisualColumn = caret.getVisualPosition().column;
            for (VisualLineFragmentsIterator.Fragment fragment : VisualLineFragmentsIterator.create(this.myView, caret.getVisualLineStart(), false)) {
                int startVisualColumn = fragment.getStartVisualColumn();
                int endVisualColumn = fragment.getEndVisualColumn();
                if (!(startVisualColumn < targetVisualColumn && endVisualColumn > targetVisualColumn || startVisualColumn == targetVisualColumn && !isRtl) && (endVisualColumn != targetVisualColumn || !isRtl)) continue;
                g.setColor(ColorUtil.isDark((Color)caretColor) ? CARET_LIGHT : CARET_DARK);
                fragment.draw(g, startX, y + this.myView.getAscent(), targetVisualColumn - startVisualColumn - (isRtl ? 1 : 0), targetVisualColumn - startVisualColumn + (isRtl ? 0 : 1));
                continue block0;
            }
        }
    }

    void repaintCarets() {
        EditorImpl.CaretRectangle[] locations = this.myEditor.getCaretLocations(false);
        if (locations == null) {
            return;
        }
        int lineHeight = this.myView.getLineHeight();
        for (EditorImpl.CaretRectangle location : locations) {
            int x = location.myPoint.x;
            int y = location.myPoint.y;
            int width = Math.max(location.myWidth, 5);
            this.myEditor.getContentComponent().repaintEditorComponent(x - width, y, width * 2, lineHeight);
        }
    }

    private void paintLineFragments(Graphics2D g, Rectangle clip, VisualLinesIterator visLineIterator, int y, LineFragmentPainter painter) {
        int visualLine = visLineIterator.getVisualLine();
        float x = visualLine == 0 ? this.myView.getPrefixTextWidthInPixels() : 0.0f;
        int offset = visLineIterator.getVisualLineStartOffset();
        int visualLineEndOffset = visLineIterator.getVisualLineEndOffset();
        IterationState it = null;
        int prevEndOffset = -1;
        boolean firstFragment = true;
        int maxColumn = 0;
        for (VisualLineFragmentsIterator.Fragment fragment : VisualLineFragmentsIterator.create(this.myView, visLineIterator, null)) {
            FoldRegion foldRegion;
            int fragmentStartOffset;
            int start = fragmentStartOffset = fragment.getStartOffset();
            int end = fragment.getEndOffset();
            x = fragment.getStartX();
            if (firstFragment) {
                firstFragment = false;
                SoftWrap softWrap = this.myEditor.getSoftWrapModel().getSoftWrap(offset);
                if (softWrap != null) {
                    prevEndOffset = offset;
                    it = new IterationState(this.myEditor, offset == 0 ? 0 : offset - 1, visualLineEndOffset, true, false, false, false);
                    if (it.getEndOffset() <= offset) {
                        it.advance();
                    }
                    if ((double)x >= clip.getMinX()) {
                        painter.paintBeforeLineStart(g, it.getStartOffset() == offset ? it.getBeforeLineStartBackgroundAttributes() : it.getMergedAttributes(), fragment.getStartVisualColumn(), x, y);
                    }
                }
            }
            if ((foldRegion = fragment.getCurrentFoldRegion()) == null) {
                if (start != prevEndOffset) {
                    it = new IterationState(this.myEditor, start, fragment.isRtl() ? offset : visualLineEndOffset, true, false, false, fragment.isRtl());
                }
                prevEndOffset = end;
                assert (it != null);
                while (fragment.isRtl() ? start > end : start < end) {
                    if (fragment.isRtl() ? it.getEndOffset() >= start : it.getEndOffset() <= start) {
                        assert (!it.atEnd());
                        it.advance();
                    }
                    TextAttributes attributes = it.getMergedAttributes();
                    int curEnd = fragment.isRtl() ? Math.max(it.getEndOffset(), end) : Math.min(it.getEndOffset(), end);
                    float xNew = fragment.offsetToX(x, start, curEnd);
                    if ((double)xNew >= clip.getMinX()) {
                        painter.paint(g, fragment, fragment.isRtl() ? fragmentStartOffset - start : start - fragmentStartOffset, fragment.isRtl() ? fragmentStartOffset - curEnd : curEnd - fragmentStartOffset, attributes, x, xNew, y);
                    }
                    x = xNew;
                    start = curEnd;
                }
            } else {
                float xNew = fragment.getEndX();
                if ((double)xNew >= clip.getMinX()) {
                    painter.paint(g, fragment, 0, fragment.getEndVisualColumn() - fragment.getStartVisualColumn(), this.getFoldRegionAttributes(foldRegion), x, xNew, y);
                }
                x = xNew;
                prevEndOffset = -1;
                it = null;
            }
            if ((double)x > clip.getMaxX()) {
                return;
            }
            maxColumn = fragment.getEndVisualColumn();
        }
        if (it == null || it.getEndOffset() != visualLineEndOffset) {
            it = new IterationState(this.myEditor, visualLineEndOffset == offset ? visualLineEndOffset : visualLineEndOffset - 1, visualLineEndOffset, true, false, false, false);
        }
        if (!it.atEnd()) {
            it.advance();
        }
        assert (it.atEnd());
        painter.paintAfterLineEnd(g, clip, it, maxColumn, x, y);
    }

    private TextAttributes getFoldRegionAttributes(FoldRegion foldRegion) {
        TextAttributes selectionAttributes = EditorPainter.isSelected(foldRegion) ? this.myEditor.getSelectionModel().getTextAttributes() : null;
        TextAttributes foldAttributes = this.myEditor.getFoldingModel().getPlaceholderAttributes();
        TextAttributes defaultAttributes = this.getDefaultAttributes();
        return EditorPainter.mergeAttributes(EditorPainter.mergeAttributes(selectionAttributes, foldAttributes), defaultAttributes);
    }

    private TextAttributes getDefaultAttributes() {
        TextAttributes attributes = this.myEditor.getColorsScheme().getAttributes(HighlighterColors.TEXT);
        if (attributes.getForegroundColor() == null) {
            attributes.setForegroundColor(Color.black);
        }
        if (attributes.getBackgroundColor() == null) {
            attributes.setBackgroundColor(Color.white);
        }
        return attributes;
    }

    private static boolean isSelected(FoldRegion foldRegion) {
        int regionStart = foldRegion.getStartOffset();
        int regionEnd = foldRegion.getEndOffset();
        int[] selectionStarts = foldRegion.getEditor().getSelectionModel().getBlockSelectionStarts();
        int[] selectionEnds = foldRegion.getEditor().getSelectionModel().getBlockSelectionEnds();
        for (int i = 0; i < selectionStarts.length; ++i) {
            int start = selectionStarts[i];
            int end = selectionEnds[i];
            if (regionStart < start || regionEnd > end) continue;
            return true;
        }
        return false;
    }

    private static TextAttributes mergeAttributes(TextAttributes primary, TextAttributes secondary) {
        if (primary == null) {
            return secondary;
        }
        if (secondary == null) {
            return primary;
        }
        return new TextAttributes(primary.getForegroundColor() == null ? secondary.getForegroundColor() : primary.getForegroundColor(), primary.getBackgroundColor() == null ? secondary.getBackgroundColor() : primary.getBackgroundColor(), primary.getEffectColor() == null ? secondary.getEffectColor() : primary.getEffectColor(), primary.getEffectType() == null ? secondary.getEffectType() : primary.getEffectType(), primary.getFontType() == 0 ? secondary.getFontType() : primary.getFontType());
    }

    @Override
    public void drawChars(@NotNull Graphics g, @NotNull char[] data, int start, int end, int x, int y, Color color, FontInfo fontInfo) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/view/EditorPainter", "drawChars"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/editor/impl/view/EditorPainter", "drawChars"));
        }
        g.setFont(fontInfo.getFont());
        g.setColor(color);
        g.drawChars(data, start, end - start, x, y);
    }

    static interface LineFragmentPainter {
        public void paintBeforeLineStart(Graphics2D var1, TextAttributes var2, int var3, float var4, int var5);

        public void paint(Graphics2D var1, VisualLineFragmentsIterator.Fragment var2, int var3, int var4, TextAttributes var5, float var6, float var7, int var8);

        public void paintAfterLineEnd(Graphics2D var1, Rectangle var2, IterationState var3, int var4, float var5, int var6);
    }
}

