/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.SoftWrapModelImpl;
import com.intellij.openapi.editor.impl.view.EditorView;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class VisualLinesIterator {
    private static final Logger LOG = Logger.getInstance(VisualLinesIterator.class);
    private final EditorView myView;
    private final EditorImpl myEditor;
    private final Document myDocument;
    private final FoldRegion[] myFoldRegions;
    private final List<? extends SoftWrap> mySoftWraps;
    @NotNull
    private Location myLocation;
    private Location myNextLocation;

    VisualLinesIterator(@NotNull EditorView view, int startVisualLine) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/openapi/editor/impl/view/VisualLinesIterator", "<init>"));
        }
        this.myView = view;
        this.myEditor = view.getEditor();
        SoftWrapModelImpl softWrapModel = this.myEditor.getSoftWrapModel();
        this.myDocument = this.myEditor.getDocument();
        FoldRegion[] regions = this.myEditor.getFoldingModel().fetchTopLevel();
        this.myFoldRegions = regions == null ? FoldRegion.EMPTY_ARRAY : regions;
        this.mySoftWraps = softWrapModel.getRegisteredSoftWraps();
        if (!this.mySoftWraps.isEmpty() && this.mySoftWraps.get(this.mySoftWraps.size() - 1).getStart() >= this.myDocument.getTextLength()) {
            LOG.error("Unexpected soft wrap location", new Attachment[]{new Attachment("editorState.txt", this.myEditor.dumpState())});
        }
        this.myLocation = new Location(startVisualLine);
    }

    boolean atEnd() {
        return this.myLocation.atEnd();
    }

    void advance() {
        this.checkEnd();
        if (this.myNextLocation == null) {
            this.myLocation.advance();
        } else {
            this.myLocation = this.myNextLocation;
            this.myNextLocation = null;
        }
    }

    int getVisualLine() {
        this.checkEnd();
        return this.myLocation.visualLine;
    }

    int getVisualLineStartOffset() {
        this.checkEnd();
        return this.myLocation.offset;
    }

    int getVisualLineEndOffset() {
        this.checkEnd();
        if (this.myNextLocation == null) {
            this.myNextLocation = this.myLocation.clone();
            this.myNextLocation.advance();
        }
        return this.myNextLocation.atEnd() ? this.myDocument.getTextLength() : (this.myNextLocation.softWrap == this.myLocation.softWrap ? this.myDocument.getLineEndOffset(this.myNextLocation.logicalLine - 2) : this.myNextLocation.offset);
    }

    int getStartLogicalLine() {
        this.checkEnd();
        return this.myLocation.logicalLine - 1;
    }

    int getStartOrPrevWrapIndex() {
        this.checkEnd();
        return this.myLocation.softWrap - 1;
    }

    int getStartFoldingIndex() {
        this.checkEnd();
        return this.myLocation.foldRegion;
    }

    private void checkEnd() {
        if (this.atEnd()) {
            throw new IllegalStateException("Iteration finished");
        }
    }

    private final class Location
    implements Cloneable {
        private int visualLine;
        private int offset;
        private int logicalLine = 1;
        private int foldRegion;
        private int softWrap;

        private Location(int startVisualLine) {
            if (startVisualLine < 0 || startVisualLine >= VisualLinesIterator.this.myEditor.getVisibleLineCount()) {
                this.offset = -1;
            } else if (startVisualLine > 0) {
                this.visualLine = startVisualLine;
                this.offset = VisualLinesIterator.this.myView.visualLineToOffset(startVisualLine);
                this.logicalLine = VisualLinesIterator.this.myDocument.getLineNumber(this.offset) + 1;
                this.softWrap = VisualLinesIterator.this.myEditor.getSoftWrapModel().getSoftWrapIndex(this.offset) + 1;
                if (this.softWrap <= 0) {
                    this.softWrap = -this.softWrap;
                }
                this.foldRegion = VisualLinesIterator.this.myEditor.getFoldingModel().getLastCollapsedRegionBefore(this.offset) + 1;
            }
        }

        private void advance() {
            int nextWrapOffset = this.getNextSoftWrapOffset();
            this.offset = this.getNextVisualLineStartOffset(nextWrapOffset);
            if (this.offset == Integer.MAX_VALUE) {
                this.offset = -1;
            } else if (this.offset == nextWrapOffset) {
                ++this.softWrap;
            }
            ++this.visualLine;
            while (this.foldRegion < VisualLinesIterator.this.myFoldRegions.length && VisualLinesIterator.this.myFoldRegions[this.foldRegion].getStartOffset() < this.offset) {
                ++this.foldRegion;
            }
        }

        private int getNextSoftWrapOffset() {
            return this.softWrap < VisualLinesIterator.this.mySoftWraps.size() ? ((SoftWrap)VisualLinesIterator.this.mySoftWraps.get(this.softWrap)).getStart() : Integer.MAX_VALUE;
        }

        private int getNextVisualLineStartOffset(int nextWrapOffset) {
            while (this.logicalLine < VisualLinesIterator.this.myDocument.getLineCount()) {
                int lineStartOffset = VisualLinesIterator.this.myDocument.getLineStartOffset(this.logicalLine);
                if (lineStartOffset > nextWrapOffset) {
                    return nextWrapOffset;
                }
                ++this.logicalLine;
                if (this.isCollapsed(lineStartOffset)) continue;
                return lineStartOffset;
            }
            return nextWrapOffset;
        }

        private boolean isCollapsed(int offset) {
            while (this.foldRegion < VisualLinesIterator.this.myFoldRegions.length) {
                FoldRegion region = VisualLinesIterator.this.myFoldRegions[this.foldRegion];
                if (offset <= region.getStartOffset()) {
                    return false;
                }
                if (offset <= region.getEndOffset()) {
                    return true;
                }
                ++this.foldRegion;
            }
            return false;
        }

        private boolean atEnd() {
            return this.offset == -1;
        }

        protected Location clone() {
            try {
                return (Location)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

