/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorState;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.SingleRootFileViewProvider;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class LargeFileEditorProvider
implements FileEditorProvider,
DumbAware {
    public boolean accept(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/text/LargeFileEditorProvider", "accept"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/text/LargeFileEditorProvider", "accept"));
        }
        return TextEditorProvider.isTextFile(file2) && SingleRootFileViewProvider.isTooLargeForContentLoading(file2);
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/text/LargeFileEditorProvider", "createEditor"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/text/LargeFileEditorProvider", "createEditor"));
        }
        LargeFileEditor largeFileEditor = new LargeFileEditor(file2);
        if (largeFileEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/text/LargeFileEditorProvider", "createEditor"));
        }
        return largeFileEditor;
    }

    public void disposeEditor(@NotNull FileEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/fileEditor/impl/text/LargeFileEditorProvider", "disposeEditor"));
        }
        Disposer.dispose((Disposable)editor);
    }

    @NotNull
    public FileEditorState readState(@NotNull Element element, @NotNull Project project2, @NotNull VirtualFile file2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/fileEditor/impl/text/LargeFileEditorProvider", "readState"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/text/LargeFileEditorProvider", "readState"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/text/LargeFileEditorProvider", "readState"));
        }
        FileEditorState fileEditorState = FileEditorState.INSTANCE;
        if (fileEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/text/LargeFileEditorProvider", "readState"));
        }
        return fileEditorState;
    }

    public void writeState(@NotNull FileEditorState _state, @NotNull Project project2, @NotNull Element element) {
        if (_state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_state", "com/intellij/openapi/fileEditor/impl/text/LargeFileEditorProvider", "writeState"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/text/LargeFileEditorProvider", "writeState"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/fileEditor/impl/text/LargeFileEditorProvider", "writeState"));
        }
    }

    @NotNull
    public String getEditorTypeId() {
        if ("LargeFileEditor" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/text/LargeFileEditorProvider", "getEditorTypeId"));
        }
        return "LargeFileEditor";
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        FileEditorPolicy fileEditorPolicy = FileEditorPolicy.NONE;
        if (fileEditorPolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/text/LargeFileEditorProvider", "getPolicy"));
        }
        return fileEditorPolicy;
    }

    private static class LargeFileEditor
    extends UserDataHolderBase
    implements FileEditor {
        private final VirtualFile myFile;

        public LargeFileEditor(VirtualFile file2) {
            this.myFile = file2;
        }

        @NotNull
        public JComponent getComponent() {
            JLabel label = new JLabel("File " + this.myFile.getPath() + " is too large (" + StringUtil.formatFileSize((long)this.myFile.getLength()) + ")");
            label.setHorizontalAlignment(0);
            JLabel jLabel = label;
            if (jLabel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/text/LargeFileEditorProvider$LargeFileEditor", "getComponent"));
            }
            return jLabel;
        }

        public JComponent getPreferredFocusedComponent() {
            return null;
        }

        @NotNull
        public String getName() {
            if ("Large file editor" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/text/LargeFileEditorProvider$LargeFileEditor", "getName"));
            }
            return "Large file editor";
        }

        @NotNull
        public FileEditorState getState(@NotNull FileEditorStateLevel level) {
            if (level == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/openapi/fileEditor/impl/text/LargeFileEditorProvider$LargeFileEditor", "getState"));
            }
            TextEditorState textEditorState = new TextEditorState();
            if (textEditorState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/text/LargeFileEditorProvider$LargeFileEditor", "getState"));
            }
            return textEditorState;
        }

        public void setState(@NotNull FileEditorState state) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/fileEditor/impl/text/LargeFileEditorProvider$LargeFileEditor", "setState"));
            }
        }

        public boolean isModified() {
            return false;
        }

        public boolean isValid() {
            return this.myFile.isValid();
        }

        public void selectNotify() {
        }

        public void deselectNotify() {
        }

        public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/fileEditor/impl/text/LargeFileEditorProvider$LargeFileEditor", "addPropertyChangeListener"));
            }
        }

        public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/fileEditor/impl/text/LargeFileEditorProvider$LargeFileEditor", "removePropertyChangeListener"));
            }
        }

        public BackgroundEditorHighlighter getBackgroundHighlighter() {
            return null;
        }

        public FileEditorLocation getCurrentLocation() {
            return null;
        }

        public StructureViewBuilder getStructureViewBuilder() {
            return null;
        }

        public void dispose() {
        }
    }
}

