/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot.daemon;

import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.InheritedJdkOrderEntry;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.ModuleEditor;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.LibraryProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.PlaceInModuleClasspath;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.PlaceInProjectStructure;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.PlaceInProjectStructureBase;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElementUsage;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemType;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemsHolder;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.SdkProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.UsageInModuleClasspath;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ModuleProjectStructureElement
extends ProjectStructureElement {
    private final Module myModule;

    public ModuleProjectStructureElement(@NotNull StructureConfigurableContext context, @NotNull Module module2) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ModuleProjectStructureElement", "<init>"));
        }
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ModuleProjectStructureElement", "<init>"));
        }
        super(context);
        this.myModule = module2;
    }

    public Module getModule() {
        return this.myModule;
    }

    public void checkModulesNames(ProjectStructureProblemsHolder problemsHolder) {
        ModifiableModuleModel moduleModel = this.myContext.getModulesConfigurator().getModuleModel();
        Object[] all = moduleModel.getModules();
        if (!ArrayUtil.contains((Object)this.myModule, (Object[])all)) {
            return;
        }
        for (Object each : all) {
            if (each == this.myModule || !this.myContext.getRealName((Module)each).equals(this.myContext.getRealName(this.myModule))) continue;
            problemsHolder.registerProblem(ProjectBundle.message((String)"project.roots.module.duplicate.name.message", (Object[])new Object[0]), null, ProjectStructureProblemType.error("duplicate-module-name"), this.createPlace(), null);
            break;
        }
    }

    @Override
    public void check(ProjectStructureProblemsHolder problemsHolder) {
        OrderEntry[] entries;
        this.checkModulesNames(problemsHolder);
        ModuleRootModel rootModel = this.myContext.getModulesConfigurator().getRootModel(this.myModule);
        if (rootModel == null) {
            return;
        }
        for (OrderEntry entry : entries = rootModel.getOrderEntries()) {
            if (entry.isValid()) continue;
            if (entry instanceof JdkOrderEntry && ((JdkOrderEntry)entry).getJdkName() == null) {
                if (entry instanceof InheritedJdkOrderEntry) continue;
                problemsHolder.registerProblem(ProjectBundle.message((String)"project.roots.module.jdk.problem.message", (Object[])new Object[0]), null, ProjectStructureProblemType.error("module-sdk-not-defined"), this.createPlace(entry), null);
                continue;
            }
            problemsHolder.registerProblem(ProjectBundle.message((String)"project.roots.library.problem.message", (Object[])new Object[]{StringUtil.escapeXml((String)entry.getPresentableName())}), null, ProjectStructureProblemType.error("invalid-module-dependency"), this.createPlace(entry), null);
        }
    }

    private PlaceInProjectStructure createPlace() {
        Project project2 = this.myContext.getProject();
        return new PlaceInProjectStructureBase(project2, ProjectStructureConfigurable.getInstance(project2).createModulePlace(this.myModule), this);
    }

    private PlaceInProjectStructure createPlace(OrderEntry entry) {
        return new PlaceInModuleClasspath(this.myContext, this.myModule, (ProjectStructureElement)this, entry);
    }

    @Override
    public List<ProjectStructureElementUsage> getUsagesInElement() {
        ArrayList<ProjectStructureElementUsage> usages = new ArrayList<ProjectStructureElementUsage>();
        ModuleEditor moduleEditor = this.myContext.getModulesConfigurator().getModuleEditor(this.myModule);
        if (moduleEditor != null) {
            for (OrderEntry entry : moduleEditor.getOrderEntries()) {
                Sdk jdk;
                if (entry instanceof ModuleOrderEntry) {
                    ModuleOrderEntry moduleOrderEntry = (ModuleOrderEntry)entry;
                    Module module2 = moduleOrderEntry.getModule();
                    if (module2 == null) continue;
                    usages.add(new UsageInModuleClasspath(this.myContext, this, new ModuleProjectStructureElement(this.myContext, module2), moduleOrderEntry.getScope()));
                    continue;
                }
                if (entry instanceof LibraryOrderEntry) {
                    LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)entry;
                    Library library = libraryOrderEntry.getLibrary();
                    if (library == null) continue;
                    usages.add(new UsageInModuleClasspath(this.myContext, this, new LibraryProjectStructureElement(this.myContext, library), libraryOrderEntry.getScope()));
                    continue;
                }
                if (!(entry instanceof JdkOrderEntry) || (jdk = ((JdkOrderEntry)entry).getJdk()) == null) continue;
                usages.add(new UsageInModuleClasspath(this.myContext, this, new SdkProjectStructureElement(this.myContext, jdk), null));
            }
        }
        return usages;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModuleProjectStructureElement)) {
            return false;
        }
        return this.myModule.equals(((ModuleProjectStructureElement)o).myModule);
    }

    @Override
    public int hashCode() {
        return this.myModule.hashCode();
    }

    @Override
    public String getPresentableName() {
        return "Module '" + this.myModule.getName() + "'";
    }

    @Override
    public String getTypeName() {
        return "Module";
    }

    @Override
    public String getId() {
        return "module:" + this.myModule.getName();
    }
}

