/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.CommonBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.util.ui.OptionsDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class VcsConfirmationDialog
extends OptionsDialog {
    private final VcsShowConfirmationOption myOption;
    private final String myMessage;
    private final String myDoNotShowMessage;

    protected VcsConfirmationDialog(Project project2, VcsShowConfirmationOption option, String message, @NotNull String doNotShowMessage) {
        if (doNotShowMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doNotShowMessage", "com/intellij/openapi/vcs/changes/VcsConfirmationDialog", "<init>"));
        }
        super(project2);
        this.myOption = option;
        this.myMessage = message;
        this.myDoNotShowMessage = doNotShowMessage;
        this.setTitle("Confirmation");
        this.init();
    }

    protected boolean isToBeShown() {
        return this.myOption.getValue() == VcsShowConfirmationOption.Value.SHOW_CONFIRMATION;
    }

    protected void setToBeShown(boolean value, boolean onOk) {
        this.myOption.setValue(value ? VcsShowConfirmationOption.Value.SHOW_CONFIRMATION : (onOk ? VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY : VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY));
    }

    protected boolean shouldSaveOptionsOnCancel() {
        return true;
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout(15, 0));
        panel.add(new JLabel(this.myMessage));
        panel.add((Component)new JLabel(Messages.getQuestionIcon()), "West");
        return panel;
    }

    @NotNull
    protected String getDoNotShowMessage() {
        String string = this.myDoNotShowMessage;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/VcsConfirmationDialog", "getDoNotShowMessage"));
        }
        return string;
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray;
        AbstractAction okAction = new AbstractAction(CommonBundle.getYesButtonText()){
            {
                this.putValue("DefaultAction", Boolean.TRUE);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                VcsConfirmationDialog.this.doOKAction();
            }
        };
        AbstractAction cancelAction = new AbstractAction(CommonBundle.getNoButtonText()){

            @Override
            public void actionPerformed(ActionEvent e) {
                VcsConfirmationDialog.this.doCancelAction();
            }
        };
        if (SystemInfo.isMac) {
            Action[] actionArray2 = new Action[2];
            actionArray2[0] = cancelAction;
            actionArray = actionArray2;
            actionArray2[1] = okAction;
        } else {
            Action[] actionArray3 = new Action[2];
            actionArray3[0] = okAction;
            actionArray = actionArray3;
            actionArray3[1] = cancelAction;
        }
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/VcsConfirmationDialog", "createActions"));
        }
        return actionArray;
    }
}

