/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.BackgroundFromStartOption;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListUtil;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDifferentiatedDialog;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchExecutor;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchMode;
import com.intellij.openapi.vcs.changes.patch.UnshelvePatchDefaultExecutor;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFilePatch;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.openapi.vcs.changes.ui.ChangeListChooser;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collections;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnshelveWithDialogAction
extends DumbAwareAction {
    public void actionPerformed(AnActionEvent e) {
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        ShelvedChangeList[] changeLists = (ShelvedChangeList[])e.getData(ShelvedChangesViewManager.SHELVED_CHANGELIST_KEY);
        if (project2 == null || changeLists == null || changeLists.length == 0) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        if (changeLists.length > 1) {
            UnshelveWithDialogAction.unshelveMultipleShelveChangeLists((List)e.getData(ShelvedChangesViewManager.SHELVED_CHANGE_KEY), project2, changeLists, (List)e.getData(ShelvedChangesViewManager.SHELVED_BINARY_FILE_KEY));
        } else {
            ShelvedChangeList changeList = changeLists[0];
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(changeList.PATH));
            if (virtualFile == null) {
                VcsBalloonProblemNotifier.showOverChangesView(project2, "Can not find path file", MessageType.ERROR, new NamedRunnable[0]);
                return;
            }
            List binaryShelvedPatches = ContainerUtil.map(changeList.getBinaryFiles(), (Function)new Function<ShelvedBinaryFile, ShelvedBinaryFilePatch>(){

                public ShelvedBinaryFilePatch fun(ShelvedBinaryFile file2) {
                    return new ShelvedBinaryFilePatch(file2);
                }
            });
            MyUnshelveDialog dialog = new MyUnshelveDialog(project2, virtualFile, changeList, binaryShelvedPatches, (Change[])e.getData(VcsDataKeys.CHANGES));
            dialog.setHelpId("reference.dialogs.vcs.unshelve");
            dialog.show();
        }
    }

    private static void unshelveMultipleShelveChangeLists(@Nullable List<ShelvedChange> changes, final @NotNull Project project2, final @NotNull ShelvedChangeList[] changeLists, @Nullable List<ShelvedBinaryFile> binaryFiles) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/shelf/UnshelveWithDialogAction", "unshelveMultipleShelveChangeLists"));
        }
        if (changeLists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeLists", "com/intellij/openapi/vcs/changes/shelf/UnshelveWithDialogAction", "unshelveMultipleShelveChangeLists"));
        }
        String defaultName = changeLists[0].DESCRIPTION;
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project2);
        final ChangeListChooser chooser = new ChangeListChooser(project2, changeListManager.getChangeListsCopy(), (ChangeList)changeListManager.getDefaultChangeList(), VcsBundle.message((String)"unshelve.changelist.chooser.title", (Object[])new Object[0]), defaultName){

            @Nullable
            protected JComponent createSouthPanel() {
                return 2.addDoNotShowCheckBox((JComponent)((JComponent)ObjectUtils.assertNotNull((Object)super.createSouthPanel())), (JCheckBox)UnshelveWithDialogAction.createRemoveFilesStrategyCheckbox(project2));
            }
        };
        if (!chooser.showAndGet()) {
            return;
        }
        final List<ShelvedBinaryFile> finalBinaryFiles = binaryFiles == null || binaryFiles.isEmpty() ? null : binaryFiles;
        final List<ShelvedChange> finalChanges = changes == null || changes.isEmpty() ? null : changes;
        final ShelveChangesManager shelveChangesManager = ShelveChangesManager.getInstance(project2);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project2, "Unshelve Changes", true, BackgroundFromStartOption.getInstance()){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/shelf/UnshelveWithDialogAction$3", "run"));
                }
                for (ShelvedChangeList changeList : changeLists) {
                    shelveChangesManager.unshelveChangeList(changeList, finalChanges, finalBinaryFiles, chooser.getSelectedList(), true);
                }
            }
        });
    }

    private static boolean hasNotAllSelectedChanges(@NotNull Project project2, @NotNull ShelvedChangeList list, @Nullable Change[] changes) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/shelf/UnshelveWithDialogAction", "hasNotAllSelectedChanges"));
        }
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/vcs/changes/shelf/UnshelveWithDialogAction", "hasNotAllSelectedChanges"));
        }
        return changes != null && list.getChanges(project2).size() + list.getBinaryFiles().size() != changes.length;
    }

    public void update(AnActionEvent e) {
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        ShelvedChangeList[] changes = (ShelvedChangeList[])e.getData(ShelvedChangesViewManager.SHELVED_CHANGELIST_KEY);
        e.getPresentation().setEnabled(project2 != null && changes != null);
    }

    @NotNull
    private static JCheckBox createRemoveFilesStrategyCheckbox(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/shelf/UnshelveWithDialogAction", "createRemoveFilesStrategyCheckbox"));
        }
        final JCheckBox removeOptionCheckBox = new JCheckBox("Remove successfully applied files from the shelf");
        removeOptionCheckBox.setMnemonic(82);
        final ShelveChangesManager shelveChangesManager = ShelveChangesManager.getInstance(project2);
        removeOptionCheckBox.setSelected(shelveChangesManager.isRemoveFilesFromShelf());
        removeOptionCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                shelveChangesManager.setRemoveFilesFromShelf(removeOptionCheckBox.isSelected());
            }
        });
        JCheckBox jCheckBox = removeOptionCheckBox;
        if (jCheckBox == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/UnshelveWithDialogAction", "createRemoveFilesStrategyCheckbox"));
        }
        return jCheckBox;
    }

    private static class MyUnshelveDialog
    extends ApplyPatchDifferentiatedDialog {
        public MyUnshelveDialog(@NotNull Project project2, @NotNull VirtualFile patchFile, @NotNull ShelvedChangeList changeList, @NotNull List<ShelvedBinaryFilePatch> binaryShelvedPatches, @Nullable Change[] preselectedChanges) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/shelf/UnshelveWithDialogAction$MyUnshelveDialog", "<init>"));
            }
            if (patchFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patchFile", "com/intellij/openapi/vcs/changes/shelf/UnshelveWithDialogAction$MyUnshelveDialog", "<init>"));
            }
            if (changeList == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeList", "com/intellij/openapi/vcs/changes/shelf/UnshelveWithDialogAction$MyUnshelveDialog", "<init>"));
            }
            if (binaryShelvedPatches == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binaryShelvedPatches", "com/intellij/openapi/vcs/changes/shelf/UnshelveWithDialogAction$MyUnshelveDialog", "<init>"));
            }
            super(project2, new UnshelvePatchDefaultExecutor(project2, changeList, binaryShelvedPatches), Collections.<ApplyPatchExecutor>emptyList(), ApplyPatchMode.UNSHELVE, patchFile, null, ChangeListUtil.getPredefinedChangeList(changeList.DESCRIPTION, ChangeListManager.getInstance((Project)project2)), binaryShelvedPatches, UnshelveWithDialogAction.hasNotAllSelectedChanges(project2, changeList, preselectedChanges) ? ContainerUtil.newArrayList((Object[])preselectedChanges) : null, changeList.DESCRIPTION);
        }

        @Nullable
        protected JComponent createSouthPanel() {
            return MyUnshelveDialog.addDoNotShowCheckBox((JComponent)((JComponent)ObjectUtils.assertNotNull((Object)super.createSouthPanel())), (JCheckBox)UnshelveWithDialogAction.createRemoveFilesStrategyCheckbox(this.myProject));
        }
    }
}

