/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowser;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserExtender;
import com.intellij.openapi.vcs.changes.ui.SelectedListChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class AlienChangeListBrowser
extends ChangesBrowser
implements ChangesBrowserExtender {
    private final List<Change> myChanges;
    private final AbstractVcs myVcs;

    public AlienChangeListBrowser(Project project2, List<? extends ChangeList> changeLists, List<Change> changes, ChangeList initialListSelection, boolean capableOfExcludingChanges, boolean highlightProblems, AbstractVcs vcs) {
        super(project2, changeLists, changes, initialListSelection, capableOfExcludingChanges, highlightProblems, null, ChangesBrowser.MyUseCase.LOCAL_CHANGES, null);
        this.myChanges = changes;
        this.myVcs = vcs;
        this.rebuildList();
    }

    @Override
    public void rebuildList() {
        this.myViewer.setChangesToDisplay(this.myChanges == null ? Collections.emptyList() : this.myChanges);
    }

    @Override
    protected void setInitialSelection(List<? extends ChangeList> changeLists, List<Change> changes, ChangeList initialListSelection) {
        if (!changeLists.isEmpty()) {
            this.mySelectedChangeList = changeLists.get(0);
        }
    }

    @Override
    public void addToolbarActions(DialogWrapper dialogWrapper) {
        ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction("AlienCommitChangesDialog.AdditionalActions");
        AnAction[] children2 = group.getChildren(null);
        if (children2 != null) {
            for (AnAction anAction : children2) {
                super.addToolbarAction(anAction);
            }
        }
    }

    @Override
    public void addSelectedListChangeListener(SelectedListChangeListener listener) {
    }

    @Override
    public Collection<AbstractVcs> getAffectedVcses() {
        return Collections.singletonList(this.myVcs);
    }

    @Override
    public List<Change> getCurrentIncludedChanges() {
        return new ArrayList<Change>(this.myChanges);
    }
}

