/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history.impl;

import com.intellij.diff.Block;
import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestPanel;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.MessageDiffRequest;
import com.intellij.diff.requests.NoDiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.FrameWrapper;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.CurrentRevision;
import com.intellij.openapi.vcs.history.VcsDependentHistoryComponents;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.history.impl.CachedRevisionsContents;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.table.TableView;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextArea;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsHistoryDialog
extends FrameWrapper
implements DataProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.history.impl.VcsHistoryDialog");
    private static final VcsRevisionNumber LOCAL_REVISION_NUMBER = new VcsRevisionNumber(){

        public String asString() {
            return "Local Changes";
        }

        public int compareTo(@NotNull VcsRevisionNumber vcsRevisionNumber) {
            if (vcsRevisionNumber == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsRevisionNumber", "com/intellij/openapi/vcs/history/impl/VcsHistoryDialog$1", "compareTo"));
            }
            return 0;
        }

        public String toString() {
            return this.asString();
        }
    };
    private static final ColumnInfo REVISION = new ColumnInfo(VcsBundle.message((String)"column.name.revision.version", (Object[])new Object[0])){

        public Object valueOf(Object object) {
            return ((VcsFileRevision)object).getRevisionNumber();
        }
    };
    private static final ColumnInfo DATE = new ColumnInfo(VcsBundle.message((String)"column.name.revision.list.date", (Object[])new Object[0])){

        public Object valueOf(Object object) {
            Date date = ((VcsFileRevision)object).getRevisionDate();
            if (date == null) {
                return "";
            }
            return DateFormatUtil.formatPrettyDateTime((Date)date);
        }
    };
    private static final ColumnInfo MESSAGE = new ColumnInfo(VcsBundle.message((String)"column.name.revision.list.message", (Object[])new Object[0])){

        public Object valueOf(Object object) {
            return ((VcsFileRevision)object).getCommitMessage();
        }
    };
    private static final ColumnInfo AUTHOR = new ColumnInfo(VcsBundle.message((String)"column.name.revision.list.author", (Object[])new Object[0])){

        public Object valueOf(Object object) {
            return ((VcsFileRevision)object).getAuthor();
        }
    };
    private static final ColumnInfo[] COLUMNS = new ColumnInfo[]{REVISION, DATE, AUTHOR, MESSAGE};
    private static final float DIFF_SPLITTER_PROPORTION = 0.5f;
    private static final float COMMENTS_SPLITTER_PROPORTION = 0.8f;
    private static final String DIFF_SPLITTER_PROPORTION_KEY = "file.history.selection.diff.splitter.proportion";
    private static final String COMMENTS_SPLITTER_PROPORTION_KEY = "file.history.selection.comments.splitter.proportion";
    private static final Block EMPTY_BLOCK = new Block("", 0, 0);
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private final Editor myEditor;
    @NotNull
    private final AbstractVcs myActiveVcs;
    @NotNull
    private final CachedRevisionsContents myCachedContents;
    private final int mySelectionStart;
    private final int mySelectionEnd;
    @NonNls
    private final String myHelpId;
    private final List<Block> myBlocks;
    private final List<VcsFileRevision> myRevisions;
    private final ListTableModel<VcsFileRevision> myListModel;
    private final TableView<VcsFileRevision> myList;
    private final Splitter mySplitter;
    private final DiffRequestPanel myDiffPanel;
    private final JCheckBox myChangesOnlyCheckBox;
    private final JTextArea myComments;
    private boolean myIsDuringUpdate;
    private boolean myIsDisposed;

    public VcsHistoryDialog(@NotNull Project project2, @NotNull VirtualFile file2, @NotNull Editor editor, @NotNull VcsHistoryProvider vcsHistoryProvider, @NotNull VcsHistorySession session, @NotNull AbstractVcs vcs, int selectionStart, int selectionEnd, @NotNull String title, @NotNull CachedRevisionsContents cachedContents) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/history/impl/VcsHistoryDialog", "<init>"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/history/impl/VcsHistoryDialog", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/vcs/history/impl/VcsHistoryDialog", "<init>"));
        }
        if (vcsHistoryProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsHistoryProvider", "com/intellij/openapi/vcs/history/impl/VcsHistoryDialog", "<init>"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/openapi/vcs/history/impl/VcsHistoryDialog", "<init>"));
        }
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/history/impl/VcsHistoryDialog", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/vcs/history/impl/VcsHistoryDialog", "<init>"));
        }
        if (cachedContents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cachedContents", "com/intellij/openapi/vcs/history/impl/VcsHistoryDialog", "<init>"));
        }
        super(project2);
        this.myBlocks = new ArrayList<Block>();
        this.myRevisions = new ArrayList<VcsFileRevision>();
        this.myChangesOnlyCheckBox = new JCheckBox(VcsBundle.message((String)"checkbox.show.changed.revisions.only", (Object[])new Object[0]));
        this.myComments = new JTextArea();
        this.myIsDuringUpdate = false;
        this.myIsDisposed = false;
        this.myProject = project2;
        this.myFile = file2;
        this.myEditor = editor;
        this.myActiveVcs = vcs;
        this.myCachedContents = cachedContents;
        this.mySelectionStart = selectionStart;
        this.mySelectionEnd = selectionEnd;
        this.myHelpId = (String)ObjectUtils.notNull((Object)vcsHistoryProvider.getHelpId(), (Object)"reference.dialogs.vcs.selection.history");
        JRootPane rootPane = ((RootPaneContainer)((Object)this.getFrame())).getRootPane();
        final VcsDependentHistoryComponents components = vcsHistoryProvider.getUICustomization(session, (JComponent)rootPane);
        Object[] additionalColumns = (ColumnInfo[])ObjectUtils.notNull((Object)components.getColumns(), (Object)ColumnInfo.EMPTY_ARRAY);
        this.myListModel = new ListTableModel((ColumnInfo[])ArrayUtil.mergeArrays((Object[])COLUMNS, (Object[])additionalColumns));
        this.myListModel.setSortable(false);
        this.myList = new TableView(this.myListModel);
        this.myList.getEmptyText().setText(VcsBundle.message((String)"history.empty", (Object[])new Object[0]));
        this.myDiffPanel = DiffManager.getInstance().createRequestPanel(this.myProject, (Disposable)this, this.getFrame());
        this.myRevisions.add((VcsFileRevision)new CurrentRevision(file2, LOCAL_REVISION_NUMBER));
        this.myRevisions.addAll(session.getRevisionList());
        this.myBlocks.addAll(Collections.nCopies(this.myRevisions.size(), null));
        this.mySplitter = new JBSplitter(true, DIFF_SPLITTER_PROPORTION_KEY, 0.5f);
        this.mySplitter.setFirstComponent(this.myDiffPanel.getComponent());
        this.mySplitter.setSecondComponent(this.createBottomPanel(components.getDetailsComponent()));
        ListSelectionListener selectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                VcsFileRevision revision;
                if (VcsHistoryDialog.this.myList.getSelectedRowCount() == 1 && !VcsHistoryDialog.this.myList.isEmpty()) {
                    revision = (VcsFileRevision)VcsHistoryDialog.this.myList.getItems().get(VcsHistoryDialog.this.myList.getSelectedRow());
                    VcsHistoryDialog.this.myComments.setText(revision.getCommitMessage());
                    VcsHistoryDialog.this.myComments.setCaretPosition(0);
                } else {
                    revision = null;
                    VcsHistoryDialog.this.myComments.setText("");
                }
                if (components.getRevisionListener() != null) {
                    components.getRevisionListener().consume((Object)revision);
                }
                VcsHistoryDialog.this.updateDiff();
            }
        };
        this.myList.getSelectionModel().addListSelectionListener(selectionListener);
        final VcsConfiguration configuration = VcsConfiguration.getInstance((Project)this.myProject);
        this.myChangesOnlyCheckBox.setSelected(configuration.SHOW_ONLY_CHANGED_IN_SELECTION_DIFF);
        this.myChangesOnlyCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                configuration.SHOW_ONLY_CHANGED_IN_SELECTION_DIFF = VcsHistoryDialog.this.myChangesOnlyCheckBox.isSelected();
                VcsHistoryDialog.this.updateRevisionsList();
            }
        });
        this.updateRevisionsList();
        this.myList.getSelectionModel().setSelectionInterval(0, 0);
        this.setTitle(title);
        this.setComponent((JComponent)this.mySplitter);
        this.setPreferredFocusedComponent((JComponent)this.myList);
        this.setDimensionKey("VCS.FileHistoryDialog");
        this.closeOnEsc();
    }

    private void canNotLoadRevisionMessage(final VcsException e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!VcsHistoryDialog.this.getFrame().isShowing()) {
                    return;
                }
                PopupUtil.showBalloonForComponent((Component)VcsHistoryDialog.this.getFrame(), (String)VcsHistoryDialog.this.canNoLoadMessage(e), (MessageType)MessageType.ERROR, (boolean)true, (Disposable)VcsHistoryDialog.this.myProject);
            }
        });
    }

    private String canNoLoadMessage(VcsException e) {
        return "Can not load revision contents: " + e.getMessage();
    }

    protected String getContentOf(VcsFileRevision revision) throws VcsException {
        return this.myCachedContents.getContentOf(revision);
    }

    private void loadContentsFor(VcsFileRevision[] revisions) throws VcsException {
        this.myCachedContents.loadContentsFor(revisions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRevisionsList() {
        if (this.myIsDuringUpdate) {
            return;
        }
        try {
            List<VcsFileRevision> newItems;
            this.myIsDuringUpdate = true;
            if (this.myChangesOnlyCheckBox.isSelected()) {
                try {
                    this.loadContentsFor(this.myRevisions.toArray(new VcsFileRevision[this.myRevisions.size()]));
                    newItems = this.filteredRevisions();
                }
                catch (VcsException e) {
                    this.canNotLoadRevisionMessage(e);
                    this.myIsDuringUpdate = false;
                    return;
                }
            } else {
                newItems = this.myRevisions;
            }
            List<VcsFileRevision> oldSelection = this.getSelectedRevisions();
            this.myListModel.setItems(newItems);
            this.myList.setSelection(oldSelection);
            if (this.myList.getSelectedRowCount() == 0) {
                int index = this.getNearestVisibleRevision((VcsFileRevision)ContainerUtil.getFirstItem(oldSelection));
                this.myList.getSelectionModel().setSelectionInterval(index, index);
            }
        }
        finally {
            this.myIsDuringUpdate = false;
        }
        this.updateDiff();
    }

    @NotNull
    private List<VcsFileRevision> getSelectedRevisions() {
        int minIndex = this.myList.getSelectionModel().getMinSelectionIndex();
        int maxIndex = this.myList.getSelectionModel().getMaxSelectionIndex();
        VcsFileRevision minRevision = minIndex != -1 ? (VcsFileRevision)this.myList.getRow(minIndex) : null;
        VcsFileRevision maxRevision = maxIndex != -1 ? (VcsFileRevision)this.myList.getRow(maxIndex) : null;
        int startIndex = this.myRevisions.indexOf(minRevision);
        int endIndex = this.myRevisions.indexOf(maxRevision);
        List<VcsFileRevision> list = startIndex != -1 && endIndex != -1 ? this.myRevisions.subList(startIndex, endIndex + 1) : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/history/impl/VcsHistoryDialog", "getSelectedRevisions"));
        }
        return list;
    }

    private int getNearestVisibleRevision(@Nullable VcsFileRevision anchor) {
        int anchorIndex = this.myRevisions.indexOf(anchor);
        if (anchorIndex == -1) {
            return 0;
        }
        for (int i = anchorIndex - 1; i > 0; --i) {
            int index = this.myListModel.indexOf((Object)this.myRevisions.get(i));
            if (index == -1) continue;
            return index;
        }
        return 0;
    }

    private List<VcsFileRevision> filteredRevisions() throws VcsException {
        int firstRevision;
        ArrayList<VcsFileRevision> result = new ArrayList<VcsFileRevision>();
        for (firstRevision = this.myRevisions.size() - 1; firstRevision > 0 && this.getBlock(firstRevision) == EMPTY_BLOCK; --firstRevision) {
        }
        result.add(this.myRevisions.get(firstRevision));
        for (int i = firstRevision - 1; i >= 0; --i) {
            Block block1 = this.getBlock(i + 1);
            Block block2 = this.getBlock(i);
            if (block1.getLines().equals(block2.getLines())) continue;
            result.add(this.myRevisions.get(i));
        }
        Collections.reverse(result);
        return result;
    }

    private void updateDiff() {
        if (this.myIsDisposed || this.myIsDuringUpdate) {
            return;
        }
        List selected = this.myList.getSelectedObjects();
        if (selected.isEmpty()) {
            this.myDiffPanel.setRequest((DiffRequest)NoDiffRequest.INSTANCE);
        } else if (selected.size() == 1) {
            VcsFileRevision revision = (VcsFileRevision)selected.get(0);
            int index = this.myRevisions.indexOf(revision);
            this.myDiffPanel.setRequest(this.createDiffRequest(index + 1, index));
        } else {
            VcsFileRevision revision1 = (VcsFileRevision)selected.get(0);
            VcsFileRevision revision2 = (VcsFileRevision)selected.get(selected.size() - 1);
            this.myDiffPanel.setRequest(this.createDiffRequest(this.myRevisions.indexOf(revision2) + 1, this.myRevisions.indexOf(revision1)));
        }
    }

    @NotNull
    private DiffRequest createDiffRequest(int revIndex1, int revIndex2) {
        SimpleDiffRequest simpleDiffRequest;
        block6: {
            block5: {
                NoDiffRequest noDiffRequest;
                try {
                    int count = this.myRevisions.size();
                    if (revIndex1 != count || revIndex2 != count) break block5;
                    noDiffRequest = NoDiffRequest.INSTANCE;
                }
                catch (VcsException e) {
                    MessageDiffRequest messageDiffRequest = new MessageDiffRequest(this.canNoLoadMessage(e));
                    if (messageDiffRequest == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/history/impl/VcsHistoryDialog", "createDiffRequest"));
                    }
                    return messageDiffRequest;
                }
                if (noDiffRequest == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/history/impl/VcsHistoryDialog", "createDiffRequest"));
                }
                return noDiffRequest;
            }
            DiffContent content1 = this.createDiffContent(revIndex1);
            DiffContent content2 = this.createDiffContent(revIndex2);
            String title1 = this.createDiffContentTitle(revIndex1);
            String title2 = this.createDiffContentTitle(revIndex2);
            simpleDiffRequest = new SimpleDiffRequest(null, content1, content2, title1, title2);
            if (simpleDiffRequest != null) break block6;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/history/impl/VcsHistoryDialog", "createDiffRequest"));
        }
        return simpleDiffRequest;
    }

    @Nullable
    private String createDiffContentTitle(int index) {
        if (index >= this.myRevisions.size()) {
            return null;
        }
        return VcsBundle.message((String)"diff.content.title.revision.number", (Object[])new Object[]{this.myRevisions.get(index).getRevisionNumber()});
    }

    @NotNull
    private DiffContent createDiffContent(int index) throws VcsException {
        if (index >= this.myRevisions.size()) {
            EmptyContent emptyContent = DiffContentFactory.getInstance().createEmpty();
            if (emptyContent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/history/impl/VcsHistoryDialog", "createDiffContent"));
            }
            return emptyContent;
        }
        if (this.getBlock(index) == EMPTY_BLOCK) {
            EmptyContent emptyContent = DiffContentFactory.getInstance().createEmpty();
            if (emptyContent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/history/impl/VcsHistoryDialog", "createDiffContent"));
            }
            return emptyContent;
        }
        DocumentContent documentContent = DiffContentFactory.getInstance().create(this.getBlock(index).getBlockContent(), this.myFile.getFileType());
        if (documentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/history/impl/VcsHistoryDialog", "createDiffContent"));
        }
        return documentContent;
    }

    @Override
    public void dispose() {
        this.myIsDisposed = true;
        super.dispose();
    }

    private JComponent createBottomPanel(JComponent addComp) {
        JBSplitter splitter = new JBSplitter(true, COMMENTS_SPLITTER_PROPORTION_KEY, 0.8f);
        splitter.setDividerWidth(4);
        JPanel tablePanel = new JPanel(new BorderLayout());
        tablePanel.add((Component)ScrollPaneFactory.createScrollPane(this.myList), "Center");
        tablePanel.add((Component)this.myChangesOnlyCheckBox, "North");
        splitter.setFirstComponent((JComponent)tablePanel);
        splitter.setSecondComponent(this.createComments(addComp));
        return splitter;
    }

    private JComponent createComments(JComponent addComp) {
        JLabel label = new JLabel("Commit Message:");
        JPanel panel = new JPanel(new BorderLayout(4, 4));
        panel.add((Component)label, "North");
        panel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myComments), "Center");
        this.myComments.setRows(5);
        this.myComments.setEditable(false);
        this.myComments.setLineWrap(true);
        Splitter splitter = new Splitter(false);
        splitter.setFirstComponent((JComponent)panel);
        splitter.setSecondComponent(addComp);
        return splitter;
    }

    @Override
    public Object getData(@NonNls String dataId) {
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        if (VcsDataKeys.VCS_VIRTUAL_FILE.is(dataId)) {
            return this.myFile;
        }
        if (VcsDataKeys.VCS_FILE_REVISION.is(dataId)) {
            return this.myList.getSelectedObject();
        }
        if (VcsDataKeys.VCS.is(dataId)) {
            return this.myActiveVcs.getKeyInstanceMethod();
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return this.myHelpId;
        }
        return null;
    }

    private void ensureBlocksCreated(int requiredIndex) throws VcsException {
        for (int i = 0; i <= requiredIndex; ++i) {
            if (this.myBlocks.get(i) != null) continue;
            this.myBlocks.set(i, this.createBlock(i));
        }
    }

    @NotNull
    private Block createBlock(int index) throws VcsException {
        if (index == 0) {
            Block block = new Block(this.myEditor.getDocument().getText(), this.mySelectionStart, this.mySelectionEnd + 1);
            if (block == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/history/impl/VcsHistoryDialog", "createBlock"));
            }
            return block;
        }
        Block previousBlock = this.myBlocks.get(index - 1);
        if (previousBlock == EMPTY_BLOCK) {
            Block block = EMPTY_BLOCK;
            if (block == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/history/impl/VcsHistoryDialog", "createBlock"));
            }
            return block;
        }
        String revisionContent = this.getContentOf(this.myRevisions.get(index));
        if (revisionContent == null) {
            Block block = EMPTY_BLOCK;
            if (block == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/history/impl/VcsHistoryDialog", "createBlock"));
            }
            return block;
        }
        Block newBlock = previousBlock.createPreviousBlock(revisionContent);
        Block block = newBlock.getStart() != newBlock.getEnd() ? newBlock : EMPTY_BLOCK;
        if (block == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/history/impl/VcsHistoryDialog", "createBlock"));
        }
        return block;
    }

    @NotNull
    private Block getBlock(int index) throws VcsException {
        if (this.myBlocks.get(index) == null) {
            this.ensureBlocksCreated(index);
        }
        Block block = this.myBlocks.get(index);
        if (block == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/history/impl/VcsHistoryDialog", "getBlock"));
        }
        return block;
    }
}

