/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.http;

import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsBundle;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.FileDownloadingAdapter;
import com.intellij.openapi.vfs.impl.http.FileDownloadingListener;
import com.intellij.openapi.vfs.impl.http.RemoteContentProvider;
import com.intellij.openapi.vfs.impl.http.RemoteFileInfo;
import com.intellij.openapi.vfs.impl.http.RemoteFileManagerImpl;
import com.intellij.openapi.vfs.impl.http.RemoteFileState;
import com.intellij.util.Url;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public class RemoteFileInfoImpl
implements RemoteContentProvider.DownloadingCallback,
RemoteFileInfo {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.impl.http.RemoteFileInfoImpl");
    private final Object myLock;
    private final Url myUrl;
    private final RemoteFileManagerImpl myManager;
    @Nullable
    private RemoteContentProvider myContentProvider;
    private File myLocalFile;
    private VirtualFile myLocalVirtualFile;
    private VirtualFile myPrevLocalFile;
    private RemoteFileState myState;
    private String myErrorMessage;
    private final AtomicBoolean myCancelled;
    private final List<FileDownloadingListener> myListeners;

    public RemoteFileInfoImpl(@NotNull Url url, @NotNull RemoteFileManagerImpl manager) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/vfs/impl/http/RemoteFileInfoImpl", "<init>"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/openapi/vfs/impl/http/RemoteFileInfoImpl", "<init>"));
        }
        this.myLock = new Object();
        this.myState = RemoteFileState.DOWNLOADING_NOT_STARTED;
        this.myCancelled = new AtomicBoolean();
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myUrl = url;
        this.myManager = manager;
    }

    @Override
    public void addDownloadingListener(@NotNull FileDownloadingListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/vfs/impl/http/RemoteFileInfoImpl", "addDownloadingListener"));
        }
        this.myListeners.add(listener);
    }

    @Override
    public void removeDownloadingListener(@NotNull FileDownloadingListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/vfs/impl/http/RemoteFileInfoImpl", "removeDownloadingListener"));
        }
        this.myListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restartDownloading() {
        Object object = this.myLock;
        synchronized (object) {
            this.myErrorMessage = null;
            this.myPrevLocalFile = this.myLocalVirtualFile;
            this.myLocalVirtualFile = null;
            this.myState = RemoteFileState.DOWNLOADING_NOT_STARTED;
            this.myLocalFile = null;
            this.startDownloading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startDownloading() {
        File localFile;
        LOG.debug("Downloading requested");
        Iterator<FileDownloadingListener> iterator = this.myLock;
        synchronized (iterator) {
            if (this.myState != RemoteFileState.DOWNLOADING_NOT_STARTED) {
                LOG.debug("File already downloaded: file = " + this.myLocalVirtualFile + ", state = " + (Object)((Object)this.myState));
                return;
            }
            this.myState = RemoteFileState.DOWNLOADING_IN_PROGRESS;
            try {
                this.myLocalFile = this.myManager.getStorage().createLocalFile(this.myUrl);
                LOG.debug("Local file created: " + this.myLocalFile.getAbsolutePath());
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                this.errorOccurred(VfsBundle.message((String)"cannot.create.local.file", (Object[])new Object[]{e.getMessage()}), false);
                return;
            }
            this.myCancelled.set(false);
            localFile = this.myLocalFile;
        }
        for (FileDownloadingListener listener : this.myListeners) {
            listener.downloadingStarted();
        }
        if (this.myContentProvider == null) {
            this.myContentProvider = this.myManager.findContentProvider(this.myUrl);
        }
        this.myContentProvider.saveContent(this.myUrl, localFile, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finished(@Nullable FileType fileType) {
        File localIOFile;
        Object object = this.myLock;
        synchronized (object) {
            LOG.debug("Downloading finished, size = " + this.myLocalFile.length() + ", file type=" + (fileType != null ? fileType.getName() : "null"));
            if (fileType != null) {
                String fileName = this.myLocalFile.getName();
                int dot = fileName.lastIndexOf(46);
                String extension = fileType.getDefaultExtension();
                if (dot == -1 || !extension.regionMatches(true, 0, fileName, dot + 1, extension.length())) {
                    File newFile = FileUtil.findSequentNonexistentFile((File)this.myLocalFile.getParentFile(), (String)fileName, (String)extension);
                    try {
                        FileUtil.rename((File)this.myLocalFile, (File)newFile);
                        this.myLocalFile = newFile;
                    }
                    catch (IOException e) {
                        LOG.debug((Throwable)e);
                    }
                }
            }
            localIOFile = this.myLocalFile;
        }
        VirtualFile localFile = (VirtualFile)new WriteAction<VirtualFile>(){

            protected void run(@NotNull Result<VirtualFile> result) {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/vfs/impl/http/RemoteFileInfoImpl$1", "run"));
                }
                VirtualFile file2 = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(localIOFile);
                if (file2 != null) {
                    file2.refresh(false, false);
                }
                result.setResult((Object)file2);
            }
        }.execute().getResultObject();
        LOG.assertTrue(localFile != null, (Object)("Virtual local file not found for " + localIOFile.getAbsolutePath()));
        LOG.debug("Virtual local file: " + localFile + ", size = " + localFile.getLength());
        Iterator<FileDownloadingListener> iterator = this.myLock;
        synchronized (iterator) {
            this.myLocalVirtualFile = localFile;
            this.myPrevLocalFile = null;
            this.myState = RemoteFileState.DOWNLOADED;
            this.myErrorMessage = null;
        }
        for (FileDownloadingListener listener : this.myListeners) {
            listener.fileDownloaded(localFile);
        }
    }

    @Override
    public boolean isCancelled() {
        return this.myCancelled.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getErrorMessage() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myErrorMessage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void errorOccurred(@NotNull String errorMessage, boolean cancelled) {
        if (errorMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/openapi/vfs/impl/http/RemoteFileInfoImpl", "errorOccurred"));
        }
        LOG.debug("Error: " + errorMessage);
        Iterator<FileDownloadingListener> iterator = this.myLock;
        synchronized (iterator) {
            this.myLocalVirtualFile = null;
            this.myPrevLocalFile = null;
            this.myState = RemoteFileState.ERROR_OCCURRED;
            this.myErrorMessage = errorMessage;
        }
        for (FileDownloadingListener listener : this.myListeners) {
            if (cancelled) continue;
            listener.errorOccurred(errorMessage);
        }
    }

    @Override
    public void setProgressFraction(double fraction) {
        for (FileDownloadingListener listener : this.myListeners) {
            listener.progressFractionChanged(fraction);
        }
    }

    @Override
    public void setProgressText(@NotNull String text, boolean indeterminate) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/vfs/impl/http/RemoteFileInfoImpl", "setProgressText"));
        }
        for (FileDownloadingListener listener : this.myListeners) {
            listener.progressMessageChanged(indeterminate, text);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualFile getLocalFile() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myLocalVirtualFile;
        }
    }

    public String toString() {
        String errorMessage = this.getErrorMessage();
        return "state=" + (Object)((Object)this.getState()) + ", local file=" + this.myLocalFile + (errorMessage != null ? ", error=" + errorMessage : "") + (this.isCancelled() ? ", cancelled" : "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteFileState getState() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelDownloading() {
        Iterator<FileDownloadingListener> iterator = this.myLock;
        synchronized (iterator) {
            this.myCancelled.set(true);
            if (this.myPrevLocalFile != null) {
                this.myLocalVirtualFile = this.myPrevLocalFile;
                this.myLocalFile = VfsUtilCore.virtualToIoFile((VirtualFile)this.myLocalVirtualFile);
                this.myState = RemoteFileState.DOWNLOADED;
                this.myErrorMessage = null;
            } else {
                this.myState = RemoteFileState.ERROR_OCCURRED;
            }
        }
        for (FileDownloadingListener listener : this.myListeners) {
            listener.downloadingCancelled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(@Nullable Runnable postRunnable) {
        VirtualFile localVirtualFile;
        Object object = this.myLock;
        synchronized (object) {
            localVirtualFile = this.myLocalVirtualFile;
        }
        RemoteContentProvider contentProvider = this.myManager.findContentProvider(this.myUrl);
        if (localVirtualFile == null || !contentProvider.equals(this.myContentProvider) || !contentProvider.isUpToDate(this.myUrl, localVirtualFile)) {
            this.myContentProvider = contentProvider;
            this.addDownloadingListener(new MyRefreshingDownloadingListener(postRunnable));
            this.restartDownloading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public Promise<VirtualFile> download() {
        Object object = this.myLock;
        // MONITORENTER : object
        switch (this.getState()) {
            case DOWNLOADING_NOT_STARTED: {
                this.startDownloading();
                Promise<VirtualFile> promise2 = RemoteFileInfoImpl.createDownloadedCallback(this);
                // MONITOREXIT : object
                if (promise2 != null) return promise2;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/http/RemoteFileInfoImpl", "download"));
            }
            case DOWNLOADING_IN_PROGRESS: {
                Promise<VirtualFile> promise3 = RemoteFileInfoImpl.createDownloadedCallback(this);
                // MONITOREXIT : object
                if (promise3 != null) return promise3;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/http/RemoteFileInfoImpl", "download"));
            }
            case DOWNLOADED: {
                Promise promise4 = Promise.resolve((Object)this.myLocalVirtualFile);
                // MONITOREXIT : object
                if (promise4 != null) return promise4;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/http/RemoteFileInfoImpl", "download"));
            }
        }
        Promise promise5 = Promise.reject((String)"errorOccured");
        // MONITOREXIT : object
        if (promise5 != null) return promise5;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/http/RemoteFileInfoImpl", "download"));
    }

    @NotNull
    private static Promise<VirtualFile> createDownloadedCallback(final @NotNull RemoteFileInfo remoteFileInfo) {
        if (remoteFileInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteFileInfo", "com/intellij/openapi/vfs/impl/http/RemoteFileInfoImpl", "createDownloadedCallback"));
        }
        final AsyncPromise promise2 = new AsyncPromise();
        remoteFileInfo.addDownloadingListener(new FileDownloadingAdapter(){

            @Override
            public void fileDownloaded(VirtualFile localFile) {
                try {
                    remoteFileInfo.removeDownloadingListener(this);
                }
                finally {
                    promise2.setResult((Object)localFile);
                }
            }

            @Override
            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/openapi/vfs/impl/http/RemoteFileInfoImpl$2", "errorOccurred"));
                }
                try {
                    remoteFileInfo.removeDownloadingListener(this);
                }
                finally {
                    promise2.setError(errorMessage);
                }
            }

            @Override
            public void downloadingCancelled() {
                try {
                    remoteFileInfo.removeDownloadingListener(this);
                }
                finally {
                    promise2.setError("Cancelled");
                }
            }
        });
        AsyncPromise asyncPromise = promise2;
        if (asyncPromise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/http/RemoteFileInfoImpl", "createDownloadedCallback"));
        }
        return asyncPromise;
    }

    private class MyRefreshingDownloadingListener
    extends FileDownloadingAdapter {
        private final Runnable myPostRunnable;

        public MyRefreshingDownloadingListener(Runnable postRunnable) {
            this.myPostRunnable = postRunnable;
        }

        @Override
        public void downloadingCancelled() {
            RemoteFileInfoImpl.this.removeDownloadingListener(this);
            if (this.myPostRunnable != null) {
                this.myPostRunnable.run();
            }
        }

        @Override
        public void fileDownloaded(VirtualFile localFile) {
            RemoteFileInfoImpl.this.removeDownloadingListener(this);
            if (this.myPostRunnable != null) {
                this.myPostRunnable.run();
            }
        }

        @Override
        public void errorOccurred(@NotNull String errorMessage) {
            if (errorMessage == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/openapi/vfs/impl/http/RemoteFileInfoImpl$MyRefreshingDownloadingListener", "errorOccurred"));
            }
            RemoteFileInfoImpl.this.removeDownloadingListener(this);
            if (this.myPostRunnable != null) {
                this.myPostRunnable.run();
            }
        }
    }
}

