/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies;

import com.intellij.icons.AllIcons;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;

public class DependenciesToolWindow {
    private final Project myProject;
    private ContentManager myContentManager;

    public static DependenciesToolWindow getInstance(Project project2) {
        return (DependenciesToolWindow)ServiceManager.getService((Project)project2, DependenciesToolWindow.class);
    }

    public DependenciesToolWindow(final Project project2) {
        this.myProject = project2;
        StartupManager.getInstance((Project)project2).runWhenProjectIsInitialized(new Runnable(){

            @Override
            public void run() {
                ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)DependenciesToolWindow.this.myProject);
                if (toolWindowManager == null) {
                    return;
                }
                ToolWindow toolWindow = toolWindowManager.registerToolWindow(ToolWindowId.DEPENDENCIES, true, ToolWindowAnchor.BOTTOM, (Disposable)project2);
                DependenciesToolWindow.this.myContentManager = toolWindow.getContentManager();
                toolWindow.setIcon(AllIcons.Toolwindows.ToolWindowInspection);
                new ContentManagerWatcher(toolWindow, DependenciesToolWindow.this.myContentManager);
            }
        });
    }

    public void addContent(final Content content) {
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                DependenciesToolWindow.this.myContentManager.addContent(content);
                DependenciesToolWindow.this.myContentManager.setSelectedContent(content);
                ToolWindowManager.getInstance((Project)DependenciesToolWindow.this.myProject).getToolWindow(ToolWindowId.DEPENDENCIES).activate(null);
            }
        };
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(runnable2);
    }

    public void closeContent(Content content) {
        this.myContentManager.removeContent(content, true);
    }
}

