/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.ui;

import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.ui.FileNode;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.file.DirectoryIconProvider;
import com.intellij.psi.search.scope.packageSet.FilePatternPackageSet;
import com.intellij.util.PlatformIcons;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class DirectoryNode
extends PackageDependenciesNode {
    private final String myDirName;
    private PsiDirectory myDirectory;
    private DirectoryNode myCompactedDirNode;
    private DirectoryNode myWrapper;
    private boolean myCompactPackages = true;
    private String myFQName = null;
    private final VirtualFile myVDirectory;

    public DirectoryNode(VirtualFile aDirectory, Project project2, boolean compactPackages, boolean showFQName, VirtualFile baseDir, VirtualFile[] contentRoots) {
        super(project2);
        this.myVDirectory = aDirectory;
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project2);
        ProjectFileIndex index = projectRootManager.getFileIndex();
        String dirName = aDirectory.getName();
        if (showFQName) {
            VirtualFile contentRoot = index.getContentRootForFile(this.myVDirectory);
            if (contentRoot != null) {
                VirtualFile sourceRoot;
                this.myFQName = Comparing.equal((Object)this.myVDirectory, (Object)contentRoot) ? dirName : (Comparing.equal((Object)this.myVDirectory, (Object)(sourceRoot = index.getSourceRootForFile(this.myVDirectory))) ? VfsUtilCore.getRelativePath((VirtualFile)this.myVDirectory, (VirtualFile)contentRoot, (char)'/') : (sourceRoot != null ? VfsUtilCore.getRelativePath((VirtualFile)this.myVDirectory, (VirtualFile)sourceRoot, (char)'/') : VfsUtilCore.getRelativePath((VirtualFile)this.myVDirectory, (VirtualFile)contentRoot, (char)'/')));
                if (contentRoots.length > 1 && ProjectRootsUtil.isModuleContentRoot(this.myVDirectory, project2)) {
                    this.myFQName = this.getContentRootName(baseDir, this.myFQName);
                }
            } else {
                this.myFQName = FilePatternPackageSet.getLibRelativePath((VirtualFile)this.myVDirectory, (ProjectFileIndex)index);
            }
            dirName = this.myFQName;
        } else if (contentRoots.length > 1 && ProjectRootsUtil.isModuleContentRoot(this.myVDirectory, project2)) {
            dirName = this.getContentRootName(baseDir, dirName);
        }
        this.myDirName = dirName;
        this.myCompactPackages = compactPackages;
    }

    private String getContentRootName(VirtualFile baseDir, String dirName) {
        if (baseDir != null) {
            if (!Comparing.equal((Object)this.myVDirectory, (Object)baseDir)) {
                if (VfsUtil.isAncestor((VirtualFile)baseDir, (VirtualFile)this.myVDirectory, (boolean)false)) {
                    return VfsUtilCore.getRelativePath((VirtualFile)this.myVDirectory, (VirtualFile)baseDir, (char)'/');
                }
                return this.myVDirectory.getPresentableUrl();
            }
        } else {
            return this.myVDirectory.getPresentableUrl();
        }
        return dirName;
    }

    @Override
    public void fillFiles(Set<PsiFile> set, boolean recursively) {
        super.fillFiles(set, recursively);
        int count = this.getChildCount();
        Boolean isRoot = null;
        for (int i = 0; i < count; ++i) {
            PackageDependenciesNode child = (PackageDependenciesNode)this.getChildAt(i);
            if (child instanceof FileNode || recursively) {
                child.fillFiles(set, true);
                continue;
            }
            if (!(child instanceof DirectoryNode)) continue;
            if (isRoot == null) {
                isRoot = this.isContentOrSourceRoot();
            }
            if (!isRoot.booleanValue()) continue;
            child.fillFiles(set, false);
        }
    }

    public boolean isContentOrSourceRoot() {
        if (this.myVDirectory != null) {
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
            VirtualFile contentRoot = fileIndex.getContentRootForFile(this.myVDirectory);
            VirtualFile sourceRoot = fileIndex.getSourceRootForFile(this.myVDirectory);
            if (this.myVDirectory.equals(contentRoot) || this.myVDirectory.equals(sourceRoot)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        if (this.myFQName != null) {
            return this.myFQName;
        }
        if (this.myCompactPackages && this.myCompactedDirNode != null) {
            return this.myDirName + "/" + this.myCompactedDirNode.getDirName();
        }
        return this.myDirName;
    }

    public String getDirName() {
        if (this.myVDirectory == null || !this.myVDirectory.isValid()) {
            return "";
        }
        if (this.myCompactPackages && this.myCompactedDirNode != null) {
            return this.myVDirectory.getName() + "/" + this.myCompactedDirNode.getDirName();
        }
        return this.myDirName;
    }

    public String getFQName() {
        VirtualFile directory = this.myVDirectory;
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        VirtualFile contentRoot = index.getContentRootForFile(directory);
        if (Comparing.equal((Object)directory, (Object)contentRoot)) {
            return "";
        }
        if (contentRoot == null) {
            return "";
        }
        return VfsUtilCore.getRelativePath((VirtualFile)directory, (VirtualFile)contentRoot, (char)'/');
    }

    @Override
    public PsiElement getPsiElement() {
        return this.getTargetDirectory();
    }

    @Nullable
    private PsiDirectory getPsiDirectory() {
        if (this.myDirectory == null && this.myVDirectory.isValid() && !this.myProject.isDisposed()) {
            this.myDirectory = PsiManager.getInstance((Project)this.myProject).findDirectory(this.myVDirectory);
        }
        return this.myDirectory;
    }

    public PsiDirectory getTargetDirectory() {
        DirectoryNode compacted;
        DirectoryNode dirNode = this;
        while ((compacted = dirNode.getCompactedDirNode()) != null) {
            dirNode = compacted;
        }
        return dirNode.getPsiDirectory();
    }

    @Override
    public int getWeight() {
        return 3;
    }

    public boolean equals(Object o) {
        if (this.isEquals()) {
            return super.equals(o);
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof DirectoryNode)) {
            return false;
        }
        DirectoryNode packageNode = (DirectoryNode)o;
        return this.toString().equals(packageNode.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public Icon getIcon() {
        if (this.myVDirectory != null) {
            VirtualFile jarRoot = JarFileSystem.getInstance().getRootByEntry(this.myVDirectory);
            return this.myVDirectory.equals(jarRoot) ? PlatformIcons.JAR_ICON : DirectoryIconProvider.getDirectoryIcon(this.myVDirectory, this.myProject);
        }
        return PlatformIcons.PACKAGE_ICON;
    }

    public void setCompactedDirNode(DirectoryNode compactedDirNode) {
        if (this.myCompactedDirNode != null) {
            this.myCompactedDirNode.myWrapper = null;
        }
        this.myCompactedDirNode = compactedDirNode;
        if (this.myCompactedDirNode != null) {
            this.myCompactedDirNode.myWrapper = this;
        }
    }

    public DirectoryNode getWrapper() {
        return this.myWrapper;
    }

    @Nullable
    public DirectoryNode getCompactedDirNode() {
        return this.myCompactPackages ? this.myCompactedDirNode : null;
    }

    public void removeUpReference() {
        this.myWrapper = null;
    }

    @Override
    public boolean isValid() {
        return this.myVDirectory != null && this.myVDirectory.isValid();
    }

    @Override
    public boolean canNavigate() {
        return false;
    }

    @Override
    public String getComment() {
        PsiDirectory directory;
        if (this.myVDirectory != null && this.myVDirectory.isValid() && !this.myProject.isDisposed() && (directory = this.getPsiDirectory()) != null) {
            return ProjectViewDirectoryHelper.getInstance(this.myProject).getLocationString(directory);
        }
        return super.getComment();
    }

    @Override
    public boolean canSelectInLeftTree(Map<PsiFile, Set<PsiFile>> deps) {
        Set<PsiFile> files = deps.keySet();
        for (PsiFile file2 : files) {
            if (file2.getContainingDirectory() != this.getPsiDirectory()) continue;
            return true;
        }
        return false;
    }

    public VirtualFile getDirectory() {
        return this.myVDirectory;
    }
}

