/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocationNameFieldsBinding {
    private boolean myModifyingLocation = false;
    private boolean myModifyingProjectName = false;
    private boolean myExternalModify = false;
    private String myBaseDir;
    private String mySuggestedProjectName;

    public LocationNameFieldsBinding(@Nullable Project project2, final TextFieldWithBrowseButton locationField, final JTextField nameField, String baseDir, String title) {
        this.myBaseDir = baseDir;
        File suggestedProjectDirectory = FileUtil.findSequentNonexistentFile((File)new File(baseDir), (String)"untitled", (String)"");
        locationField.setText(suggestedProjectDirectory.toString());
        nameField.setDocument(new NameFieldDocument(nameField, locationField));
        this.mySuggestedProjectName = suggestedProjectDirectory.getName();
        nameField.setText(this.mySuggestedProjectName);
        nameField.selectAll();
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        ComponentWithBrowseButton.BrowseFolderActionListener<JTextField> listener = new ComponentWithBrowseButton.BrowseFolderActionListener<JTextField>(title, "", (ComponentWithBrowseButton)locationField, project2, descriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT){

            protected void onFileChosen(@NotNull VirtualFile chosenFile) {
                if (chosenFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chosenFile", "com/intellij/platform/LocationNameFieldsBinding$1", "onFileChosen"));
                }
                LocationNameFieldsBinding.this.myBaseDir = chosenFile.getPath();
                if (LocationNameFieldsBinding.this.isProjectNameChanged(nameField.getText()) && !nameField.getText().equals(chosenFile.getName())) {
                    LocationNameFieldsBinding.this.myExternalModify = true;
                    locationField.setText(new File(chosenFile.getPath(), nameField.getText()).toString());
                    LocationNameFieldsBinding.this.myExternalModify = false;
                } else {
                    LocationNameFieldsBinding.this.myExternalModify = true;
                    locationField.setText(chosenFile.getPath());
                    nameField.setText(chosenFile.getName());
                    LocationNameFieldsBinding.this.myExternalModify = false;
                }
            }
        };
        locationField.addActionListener((ActionListener)listener);
        locationField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (LocationNameFieldsBinding.this.myExternalModify) {
                    return;
                }
                LocationNameFieldsBinding.this.myModifyingLocation = true;
                String path = locationField.getText().trim();
                path = StringUtil.trimEnd((String)path, (String)File.separator);
                int ind = path.lastIndexOf(File.separator);
                if (ind != -1) {
                    String projectName = path.substring(ind + 1, path.length());
                    if (!nameField.getText().trim().isEmpty()) {
                        LocationNameFieldsBinding.this.myBaseDir = path.substring(0, ind);
                    }
                    if (!projectName.equals(nameField.getText()) && !LocationNameFieldsBinding.this.myModifyingProjectName) {
                        nameField.setText(projectName);
                    }
                }
                LocationNameFieldsBinding.this.myModifyingLocation = false;
            }
        });
    }

    private boolean isProjectNameChanged(@NotNull String currentName) {
        if (currentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentName", "com/intellij/platform/LocationNameFieldsBinding", "isProjectNameChanged"));
        }
        return !currentName.equals(this.mySuggestedProjectName);
    }

    private class NameFieldDocument
    extends PlainDocument {
        public NameFieldDocument(final JTextField projectNameTextField, final TextFieldWithBrowseButton locationField) {
            this.addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    if (!LocationNameFieldsBinding.this.myModifyingLocation && !LocationNameFieldsBinding.this.myExternalModify) {
                        LocationNameFieldsBinding.this.myModifyingProjectName = true;
                        File f = new File(LocationNameFieldsBinding.this.myBaseDir);
                        locationField.setText(new File(f, projectNameTextField.getText()).getPath());
                    }
                }
            });
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            StringBuilder sb = null;
            for (int i = 0; i < str.length(); ++i) {
                boolean replace;
                char c = str.charAt(i);
                boolean bl = replace = c == '\\' || c == '/' || SystemInfo.isWindows && (c == '|' || c == ':');
                if (replace) {
                    if (sb == null) {
                        sb = new StringBuilder(str.length());
                        sb.append(str.substring(0, i));
                    }
                    sb.append('_');
                    continue;
                }
                if (sb == null) continue;
                sb.append(c);
            }
            if (sb != null) {
                str = sb.toString();
            }
            super.insertString(offs, str, a);
        }
    }
}

