/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.lang.LangBundle;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PackagePrefixFileSystemItem;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.resolve.reference.impl.CachingReference;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceCompletion;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelperRegistrar;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceOwner;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceResolver;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.NullFileReferenceHelper;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileSystemItemUtil;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiFileSystemItemProcessor;
import com.intellij.refactoring.rename.BindablePsiReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.THashSet;
import java.net.URI;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileReference
implements PsiFileReference,
FileReferenceOwner,
PsiPolyVariantReference,
LocalQuickFixProvider,
EmptyResolveMessageProvider,
BindablePsiReference {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference");
    public static final FileReference[] EMPTY = new FileReference[0];
    private final int myIndex;
    private TextRange myRange;
    private final String myText;
    @NotNull
    private final FileReferenceSet myFileReferenceSet;

    public FileReference(@NotNull FileReferenceSet fileReferenceSet, TextRange range, int index, String text) {
        if (fileReferenceSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileReferenceSet", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference", "<init>"));
        }
        this.myFileReferenceSet = fileReferenceSet;
        this.myIndex = index;
        this.myRange = range;
        this.myText = text;
    }

    public FileReference(FileReference original) {
        this(original.myFileReferenceSet, original.myRange, original.myIndex, original.myText);
    }

    @Nullable
    public static FileReference findFileReference(@NotNull PsiReference original) {
        PsiFileReference fileReference;
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference", "findFileReference"));
        }
        if (original instanceof PsiMultiReference) {
            PsiMultiReference multiReference = (PsiMultiReference)original;
            for (PsiReference reference : multiReference.getReferences()) {
                if (!(reference instanceof FileReference)) continue;
                return (FileReference)reference;
            }
        } else if (original instanceof FileReferenceOwner && (fileReference = ((FileReferenceOwner)original).getLastFileReference()) instanceof FileReference) {
            return (FileReference)fileReference;
        }
        return null;
    }

    @NotNull
    protected Collection<PsiFileSystemItem> getContexts() {
        FileReference contextRef = this.getContextReference();
        ArrayList<PsiFileSystemItem> result = new ArrayList<PsiFileSystemItem>();
        if (contextRef == null) {
            Collection<PsiFileSystemItem> defaultContexts = this.myFileReferenceSet.getDefaultContexts();
            for (PsiFileSystemItem context : defaultContexts) {
                if (context != null) continue;
                LOG.error(this.myFileReferenceSet.getClass() + " provided a null context");
            }
            result.addAll(defaultContexts);
        } else {
            ResolveResult[] resolveResults;
            for (ResolveResult resolveResult : resolveResults = contextRef.multiResolve(false)) {
                if (resolveResult.getElement() == null) continue;
                result.add((PsiFileSystemItem)resolveResult.getElement());
            }
        }
        result.addAll(this.myFileReferenceSet.getExtraContexts());
        ArrayList<PsiFileSystemItem> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference", "getContexts"));
        }
        return arrayList;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        PsiFile file2 = this.getElement().getContainingFile();
        ResolveResult[] resolveResultArray = ResolveCache.getInstance(file2.getProject()).resolveWithCaching(this, MyResolver.INSTANCE, false, false, file2);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference", "multiResolve"));
        }
        return resolveResultArray;
    }

    @NotNull
    protected ResolveResult[] innerResolve(boolean caseSensitive, @NotNull PsiFile containingFile) {
        int resultCount;
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference", "innerResolve"));
        }
        String referenceText = this.getText();
        if (referenceText.isEmpty() && this.myIndex == 0) {
            ResolveResult[] resolveResultArray = new ResolveResult[]{new PsiElementResolveResult((PsiElement)containingFile)};
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference", "innerResolve"));
            }
            return resolveResultArray;
        }
        Collection<PsiFileSystemItem> contexts = this.getContexts();
        THashSet result = new THashSet();
        for (PsiFileSystemItem context : contexts) {
            this.innerResolveInContext(referenceText, context, (Collection<ResolveResult>)result, caseSensitive);
        }
        if (contexts.isEmpty() && this.isAllowedEmptyPath(referenceText)) {
            result.add(new PsiElementResolveResult((PsiElement)containingFile));
        }
        ResolveResult[] resolveResultArray = (resultCount = result.size()) > 0 ? result.toArray(new ResolveResult[resultCount]) : ResolveResult.EMPTY_ARRAY;
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference", "innerResolve"));
        }
        return resolveResultArray;
    }

    protected void innerResolveInContext(@NotNull String text, @NotNull PsiFileSystemItem context, final Collection<ResolveResult> result, final boolean caseSensitive) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference", "innerResolveInContext"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference", "innerResolveInContext"));
        }
        if (this.isAllowedEmptyPath(text) || ".".equals(text) || "/".equals(text)) {
            result.add((ResolveResult)new PsiElementResolveResult((PsiElement)context));
        } else if ("..".equals(text)) {
            PsiFileSystemItem resolved = context.getParent();
            if (resolved != null) {
                result.add((ResolveResult)new PsiElementResolveResult((PsiElement)resolved));
            }
        } else {
            int separatorIndex = text.indexOf(47);
            if (separatorIndex >= 0) {
                ArrayList<ResolveResult> resolvedContexts = new ArrayList<ResolveResult>();
                if (separatorIndex == 0 && "/".equals(context.getName())) {
                    resolvedContexts.add((ResolveResult)new PsiElementResolveResult((PsiElement)context));
                } else {
                    this.innerResolveInContext(text.substring(0, separatorIndex), context, resolvedContexts, caseSensitive);
                }
                String restOfText = text.substring(separatorIndex + 1);
                for (ResolveResult contextVariant : resolvedContexts) {
                    PsiFileSystemItem item = (PsiFileSystemItem)contextVariant.getElement();
                    if (item == null) continue;
                    this.innerResolveInContext(restOfText, item, result, caseSensitive);
                }
            } else {
                PsiFileSystemItem child;
                final String decoded = this.decode(text);
                if (context instanceof PackagePrefixFileSystemItem) {
                    context = ((PackagePrefixFileSystemItem)context).getDirectory();
                } else if (context instanceof FileReferenceResolver && (child = ((FileReferenceResolver)context).resolveFileReference(this, decoded)) != null) {
                    result.add((ResolveResult)new PsiElementResolveResult((PsiElement)FileReference.getOriginalFile(child)));
                    return;
                }
                if (context.getParent() == null && FileUtil.namesEqual((String)decoded, (String)context.getName())) {
                    result.add((ResolveResult)new PsiElementResolveResult((PsiElement)FileReference.getOriginalFile(context)));
                } else if (context instanceof PsiDirectory && FileReference.caseSensitivityApplies((PsiDirectory)context, caseSensitive)) {
                    PsiDirectory directory = (PsiDirectory)context;
                    PsiFile child2 = directory.findFile(decoded);
                    if (child2 == null) {
                        child2 = directory.findSubdirectory(decoded);
                    }
                    if (child2 != null) {
                        result.add((ResolveResult)new PsiElementResolveResult((PsiElement)FileReference.getOriginalFile((PsiFileSystemItem)child2)));
                    }
                } else {
                    FileReference.processVariants(context, new PsiFileSystemItemProcessor(){

                        @Override
                        public boolean acceptItem(String name, boolean isDirectory) {
                            return caseSensitive ? decoded.equals(name) : decoded.compareToIgnoreCase(name) == 0;
                        }

                        public boolean execute(@NotNull PsiFileSystemItem element) {
                            if (element == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference$1", "execute"));
                            }
                            result.add(new PsiElementResolveResult((PsiElement)FileReference.getOriginalFile(element)));
                            return true;
                        }
                    });
                }
            }
        }
    }

    @NotNull
    public String getFileNameToCreate() {
        String string = this.decode(this.getCanonicalText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference", "getFileNameToCreate"));
        }
        return string;
    }

    @Nullable
    public String getNewFileTemplateName() {
        FileType fileType = FileTypeRegistry.getInstance().getFileTypeByFileName(this.myText);
        if (fileType != UnknownFileType.INSTANCE) {
            return fileType.getName() + " File." + fileType.getDefaultExtension();
        }
        return null;
    }

    private static boolean caseSensitivityApplies(PsiDirectory context, boolean caseSensitive) {
        VirtualFileSystem fs = context.getVirtualFile().getFileSystem();
        return fs.isCaseSensitive() == caseSensitive;
    }

    private boolean isAllowedEmptyPath(String text) {
        return text.isEmpty() && this.isLast() && (StringUtil.isEmpty((String)this.myFileReferenceSet.getPathString()) && this.myFileReferenceSet.isEmptyPathAllowed() || !this.myFileReferenceSet.isEndingSlashNotAllowed() && this.myIndex > 0);
    }

    @NotNull
    public String decode(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference", "decode"));
        }
        if (SystemInfo.isMac) {
            text = Normalizer.normalize(text, Normalizer.Form.NFC);
        }
        String _text = text;
        int paramIndex = text.lastIndexOf(63);
        if (paramIndex >= 0) {
            _text = text.substring(0, paramIndex);
        }
        if (this.myFileReferenceSet.isUrlEncoded()) {
            String string;
            try {
                string = StringUtil.notNullize((String)new URI(_text).getPath(), (String)text);
            }
            catch (Exception ignored) {
                String string2 = text;
                if (string2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference", "decode"));
                }
                return string2;
            }
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference", "decode"));
            }
            return string;
        }
        String string = _text;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference", "decode"));
        }
        return string;
    }

    @NotNull
    public Object[] getVariants() {
        FileReferenceCompletion completion = FileReferenceCompletion.getInstance();
        if (completion != null) {
            Object[] objectArray = completion.getFileReferenceCompletionVariants(this);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference", "getVariants"));
            }
            return objectArray;
        }
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    protected Object createLookupItem(PsiElement candidate) {
        return null;
    }

    protected static PsiFileSystemItem getOriginalFile(PsiFileSystemItem fileSystemItem) {
        PsiFile psiFile;
        PsiManager psiManager;
        VirtualFile file2 = fileSystemItem.getVirtualFile();
        if (file2 != null && !file2.isDirectory() && (psiManager = fileSystemItem.getManager()) != null && (psiFile = psiManager.findFile(file2)) != null) {
            fileSystemItem = psiFile;
        }
        return fileSystemItem;
    }

    @Nullable
    protected String encode(String name, PsiElement psiElement) {
        try {
            return new URI(null, null, name, null).toString();
        }
        catch (Exception ignored) {
            return name;
        }
    }

    protected static void processVariants(PsiFileSystemItem context, PsiFileSystemItemProcessor processor2) {
        context.processChildren((PsiElementProcessor)processor2);
    }

    @Nullable
    private FileReference getContextReference() {
        return this.myIndex > 0 ? this.myFileReferenceSet.getReference(this.myIndex - 1) : null;
    }

    public PsiElement getElement() {
        return this.myFileReferenceSet.getElement();
    }

    public PsiFileSystemItem resolve() {
        ResolveResult[] resolveResults = this.multiResolve(false);
        return resolveResults.length == 1 ? (PsiFileSystemItem)resolveResults[0].getElement() : null;
    }

    @Nullable
    public PsiFileSystemItem innerSingleResolve(boolean caseSensitive, @NotNull PsiFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference", "innerSingleResolve"));
        }
        ResolveResult[] resolveResults = this.innerResolve(caseSensitive, containingFile);
        return resolveResults.length == 1 ? (PsiFileSystemItem)resolveResults[0].getElement() : null;
    }

    public boolean isReferenceTo(PsiElement element) {
        if (!(element instanceof PsiFileSystemItem)) {
            return false;
        }
        PsiFileSystemItem item = this.resolve();
        return item != null && FileReferenceHelperRegistrar.areElementsEquivalent(item, (PsiFileSystemItem)element);
    }

    public TextRange getRangeInElement() {
        return this.myRange;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference", "getCanonicalText"));
        }
        return string;
    }

    public String getText() {
        return this.myText;
    }

    public boolean isSoft() {
        return this.myFileReferenceSet.isSoft();
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        ElementManipulator<PsiElement> manipulator = CachingReference.getManipulator(this.getElement());
        this.myFileReferenceSet.setElement(manipulator.handleContentChange(this.getElement(), this.getRangeInElement(), newElementName));
        int delta = newElementName.length() - this.myRange.getLength();
        this.myRange = new TextRange(this.getRangeInElement().getStartOffset(), this.getRangeInElement().getStartOffset() + newElementName.length());
        FileReference[] references = this.myFileReferenceSet.getAllReferences();
        for (int idx = this.myIndex + 1; idx < references.length; ++idx) {
            references[idx].myRange = references[idx].myRange.shiftRight(delta);
        }
        return this.myFileReferenceSet.getElement();
    }

    public PsiElement bindToElement(@NotNull PsiElement element, boolean absolute) throws IncorrectOperationException {
        String newName;
        VirtualFile curVFile;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference", "bindToElement"));
        }
        if (!(element instanceof PsiFileSystemItem)) {
            throw new IncorrectOperationException("Cannot bind to element, should be instanceof PsiFileSystemItem: " + element);
        }
        if (this.getCanonicalText().isEmpty() && element == this.getElement().getContainingFile()) {
            return this.getElement();
        }
        PsiFileSystemItem fileSystemItem = (PsiFileSystemItem)element;
        VirtualFile dstVFile = fileSystemItem.getVirtualFile();
        if (dstVFile == null) {
            throw new IncorrectOperationException("Cannot bind to non-physical element:" + element);
        }
        PsiFile file2 = this.getElement().getContainingFile();
        PsiLanguageInjectionHost contextPsiFile = InjectedLanguageManager.getInstance((Project)file2.getProject()).getInjectionHost((PsiElement)file2);
        if (contextPsiFile != null) {
            file2 = contextPsiFile.getContainingFile();
        }
        if ((curVFile = file2.getVirtualFile()) == null) {
            throw new IncorrectOperationException("Cannot bind from non-physical element:" + file2);
        }
        Project project2 = element.getProject();
        if (absolute) {
            String relativePath;
            PsiFileSystemItem root = null;
            PsiFileSystemItem dstItem = null;
            for (FileReferenceHelper helper : FileReferenceHelperRegistrar.getHelpers()) {
                PsiFileSystemItem _root;
                PsiFileSystemItem _dstItem;
                if (!helper.isMine(project2, dstVFile) || (_dstItem = helper.getPsiFileSystemItem(project2, dstVFile)) == null || (_root = helper.findRoot(project2, dstVFile)) == null) continue;
                root = _root;
                dstItem = _dstItem;
                break;
            }
            if (root == null) {
                PsiFileSystemItem _root;
                PsiFileSystemItem _dstItem = NullFileReferenceHelper.INSTANCE.getPsiFileSystemItem(project2, dstVFile);
                if (_dstItem != null && (_root = NullFileReferenceHelper.INSTANCE.findRoot(project2, dstVFile)) != null) {
                    root = _root;
                    dstItem = _dstItem;
                }
                if (root == null) {
                    return this.getElement();
                }
            }
            if ((relativePath = PsiFileSystemItemUtil.getRelativePath(root, dstItem)) == null) {
                return this.getElement();
            }
            newName = this.myFileReferenceSet.getNewAbsolutePath(root, relativePath);
        } else {
            FileReferenceHelper helper = FileReferenceHelperRegistrar.getNotNullHelper(file2);
            Collection<PsiFileSystemItem> contexts = this.getContextsForBindToElement(curVFile, project2, helper);
            switch (contexts.size()) {
                case 0: {
                    break;
                }
                default: {
                    for (PsiFileSystemItem context : contexts) {
                        String path;
                        VirtualFile contextFile = context.getVirtualFile();
                        assert (contextFile != null);
                        if (!VfsUtilCore.isAncestor((VirtualFile)contextFile, (VirtualFile)dstVFile, (boolean)true) || (path = VfsUtilCore.getRelativePath((VirtualFile)dstVFile, (VirtualFile)contextFile, (char)'/')) == null) continue;
                        return this.rename(path);
                    }
                }
            }
            PsiFileSystemItem dstItem = helper.getPsiFileSystemItem(project2, dstVFile);
            PsiFileSystemItem curItem = helper.getPsiFileSystemItem(project2, curVFile);
            if (curItem == null) {
                throw new IncorrectOperationException("Cannot find path between files; src = " + curVFile.getPresentableUrl() + "; " + "dst = " + dstVFile.getPresentableUrl() + "; " + "Contexts: " + contexts);
            }
            if (curItem.equals(dstItem)) {
                if (this.getCanonicalText().equals(dstItem.getName())) {
                    return this.getElement();
                }
                return this.fixRefText(file2.getName());
            }
            newName = PsiFileSystemItemUtil.getRelativePath(curItem, dstItem);
            if (newName == null) {
                return this.getElement();
            }
        }
        if (this.myFileReferenceSet.isUrlEncoded()) {
            newName = this.encode(newName, element);
        }
        return this.rename(newName);
    }

    protected Collection<PsiFileSystemItem> getContextsForBindToElement(VirtualFile curVFile, Project project2, FileReferenceHelper helper) {
        return helper.getContexts(project2, curVFile);
    }

    protected PsiElement fixRefText(String name) {
        return ElementManipulators.getManipulator((PsiElement)this.getElement()).handleContentChange(this.getElement(), this.getRangeInElement(), name);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference", "bindToElement"));
        }
        return this.bindToElement(element, this.myFileReferenceSet.isAbsolutePathReference());
    }

    protected PsiElement rename(String newName) throws IncorrectOperationException {
        TextRange range = new TextRange(this.myFileReferenceSet.getStartInElement(), this.getRangeInElement().getEndOffset());
        PsiElement element = this.getElement();
        try {
            return CachingReference.getManipulator(element).handleContentChange(element, range, newName);
        }
        catch (IncorrectOperationException e) {
            LOG.error("Cannot rename " + this.getClass() + " from " + this.myFileReferenceSet.getClass() + " to " + newName, (Throwable)e);
            throw e;
        }
    }

    protected static FileReferenceHelper[] getHelpers() {
        return FileReferenceHelperRegistrar.getHelpers();
    }

    public int getIndex() {
        return this.myIndex;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = LangBundle.message("error.cannot.resolve", new Object[0]) + " " + (this.isLast() ? LangBundle.message("terms.file", new Object[0]) : LangBundle.message("terms.directory", new Object[0])) + " '" + StringUtil.escapePattern((String)this.decode(this.getCanonicalText())) + "'";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference", "getUnresolvedMessagePattern"));
        }
        return string;
    }

    public final boolean isLast() {
        return this.myIndex == this.myFileReferenceSet.getAllReferences().length - 1;
    }

    @NotNull
    public FileReferenceSet getFileReferenceSet() {
        FileReferenceSet fileReferenceSet = this.myFileReferenceSet;
        if (fileReferenceSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference", "getFileReferenceSet"));
        }
        return fileReferenceSet;
    }

    public LocalQuickFix[] getQuickFixes() {
        ArrayList<? extends LocalQuickFix> result = new ArrayList<LocalQuickFix>();
        for (FileReferenceHelper helper : FileReference.getHelpers()) {
            result.addAll(helper.registerFixes(this));
        }
        return result.toArray(new LocalQuickFix[result.size()]);
    }

    @Override
    public FileReference getLastFileReference() {
        return this.myFileReferenceSet.getLastReference();
    }

    static class MyResolver
    implements ResolveCache.PolyVariantContextResolver<FileReference> {
        static final MyResolver INSTANCE = new MyResolver();

        MyResolver() {
        }

        @Override
        @NotNull
        public ResolveResult[] resolve(@NotNull FileReference ref, @NotNull PsiFile containingFile, boolean incompleteCode) {
            if (ref == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference$MyResolver", "resolve"));
            }
            if (containingFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference$MyResolver", "resolve"));
            }
            ResolveResult[] resolveResultArray = ref.innerResolve(ref.getFileReferenceSet().isCaseSensitive(), containingFile);
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference$MyResolver", "resolve"));
            }
            return resolveResultArray;
        }
    }
}

