/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeClassSignature;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiQualifiedReferenceElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.changeClassSignature.ChangeClassSignatureDialog;
import com.intellij.refactoring.changeClassSignature.ChangeClassSigntaureViewDescriptor;
import com.intellij.refactoring.changeClassSignature.TypeParameterInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureUtil;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeClassSignatureProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.changeClassSignature.ChangeClassSignatureProcessor");
    private PsiClass myClass;
    private final TypeParameterInfo[] myNewSignature;

    public ChangeClassSignatureProcessor(Project project2, PsiClass aClass, TypeParameterInfo[] newSignature) {
        super(project2);
        this.myClass = aClass;
        this.myNewSignature = newSignature;
    }

    @Override
    protected void refreshElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/changeClassSignature/ChangeClassSignatureProcessor", "refreshElements"));
        }
        LOG.assertTrue(elements.length == 1);
        LOG.assertTrue(elements[0] instanceof PsiClass);
        this.myClass = (PsiClass)elements[0];
    }

    @Override
    protected String getCommandName() {
        return ChangeClassSignatureDialog.REFACTORING_NAME;
    }

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/changeClassSignature/ChangeClassSignatureProcessor", "createUsageViewDescriptor"));
        }
        ChangeClassSigntaureViewDescriptor changeClassSigntaureViewDescriptor = new ChangeClassSigntaureViewDescriptor(this.myClass);
        if (changeClassSigntaureViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/changeClassSignature/ChangeClassSignatureProcessor", "createUsageViewDescriptor"));
        }
        return changeClassSigntaureViewDescriptor;
    }

    @Override
    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refUsages", "com/intellij/refactoring/changeClassSignature/ChangeClassSignatureProcessor", "preprocessUsages"));
        }
        MultiMap conflicts = new MultiMap();
        PsiTypeParameter[] parameters = this.myClass.getTypeParameters();
        HashMap<String, TypeParameterInfo> infos = new HashMap<String, TypeParameterInfo>();
        for (TypeParameterInfo info : this.myNewSignature) {
            String newName = info.isForExistingParameter() ? parameters[info.getOldParameterIndex()].getName() : info.getNewName();
            TypeParameterInfo existing = (TypeParameterInfo)infos.get(newName);
            if (existing != null) {
                conflicts.putValue((Object)this.myClass, (Object)(RefactoringUIUtil.getDescription((PsiElement)this.myClass, false) + " already contains type parameter " + newName));
            }
            infos.put(newName, info);
        }
        return this.showConflicts((MultiMap<PsiElement, String>)conflicts, (UsageInfo[])refUsages.get());
    }

    @Override
    @NotNull
    protected UsageInfo[] findUsages() {
        GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)this.myProject);
        ArrayList<UsageInfo> result = new ArrayList<UsageInfo>();
        boolean hadTypeParameters = this.myClass.hasTypeParameters();
        for (PsiReference reference : ReferencesSearch.search((PsiElement)this.myClass, (SearchScope)projectScope, (boolean)false)) {
            PsiJavaCodeReferenceElement referenceElement;
            PsiElement parent;
            if (!(reference.getElement() instanceof PsiJavaCodeReferenceElement) || (parent = (referenceElement = (PsiJavaCodeReferenceElement)reference.getElement()).getParent()) instanceof PsiTypeElement && parent.getParent() instanceof PsiInstanceOfExpression || parent instanceof PsiNewExpression && PsiDiamondTypeUtil.hasDiamond((PsiNewExpression)parent) || !(parent instanceof PsiTypeElement) && !(parent instanceof PsiNewExpression) && !(parent instanceof PsiAnonymousClass) && !(parent instanceof PsiReferenceList) || hadTypeParameters && referenceElement.getTypeParameters().length <= 0) continue;
            result.add(new UsageInfo((PsiQualifiedReferenceElement)referenceElement));
        }
        UsageInfo[] usageInfoArray = result.toArray(new UsageInfo[result.size()]);
        if (usageInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/changeClassSignature/ChangeClassSignatureProcessor", "findUsages"));
        }
        return usageInfoArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/changeClassSignature/ChangeClassSignatureProcessor", "performRefactoring"));
        }
        LocalHistoryAction a = LocalHistory.getInstance().startAction(this.getCommandName());
        try {
            this.doRefactoring(usages);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        finally {
            a.finish();
        }
    }

    @Override
    @Nullable
    protected String getRefactoringId() {
        return "refactoring.changeClassSignature";
    }

    @Override
    @Nullable
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData data = new RefactoringEventData();
        data.addElement((PsiElement)this.myClass);
        return data;
    }

    @Override
    @Nullable
    protected RefactoringEventData getAfterData(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/changeClassSignature/ChangeClassSignatureProcessor", "getAfterData"));
        }
        RefactoringEventData data = new RefactoringEventData();
        data.addElement((PsiElement)this.myClass);
        return data;
    }

    private void doRefactoring(UsageInfo[] usages) throws IncorrectOperationException {
        final PsiTypeParameter[] typeParameters = this.myClass.getTypeParameters();
        final boolean[] toRemoveParms = this.detectRemovedParameters(typeParameters);
        for (UsageInfo usage : usages) {
            LOG.assertTrue(usage.getElement() instanceof PsiJavaCodeReferenceElement);
            this.processUsage(usage, typeParameters, toRemoveParms);
        }
        final HashMap supersMap = new HashMap();
        this.myClass.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitTypeElement(PsiTypeElement typeElement) {
                int i;
                super.visitTypeElement(typeElement);
                PsiType type = typeElement.getType();
                PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type);
                if (psiClass instanceof PsiTypeParameter && (i = ArrayUtil.find((Object[])typeParameters, (Object)psiClass)) >= 0 && i < toRemoveParms.length && toRemoveParms[i]) {
                    supersMap.put(typeElement, psiClass.getSuperClass());
                }
            }
        });
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.myProject);
        for (Map.Entry classEntry : supersMap.entrySet()) {
            ((PsiTypeElement)classEntry.getKey()).replace((PsiElement)elementFactory.createTypeElement((PsiType)elementFactory.createType((PsiClass)classEntry.getValue())));
        }
        this.changeClassSignature(typeParameters, toRemoveParms);
    }

    private void changeClassSignature(PsiTypeParameter[] originalTypeParameters, boolean[] toRemoveParms) throws IncorrectOperationException {
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myClass.getProject()).getElementFactory();
        ArrayList<PsiTypeParameter> newTypeParameters = new ArrayList<PsiTypeParameter>();
        for (TypeParameterInfo info : this.myNewSignature) {
            int oldIndex = info.getOldParameterIndex();
            if (oldIndex >= 0) {
                newTypeParameters.add(originalTypeParameters[oldIndex]);
                continue;
            }
            newTypeParameters.add(factory.createTypeParameterFromText(info.getNewName(), null));
        }
        ChangeSignatureUtil.synchronizeList(this.myClass.getTypeParameterList(), newTypeParameters, TypeParameterList.INSTANCE, toRemoveParms);
    }

    private boolean[] detectRemovedParameters(PsiTypeParameter[] original) {
        boolean[] toRemove = new boolean[original.length];
        Arrays.fill(toRemove, true);
        for (TypeParameterInfo info : this.myNewSignature) {
            int oldParameterIndex = info.getOldParameterIndex();
            if (oldParameterIndex < 0) continue;
            toRemove[oldParameterIndex] = false;
        }
        return toRemove;
    }

    private void processUsage(UsageInfo usage, PsiTypeParameter[] original, boolean[] toRemove) throws IncorrectOperationException {
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myClass.getProject()).getElementFactory();
        PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)usage.getElement();
        assert (referenceElement != null) : usage;
        PsiSubstitutor usageSubstitutor = this.determineUsageSubstitutor(referenceElement);
        PsiReferenceParameterList referenceParameterList = referenceElement.getParameterList();
        assert (referenceParameterList != null) : referenceElement;
        PsiTypeElement[] oldValues = referenceParameterList.getTypeParameterElements();
        if (oldValues.length != original.length) {
            return;
        }
        ArrayList<PsiTypeElement> newValues = new ArrayList<PsiTypeElement>();
        for (TypeParameterInfo info : this.myNewSignature) {
            int oldIndex = info.getOldParameterIndex();
            if (oldIndex >= 0) {
                newValues.add(oldValues[oldIndex]);
                continue;
            }
            PsiType type = info.getDefaultValue().getType(this.myClass.getLBrace(), PsiManager.getInstance((Project)this.myProject));
            PsiTypeElement newValue = factory.createTypeElement(usageSubstitutor.substitute(type));
            newValues.add(newValue);
        }
        ChangeSignatureUtil.synchronizeList(referenceParameterList, newValues, ReferenceParameterList.INSTANCE, toRemove);
        JavaCodeStyleManager.getInstance((Project)this.myProject).shortenClassReferences((PsiElement)referenceParameterList);
    }

    private PsiSubstitutor determineUsageSubstitutor(PsiJavaCodeReferenceElement referenceElement) {
        PsiType[] typeArguments = referenceElement.getTypeParameters();
        PsiSubstitutor usageSubstitutor = PsiSubstitutor.EMPTY;
        PsiTypeParameter[] typeParameters = this.myClass.getTypeParameters();
        if (typeParameters.length == typeArguments.length) {
            for (int i = 0; i < typeParameters.length; ++i) {
                usageSubstitutor = usageSubstitutor.put(typeParameters[i], typeArguments[i]);
            }
        }
        return usageSubstitutor;
    }

    private static class TypeParameterList
    implements ChangeSignatureUtil.ChildrenGenerator<PsiTypeParameterList, PsiTypeParameter> {
        private static final TypeParameterList INSTANCE = new TypeParameterList();

        private TypeParameterList() {
        }

        @Override
        public List<PsiTypeParameter> getChildren(PsiTypeParameterList psiTypeParameterList) {
            return Arrays.asList(psiTypeParameterList.getTypeParameters());
        }
    }

    private static class ReferenceParameterList
    implements ChangeSignatureUtil.ChildrenGenerator<PsiReferenceParameterList, PsiTypeElement> {
        private static final ReferenceParameterList INSTANCE = new ReferenceParameterList();

        private ReferenceParameterList() {
        }

        @Override
        public List<PsiTypeElement> getChildren(PsiReferenceParameterList list) {
            return Arrays.asList(list.getTypeParameterElements());
        }
    }
}

