/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.copy;

import com.intellij.ide.util.DirectoryUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.DialogWrapperPeer;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.components.JBLabelDecorator;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.FormBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class CopyFilesOrDirectoriesDialog
extends DialogWrapper {
    public static final int MAX_PATH_LENGTH = 70;
    private static final String COPY_OPEN_IN_EDITOR = "Copy.OpenInEditor";
    private static final String RECENT_KEYS = "CopyFile.RECENT_KEYS";
    private JLabel myInformationLabel;
    private TextFieldWithHistoryWithBrowseButton myTargetDirectoryField;
    private JCheckBox myOpenFilesInEditor = CopyFilesOrDirectoriesDialog.createOpenInEditorCB();
    private JTextField myNewNameField;
    private final Project myProject;
    private final boolean myShowDirectoryField;
    private final boolean myShowNewNameField;
    private PsiDirectory myTargetDirectory;
    private boolean myFileCopy = false;

    public static String shortenPath(VirtualFile file2) {
        return StringUtil.shortenPathWithEllipsis((String)file2.getPresentableUrl(), (int)70);
    }

    public static JCheckBox createOpenInEditorCB() {
        JCheckBox checkBox = new JCheckBox("Open copy in editor", PropertiesComponent.getInstance().getBoolean(COPY_OPEN_IN_EDITOR, true));
        checkBox.setMnemonic('o');
        return checkBox;
    }

    public static void saveOpenInEditorState(boolean selected) {
        PropertiesComponent.getInstance().setValue(COPY_OPEN_IN_EDITOR, String.valueOf(selected));
    }

    public CopyFilesOrDirectoriesDialog(PsiElement[] elements, PsiDirectory defaultTargetDirectory, Project project2, boolean doClone) {
        super(project2, true);
        this.myProject = project2;
        this.myShowDirectoryField = !doClone;
        boolean bl = this.myShowNewNameField = ((PsiElement[])elements).length == 1;
        if (doClone && ((PsiElement[])elements).length != 1) {
            throw new IllegalArgumentException("wrong number of elements to clone: " + ((PsiElement[])elements).length);
        }
        this.setTitle(RefactoringBundle.message((String)(doClone ? "copy.files.clone.title" : "copy.files.copy.title")));
        this.init();
        if (((PsiElement[])elements).length == 1) {
            String text;
            if (elements[0] instanceof PsiFile) {
                String fileName;
                PsiFile file2 = (PsiFile)elements[0];
                VirtualFile vFile = file2.getVirtualFile();
                text = RefactoringBundle.message((String)(doClone ? "copy.files.clone.file.0" : "copy.files.copy.file.0"), (Object[])new Object[]{CopyFilesOrDirectoriesDialog.shortenPath(vFile)});
                String string = fileName = vFile.isInLocalFileSystem() ? vFile.getName() : PathUtil.suggestFileName((String)file2.getName(), (boolean)true, (boolean)true);
                if (StringUtil.isEmpty((String)vFile.getExtension())) {
                    FileType type = (FileType)ObjectUtils.notNull((Object)file2.getLanguage().getAssociatedFileType(), (Object)file2.getFileType());
                    fileName = PathUtil.makeFileName((String)fileName, (String)type.getDefaultExtension());
                }
                this.myNewNameField.setText(fileName);
                int dotIdx = fileName.lastIndexOf(46);
                if (dotIdx > 0) {
                    this.myNewNameField.select(0, dotIdx);
                    this.myNewNameField.putClientProperty(DialogWrapperPeer.HAVE_INITIAL_SELECTION, true);
                }
                this.myFileCopy = true;
            } else {
                VirtualFile vFile = ((PsiDirectory)elements[0]).getVirtualFile();
                text = RefactoringBundle.message((String)(doClone ? "copy.files.clone.directory.0" : "copy.files.copy.directory.0"), (Object[])new Object[]{CopyFilesOrDirectoriesDialog.shortenPath(vFile)});
                this.myNewNameField.setText(vFile.getName());
            }
            this.myInformationLabel.setText(text);
        } else {
            this.setMultipleElementCopyLabel((PsiElement[])elements);
        }
        boolean allBinary = true;
        for (VirtualFile element : elements) {
            if (element.getContainingFile() instanceof PsiBinaryFile) continue;
            allBinary = false;
            break;
        }
        if (allBinary) {
            this.myOpenFilesInEditor.setVisible(false);
        }
        if (this.myShowDirectoryField) {
            String targetPath = defaultTargetDirectory == null ? "" : defaultTargetDirectory.getVirtualFile().getPresentableUrl();
            ((TextFieldWithHistory)this.myTargetDirectoryField.getChildComponent()).setText(targetPath);
        }
        this.validateOKButton();
    }

    private void setMultipleElementCopyLabel(PsiElement[] elements) {
        boolean allFiles = true;
        boolean allDirectories = true;
        for (PsiElement element : elements) {
            if (element instanceof PsiDirectory) {
                allFiles = false;
                continue;
            }
            allDirectories = false;
        }
        if (allFiles) {
            this.myInformationLabel.setText(RefactoringBundle.message((String)"copy.files.copy.specified.files.label"));
        } else if (allDirectories) {
            this.myInformationLabel.setText(RefactoringBundle.message((String)"copy.files.copy.specified.directories.label"));
        } else {
            this.myInformationLabel.setText(RefactoringBundle.message((String)"copy.files.copy.specified.mixed.label"));
        }
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/copy/CopyFilesOrDirectoriesDialog", "createActions"));
        }
        return actionArray;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myShowNewNameField ? this.myNewNameField : this.myTargetDirectoryField.getChildComponent();
    }

    protected JComponent createCenterPanel() {
        return new JPanel(new BorderLayout());
    }

    protected JComponent createNorthPanel() {
        this.myInformationLabel = JBLabelDecorator.createJBLabelDecorator().setBold(true);
        FormBuilder formBuilder = FormBuilder.createFormBuilder().addComponent((JComponent)this.myInformationLabel).addVerticalGap(8);
        DocumentAdapter documentListener = new DocumentAdapter(){

            public void textChanged(DocumentEvent event) {
                CopyFilesOrDirectoriesDialog.this.validateOKButton();
            }
        };
        if (this.myShowNewNameField) {
            this.myNewNameField = new JBTextField();
            this.myNewNameField.getDocument().addDocumentListener((DocumentListener)documentListener);
            formBuilder.addLabeledComponent(RefactoringBundle.message((String)"copy.files.new.name.label"), (JComponent)this.myNewNameField);
        }
        if (this.myShowDirectoryField) {
            this.myTargetDirectoryField = new TextFieldWithHistoryWithBrowseButton();
            this.myTargetDirectoryField.setTextFieldPreferredWidth(70);
            List<String> recentEntries = RecentsManager.getInstance(this.myProject).getRecentEntries(RECENT_KEYS);
            if (recentEntries != null) {
                ((TextFieldWithHistory)this.myTargetDirectoryField.getChildComponent()).setHistory(recentEntries);
            }
            FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
            this.myTargetDirectoryField.addBrowseFolderListener(RefactoringBundle.message((String)"select.target.directory"), RefactoringBundle.message((String)"the.file.will.be.copied.to.this.directory"), this.myProject, descriptor, TextComponentAccessor.TEXT_FIELD_WITH_HISTORY_WHOLE_TEXT);
            ((TextFieldWithHistory)this.myTargetDirectoryField.getChildComponent()).addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    CopyFilesOrDirectoriesDialog.this.validateOKButton();
                }
            });
            formBuilder.addLabeledComponent(RefactoringBundle.message((String)"copy.files.to.directory.label"), (JComponent)this.myTargetDirectoryField);
            String shortcutText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("CodeCompletion"));
            formBuilder.addTooltip(RefactoringBundle.message((String)"path.completion.shortcut", (Object[])new Object[]{shortcutText}));
        }
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)this.myOpenFilesInEditor, "East");
        formBuilder.addComponent((JComponent)wrapper);
        return formBuilder.getPanel();
    }

    public PsiDirectory getTargetDirectory() {
        return this.myTargetDirectory;
    }

    public String getNewName() {
        return this.myNewNameField != null ? this.myNewNameField.getText().trim() : null;
    }

    public boolean openInEditor() {
        return this.myOpenFilesInEditor.isSelected();
    }

    protected void doOKAction() {
        if (this.myShowNewNameField) {
            String newName = this.getNewName();
            if (newName.length() == 0) {
                Messages.showErrorDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"no.new.name.specified"), (String)RefactoringBundle.message((String)"error.title"));
                return;
            }
            if (this.myFileCopy && !PathUtil.isValidFileName((String)newName, (boolean)SystemInfo.isWindows)) {
                Messages.showErrorDialog((Component)this.myNewNameField, (String)"Name is not a valid file name");
                return;
            }
        }
        CopyFilesOrDirectoriesDialog.saveOpenInEditorState(this.myOpenFilesInEditor.isSelected());
        if (this.myShowDirectoryField) {
            final String targetDirectoryName = ((TextFieldWithHistory)this.myTargetDirectoryField.getChildComponent()).getText();
            if (targetDirectoryName.length() == 0) {
                Messages.showErrorDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"no.target.directory.specified"), (String)RefactoringBundle.message((String)"error.title"));
                return;
            }
            RecentsManager.getInstance(this.myProject).registerRecentEntry(RECENT_KEYS, targetDirectoryName);
            CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                String path = FileUtil.toSystemIndependentName((String)targetDirectoryName);
                                CopyFilesOrDirectoriesDialog.this.myTargetDirectory = DirectoryUtil.mkdirs(PsiManager.getInstance((Project)CopyFilesOrDirectoriesDialog.this.myProject), path);
                            }
                            catch (IncorrectOperationException incorrectOperationException) {
                                // empty catch block
                            }
                        }
                    });
                }
            }, RefactoringBundle.message((String)"create.directory"), null);
            if (this.myTargetDirectory == null) {
                Messages.showErrorDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"cannot.create.directory"), (String)RefactoringBundle.message((String)"error.title"));
                return;
            }
        }
        super.doOKAction();
    }

    private void validateOKButton() {
        String newName;
        if (this.myShowDirectoryField && ((TextFieldWithHistory)this.myTargetDirectoryField.getChildComponent()).getText().length() == 0) {
            this.setOKActionEnabled(false);
            return;
        }
        if (this.myShowNewNameField && ((newName = this.getNewName()).length() == 0 || this.myFileCopy && !PathUtil.isValidFileName((String)newName, (boolean)SystemInfo.isWindows))) {
            this.setOKActionEnabled(false);
            return;
        }
        this.setOKActionEnabled(true);
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("refactoring.copyClass");
    }
}

