/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceParameter;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.lang.Language;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.ExpressionConverter;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.introduceParameter.ExternalUsageInfo;
import com.intellij.refactoring.introduceParameter.IntroduceParameterData;
import com.intellij.refactoring.introduceParameter.IntroduceParameterMethodUsagesProcessor;
import com.intellij.refactoring.introduceParameter.IntroduceParameterUtil;
import com.intellij.refactoring.introduceParameter.OldReferenceResolver;
import com.intellij.refactoring.util.FieldConflictsResolver;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.javadoc.MethodJavaDocHelper;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntProcedure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaIntroduceParameterMethodUsagesProcessor
implements IntroduceParameterMethodUsagesProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.introduceParameter.JavaIntroduceParameterMethodUsagesProcessor");
    private static final JavaLanguage myLanguage = (JavaLanguage)Language.findInstance(JavaLanguage.class);

    private static boolean isJavaUsage(UsageInfo usage) {
        PsiElement e = usage.getElement();
        return e != null && e.getLanguage().is((Language)myLanguage);
    }

    @Override
    public boolean isMethodUsage(UsageInfo usage) {
        return RefactoringUtil.isMethodUsage(usage.getElement()) && JavaIntroduceParameterMethodUsagesProcessor.isJavaUsage(usage);
    }

    @Override
    public boolean processChangeMethodUsage(IntroduceParameterData data, UsageInfo usage, UsageInfo[] usages) throws IncorrectOperationException {
        PsiExpression anchor;
        if (!this.isMethodUsage(usage)) {
            return true;
        }
        PsiElement ref = usage.getElement();
        PsiCall callExpression = RefactoringUtil.getCallExpressionByMethodReference(ref);
        PsiExpressionList argList = RefactoringUtil.getArgumentListByMethodReference(ref);
        if (argList == null) {
            return true;
        }
        PsiExpression[] oldArgs = argList.getExpressions();
        PsiMethod methodToSearchFor = data.getMethodToSearchFor();
        if (!methodToSearchFor.isVarArgs()) {
            anchor = JavaIntroduceParameterMethodUsagesProcessor.getLast(oldArgs);
        } else {
            PsiParameter[] parameters = methodToSearchFor.getParameterList().getParameters();
            if (parameters.length > oldArgs.length) {
                anchor = JavaIntroduceParameterMethodUsagesProcessor.getLast(oldArgs);
            } else {
                LOG.assertTrue(parameters.length > 0);
                int lastNonVararg = parameters.length - 2;
                anchor = lastNonVararg >= 0 ? oldArgs[lastNonVararg] : null;
            }
        }
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)argList, PsiMethod.class);
        if (method != null && IntroduceParameterUtil.isMethodInUsages(data, method, usages)) {
            argList.addAfter((PsiElement)JavaPsiFacade.getElementFactory((Project)data.getProject()).createExpressionFromText(data.getParameterName(), (PsiElement)argList), (PsiElement)anchor);
        } else {
            PsiElement initializer = ExpressionConverter.getExpression(data.getParameterInitializer().getExpression(), StdLanguages.JAVA, data.getProject());
            assert (initializer instanceof PsiExpression);
            if (initializer instanceof PsiNewExpression && !PsiDiamondTypeUtil.canChangeContextForDiamond((PsiNewExpression)initializer, ((PsiNewExpression)initializer).getType())) {
                initializer = PsiDiamondTypeUtil.expandTopLevelDiamondsInside((PsiExpression)((PsiNewExpression)initializer));
            }
            JavaIntroduceParameterMethodUsagesProcessor.substituteTypeParametersInInitializer(initializer, callExpression, argList, methodToSearchFor);
            ChangeContextUtil.encodeContextInfo(initializer, true);
            PsiExpression newArg = (PsiExpression)argList.addAfter(initializer, (PsiElement)anchor);
            ChangeContextUtil.decodeContextInfo((PsiElement)newArg, null, null);
            ChangeContextUtil.clearContextInfo(initializer);
            new OldReferenceResolver(callExpression, newArg, data.getMethodToReplaceIn(), data.getReplaceFieldsWithGetters(), initializer).resolve();
        }
        PsiExpressionList argumentList = callExpression.getArgumentList();
        LOG.assertTrue(argumentList != null, (Object)callExpression.getText());
        JavaIntroduceParameterMethodUsagesProcessor.removeParametersFromCall(argumentList, data.getParametersToRemove());
        return false;
    }

    private static void substituteTypeParametersInInitializer(PsiElement initializer, PsiCall callExpression, PsiExpressionList argList, PsiMethod method) {
        Project project2 = method.getProject();
        PsiSubstitutor psiSubstitutor = JavaPsiFacade.getInstance((Project)project2).getResolveHelper().inferTypeArguments(method.getTypeParameters(), method.getParameterList().getParameters(), argList.getExpressions(), PsiSubstitutor.EMPTY, (PsiElement)callExpression, (ParameterTypeInferencePolicy)DefaultParameterTypeInferencePolicy.INSTANCE);
        RefactoringUtil.replaceMovedMemberTypeParameters(initializer, PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)method), psiSubstitutor, JavaPsiFacade.getElementFactory((Project)project2));
    }

    private static void removeParametersFromCall(@NotNull PsiExpressionList argList, TIntArrayList parametersToRemove) {
        if (argList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argList", "com/intellij/refactoring/introduceParameter/JavaIntroduceParameterMethodUsagesProcessor", "removeParametersFromCall"));
        }
        final PsiExpression[] exprs = argList.getExpressions();
        parametersToRemove.forEachDescending(new TIntProcedure(){

            public boolean execute(int paramNum) {
                try {
                    if (paramNum < exprs.length) {
                        exprs[paramNum].delete();
                    }
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
                return true;
            }
        });
    }

    @Nullable
    private static PsiExpression getLast(PsiExpression[] oldArgs) {
        PsiExpression anchor = oldArgs.length > 0 ? oldArgs[oldArgs.length - 1] : null;
        return anchor;
    }

    @Override
    public void findConflicts(IntroduceParameterData data, UsageInfo[] usages, final MultiMap<PsiElement, String> conflicts) {
        PsiMethod method = data.getMethodToReplaceIn();
        int parametersCount = method.getParameterList().getParametersCount();
        for (UsageInfo usage : usages) {
            PsiElement element;
            PsiCall call;
            PsiExpressionList argList;
            if (!this.isMethodUsage(usage) || (argList = (call = RefactoringUtil.getCallExpressionByMethodReference(element = usage.getElement())).getArgumentList()) == null) continue;
            final int actualParamLength = argList.getExpressions().length;
            if (method.isVarArgs() && actualParamLength + 1 < parametersCount || !method.isVarArgs() && actualParamLength < parametersCount) {
                conflicts.putValue((Object)call, (Object)("Incomplete call(" + call.getText() + "): " + parametersCount + " parameters expected but only " + actualParamLength + " found"));
            }
            data.getParametersToRemove().forEach(new TIntProcedure(){

                public boolean execute(int paramNum) {
                    if (paramNum >= actualParamLength) {
                        conflicts.putValue((Object)call, (Object)("Incomplete call(" + call.getText() + "): expected to delete the " + paramNum + " parameter but only " + actualParamLength + " parameters found"));
                    }
                    return true;
                }
            });
        }
    }

    @Override
    public boolean processChangeMethodSignature(IntroduceParameterData data, UsageInfo usage, UsageInfo[] usages) throws IncorrectOperationException {
        if (!(usage.getElement() instanceof PsiMethod) || !JavaIntroduceParameterMethodUsagesProcessor.isJavaUsage(usage)) {
            return true;
        }
        PsiMethod method = (PsiMethod)usage.getElement();
        FieldConflictsResolver fieldConflictsResolver = new FieldConflictsResolver(data.getParameterName(), method.getBody());
        final MethodJavaDocHelper javaDocHelper = new MethodJavaDocHelper(method);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)data.getProject()).getElementFactory();
        PsiParameter parameter = factory.createParameter(data.getParameterName(), data.getForcedType());
        PsiUtil.setModifierProperty((PsiModifierListOwner)parameter, (String)"final", (boolean)data.isDeclareFinal());
        PsiParameterList parameterList = method.getParameterList();
        final PsiParameter[] parameters = parameterList.getParameters();
        data.getParametersToRemove().forEachDescending(new TIntProcedure(){

            public boolean execute(int paramNum) {
                try {
                    PsiParameter param = parameters[paramNum];
                    PsiDocTag tag = javaDocHelper.getTagForParameter(param);
                    if (tag != null) {
                        tag.delete();
                    }
                    param.delete();
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
                return true;
            }
        });
        PsiParameter anchorParameter = JavaIntroduceParameterMethodUsagesProcessor.getAnchorParameter(method);
        parameter = (PsiParameter)parameterList.addAfter((PsiElement)parameter, (PsiElement)anchorParameter);
        JavaCodeStyleManager.getInstance((Project)data.getProject()).shortenClassReferences((PsiElement)parameter);
        PsiDocTag tagForAnchorParameter = javaDocHelper.getTagForParameter(anchorParameter);
        javaDocHelper.addParameterAfter(data.getParameterName(), tagForAnchorParameter);
        fieldConflictsResolver.fix();
        return false;
    }

    @Nullable
    public static PsiParameter getAnchorParameter(PsiMethod methodToReplaceIn) {
        PsiParameter anchorParameter;
        PsiParameterList parameterList = methodToReplaceIn.getParameterList();
        PsiParameter[] parameters = parameterList.getParameters();
        int length = parameters.length;
        if (!methodToReplaceIn.isVarArgs()) {
            anchorParameter = length > 0 ? parameters[length - 1] : null;
        } else {
            LOG.assertTrue(length > 0);
            LOG.assertTrue(parameters[length - 1].isVarArgs());
            anchorParameter = length > 1 ? parameters[length - 2] : null;
        }
        return anchorParameter;
    }

    @Override
    public boolean processAddDefaultConstructor(IntroduceParameterData data, UsageInfo usage, UsageInfo[] usages) {
        if (!(usage.getElement() instanceof PsiClass) || !JavaIntroduceParameterMethodUsagesProcessor.isJavaUsage(usage)) {
            return true;
        }
        PsiClass aClass = (PsiClass)usage.getElement();
        if (aClass instanceof PsiAnonymousClass) {
            return true;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)data.getProject()).getElementFactory();
        PsiMethod constructor = factory.createMethodFromText(aClass.getName() + "(){}", (PsiElement)aClass);
        constructor = (PsiMethod)CodeStyleManager.getInstance((Project)data.getProject()).reformat((PsiElement)constructor);
        constructor = (PsiMethod)aClass.add((PsiElement)constructor);
        PsiUtil.setModifierProperty((PsiModifierListOwner)constructor, (String)VisibilityUtil.getVisibilityModifier((PsiModifierList)aClass.getModifierList()), (boolean)true);
        this.processAddSuperCall(data, new UsageInfo((PsiElement)constructor), usages);
        return false;
    }

    @Override
    public boolean processAddSuperCall(IntroduceParameterData data, UsageInfo usage, UsageInfo[] usages) throws IncorrectOperationException {
        if (!(usage.getElement() instanceof PsiMethod) || !JavaIntroduceParameterMethodUsagesProcessor.isJavaUsage(usage)) {
            return true;
        }
        PsiMethod constructor = (PsiMethod)usage.getElement();
        if (!constructor.isConstructor()) {
            return true;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)data.getProject()).getElementFactory();
        PsiExpressionStatement superCall = (PsiExpressionStatement)factory.createStatementFromText("super();", (PsiElement)constructor);
        superCall = (PsiExpressionStatement)CodeStyleManager.getInstance((Project)data.getProject()).reformat((PsiElement)superCall);
        PsiCodeBlock body = constructor.getBody();
        PsiStatement[] statements = body.getStatements();
        superCall = statements.length > 0 ? (PsiExpressionStatement)body.addBefore((PsiElement)superCall, (PsiElement)statements[0]) : (PsiExpressionStatement)body.add((PsiElement)superCall);
        this.processChangeMethodUsage(data, new ExternalUsageInfo((PsiElement)((PsiMethodCallExpression)superCall.getExpression()).getMethodExpression()), usages);
        return false;
    }
}

