/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RenamePsiElementProcessor {
    protected static final ExtensionPointName<RenamePsiElementProcessor> EP_NAME = ExtensionPointName.create((String)"com.intellij.renamePsiElementProcessor");
    public static final RenamePsiElementProcessor DEFAULT = new RenamePsiElementProcessor(){

        @Override
        public boolean canProcessElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/rename/RenamePsiElementProcessor$1", "canProcessElement"));
            }
            return true;
        }
    };

    public abstract boolean canProcessElement(@NotNull PsiElement var1);

    public RenameDialog createRenameDialog(Project project2, PsiElement element, PsiElement nameSuggestionContext, Editor editor) {
        return new RenameDialog(project2, element, nameSuggestionContext, editor);
    }

    public void renameElement(PsiElement element, String newName, UsageInfo[] usages, @Nullable RefactoringElementListener listener) throws IncorrectOperationException {
        RenameUtil.doRenameGenericNamedElement(element, newName, usages, listener);
    }

    @NotNull
    public Collection<PsiReference> findReferences(PsiElement element, boolean searchInCommentsAndStrings) {
        Collection<PsiReference> collection = this.findReferences(element);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/rename/RenamePsiElementProcessor", "findReferences"));
        }
        return collection;
    }

    @NotNull
    public Collection<PsiReference> findReferences(PsiElement element) {
        Collection collection = ReferencesSearch.search((PsiElement)element, (SearchScope)GlobalSearchScope.projectScope((Project)element.getProject())).findAll();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/rename/RenamePsiElementProcessor", "findReferences"));
        }
        return collection;
    }

    @Nullable
    public Pair<String, String> getTextOccurrenceSearchStrings(@NotNull PsiElement element, @NotNull String newName) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/rename/RenamePsiElementProcessor", "getTextOccurrenceSearchStrings"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/refactoring/rename/RenamePsiElementProcessor", "getTextOccurrenceSearchStrings"));
        }
        return null;
    }

    @Nullable
    public String getQualifiedNameAfterRename(PsiElement element, String newName, boolean nonJava) {
        return null;
    }

    public void prepareRenaming(PsiElement element, String newName, Map<PsiElement, String> allRenames) {
        this.prepareRenaming(element, newName, allRenames, element.getUseScope());
    }

    public void prepareRenaming(PsiElement element, String newName, Map<PsiElement, String> allRenames, SearchScope scope) {
    }

    public void findExistingNameConflicts(PsiElement element, String newName, MultiMap<PsiElement, String> conflicts) {
    }

    public void findExistingNameConflicts(PsiElement element, String newName, MultiMap<PsiElement, String> conflicts, Map<PsiElement, String> allRenames) {
        this.findExistingNameConflicts(element, newName, conflicts);
    }

    public boolean isInplaceRenameSupported() {
        return true;
    }

    public static List<RenamePsiElementProcessor> allForElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/rename/RenamePsiElementProcessor", "allForElement"));
        }
        ArrayList<RenamePsiElementProcessor> result = new ArrayList<RenamePsiElementProcessor>();
        for (RenamePsiElementProcessor processor2 : (RenamePsiElementProcessor[])EP_NAME.getExtensions()) {
            if (!processor2.canProcessElement(element)) continue;
            result.add(processor2);
        }
        return result;
    }

    @NotNull
    public static RenamePsiElementProcessor forElement(@NotNull PsiElement element) {
        RenamePsiElementProcessor[] extensions;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/rename/RenamePsiElementProcessor", "forElement"));
        }
        for (RenamePsiElementProcessor processor2 : extensions = (RenamePsiElementProcessor[])Extensions.getExtensions(EP_NAME)) {
            if (!processor2.canProcessElement(element)) continue;
            RenamePsiElementProcessor renamePsiElementProcessor = processor2;
            if (renamePsiElementProcessor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/rename/RenamePsiElementProcessor", "forElement"));
            }
            return renamePsiElementProcessor;
        }
        RenamePsiElementProcessor renamePsiElementProcessor = DEFAULT;
        if (renamePsiElementProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/rename/RenamePsiElementProcessor", "forElement"));
        }
        return renamePsiElementProcessor;
    }

    @Nullable
    public Runnable getPostRenameCallback(PsiElement element, String newName, RefactoringElementListener elementListener) {
        return null;
    }

    @Nullable
    @NonNls
    public String getHelpID(PsiElement element) {
        if (element instanceof PsiFile) {
            return "refactoring.renameFile";
        }
        return "refactoring.renameDialogs";
    }

    public boolean isToSearchInComments(PsiElement element) {
        return element instanceof PsiFileSystemItem && RefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_FILE;
    }

    public void setToSearchInComments(PsiElement element, boolean enabled) {
        if (element instanceof PsiFileSystemItem) {
            RefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_FILE = enabled;
        }
    }

    public boolean isToSearchForTextOccurrences(PsiElement element) {
        return element instanceof PsiFileSystemItem && RefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_FILE;
    }

    public void setToSearchForTextOccurrences(PsiElement element, boolean enabled) {
        if (element instanceof PsiFileSystemItem) {
            RefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_FILE = enabled;
        }
    }

    public boolean showRenamePreviewButton(PsiElement psiElement) {
        return true;
    }

    @Nullable
    public PsiElement substituteElementToRename(PsiElement element, @Nullable Editor editor) {
        return element;
    }

    public void substituteElementToRename(@NotNull PsiElement element, @NotNull Editor editor, @NotNull Pass<PsiElement> renameCallback) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/rename/RenamePsiElementProcessor", "substituteElementToRename"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/refactoring/rename/RenamePsiElementProcessor", "substituteElementToRename"));
        }
        if (renameCallback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renameCallback", "com/intellij/refactoring/rename/RenamePsiElementProcessor", "substituteElementToRename"));
        }
        PsiElement psiElement = this.substituteElementToRename(element, editor);
        if (psiElement == null) {
            return;
        }
        if (!PsiElementRenameHandler.canRename(psiElement.getProject(), editor, psiElement)) {
            return;
        }
        renameCallback.pass((Object)psiElement);
    }

    public void findCollisions(PsiElement element, String newName, Map<? extends PsiElement, String> allRenames, List<UsageInfo> result) {
    }

    public boolean forcesShowPreview() {
        return false;
    }

    @Nullable
    public PsiElement getElementToSearchInStringsAndComments(PsiElement element) {
        return element;
    }
}

