/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.safeDelete;

import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.lang.LanguageRefactoringSupport;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.refactoring.RefactoringSupportProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbModePermission;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.refactoring.safeDelete.NonCodeUsageSearchInfo;
import com.intellij.refactoring.safeDelete.SafeDeleteHandler;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessorDelegate;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessorDelegateBase;
import com.intellij.refactoring.safeDelete.SafeDeleteUsageViewDescriptor;
import com.intellij.refactoring.safeDelete.UnsafeUsagesDialog;
import com.intellij.refactoring.safeDelete.UsageHolder;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteCustomUsageInfo;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteReferenceSimpleDeleteUsageInfo;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteReferenceUsageInfo;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteUsageInfo;
import com.intellij.refactoring.util.NonCodeSearchDescriptionLocation;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.TextOccurrencesUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageInfoFactory;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.UsageInfoToUsageConverter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SafeDeleteProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.safeDelete.SafeDeleteProcessor");
    private final PsiElement[] myElements;
    private boolean mySearchInCommentsAndStrings;
    private boolean mySearchNonJava;
    private boolean myPreviewNonCodeUsages = true;
    private String myCachedCommandName = null;

    private SafeDeleteProcessor(Project project2, @Nullable Runnable prepareSuccessfulCallback, PsiElement[] elementsToDelete, boolean isSearchInComments, boolean isSearchNonJava) {
        super(project2, prepareSuccessfulCallback);
        this.myElements = elementsToDelete;
        this.mySearchInCommentsAndStrings = isSearchInComments;
        this.mySearchNonJava = isSearchNonJava;
    }

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/safeDelete/SafeDeleteProcessor", "createUsageViewDescriptor"));
        }
        SafeDeleteUsageViewDescriptor safeDeleteUsageViewDescriptor = new SafeDeleteUsageViewDescriptor(this.myElements);
        if (safeDeleteUsageViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/safeDelete/SafeDeleteProcessor", "createUsageViewDescriptor"));
        }
        return safeDeleteUsageViewDescriptor;
    }

    private static boolean isInside(PsiElement place, PsiElement[] ancestors) {
        return SafeDeleteProcessor.isInside(place, Arrays.asList(ancestors));
    }

    private static boolean isInside(PsiElement place, Collection<? extends PsiElement> ancestors) {
        for (PsiElement psiElement : ancestors) {
            if (!SafeDeleteProcessor.isInside(place, psiElement)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInside(PsiElement place, PsiElement ancestor) {
        PsiElement nameIdentifier;
        boolean isAncestor;
        if (ancestor instanceof PsiDirectoryContainer) {
            PsiDirectory[] directories = ((PsiDirectoryContainer)ancestor).getDirectories(place.getResolveScope());
            for (PsiDirectory directory : directories) {
                if (!SafeDeleteProcessor.isInside(place, (PsiElement)directory)) continue;
                return true;
            }
        }
        if (ancestor instanceof PsiFile) {
            for (PsiFile file2 : ((PsiFile)ancestor).getViewProvider().getAllFiles()) {
                if (!PsiTreeUtil.isAncestor((PsiElement)file2, (PsiElement)place, (boolean)false)) continue;
                return true;
            }
        }
        if (!(isAncestor = PsiTreeUtil.isAncestor((PsiElement)ancestor, (PsiElement)place, (boolean)false)) && ancestor instanceof PsiNameIdentifierOwner && (nameIdentifier = ((PsiNameIdentifierOwner)ancestor).getNameIdentifier()) != null && !PsiTreeUtil.isAncestor((PsiElement)ancestor, (PsiElement)nameIdentifier, (boolean)true)) {
            isAncestor = PsiTreeUtil.isAncestor((PsiElement)nameIdentifier.getParent(), (PsiElement)place, (boolean)false);
        }
        if (!isAncestor) {
            InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)place.getProject());
            PsiLanguageInjectionHost host = injectedLanguageManager.getInjectionHost(place);
            while (host != null) {
                if (PsiTreeUtil.isAncestor((PsiElement)ancestor, (PsiElement)host, (boolean)false)) {
                    isAncestor = true;
                    break;
                }
                host = injectedLanguageManager.getInjectionHost((PsiElement)host);
            }
        }
        return isAncestor;
    }

    @Override
    @NotNull
    protected UsageInfo[] findUsages() {
        List<UsageInfo> usages = Collections.synchronizedList(new ArrayList());
        for (PsiElement element : this.myElements) {
            boolean handled = false;
            for (SafeDeleteProcessorDelegate delegate : (SafeDeleteProcessorDelegate[])Extensions.getExtensions(SafeDeleteProcessorDelegate.EP_NAME)) {
                if (!delegate.handlesElement(element)) continue;
                NonCodeUsageSearchInfo filter = delegate.findUsages(element, this.myElements, usages);
                if (filter != null) {
                    for (PsiElement nonCodeUsageElement : filter.getElementsToSearch()) {
                        SafeDeleteProcessor.addNonCodeUsages(nonCodeUsageElement, usages, filter.getInsideDeletedCondition(), this.mySearchNonJava, this.mySearchInCommentsAndStrings);
                    }
                }
                handled = true;
                break;
            }
            if (handled || !(element instanceof PsiNamedElement)) continue;
            SafeDeleteProcessor.findGenericElementUsages(element, usages, this.myElements);
            SafeDeleteProcessor.addNonCodeUsages(element, usages, SafeDeleteProcessor.getDefaultInsideDeletedCondition(this.myElements), this.mySearchNonJava, this.mySearchInCommentsAndStrings);
        }
        UsageInfo[] result = usages.toArray(new UsageInfo[usages.size()]);
        UsageInfo[] usageInfoArray = UsageViewUtil.removeDuplicatedUsages(result);
        if (usageInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/safeDelete/SafeDeleteProcessor", "findUsages"));
        }
        return usageInfoArray;
    }

    public static Condition<PsiElement> getDefaultInsideDeletedCondition(final PsiElement[] elements) {
        return new Condition<PsiElement>(){

            public boolean value(PsiElement usage) {
                return !(usage instanceof PsiFile) && SafeDeleteProcessor.isInside(usage, elements);
            }
        };
    }

    public static void findGenericElementUsages(final PsiElement element, final List<UsageInfo> usages, final PsiElement[] allElementsToDelete) {
        ReferencesSearch.search((PsiElement)element).forEach((Processor)new Processor<PsiReference>(){

            public boolean process(PsiReference reference) {
                PsiElement refElement = reference.getElement();
                if (!SafeDeleteProcessor.isInside(refElement, allElementsToDelete)) {
                    usages.add(new SafeDeleteReferenceSimpleDeleteUsageInfo(refElement, element, false));
                }
                return true;
            }
        });
    }

    @Override
    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refUsages", "com/intellij/refactoring/safeDelete/SafeDeleteProcessor", "preprocessUsages"));
        }
        UsageInfo[] usages = (UsageInfo[])refUsages.get();
        ArrayList<String> conflicts = new ArrayList<String>();
        block0: for (PsiElement psiElement : this.myElements) {
            SafeDeleteProcessorDelegate[] safeDeleteProcessorDelegateArray = (SafeDeleteProcessorDelegate[])Extensions.getExtensions(SafeDeleteProcessorDelegate.EP_NAME);
            int n = safeDeleteProcessorDelegateArray.length;
            for (int i = 0; i < n; ++i) {
                SafeDeleteProcessorDelegate delegate = safeDeleteProcessorDelegateArray[i];
                if (!delegate.handlesElement(psiElement)) continue;
                Collection<String> foundConflicts = delegate.findConflicts(psiElement, this.myElements);
                if (foundConflicts == null) continue block0;
                conflicts.addAll(foundConflicts);
                continue block0;
            }
        }
        HashMap<PsiElement, UsageHolder> elementsToUsageHolders = SafeDeleteProcessor.sortUsages(usages);
        Collection usageHolders = elementsToUsageHolders.values();
        for (UsageHolder usageHolder : usageHolders) {
            if (!usageHolder.hasUnsafeUsagesInCode()) continue;
            conflicts.add(usageHolder.getDescription());
        }
        if (!conflicts.isEmpty()) {
            RefactoringEventData conflictData = new RefactoringEventData();
            conflictData.putUserData(RefactoringEventData.CONFLICTS_KEY, conflicts);
            ((RefactoringEventListener)this.myProject.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).conflictsDetected("refactoring.safeDelete", conflictData);
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                if (!BaseRefactoringProcessor.ConflictsInTestsException.isTestIgnore()) {
                    throw new BaseRefactoringProcessor.ConflictsInTestsException(conflicts);
                }
            } else {
                UnsafeUsagesDialog unsafeUsagesDialog = new UnsafeUsagesDialog(ArrayUtil.toStringArray(conflicts), this.myProject);
                if (!unsafeUsagesDialog.showAndGet()) {
                    int exitCode = unsafeUsagesDialog.getExitCode();
                    this.prepareSuccessful();
                    if (exitCode == 2) {
                        this.showUsages(usages);
                    }
                    return false;
                }
                this.myPreviewNonCodeUsages = false;
            }
        }
        UsageInfo[] preprocessedUsages = usages;
        for (SafeDeleteProcessorDelegate delegate : (SafeDeleteProcessorDelegate[])Extensions.getExtensions(SafeDeleteProcessorDelegate.EP_NAME)) {
            if ((preprocessedUsages = delegate.preprocessUsages(this.myProject, preprocessedUsages)) != null) continue;
            return false;
        }
        UsageInfo[] usageInfoArray = UsageViewUtil.removeDuplicatedUsages(preprocessedUsages);
        this.prepareSuccessful();
        if (usageInfoArray == null) {
            return false;
        }
        refUsages.set((Object)usageInfoArray);
        return true;
    }

    private void showUsages(final UsageInfo[] usages) {
        UsageViewPresentation presentation = new UsageViewPresentation();
        presentation.setTabText(RefactoringBundle.message((String)"safe.delete.title"));
        presentation.setTargetsNodeText(RefactoringBundle.message((String)"attempting.to.delete.targets.node.text"));
        presentation.setShowReadOnlyStatusAsRed(true);
        presentation.setShowCancelButton(true);
        presentation.setCodeUsagesString(RefactoringBundle.message((String)"references.found.in.code"));
        presentation.setUsagesInGeneratedCodeString(RefactoringBundle.message((String)"references.found.in.generated.code"));
        presentation.setNonCodeUsagesString(RefactoringBundle.message((String)"occurrences.found.in.comments.strings.and.non.java.files"));
        presentation.setUsagesString(RefactoringBundle.message((String)"usageView.usagesText"));
        UsageViewManager manager = UsageViewManager.getInstance((Project)this.myProject);
        UsageView usageView = this.showUsages(usages, presentation, manager);
        usageView.addPerformOperationAction((Runnable)new RerunSafeDelete(this.myProject, this.myElements, usageView), RefactoringBundle.message((String)"retry.command"), null, RefactoringBundle.message((String)"rerun.safe.delete"));
        usageView.addPerformOperationAction(new Runnable(){

            @Override
            public void run() {
                UsageInfo[] preprocessedUsages = usages;
                for (SafeDeleteProcessorDelegate delegate : (SafeDeleteProcessorDelegate[])Extensions.getExtensions(SafeDeleteProcessorDelegate.EP_NAME)) {
                    preprocessedUsages = delegate.preprocessUsages(SafeDeleteProcessor.this.myProject, preprocessedUsages);
                    if (preprocessedUsages != null) continue;
                    return;
                }
                UsageInfo[] filteredUsages = UsageViewUtil.removeDuplicatedUsages(preprocessedUsages);
                SafeDeleteProcessor.this.execute(filteredUsages);
            }
        }, "Delete Anyway", RefactoringBundle.message((String)"usageView.need.reRun"), RefactoringBundle.message((String)"usageView.doAction"));
    }

    private UsageView showUsages(UsageInfo[] usages, UsageViewPresentation presentation, UsageViewManager manager) {
        for (SafeDeleteProcessorDelegate delegate : (SafeDeleteProcessorDelegate[])Extensions.getExtensions(SafeDeleteProcessorDelegate.EP_NAME)) {
            UsageView view;
            if (!(delegate instanceof SafeDeleteProcessorDelegateBase) || (view = ((SafeDeleteProcessorDelegateBase)delegate).showUsages(usages, presentation, manager, this.myElements)) == null) continue;
            return view;
        }
        UsageTarget[] targets = new UsageTarget[this.myElements.length];
        for (int i = 0; i < targets.length; ++i) {
            targets[i] = new PsiElement2UsageTargetAdapter(this.myElements[i]);
        }
        return manager.showUsages(targets, UsageInfoToUsageConverter.convert((PsiElement[])this.myElements, (UsageInfo[])usages), presentation);
    }

    public PsiElement[] getElements() {
        return this.myElements;
    }

    private static HashMap<PsiElement, UsageHolder> sortUsages(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/safeDelete/SafeDeleteProcessor", "sortUsages"));
        }
        HashMap result = new HashMap();
        for (UsageInfo usage : usages) {
            PsiElement referencedElement;
            if (!(usage instanceof SafeDeleteUsageInfo) || result.containsKey((Object)(referencedElement = ((SafeDeleteUsageInfo)usage).getReferencedElement()))) continue;
            result.put((Object)referencedElement, (Object)new UsageHolder(referencedElement, usages));
        }
        return result;
    }

    @Override
    protected void refreshElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/safeDelete/SafeDeleteProcessor", "refreshElements"));
        }
        LOG.assertTrue(elements.length == this.myElements.length);
        System.arraycopy(elements, 0, this.myElements, 0, elements.length);
    }

    @Override
    protected boolean isPreviewUsages(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/safeDelete/SafeDeleteProcessor", "isPreviewUsages"));
        }
        if (this.myPreviewNonCodeUsages && UsageViewUtil.reportNonRegularUsages(usages, this.myProject)) {
            return true;
        }
        return super.isPreviewUsages(SafeDeleteProcessor.filterToBeDeleted(usages));
    }

    private static UsageInfo[] filterToBeDeleted(UsageInfo[] infos) {
        ArrayList<UsageInfo> list = new ArrayList<UsageInfo>();
        for (UsageInfo info : infos) {
            if (info instanceof SafeDeleteReferenceUsageInfo && !((SafeDeleteReferenceUsageInfo)info).isSafeDelete()) continue;
            list.add(info);
        }
        return list.toArray(new UsageInfo[list.size()]);
    }

    @Override
    @Nullable
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData beforeData = new RefactoringEventData();
        beforeData.addElements(this.myElements);
        return beforeData;
    }

    @Override
    @Nullable
    protected String getRefactoringId() {
        return "refactoring.safeDelete";
    }

    @Override
    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/safeDelete/SafeDeleteProcessor", "performRefactoring"));
        }
        try {
            for (UsageInfo usage : usages) {
                if (!(usage instanceof SafeDeleteCustomUsageInfo)) continue;
                ((SafeDeleteCustomUsageInfo)usage).performRefactoring();
            }
            DumbService.allowStartingDumbModeInside((DumbModePermission)DumbModePermission.MAY_START_MODAL, (Runnable)new Runnable(){

                @Override
                public void run() {
                    for (PsiElement element : SafeDeleteProcessor.this.myElements) {
                        for (SafeDeleteProcessorDelegate delegate : (SafeDeleteProcessorDelegate[])Extensions.getExtensions(SafeDeleteProcessorDelegate.EP_NAME)) {
                            if (!delegate.handlesElement(element)) continue;
                            delegate.prepareForDeletion(element);
                        }
                        element.delete();
                    }
                }
            });
        }
        catch (IncorrectOperationException e) {
            RefactoringUIUtil.processIncorrectOperation(this.myProject, e);
        }
    }

    private String calcCommandName() {
        return RefactoringBundle.message((String)"safe.delete.command", (Object[])new Object[]{RefactoringUIUtil.calculatePsiElementDescriptionList(this.myElements)});
    }

    @Override
    protected String getCommandName() {
        if (this.myCachedCommandName == null) {
            this.myCachedCommandName = this.calcCommandName();
        }
        return this.myCachedCommandName;
    }

    public static void addNonCodeUsages(final PsiElement element, List<UsageInfo> usages, final @Nullable Condition<PsiElement> insideElements, boolean searchNonJava, boolean searchInCommentsAndStrings) {
        String stringToSearch;
        UsageInfoFactory nonCodeUsageFactory = new UsageInfoFactory(){

            public UsageInfo createUsageInfo(@NotNull PsiElement usage, int startOffset, int endOffset) {
                if (usage == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/refactoring/safeDelete/SafeDeleteProcessor$5", "createUsageInfo"));
                }
                if (insideElements != null && insideElements.value((Object)usage)) {
                    return null;
                }
                return new SafeDeleteReferenceSimpleDeleteUsageInfo(usage, element, startOffset, endOffset, true, false);
            }
        };
        if (searchInCommentsAndStrings) {
            stringToSearch = ElementDescriptionUtil.getElementDescription((PsiElement)element, (ElementDescriptionLocation)NonCodeSearchDescriptionLocation.STRINGS_AND_COMMENTS);
            TextOccurrencesUtil.addUsagesInStringsAndComments(element, stringToSearch, usages, nonCodeUsageFactory);
        }
        if (searchNonJava) {
            stringToSearch = ElementDescriptionUtil.getElementDescription((PsiElement)element, (ElementDescriptionLocation)NonCodeSearchDescriptionLocation.NON_JAVA);
            TextOccurrencesUtil.addTextOccurences(element, stringToSearch, GlobalSearchScope.projectScope((Project)element.getProject()), usages, nonCodeUsageFactory);
        }
    }

    @Override
    protected boolean isToBeChanged(@NotNull UsageInfo usageInfo) {
        if (usageInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageInfo", "com/intellij/refactoring/safeDelete/SafeDeleteProcessor", "isToBeChanged"));
        }
        if (usageInfo instanceof SafeDeleteReferenceUsageInfo) {
            return ((SafeDeleteReferenceUsageInfo)usageInfo).isSafeDelete() && super.isToBeChanged(usageInfo);
        }
        return super.isToBeChanged(usageInfo);
    }

    public static boolean validElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/safeDelete/SafeDeleteProcessor", "validElement"));
        }
        if (element instanceof PsiFile) {
            return true;
        }
        if (!element.isPhysical()) {
            return false;
        }
        RefactoringSupportProvider provider = (RefactoringSupportProvider)LanguageRefactoringSupport.INSTANCE.forLanguage(element.getLanguage());
        return provider.isSafeDeleteAvailable(element);
    }

    public static SafeDeleteProcessor createInstance(Project project2, @Nullable Runnable prepareSuccessfulCallback, PsiElement[] elementsToDelete, boolean isSearchInComments, boolean isSearchNonJava) {
        return new SafeDeleteProcessor(project2, prepareSuccessfulCallback, elementsToDelete, isSearchInComments, isSearchNonJava);
    }

    public static SafeDeleteProcessor createInstance(Project project2, @Nullable Runnable prepareSuccessfulCallBack, PsiElement[] elementsToDelete, boolean isSearchInComments, boolean isSearchNonJava, boolean askForAccessors) {
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>(Arrays.asList(elementsToDelete));
        HashSet<PsiElement> elementsToDeleteSet = new HashSet<PsiElement>(Arrays.asList(elementsToDelete));
        block0: for (PsiElement psiElement : elementsToDelete) {
            for (SafeDeleteProcessorDelegate delegate : (SafeDeleteProcessorDelegate[])Extensions.getExtensions(SafeDeleteProcessorDelegate.EP_NAME)) {
                if (!delegate.handlesElement(psiElement)) continue;
                Collection<PsiElement> addedElements = delegate.getAdditionalElementsToDelete(psiElement, elementsToDeleteSet, askForAccessors);
                if (addedElements == null) continue block0;
                elements.addAll(addedElements);
                continue block0;
            }
        }
        return new SafeDeleteProcessor(project2, prepareSuccessfulCallBack, PsiUtilCore.toPsiElementArray(elements), isSearchInComments, isSearchNonJava);
    }

    public boolean isSearchInCommentsAndStrings() {
        return this.mySearchInCommentsAndStrings;
    }

    public void setSearchInCommentsAndStrings(boolean searchInCommentsAndStrings) {
        this.mySearchInCommentsAndStrings = searchInCommentsAndStrings;
    }

    public boolean isSearchNonJava() {
        return this.mySearchNonJava;
    }

    public void setSearchNonJava(boolean searchNonJava) {
        this.mySearchNonJava = searchNonJava;
    }

    @Override
    protected boolean skipNonCodeUsages() {
        return true;
    }

    private static class RerunSafeDelete
    implements Runnable {
        final SmartPsiElementPointer[] myPointers;
        private final Project myProject;
        private final UsageView myUsageView;

        RerunSafeDelete(Project project2, PsiElement[] elements, UsageView usageView) {
            this.myProject = project2;
            this.myUsageView = usageView;
            this.myPointers = new SmartPsiElementPointer[elements.length];
            for (int i = 0; i < elements.length; ++i) {
                PsiElement element = elements[i];
                this.myPointers[i] = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer(element);
            }
        }

        @Override
        public void run() {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    PsiDocumentManager.getInstance((Project)RerunSafeDelete.this.myProject).commitAllDocuments();
                    RerunSafeDelete.this.myUsageView.close();
                    ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
                    for (SmartPsiElementPointer pointer : RerunSafeDelete.this.myPointers) {
                        PsiElement element = pointer.getElement();
                        if (element == null) continue;
                        elements.add(element);
                    }
                    if (!elements.isEmpty()) {
                        SafeDeleteHandler.invoke(RerunSafeDelete.this.myProject, PsiUtilCore.toPsiElementArray(elements), true);
                    }
                }
            });
        }
    }
}

