/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.remote.CredentialsType;
import com.intellij.remote.DockerCredentialsHolder;
import com.intellij.remote.RemoteConnectionCredentialsWrapper;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.remote.RemoteSdkConnectionAcceptor;
import com.intellij.remote.VagrantBasedCredentialsHolder;
import com.intellij.remote.WebDeploymentCredentialsHolder;
import org.jetbrains.annotations.NotNull;

public class DefaultRemoteSdkConnectionAcceptor
implements RemoteSdkConnectionAcceptor {
    private CredentialsType myCredentialsType;

    @Override
    public void ssh(@NotNull RemoteCredentialsHolder cred) {
        if (cred == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cred", "com/intellij/remote/DefaultRemoteSdkConnectionAcceptor", "ssh"));
        }
        this.myCredentialsType = CredentialsType.SSH_HOST;
    }

    @Override
    public void vagrant(@NotNull VagrantBasedCredentialsHolder cred) {
        if (cred == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cred", "com/intellij/remote/DefaultRemoteSdkConnectionAcceptor", "vagrant"));
        }
        this.myCredentialsType = CredentialsType.VAGRANT;
    }

    @Override
    public void deployment(@NotNull WebDeploymentCredentialsHolder cred) {
        if (cred == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cred", "com/intellij/remote/DefaultRemoteSdkConnectionAcceptor", "deployment"));
        }
        this.myCredentialsType = CredentialsType.WEB_DEPLOYMENT;
    }

    @Override
    public void docker(@NotNull DockerCredentialsHolder cred) {
        if (cred == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cred", "com/intellij/remote/DefaultRemoteSdkConnectionAcceptor", "docker"));
        }
        this.myCredentialsType = CredentialsType.DOCKER;
    }

    public CredentialsType getCredentialsType() {
        return this.myCredentialsType;
    }

    public static CredentialsType getRemoteConnectionType(@NotNull RemoteConnectionCredentialsWrapper wrapper) {
        if (wrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapper", "com/intellij/remote/DefaultRemoteSdkConnectionAcceptor", "getRemoteConnectionType"));
        }
        DefaultRemoteSdkConnectionAcceptor acceptor = new DefaultRemoteSdkConnectionAcceptor();
        wrapper.switchType(acceptor);
        return acceptor.getCredentialsType();
    }
}

