/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.DefaultRemoteSdkConnectionAcceptor;
import com.intellij.remote.DockerCredentialsHolder;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.remote.RemoteSdkConnectionAcceptor;
import com.intellij.remote.VagrantBasedCredentialsHolder;
import com.intellij.remote.WebDeploymentCredentialsHolder;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class RemoteConnectionCredentialsWrapper {
    public static final String VAGRANT_PREFIX = "vagrant://";
    public static final String SFTP_DEPLOYMENT_PREFIX = "sftp://";
    public static final String DOCKER_PREFIX = "docker://";
    public final Key<VagrantBasedCredentialsHolder> VAGRANT_BASED_CREDENTIALS = Key.create((String)"VAGRANT_BASED_CREDENTIALS");
    public final Key<WebDeploymentCredentialsHolder> WEB_DEPLOYMENT_BASED_CREDENTIALS = Key.create((String)"WEB_DEPLOYMENT_BASED_CREDENTIALS");
    public final Key<RemoteCredentialsHolder> PLAIN_SSH_CREDENTIALS = Key.create((String)"PLAIN_SSH_CREDENTIALS");
    public final Key<DockerCredentialsHolder> DOCKER_CREDENTIALS = Key.create((String)"DOCKER_CREDENTIALS");
    private UserDataHolderBase myCredentialsTypeHolder = new UserDataHolderBase();

    public void setVagrantConnectionType(VagrantBasedCredentialsHolder vagrantBasedCredentials) {
        this.myCredentialsTypeHolder = new UserDataHolderBase();
        this.myCredentialsTypeHolder.putUserData(this.VAGRANT_BASED_CREDENTIALS, (Object)vagrantBasedCredentials);
    }

    private VagrantBasedCredentialsHolder getVagrantCredentials() {
        return (VagrantBasedCredentialsHolder)this.myCredentialsTypeHolder.getUserData(this.VAGRANT_BASED_CREDENTIALS);
    }

    public void setPlainSshCredentials(RemoteCredentialsHolder credentials) {
        this.myCredentialsTypeHolder = new UserDataHolderBase();
        this.myCredentialsTypeHolder.putUserData(this.PLAIN_SSH_CREDENTIALS, (Object)credentials);
    }

    private RemoteCredentialsHolder getPlainSshCredentials() {
        return (RemoteCredentialsHolder)this.myCredentialsTypeHolder.getUserData(this.PLAIN_SSH_CREDENTIALS);
    }

    public void setWebDeploymentCredentials(WebDeploymentCredentialsHolder webDeploymentCredentials) {
        this.myCredentialsTypeHolder = new UserDataHolderBase();
        this.myCredentialsTypeHolder.putUserData(this.WEB_DEPLOYMENT_BASED_CREDENTIALS, (Object)webDeploymentCredentials);
    }

    public WebDeploymentCredentialsHolder getWebDeploymentCredentials() {
        return (WebDeploymentCredentialsHolder)this.myCredentialsTypeHolder.getUserData(this.WEB_DEPLOYMENT_BASED_CREDENTIALS);
    }

    private DockerCredentialsHolder getDockerCredentials() {
        return (DockerCredentialsHolder)this.myCredentialsTypeHolder.getUserData(this.DOCKER_CREDENTIALS);
    }

    private boolean isVagrantConnection() {
        return this.getVagrantCredentials() != null;
    }

    private boolean isPlainSshConnection() {
        return this.getPlainSshCredentials() != null;
    }

    private boolean isWebDeploymentConnection() {
        return this.getWebDeploymentCredentials() != null;
    }

    private boolean isDockerConnection() {
        return this.getDockerCredentials() != null;
    }

    public Object getConnectionKey() {
        if (this.isVagrantConnection()) {
            return this.getVagrantCredentials();
        }
        if (this.isPlainSshConnection()) {
            return this.getPlainSshCredentials();
        }
        if (this.isWebDeploymentConnection()) {
            return this.getWebDeploymentCredentials();
        }
        if (this.isDockerConnection()) {
            return this.getDockerCredentials();
        }
        throw RemoteConnectionCredentialsWrapper.unknownConnectionType();
    }

    public void save(final Element rootElement) {
        this.switchType(new RemoteSdkConnectionAcceptor(){

            @Override
            public void ssh(@NotNull RemoteCredentialsHolder cred) {
                if (cred == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cred", "com/intellij/remote/RemoteConnectionCredentialsWrapper$1", "ssh"));
                }
                cred.save(rootElement);
            }

            @Override
            public void vagrant(@NotNull VagrantBasedCredentialsHolder cred) {
                if (cred == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cred", "com/intellij/remote/RemoteConnectionCredentialsWrapper$1", "vagrant"));
                }
                cred.save(rootElement);
            }

            @Override
            public void deployment(@NotNull WebDeploymentCredentialsHolder cred) {
                if (cred == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cred", "com/intellij/remote/RemoteConnectionCredentialsWrapper$1", "deployment"));
                }
                cred.save(rootElement);
            }

            @Override
            public void docker(@NotNull DockerCredentialsHolder cred) {
                if (cred == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cred", "com/intellij/remote/RemoteConnectionCredentialsWrapper$1", "docker"));
                }
                cred.save(rootElement);
            }
        });
    }

    public static IllegalStateException unknownConnectionType() {
        return new IllegalStateException("Unknown connection type");
    }

    public void copyTo(final RemoteConnectionCredentialsWrapper copy) {
        copy.myCredentialsTypeHolder = new UserDataHolderBase();
        this.switchType(new RemoteSdkConnectionAcceptor(){

            @Override
            public void ssh(@NotNull RemoteCredentialsHolder cred) {
                if (cred == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cred", "com/intellij/remote/RemoteConnectionCredentialsWrapper$2", "ssh"));
                }
                copy.setPlainSshCredentials(RemoteConnectionCredentialsWrapper.this.getPlainSshCredentials());
            }

            @Override
            public void vagrant(@NotNull VagrantBasedCredentialsHolder cred) {
                if (cred == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cred", "com/intellij/remote/RemoteConnectionCredentialsWrapper$2", "vagrant"));
                }
                copy.setVagrantConnectionType(RemoteConnectionCredentialsWrapper.this.getVagrantCredentials());
            }

            @Override
            public void deployment(@NotNull WebDeploymentCredentialsHolder cred) {
                if (cred == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cred", "com/intellij/remote/RemoteConnectionCredentialsWrapper$2", "deployment"));
                }
                copy.setWebDeploymentCredentials(RemoteConnectionCredentialsWrapper.this.getWebDeploymentCredentials());
            }

            @Override
            public void docker(@NotNull DockerCredentialsHolder credentials) {
                if (credentials == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "credentials", "com/intellij/remote/RemoteConnectionCredentialsWrapper$2", "docker"));
                }
                copy.setDockerDeploymentCredentials(RemoteConnectionCredentialsWrapper.this.getDockerCredentials());
            }
        });
    }

    @NotNull
    public String getId() {
        final Ref result = Ref.create();
        this.switchType(new RemoteSdkConnectionAcceptor(){

            @Override
            public void ssh(@NotNull RemoteCredentialsHolder cred) {
                if (cred == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cred", "com/intellij/remote/RemoteConnectionCredentialsWrapper$3", "ssh"));
                }
                result.set((Object)RemoteConnectionCredentialsWrapper.constructSshCredentialsFullPath(cred));
            }

            @Override
            public void vagrant(@NotNull VagrantBasedCredentialsHolder cred) {
                if (cred == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cred", "com/intellij/remote/RemoteConnectionCredentialsWrapper$3", "vagrant"));
                }
                result.set((Object)(RemoteConnectionCredentialsWrapper.VAGRANT_PREFIX + cred.getVagrantFolder() + (StringUtil.isNotEmpty((String)cred.getMachineName()) ? "@" + cred.getMachineName() : "")));
            }

            @Override
            public void deployment(@NotNull WebDeploymentCredentialsHolder cred) {
                if (cred == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cred", "com/intellij/remote/RemoteConnectionCredentialsWrapper$3", "deployment"));
                }
                result.set((Object)RemoteConnectionCredentialsWrapper.constructSftpCredentialsFullPath(cred.getSshCredentials()));
            }

            @Override
            public void docker(@NotNull DockerCredentialsHolder cred) {
                if (cred == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cred", "com/intellij/remote/RemoteConnectionCredentialsWrapper$3", "docker"));
                }
                String name = StringUtil.isNotEmpty((String)cred.getContainerName()) ? cred.getContainerName() : cred.getImageName();
                result.set((Object)(RemoteConnectionCredentialsWrapper.DOCKER_PREFIX + name + "/"));
            }
        });
        String string = (String)result.get();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remote/RemoteConnectionCredentialsWrapper", "getId"));
        }
        return string;
    }

    @NotNull
    private static String constructSftpCredentialsFullPath(RemoteCredentials cred) {
        String string = SFTP_DEPLOYMENT_PREFIX + cred.getUserName() + "@" + cred.getHost() + ":" + cred.getPort();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remote/RemoteConnectionCredentialsWrapper", "constructSftpCredentialsFullPath"));
        }
        return string;
    }

    @NotNull
    public static String constructSshCredentialsFullPath(RemoteCredentials cred) {
        String string = "ssh://" + cred.getUserName() + "@" + cred.getHost() + ":" + cred.getPort();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remote/RemoteConnectionCredentialsWrapper", "constructSshCredentialsFullPath"));
        }
        return string;
    }

    public CredentialsType getRemoteConnectionType() {
        return DefaultRemoteSdkConnectionAcceptor.getRemoteConnectionType(this);
    }

    public void switchType(@NotNull RemoteSdkConnectionAcceptor acceptor) {
        if (acceptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "acceptor", "com/intellij/remote/RemoteConnectionCredentialsWrapper", "switchType"));
        }
        if (this.isVagrantConnection()) {
            acceptor.vagrant(this.getVagrantCredentials());
        } else if (this.isPlainSshConnection()) {
            acceptor.ssh(this.getPlainSshCredentials());
        } else if (this.isWebDeploymentConnection()) {
            acceptor.deployment(this.getWebDeploymentCredentials());
        } else if (this.isDockerConnection()) {
            acceptor.docker(this.getDockerCredentials());
        } else {
            throw RemoteConnectionCredentialsWrapper.unknownConnectionType();
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof RemoteConnectionCredentialsWrapper) {
            RemoteConnectionCredentialsWrapper w = (RemoteConnectionCredentialsWrapper)obj;
            if (this.isVagrantConnection()) {
                return w.isVagrantConnection() && this.getVagrantCredentials().equals(w.getVagrantCredentials());
            }
            if (this.isWebDeploymentConnection()) {
                return w.isWebDeploymentConnection() && this.getWebDeploymentCredentials().equals(w.getWebDeploymentCredentials());
            }
            if (this.isPlainSshConnection()) {
                return w.isPlainSshConnection() && this.getPlainSshCredentials().equals(w.getPlainSshCredentials());
            }
        }
        return false;
    }

    public String getPresentableDetails(final String interpreterPath) {
        final Ref result = Ref.create();
        this.switchType(new RemoteSdkConnectionAcceptor(){

            @Override
            public void ssh(@NotNull RemoteCredentialsHolder cred) {
                if (cred == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cred", "com/intellij/remote/RemoteConnectionCredentialsWrapper$4", "ssh"));
                }
                result.set((Object)("(" + RemoteConnectionCredentialsWrapper.constructSshCredentialsFullPath(cred) + interpreterPath + ")"));
            }

            @Override
            public void vagrant(@NotNull VagrantBasedCredentialsHolder cred) {
                if (cred == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cred", "com/intellij/remote/RemoteConnectionCredentialsWrapper$4", "vagrant"));
                }
                String pathRelativeToHome = FileUtil.getLocationRelativeToUserHome((String)cred.getVagrantFolder());
                result.set((Object)("Vagrant VM " + (StringUtil.isNotEmpty((String)cred.getMachineName()) ? "'" + cred.getMachineName() + "' " : "") + "at " + (pathRelativeToHome.length() < cred.getVagrantFolder().length() ? pathRelativeToHome : cred.getVagrantFolder()) + " (" + interpreterPath + ")"));
            }

            @Override
            public void deployment(@NotNull WebDeploymentCredentialsHolder cred) {
                if (cred == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cred", "com/intellij/remote/RemoteConnectionCredentialsWrapper$4", "deployment"));
                }
                result.set((Object)("(" + RemoteConnectionCredentialsWrapper.constructSftpCredentialsFullPath(cred.getSshCredentials()) + interpreterPath + ")"));
            }

            @Override
            public void docker(@NotNull DockerCredentialsHolder credentials) {
                if (credentials == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "credentials", "com/intellij/remote/RemoteConnectionCredentialsWrapper$4", "docker"));
                }
                String containerName = StringUtil.isNotEmpty((String)credentials.getContainerName()) ? credentials.getContainerName() + " " : "";
                result.set((Object)("Docker " + containerName + "(" + credentials.getImageName() + ")"));
            }
        });
        return (String)result.get();
    }

    public void setDockerDeploymentCredentials(DockerCredentialsHolder credentials) {
        this.myCredentialsTypeHolder = new UserDataHolderBase();
        this.myCredentialsTypeHolder.putUserData(this.DOCKER_CREDENTIALS, (Object)credentials);
    }

    public void loadCredentials(@NotNull String interpreterPath, @NotNull Element element) {
        if (interpreterPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreterPath", "com/intellij/remote/RemoteConnectionCredentialsWrapper", "loadCredentials"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/remote/RemoteConnectionCredentialsWrapper", "loadCredentials"));
        }
        if (interpreterPath.startsWith("ssh://")) {
            RemoteCredentialsHolder remoteSdkCred = new RemoteCredentialsHolder();
            remoteSdkCred.load(element);
            this.setPlainSshCredentials(remoteSdkCred);
        } else if (interpreterPath.startsWith(VAGRANT_PREFIX)) {
            VagrantBasedCredentialsHolder vagrantCred = new VagrantBasedCredentialsHolder();
            vagrantCred.load(element);
            this.setVagrantConnectionType(vagrantCred);
        } else if (interpreterPath.startsWith(SFTP_DEPLOYMENT_PREFIX)) {
            WebDeploymentCredentialsHolder deploymentCred = new WebDeploymentCredentialsHolder();
            deploymentCred.load(element);
            this.setWebDeploymentCredentials(deploymentCred);
        } else if (interpreterPath.startsWith(DOCKER_PREFIX)) {
            DockerCredentialsHolder dockerCred = new DockerCredentialsHolder();
            dockerCred.load(element);
            this.setDockerDeploymentCredentials(dockerCred);
        }
    }
}

