/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.generator;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spellchecker.SpellCheckerManager;
import com.intellij.spellchecker.inspections.SpellCheckingInspection;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class SpellCheckerDictionaryGenerator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.spellchecker.generator.SpellCheckerDictionaryGenerator");
    private final Set<String> globalSeenNames = new HashSet<String>();
    protected final Project myProject;
    private final String myDefaultDictName;
    protected final String myDictOutputFolder;
    protected final MultiMap<String, VirtualFile> myDict2FolderMap;
    protected final Set<VirtualFile> myExcludedFolders = new HashSet<VirtualFile>();
    protected SpellCheckerManager mySpellCheckerManager;

    public SpellCheckerDictionaryGenerator(Project project2, String dictOutputFolder, String defaultDictName) {
        this.myDict2FolderMap = new MultiMap();
        this.myProject = project2;
        this.myDefaultDictName = defaultDictName;
        this.mySpellCheckerManager = SpellCheckerManager.getInstance(this.myProject);
        this.myDictOutputFolder = dictOutputFolder;
    }

    public void addFolder(String dictName, VirtualFile path) {
        this.myDict2FolderMap.putValue((Object)dictName, (Object)path);
    }

    public void excludeFolder(VirtualFile folder) {
        this.myExcludedFolders.add(folder);
    }

    public void generate() {
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                SpellCheckerDictionaryGenerator.this.generate(SpellCheckerDictionaryGenerator.this.myDefaultDictName, progressIndicator);
                ArrayList dictionaries = new ArrayList(SpellCheckerDictionaryGenerator.this.myDict2FolderMap.keySet());
                Collections.sort(dictionaries);
                for (String dict : dictionaries) {
                    if (SpellCheckerDictionaryGenerator.this.myDefaultDictName.equals(dict)) continue;
                    SpellCheckerDictionaryGenerator.this.generate(dict, progressIndicator);
                }
            }
        }, "Generating Dictionaries", false, this.myProject);
    }

    private void generate(@NotNull String dict, ProgressIndicator progressIndicator) {
        if (dict == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dict", "com/intellij/spellchecker/generator/SpellCheckerDictionaryGenerator", "generate"));
        }
        progressIndicator.setText("Processing dictionary: " + dict);
        this.generateDictionary(this.myProject, this.myDict2FolderMap.get((Object)dict), this.myDictOutputFolder + "/" + dict + ".dic", progressIndicator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateDictionary(Project project2, Collection<VirtualFile> folderPaths, String outFile, ProgressIndicator progressIndicator) {
        HashSet<String> seenNames = new HashSet<String>();
        for (VirtualFile folder : folderPaths) {
            progressIndicator.setText2("Scanning folder: " + folder.getPath());
            PsiManager manager = PsiManager.getInstance((Project)project2);
            this.processFolder(seenNames, manager, folder);
        }
        if (seenNames.isEmpty()) {
            LOG.info("  No new words was found.");
            return;
        }
        StringBuilder builder = new StringBuilder();
        ArrayList names = new ArrayList(seenNames);
        Collections.sort(names);
        for (String name : names) {
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append(name);
        }
        try {
            File dictionaryFile = new File(outFile);
            FileUtil.createIfDoesntExist((File)dictionaryFile);
            FileWriter writer = new FileWriter(dictionaryFile.getPath());
            try {
                writer.write(builder.toString());
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    protected void processFolder(final HashSet<String> seenNames, final PsiManager manager, VirtualFile folder) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)folder, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file2) {
                PsiFile psiFile;
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spellchecker/generator/SpellCheckerDictionaryGenerator$2", "visitFile"));
                }
                if (SpellCheckerDictionaryGenerator.this.myExcludedFolders.contains(file2)) {
                    return false;
                }
                if (!file2.isDirectory() && (psiFile = manager.findFile(file2)) != null) {
                    SpellCheckerDictionaryGenerator.this.processFile(psiFile, seenNames);
                }
                return true;
            }
        });
    }

    protected abstract void processFile(PsiFile var1, HashSet<String> var2);

    protected void process(PsiElement element, @NotNull HashSet<String> seenNames) {
        if (seenNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "seenNames", "com/intellij/spellchecker/generator/SpellCheckerDictionaryGenerator", "process"));
        }
        int endOffset = element.getTextRange().getEndOffset();
        ArrayList<PsiElement> leafs = new ArrayList<PsiElement>();
        if (element.getChildren().length == 0) {
            leafs.add(element);
        } else {
            PsiElement currentLeaf = PsiTreeUtil.firstChild((PsiElement)element);
            while (currentLeaf != null && currentLeaf.getTextRange().getEndOffset() <= endOffset) {
                leafs.add(currentLeaf);
                currentLeaf = PsiTreeUtil.nextLeaf((PsiElement)currentLeaf);
            }
        }
        for (PsiElement leaf : leafs) {
            this.processLeafsNames(leaf, seenNames);
        }
    }

    protected void processLeafsNames(@NotNull PsiElement leafElement, final @NotNull HashSet<String> seenNames) {
        if (leafElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leafElement", "com/intellij/spellchecker/generator/SpellCheckerDictionaryGenerator", "processLeafsNames"));
        }
        if (seenNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "seenNames", "com/intellij/spellchecker/generator/SpellCheckerDictionaryGenerator", "processLeafsNames"));
        }
        final Language language = leafElement.getLanguage();
        SpellCheckingInspection.tokenize(leafElement, language, new TokenConsumer(){

            @Override
            public void consumeToken(PsiElement element, final String text, boolean useRename, int offset, TextRange rangeToCheck, Splitter splitter) {
                splitter.split(text, rangeToCheck, new Consumer<TextRange>(){

                    public void consume(TextRange textRange) {
                        String word = textRange.substring(text);
                        SpellCheckerDictionaryGenerator.this.addSeenWord(seenNames, word, language);
                    }
                });
            }
        });
    }

    protected void addSeenWord(HashSet<String> seenNames, String word, Language language) {
        String lowerWord = word.toLowerCase();
        if (this.globalSeenNames.contains(lowerWord)) {
            return;
        }
        NamesValidator namesValidator = (NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage(language);
        if (namesValidator != null && namesValidator.isKeyword(word, this.myProject)) {
            return;
        }
        this.globalSeenNames.add(lowerWord);
        if (this.mySpellCheckerManager.hasProblem(lowerWord)) {
            seenNames.add(lowerWord);
        }
    }
}

