/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.VfsTestUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.NoSuchFileException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0007\u001a\n \b*\u0004\u0018\u00010\u00020\u0002*\u00020\u0002\u001a\n\u0010\t\u001a\u00020\n*\u00020\u0002\u001a\u0012\u0010\u000b\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002\u001a\n\u0010\r\u001a\u00020\n*\u00020\u0002\u001a\n\u0010\u000e\u001a\u00020\u0002*\u00020\u0002\u001a\n\u0010\u000f\u001a\u00020\u0010*\u00020\u0002\u001a\f\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u0002\u001a\n\u0010\u0013\u001a\u00020\u0010*\u00020\u0002\u001a\n\u0010\u0014\u001a\u00020\u0010*\u00020\u0002\u001a\n\u0010\u0015\u001a\u00020\u0016*\u00020\u0002\u001a\u0012\u0010\u0017\u001a\n \b*\u0004\u0018\u00010\u00180\u0018*\u00020\u0002\u001a\n\u0010\u0019\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u001a\u001a\u00020\n*\u00020\u0002\u001a\u0012\u0010\u001b\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u0018\u001a\"\u0010\u001d\u001a\n \b*\u0004\u0018\u00010\u001e0\u001e*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u0001\u001a\u001a\u0010\u001d\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u0018\u001a\u001a\u0010\u001d\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u0001\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\u00a8\u0006 "}, d2={"parentSystemIndependentPath", "", "Ljava/nio/file/Path;", "getParentSystemIndependentPath", "(Ljava/nio/file/Path;)Ljava/lang/String;", "systemIndependentPath", "getSystemIndependentPath", "createDirectories", "kotlin.jvm.PlatformType", "createFile", "", "createSymbolicLink", "target", "delete", "deleteRecursively", "exists", "", "getLastModifiedTime", "Ljava/nio/file/attribute/FileTime;", "isDirectory", "isFile", "outputStream", "Ljava/io/OutputStream;", "readBytes", "", "readText", "refreshVfs", "write", "data", "writeChild", "Lcom/intellij/openapi/vfs/VirtualFile;", "relativePath", "testFramework"})
@KotlinFileFacade(version={1, 1, 0}, data={"\u0000:\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0007\u001a\n \b*\u0004\u0018\u00010\u00020\u0002*\u00020\u0002\u001a\n\u0010\t\u001a\u00020\n*\u00020\u0002\u001a\u0012\u0010\u000b\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002\u001a\n\u0010\r\u001a\u00020\n*\u00020\u0002\u001a\n\u0010\u000e\u001a\u00020\u0002*\u00020\u0002\u001a\n\u0010\u000f\u001a\u00020\u0010*\u00020\u0002\u001a\f\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u0002\u001a\n\u0010\u0013\u001a\u00020\u0010*\u00020\u0002\u001a\n\u0010\u0014\u001a\u00020\u0010*\u00020\u0002\u001a\n\u0010\u0015\u001a\u00020\u0016*\u00020\u0002\u001a\u0012\u0010\u0017\u001a\n \b*\u0004\u0018\u00010\u00180\u0018*\u00020\u0002\u001a\n\u0010\u0019\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u001a\u001a\u00020\n*\u00020\u0002\u001a\u0012\u0010\u001b\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u0018\u001a\"\u0010\u001d\u001a\n \b*\u0004\u0018\u00010\u001e0\u001e*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u0001\u001a\u001a\u0010\u001d\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u0018\u001a\u001a\u0010\u001d\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u0001\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\u00a8\u0006 "}, strings={"parentSystemIndependentPath", "", "Ljava/nio/file/Path;", "getParentSystemIndependentPath", "(Ljava/nio/file/Path;)Ljava/lang/String;", "systemIndependentPath", "getSystemIndependentPath", "createDirectories", "kotlin.jvm.PlatformType", "createFile", "", "createSymbolicLink", "target", "delete", "deleteRecursively", "exists", "", "getLastModifiedTime", "Ljava/nio/file/attribute/FileTime;", "isDirectory", "isFile", "outputStream", "Ljava/io/OutputStream;", "readBytes", "", "readText", "refreshVfs", "write", "data", "writeChild", "Lcom/intellij/openapi/vfs/VirtualFile;", "relativePath", "testFramework"})
public final class PathKt {
    public static final boolean exists(Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Files.exists($receiver, new LinkOption[0]);
    }

    public static final Path createDirectories(Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Files.createDirectories($receiver, new FileAttribute[0]);
    }

    @NotNull
    public static final OutputStream outputStream(Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Path path = $receiver.getParent();
        Path path2 = path != null ? PathKt.createDirectories(path) : null;
        OutputStream outputStream = Files.newOutputStream($receiver, new OpenOption[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)outputStream, (String)"Files.newOutputStream(this)");
        return outputStream;
    }

    @NotNull
    public static final Path createSymbolicLink(Path $receiver, @NotNull Path target) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Path path = $receiver.getParent();
        Path path2 = path != null ? PathKt.createDirectories(path) : null;
        Files.createSymbolicLink($receiver, target, new FileAttribute[0]);
        return $receiver;
    }

    public static final void delete(Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        try {
            Files.delete($receiver);
        }
        catch (NoSuchFileException ignored) {
        }
        catch (Exception e) {
            FileUtil.delete((File)$receiver.toFile());
        }
    }

    @NotNull
    public static final Path deleteRecursively(Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return PathKt.exists($receiver) ? Files.walkFileTree($receiver, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @NotNull
            public FileVisitResult visitFile(@NotNull Path file2, @NotNull BasicFileAttributes attrs) {
                Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
                Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
                PathKt.delete(file2);
                return FileVisitResult.CONTINUE;
            }

            @NotNull
            public FileVisitResult postVisitDirectory(@NotNull Path dir, @Nullable IOException exc) {
                Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
                PathKt.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        }) : $receiver;
    }

    @Nullable
    public static final FileTime getLastModifiedTime(Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Files.getLastModifiedTime($receiver, new LinkOption[0]);
    }

    @NotNull
    public static final String getSystemIndependentPath(Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return StringsKt.replace$default((String)((Object)$receiver).toString(), (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
    }

    @NotNull
    public static final String getParentSystemIndependentPath(Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Path path = $receiver.getParent();
        if (path == null) {
            Intrinsics.throwNpe();
        }
        return StringsKt.replace$default((String)((Object)path).toString(), (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
    }

    public static final byte[] readBytes(Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Files.readAllBytes($receiver);
    }

    @NotNull
    public static final String readText(Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return ArraysKt.toString((byte[])PathKt.readBytes($receiver), (Charset)Charsets.UTF_8);
    }

    public static final VirtualFile writeChild(VirtualFile $receiver, @NotNull String relativePath, @NotNull String data) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return VfsTestUtil.createFile($receiver, relativePath, data);
    }

    @NotNull
    public static final Path writeChild(Path $receiver, @NotNull String relativePath, @NotNull byte[] data) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return PathKt.write($receiver.resolve(relativePath), data);
    }

    @NotNull
    public static final Path writeChild(Path $receiver, @NotNull String relativePath, @NotNull String data) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return PathKt.writeChild($receiver, relativePath, StringsKt.toByteArray$default((String)data, null, (int)1, null));
    }

    @NotNull
    public static final Path write(Path $receiver, @NotNull byte[] data) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Path path = $receiver.getParent();
        Path path2 = path != null ? PathKt.createDirectories(path) : null;
        Path path3 = Files.write($receiver, data, new OpenOption[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)path3, (String)"Files.write(this, data)");
        return path3;
    }

    public static final boolean isDirectory(Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Files.isDirectory($receiver, new LinkOption[0]);
    }

    public static final boolean isFile(Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Files.isRegularFile($receiver, new LinkOption[0]);
    }

    public static final void createFile(Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Path path = $receiver.getParent();
        Path path2 = path != null ? PathKt.createDirectories(path) : null;
        Files.createFile($receiver, new FileAttribute[0]);
    }

    public static final void refreshVfs(Path $receiver) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        if (localFileSystem != null) {
            LocalFileSystem $receiver$iv = localFileSystem;
            LocalFileSystem fs = $receiver$iv;
            VirtualFile virtualFile = fs.findFileByPath(PathKt.getSystemIndependentPath($receiver));
            if (virtualFile != null) {
                VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{virtualFile});
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
    }
}

