/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.JavaModuleExternalPaths;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.ContentEntryImpl;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.PlatformTestCase;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.junit.Assert;

public class PsiTestUtil {
    public static VirtualFile createTestProjectStructure(Project project2, Module module2, String rootPath, Collection<File> filesToDelete) throws Exception {
        return PsiTestUtil.createTestProjectStructure(project2, module2, rootPath, filesToDelete, true);
    }

    public static VirtualFile createTestProjectStructure(Project project2, Module module2, Collection<File> filesToDelete) throws IOException {
        return PsiTestUtil.createTestProjectStructure(project2, module2, null, filesToDelete, true);
    }

    public static VirtualFile createTestProjectStructure(Project project2, Module module2, String rootPath, Collection<File> filesToDelete, boolean addProjectRoots) throws IOException {
        VirtualFile vDir = PsiTestUtil.createTestProjectStructure(module2, rootPath, filesToDelete, addProjectRoots);
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        return vDir;
    }

    public static VirtualFile createTestProjectStructure(Module module2, String rootPath, Collection<File> filesToDelete, boolean addProjectRoots) throws IOException {
        return PsiTestUtil.createTestProjectStructure("unitTest", module2, rootPath, filesToDelete, addProjectRoots);
    }

    public static VirtualFile createTestProjectStructure(String tempName, Module module2, String rootPath, Collection<File> filesToDelete, boolean addProjectRoots) throws IOException {
        File dir = FileUtil.createTempDirectory((String)tempName, null, (boolean)false);
        filesToDelete.add(dir);
        VirtualFile vDir = LocalFileSystem.getInstance().refreshAndFindFileByPath(dir.getCanonicalPath().replace(File.separatorChar, '/'));
        assert (vDir != null && vDir.isDirectory()) : dir;
        PlatformTestCase.synchronizeTempDirVfs(vDir);
        EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> {
            AccessToken token = WriteAction.start();
            try {
                if (rootPath != null) {
                    VirtualFile vDir1 = LocalFileSystem.getInstance().findFileByPath(rootPath.replace(File.separatorChar, '/'));
                    if (vDir1 == null) {
                        throw new Exception(rootPath + " not found");
                    }
                    VfsUtil.copyDirectory(null, (VirtualFile)vDir1, (VirtualFile)vDir, null);
                }
                if (addProjectRoots) {
                    PsiTestUtil.addSourceContentToRoots(module2, vDir);
                }
            }
            finally {
                token.finish();
            }
        }));
        return vDir;
    }

    public static void removeAllRoots(Module module2, Sdk jdk) {
        ModuleRootModificationUtil.updateModel((Module)module2, model -> {
            model.clear();
            model.setSdk(jdk);
        });
    }

    public static void addSourceContentToRoots(Module module2, @NotNull VirtualFile vDir) {
        if (vDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vDir", "com/intellij/testFramework/PsiTestUtil", "addSourceContentToRoots"));
        }
        PsiTestUtil.addSourceContentToRoots(module2, vDir, false);
    }

    public static void addSourceContentToRoots(Module module2, @NotNull VirtualFile vDir, boolean testSource) {
        if (vDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vDir", "com/intellij/testFramework/PsiTestUtil", "addSourceContentToRoots"));
        }
        ModuleRootModificationUtil.updateModel((Module)module2, model -> {
            if (vDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vDir", "com/intellij/testFramework/PsiTestUtil", "lambda$addSourceContentToRoots$2"));
            }
            model.addContentEntry(vDir).addSourceFolder(vDir, testSource);
        });
    }

    public static void addSourceRoot(Module module2, VirtualFile vDir) {
        PsiTestUtil.addSourceRoot(module2, vDir, false);
    }

    public static void addSourceRoot(Module module2, VirtualFile vDir, boolean isTestSource) {
        PsiTestUtil.addSourceRoot(module2, vDir, isTestSource ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE);
    }

    public static <P extends JpsElement> void addSourceRoot(Module module2, VirtualFile vDir, @NotNull JpsModuleSourceRootType<P> rootType) {
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/testFramework/PsiTestUtil", "addSourceRoot"));
        }
        PsiTestUtil.addSourceRoot(module2, vDir, rootType, (JpsElement)rootType.createDefaultProperties());
    }

    public static <P extends JpsElement> void addSourceRoot(Module module2, VirtualFile vDir, @NotNull JpsModuleSourceRootType<P> rootType, P properties) {
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/testFramework/PsiTestUtil", "addSourceRoot"));
        }
        ModuleRootModificationUtil.updateModel((Module)module2, model -> {
            if (rootType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/testFramework/PsiTestUtil", "lambda$addSourceRoot$3"));
            }
            ContentEntry entry = PsiTestUtil.findContentEntry((ModuleRootModel)model, vDir);
            if (entry == null) {
                entry = model.addContentEntry(vDir);
            }
            entry.addSourceFolder(vDir, rootType, properties);
        });
    }

    @Nullable
    private static ContentEntry findContentEntry(ModuleRootModel rootModel, VirtualFile file2) {
        return (ContentEntry)ContainerUtil.find((Object[])rootModel.getContentEntries(), object -> {
            VirtualFile entryRoot = object.getFile();
            return entryRoot != null && VfsUtilCore.isAncestor((VirtualFile)entryRoot, (VirtualFile)file2, (boolean)false);
        });
    }

    public static ContentEntry addContentRoot(Module module2, VirtualFile vDir) {
        ModuleRootModificationUtil.updateModel((Module)module2, model -> model.addContentEntry(vDir));
        for (ContentEntry entry : ModuleRootManager.getInstance((Module)module2).getContentEntries()) {
            if (!Comparing.equal((Object)entry.getFile(), (Object)vDir)) continue;
            Assert.assertFalse((boolean)((ContentEntryImpl)entry).isDisposed());
            return entry;
        }
        return null;
    }

    public static void addExcludedRoot(Module module2, VirtualFile dir) {
        ModuleRootModificationUtil.updateModel((Module)module2, model -> ApplicationManager.getApplication().runReadAction(() -> PsiTestUtil.findContentEntryWithAssertion(model, dir).addExcludeFolder(dir)));
    }

    @NotNull
    private static ContentEntry findContentEntryWithAssertion(ModifiableRootModel model, VirtualFile dir) {
        ContentEntry entry = PsiTestUtil.findContentEntry((ModuleRootModel)model, dir);
        if (entry == null) {
            throw new RuntimeException(dir + " is not under content roots: " + Arrays.toString(model.getContentRoots()));
        }
        ContentEntry contentEntry = entry;
        if (contentEntry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/PsiTestUtil", "findContentEntryWithAssertion"));
        }
        return contentEntry;
    }

    public static void removeContentEntry(Module module2, VirtualFile contentRoot) {
        ModuleRootModificationUtil.updateModel((Module)module2, model -> model.removeContentEntry(PsiTestUtil.findContentEntryWithAssertion(model, contentRoot)));
    }

    public static void removeSourceRoot(Module module2, VirtualFile root) {
        ModuleRootModificationUtil.updateModel((Module)module2, model -> {
            ContentEntry entry = PsiTestUtil.findContentEntryWithAssertion(model, root);
            for (SourceFolder sourceFolder : entry.getSourceFolders()) {
                if (!root.equals(sourceFolder.getFile())) continue;
                entry.removeSourceFolder(sourceFolder);
                break;
            }
        });
    }

    public static void removeExcludedRoot(Module module2, VirtualFile root) {
        ModuleRootModificationUtil.updateModel((Module)module2, model -> {
            ContentEntry entry = PsiTestUtil.findContentEntryWithAssertion(model, root);
            entry.removeExcludeFolder(root.getUrl());
        });
    }

    public static void checkFileStructure(PsiFile file2) throws IncorrectOperationException {
        String originalTree = DebugUtil.psiTreeToString((PsiElement)file2, false);
        PsiFile dummyFile = PsiFileFactory.getInstance((Project)file2.getProject()).createFileFromText(file2.getName(), file2.getFileType(), (CharSequence)file2.getText());
        String reparsedTree = DebugUtil.psiTreeToString((PsiElement)dummyFile, false);
        Assert.assertEquals((Object)reparsedTree, (Object)originalTree);
    }

    public static void addLibrary(Module module2, String libPath) {
        File file2 = new File(libPath);
        String libName = file2.getName();
        PsiTestUtil.addLibrary(module2, libName, file2.getParent(), libName);
    }

    public static void addLibrary(Module module2, String libName, String libPath, String ... jarArr) {
        ModuleRootModificationUtil.updateModel((Module)module2, model -> PsiTestUtil.addLibrary(module2, model, libName, libPath, jarArr));
    }

    public static void addProjectLibrary(Module module2, String libName, VirtualFile ... classesRoots) {
        PsiTestUtil.addProjectLibrary(module2, libName, Arrays.asList(classesRoots), Collections.emptyList());
    }

    public static Library addProjectLibrary(Module module2, String libName, List<VirtualFile> classesRoots, List<VirtualFile> sourceRoots) {
        Ref result = Ref.create();
        ModuleRootModificationUtil.updateModel((Module)module2, model -> result.set((Object)PsiTestUtil.addProjectLibrary(module2, model, libName, classesRoots, sourceRoots)));
        return (Library)result.get();
    }

    private static Library addProjectLibrary(Module module2, final ModifiableRootModel model, final String libName, final List<VirtualFile> classesRoots, final List<VirtualFile> sourceRoots) {
        final LibraryTable libraryTable = ProjectLibraryTable.getInstance(module2.getProject());
        RunResult result = new WriteAction<Library>(){

            protected void run(@NotNull Result<Library> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/PsiTestUtil$1", "run"));
                }
                Library library = libraryTable.createLibrary(libName);
                Library.ModifiableModel libraryModel = library.getModifiableModel();
                try {
                    for (VirtualFile root : classesRoots) {
                        libraryModel.addRoot(root, OrderRootType.CLASSES);
                    }
                    for (VirtualFile root : sourceRoots) {
                        libraryModel.addRoot(root, OrderRootType.SOURCES);
                    }
                    libraryModel.commit();
                }
                catch (Throwable t) {
                    libraryModel.dispose();
                    throw t;
                }
                model.addLibraryEntry(library);
                OrderEntry[] orderEntries = model.getOrderEntries();
                OrderEntry last = orderEntries[orderEntries.length - 1];
                System.arraycopy(orderEntries, 0, orderEntries, 1, orderEntries.length - 1);
                orderEntries[0] = last;
                model.rearrangeOrderEntries(orderEntries);
                result.setResult((Object)library);
            }
        }.execute();
        result.throwException();
        return (Library)result.getResultObject();
    }

    public static void addLibrary(Module module2, ModifiableRootModel model, String libName, String libPath, String ... jarArr) {
        ArrayList<VirtualFile> classesRoots = new ArrayList<VirtualFile>();
        for (String jar : jarArr) {
            String path;
            if (!libPath.endsWith("/") && !jar.startsWith("/")) {
                jar = "/" + jar;
            }
            VirtualFile root = (path = libPath + jar).endsWith(".jar") ? JarFileSystem.getInstance().refreshAndFindFileByPath(path + "!/") : LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
            assert (root != null) : "Library root folder not found: " + path + "!/";
            classesRoots.add(root);
        }
        PsiTestUtil.addProjectLibrary(module2, model, libName, classesRoots, Collections.emptyList());
    }

    public static void addLibrary(Module module2, String libName, String libDir, String[] classRoots, String[] sourceRoots) {
        String proto = (classRoots.length > 0 ? classRoots[0] : sourceRoots[0]).endsWith(".jar!/") ? "jar" : "file";
        String parentUrl = VirtualFileManager.constructUrl((String)proto, (String)libDir);
        ArrayList<String> classesUrls = new ArrayList<String>();
        ArrayList<String> sourceUrls = new ArrayList<String>();
        for (String classRoot : classRoots) {
            classesUrls.add(parentUrl + classRoot);
        }
        for (String sourceRoot : sourceRoots) {
            sourceUrls.add(parentUrl + sourceRoot);
        }
        ModuleRootModificationUtil.addModuleLibrary((Module)module2, (String)libName, classesUrls, sourceUrls);
    }

    public static Module addModule(final Project project2, final ModuleType type, final String name, final VirtualFile root) {
        return (Module)new WriteCommandAction<Module>(project2, new PsiFile[0]){

            protected void run(@NotNull Result<Module> result) throws Throwable {
                String moduleName;
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/PsiTestUtil$2", "run"));
                }
                ModifiableModuleModel moduleModel = ModuleManager.getInstance((Project)project2).getModifiableModel();
                try {
                    moduleName = moduleModel.newModule(root.getPath() + "/" + name + ".iml", type.getId()).getName();
                    moduleModel.commit();
                }
                catch (Throwable t) {
                    moduleModel.dispose();
                    throw t;
                }
                Module dep = ModuleManager.getInstance((Project)project2).findModuleByName(moduleName);
                assert (dep != null) : moduleName;
                ModifiableRootModel model = ModuleRootManager.getInstance((Module)dep).getModifiableModel();
                try {
                    model.addContentEntry(root).addSourceFolder(root, false);
                    model.commit();
                }
                catch (Throwable t) {
                    model.dispose();
                    throw t;
                }
                result.setResult((Object)dep);
            }
        }.execute().getResultObject();
    }

    public static void setCompilerOutputPath(Module module2, String url, boolean forTests) {
        ModuleRootModificationUtil.updateModel((Module)module2, model -> {
            CompilerModuleExtension extension = (CompilerModuleExtension)model.getModuleExtension(CompilerModuleExtension.class);
            extension.inheritCompilerOutputPath(false);
            if (forTests) {
                extension.setCompilerOutputPathForTests(url);
            } else {
                extension.setCompilerOutputPath(url);
            }
        });
    }

    public static void setExcludeCompileOutput(Module module2, boolean exclude) {
        ModuleRootModificationUtil.updateModel((Module)module2, model -> ((CompilerModuleExtension)model.getModuleExtension(CompilerModuleExtension.class)).setExcludeOutput(exclude));
    }

    public static void setJavadocUrls(Module module2, String ... urls) {
        ModuleRootModificationUtil.updateModel((Module)module2, model -> ((JavaModuleExternalPaths)model.getModuleExtension(JavaModuleExternalPaths.class)).setJavadocUrls(urls));
    }

    public static Sdk addJdkAnnotations(Sdk sdk) {
        String path = FileUtil.toSystemIndependentName((String)PlatformTestUtil.getCommunityPath()) + "/java/jdkAnnotations";
        VirtualFile root = LocalFileSystem.getInstance().findFileByPath(path);
        if (root != null) {
            SdkModificator sdkModificator = sdk.getSdkModificator();
            sdkModificator.addRoot(root, AnnotationOrderRootType.getInstance());
            sdkModificator.commitChanges();
        }
        return sdk;
    }
}

