/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.testFramework.PathKt;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a8\u0006\u0004"}, d2={"generateTemporaryPath", "Ljava/nio/file/Path;", "fileName", "", "testFramework"})
@KotlinFileFacade(version={1, 1, 0}, data={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a8\u0006\u0004"}, strings={"generateTemporaryPath", "Ljava/nio/file/Path;", "fileName", "", "testFramework"})
public final class TemporaryDirectoryKt {
    @NotNull
    public static final Path generateTemporaryPath(@Nullable String fileName) {
        Path tempDirectory = Paths.get(FileUtilRt.getTempDirectory(), new String[0]);
        Path path = tempDirectory.resolve(fileName);
        for (int i = 0; PathKt.exists(path) && i < 9; ++i) {
            path = tempDirectory.resolve(fileName + "_" + i);
        }
        if (PathKt.exists(path)) {
            throw (Throwable)new IOException("Cannot generate unique random path");
        }
        Path path2 = path;
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"path");
        return path2;
    }
}

