/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration.createTest;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testIntegration.TestFramework;
import com.intellij.testIntegration.createTest.CreateTestDialog;
import com.intellij.testIntegration.createTest.TestGenerator;
import com.intellij.testIntegration.createTest.TestGenerators;
import com.intellij.util.IncorrectOperationException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class CreateTestAction
extends PsiElementBaseIntentionAction {
    private static final String CREATE_TEST_IN_THE_SAME_ROOT = "create.test.in.the.same.root";

    @NotNull
    public String getText() {
        String string = CodeInsightBundle.message((String)"intention.create.test", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testIntegration/createTest/CreateTestAction", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testIntegration/createTest/CreateTestAction", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/testIntegration/createTest/CreateTestAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/testIntegration/createTest/CreateTestAction", "isAvailable"));
        }
        if (!CreateTestAction.isAvailableForElement(element)) {
            return false;
        }
        PsiClass psiClass = CreateTestAction.getContainingClass(element);
        assert (psiClass != null);
        PsiElement leftBrace = psiClass.getLBrace();
        if (leftBrace == null) {
            return false;
        }
        return element.getTextOffset() < leftBrace.getTextOffset();
    }

    public static boolean isAvailableForElement(PsiElement element) {
        if (((TestFramework[])Extensions.getExtensions((ExtensionPointName)TestFramework.EXTENSION_NAME)).length == 0) {
            return false;
        }
        if (element == null) {
            return false;
        }
        PsiClass psiClass = CreateTestAction.getContainingClass(element);
        if (psiClass == null) {
            return false;
        }
        Module srcModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        if (srcModule == null) {
            return false;
        }
        return !psiClass.isAnnotationType() && !(psiClass instanceof PsiAnonymousClass);
    }

    public void invoke(final @NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        CreateTestDialog d;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/testIntegration/createTest/CreateTestAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/testIntegration/createTest/CreateTestAction", "invoke"));
        }
        Module srcModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        PsiClass srcClass = CreateTestAction.getContainingClass(element);
        if (srcClass == null) {
            return;
        }
        PsiDirectory srcDir = element.getContainingFile().getContainingDirectory();
        PsiPackage srcPackage = JavaDirectoryService.getInstance().getPackage(srcDir);
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        HashSet<VirtualFile> testFolders = new HashSet<VirtualFile>();
        CreateTestAction.checkForTestRoots(srcModule, testFolders);
        if (testFolders.isEmpty() && !propertiesComponent.getBoolean(CREATE_TEST_IN_THE_SAME_ROOT)) {
            if (Messages.showOkCancelDialog((Project)project2, (String)"Create test in the same source root?", (String)"No Test Roots Found", (Icon)Messages.getQuestionIcon()) != 0) {
                return;
            }
            propertiesComponent.setValue(CREATE_TEST_IN_THE_SAME_ROOT, true);
        }
        if (!(d = this.createTestDialog(project2, srcModule, srcClass, srcPackage)).showAndGet()) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(project2, new Runnable(){

            @Override
            public void run() {
                TestFramework framework = d.getSelectedTestFrameworkDescriptor();
                final TestGenerator generator = (TestGenerator)TestGenerators.INSTANCE.forLanguage(framework.getLanguage());
                DumbService.getInstance((Project)project2).withAlternativeResolveEnabled(new Runnable(){

                    @Override
                    public void run() {
                        generator.generateTest(project2, d);
                    }
                });
            }
        }, CodeInsightBundle.message((String)"intention.create.test", (Object[])new Object[0]), (Object)this);
    }

    protected CreateTestDialog createTestDialog(Project project2, Module srcModule, PsiClass srcClass, PsiPackage srcPackage) {
        return new CreateTestDialog(project2, this.getText(), srcClass, srcPackage, srcModule);
    }

    protected static void checkForTestRoots(Module srcModule, Set<VirtualFile> testFolders) {
        List sourceRoots = ModuleRootManager.getInstance((Module)srcModule).getSourceRoots((JpsModuleSourceRootType)JavaSourceRootType.TEST_SOURCE);
        for (VirtualFile sourceRoot : sourceRoots) {
            if (JavaProjectRootsUtil.isInGeneratedCode(sourceRoot, srcModule.getProject())) continue;
            testFolders.add(sourceRoot);
        }
        if (!testFolders.isEmpty()) {
            return;
        }
        HashSet modules = new HashSet();
        ModuleUtilCore.collectModulesDependsOn((Module)srcModule, modules);
        for (Module module2 : modules) {
            testFolders.addAll(ModuleRootManager.getInstance((Module)module2).getSourceRoots((JpsModuleSourceRootType)JavaSourceRootType.TEST_SOURCE));
        }
    }

    @Nullable
    protected static PsiClass getContainingClass(PsiElement element) {
        PsiClass[] classes;
        PsiFile containingFile;
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class, (boolean)false);
        if (psiClass == null && (containingFile = element.getContainingFile()) instanceof PsiClassOwner && (classes = ((PsiClassOwner)containingFile).getClasses()).length == 1) {
            return classes[0];
        }
        return psiClass;
    }

    public boolean startInWriteAction() {
        return false;
    }
}

