/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.impl.ToolWindowsPane;
import com.intellij.ui.BalloonImpl;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.BalloonLayoutData;
import com.intellij.util.Alarm;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BalloonLayoutImpl
implements BalloonLayout {
    private final JLayeredPane myLayeredPane;
    private final Insets myInsets;
    private final List<Balloon> myBalloons;
    private final Map<Balloon, BalloonLayoutData> myLayoutData;
    private Integer myWidth;
    private final Alarm myRelayoutAlarm;
    private final Runnable myRelayoutRunnable;
    private final JRootPane myParent;
    private final Runnable myCloseAll;
    private final Runnable myLayoutRunnable;

    public BalloonLayoutImpl(@NotNull JRootPane parent, @NotNull Insets insets) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/ui/BalloonLayoutImpl", "<init>"));
        }
        if (insets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insets", "com/intellij/ui/BalloonLayoutImpl", "<init>"));
        }
        this.myBalloons = new ArrayList<Balloon>();
        this.myLayoutData = new HashMap<Balloon, BalloonLayoutData>();
        this.myRelayoutAlarm = new Alarm();
        this.myRelayoutRunnable = new Runnable(){

            @Override
            public void run() {
                BalloonLayoutImpl.this.relayout();
            }
        };
        this.myCloseAll = new Runnable(){

            @Override
            public void run() {
                for (Balloon balloon : new ArrayList(BalloonLayoutImpl.this.myBalloons)) {
                    BalloonLayoutImpl.this.remove(balloon, true);
                }
            }
        };
        this.myLayoutRunnable = new Runnable(){

            @Override
            public void run() {
                BalloonLayoutImpl.this.calculateSize();
                BalloonLayoutImpl.this.relayout();
            }
        };
        this.myParent = parent;
        this.myLayeredPane = parent.getLayeredPane();
        this.myInsets = insets;
        this.myLayeredPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(@NotNull ComponentEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/BalloonLayoutImpl$4", "componentResized"));
                }
                BalloonLayoutImpl.this.queueRelayout();
            }
        });
    }

    public void add(@NotNull Balloon balloon) {
        if (balloon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "balloon", "com/intellij/ui/BalloonLayoutImpl", "add"));
        }
        this.add(balloon, null);
    }

    public void add(final @NotNull Balloon balloon, @Nullable Object layoutData) {
        if (balloon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "balloon", "com/intellij/ui/BalloonLayoutImpl", "add"));
        }
        this.myBalloons.add(balloon);
        if (layoutData instanceof BalloonLayoutData) {
            BalloonLayoutData balloonLayoutData = (BalloonLayoutData)layoutData;
            balloonLayoutData.closeAll = this.myCloseAll;
            balloonLayoutData.doLayout = this.myLayoutRunnable;
            this.myLayoutData.put(balloon, balloonLayoutData);
        }
        Disposer.register((Disposable)balloon, (Disposable)new Disposable(){

            public void dispose() {
                BalloonLayoutImpl.this.remove(balloon, false);
                BalloonLayoutImpl.this.queueRelayout();
            }
        });
        this.calculateSize();
        this.relayout();
        balloon.show(this.myLayeredPane);
    }

    private void remove(@NotNull Balloon balloon, boolean hide) {
        if (balloon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "balloon", "com/intellij/ui/BalloonLayoutImpl", "remove"));
        }
        this.myBalloons.remove(balloon);
        this.myLayoutData.remove(balloon);
        if (hide) {
            balloon.hide();
        }
    }

    @NotNull
    private Dimension getSize(@NotNull Balloon balloon) {
        if (balloon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "balloon", "com/intellij/ui/BalloonLayoutImpl", "getSize"));
        }
        BalloonLayoutData layoutData = this.myLayoutData.get(balloon);
        if (layoutData == null) {
            Dimension size = balloon.getPreferredSize();
            Dimension dimension = this.myWidth == null ? size : new Dimension(this.myWidth, size.height);
            if (dimension == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/BalloonLayoutImpl", "getSize"));
            }
            return dimension;
        }
        Dimension dimension = new Dimension(this.myWidth, layoutData.height);
        if (dimension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/BalloonLayoutImpl", "getSize"));
        }
        return dimension;
    }

    public boolean isEmpty() {
        return this.myBalloons.isEmpty();
    }

    public void queueRelayout() {
        this.myRelayoutAlarm.cancelAllRequests();
        this.myRelayoutAlarm.addRequest(this.myRelayoutRunnable, 200);
    }

    private void calculateSize() {
        this.myWidth = null;
        if (this.myLayoutData.isEmpty()) {
            return;
        }
        int width = 0;
        for (Balloon balloon : this.myBalloons) {
            Dimension size = balloon.getPreferredSize();
            width = Math.max(width, size.width);
            BalloonLayoutData layoutData = this.myLayoutData.get(balloon);
            if (layoutData == null) continue;
            layoutData.height = size.height;
        }
        this.myWidth = width;
    }

    private void relayout() {
        Dimension size = this.myLayeredPane.getSize();
        JBInsets.removeFrom((Dimension)size, (Insets)this.myInsets);
        Rectangle layoutRec = new Rectangle(new Point(this.myInsets.left, this.myInsets.top), size);
        List<ArrayList<Balloon>> columns = this.createColumns(layoutRec);
        while (columns.size() > 1) {
            this.remove(this.myBalloons.get(0), true);
            columns = this.createColumns(layoutRec);
        }
        List<Integer> columnWidths = this.computeWidths(columns);
        ToolWindowsPane pane = (ToolWindowsPane)((Object)UIUtil.findComponentOfType((JComponent)this.myParent, ToolWindowsPane.class));
        Object component = pane != null ? pane : this.myParent;
        int paneOnScreen = ((Component)component).isShowing() ? ((Component)component).getLocationOnScreen().y : 0;
        int layerOnScreen = this.myLayeredPane.isShowing() ? this.myLayeredPane.getLocationOnScreen().y : 0;
        int toolbarsOffset = paneOnScreen - layerOnScreen;
        JComponent layeredPane = pane != null ? pane.getMyLayeredPane() : null;
        int eachColumnX = (layeredPane == null ? this.myLayeredPane.getWidth() : layeredPane.getX() + layeredPane.getWidth()) - 4;
        for (int i = 0; i < columns.size(); ++i) {
            ArrayList<Balloon> eachColumn = columns.get(i);
            Integer eachWidth = columnWidths.get(i);
            int eachY = toolbarsOffset;
            int columnSize = eachColumn.size();
            if (columnSize > 0) {
                BalloonImpl balloon = (BalloonImpl)eachColumn.get(0);
                eachY = balloon.hasShadow() ? (eachY -= balloon.getShadowBorderInsets().top) : (eachY += 4);
            }
            eachColumnX -= eachWidth.intValue();
            for (int j = 0; j < columnSize; ++j) {
                BalloonImpl eachBalloon = (BalloonImpl)eachColumn.get(j);
                Rectangle eachRec = new Rectangle(this.getSize(eachBalloon));
                Insets shadow = new Insets(0, 0, 0, 0);
                boolean hasShadow = eachBalloon.hasShadow();
                if (hasShadow) {
                    shadow = eachBalloon.getShadowBorderInsets();
                    eachRec.width += shadow.left + shadow.right;
                    eachRec.height += shadow.top + shadow.bottom;
                }
                eachRec.setLocation(eachColumnX + eachWidth - eachRec.width + shadow.left, eachY);
                eachBalloon.setBounds(eachRec);
                eachY += eachRec.height;
                if (this.myLayoutData.isEmpty()) {
                    eachY += 2;
                    continue;
                }
                if (j + 1 >= columnSize) continue;
                BalloonImpl next = (BalloonImpl)eachColumn.get(j + 1);
                boolean hasNextShadow = next.hasShadow();
                if (hasShadow && !hasNextShadow) {
                    eachY -= shadow.top;
                } else if (!hasShadow && hasNextShadow) {
                    eachY -= 2 * next.getShadowBorderInsets().top;
                } else if (hasShadow) {
                    eachY -= shadow.bottom + next.getShadowBorderInsets().top;
                }
                eachY += 10;
            }
        }
    }

    private List<Integer> computeWidths(List<ArrayList<Balloon>> columns) {
        ArrayList<Integer> columnWidths = new ArrayList<Integer>();
        for (ArrayList<Balloon> eachColumn : columns) {
            int maxWidth = 0;
            for (Balloon each : eachColumn) {
                maxWidth = Math.max(this.getSize((Balloon)each).width, maxWidth);
            }
            columnWidths.add(maxWidth);
        }
        return columnWidths;
    }

    private List<ArrayList<Balloon>> createColumns(Rectangle layoutRec) {
        ArrayList<ArrayList<Balloon>> columns = new ArrayList<ArrayList<Balloon>>();
        ArrayList<Balloon> eachColumn = new ArrayList<Balloon>();
        columns.add(eachColumn);
        int eachColumnHeight = 0;
        for (Balloon each : this.myBalloons) {
            Dimension eachSize = this.getSize(each);
            if ((double)(eachColumnHeight + eachSize.height) > layoutRec.getHeight()) {
                eachColumn = new ArrayList();
                columns.add(eachColumn);
                eachColumnHeight = 0;
            }
            eachColumn.add(each);
            eachColumnHeight += eachSize.height;
        }
        return columns;
    }
}

