/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.notification.impl.NotificationsConfigurable;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.util.Computable;
import com.intellij.ui.BalloonImpl;
import com.intellij.ui.BalloonLayoutData;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NotificationBalloonActionProvider
implements BalloonImpl.ActionProvider {
    private final BalloonImpl myBalloon;
    private final BalloonLayoutData myLayoutData;
    private final String myDisplayGroupId;
    private final Component myRepaintPanel;
    private final BalloonImpl.ActionButton mySettingButton;
    private final BalloonImpl.ActionButton myCloseButton;
    private final List<BalloonImpl.ActionButton> myActions;

    public NotificationBalloonActionProvider(@NotNull BalloonImpl balloon, @Nullable Component repaintPanel, @NotNull BalloonLayoutData layoutData, @Nullable String displayGroupId) {
        if (balloon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "balloon", "com/intellij/ui/NotificationBalloonActionProvider", "<init>"));
        }
        if (layoutData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layoutData", "com/intellij/ui/NotificationBalloonActionProvider", "<init>"));
        }
        this.myActions = new ArrayList<BalloonImpl.ActionButton>();
        this.myLayoutData = layoutData;
        this.myDisplayGroupId = displayGroupId;
        this.myBalloon = balloon;
        this.myRepaintPanel = repaintPanel;
        if (this.myDisplayGroupId == null || !NotificationsConfigurationImpl.getInstanceImpl().isRegistered(this.myDisplayGroupId)) {
            this.mySettingButton = null;
        } else {
            BalloonImpl balloonImpl = this.myBalloon;
            balloonImpl.getClass();
            this.mySettingButton = new BalloonImpl.ActionButton(balloonImpl, NotificationBalloonActionProvider.icon(AllIcons.Ide.Notification.Gear), NotificationBalloonActionProvider.icon(AllIcons.Ide.Notification.GearHover), (Consumer)new Consumer<MouseEvent>(){

                public void consume(MouseEvent event) {
                    final NotificationsConfigurable configurable = new NotificationsConfigurable();
                    ShowSettingsUtil.getInstance().editConfigurable(((NotificationBalloonActionProvider)NotificationBalloonActionProvider.this).myLayoutData.project, (Configurable)configurable, new Runnable(){

                        @Override
                        public void run() {
                            configurable.enableSearch(NotificationBalloonActionProvider.this.myDisplayGroupId).run();
                        }
                    });
                }
            }){
                {
                    BalloonImpl balloonImpl = x0;
                    balloonImpl.getClass();
                    super(icon, hoverIcon, (Consumer<MouseEvent>)listener);
                }

                public void repaint() {
                    super.repaint();
                    if (NotificationBalloonActionProvider.this.myRepaintPanel != null) {
                        NotificationBalloonActionProvider.this.myRepaintPanel.repaint();
                    }
                }
            };
            this.myActions.add(this.mySettingButton);
            if (repaintPanel != null) {
                layoutData.showActions = new Computable<Boolean>(){

                    public Boolean compute() {
                        for (BalloonImpl.ActionButton action : NotificationBalloonActionProvider.this.myActions) {
                            if (action.isShowing() && action.hasPaint()) continue;
                            return Boolean.FALSE;
                        }
                        return Boolean.TRUE;
                    }
                };
            }
        }
        BalloonImpl balloonImpl = this.myBalloon;
        balloonImpl.getClass();
        this.myCloseButton = balloonImpl.new BalloonImpl.ActionButton(NotificationBalloonActionProvider.icon(AllIcons.Ide.Notification.Close), NotificationBalloonActionProvider.icon(AllIcons.Ide.Notification.CloseHover), new Consumer<MouseEvent>(){

            public void consume(MouseEvent event) {
                final int modifiers = event.getModifiers();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if ((modifiers & 8) != 0) {
                            ((NotificationBalloonActionProvider)NotificationBalloonActionProvider.this).myLayoutData.closeAll.run();
                        } else {
                            NotificationBalloonActionProvider.this.myBalloon.hide();
                        }
                    }
                });
            }
        });
        this.myActions.add(this.myCloseButton);
    }

    @Override
    @NotNull
    public List<BalloonImpl.ActionButton> getActions() {
        List<BalloonImpl.ActionButton> list = this.myActions;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/NotificationBalloonActionProvider", "getActions"));
        }
        return list;
    }

    @Override
    public void layout(@NotNull Rectangle bounds) {
        if (bounds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bounds", "com/intellij/ui/NotificationBalloonActionProvider", "layout"));
        }
        Dimension closeSize = this.myCloseButton.getPreferredSize();
        Insets borderInsets = this.myBalloon.getShadowBorderInsets();
        int x = bounds.x + bounds.width - closeSize.width - 4 - borderInsets.right;
        int y = bounds.y + 2 + borderInsets.top;
        this.myCloseButton.setBounds(x, y, closeSize.width, closeSize.height);
        if (this.mySettingButton != null) {
            Dimension size = this.mySettingButton.getPreferredSize();
            this.mySettingButton.setBounds(x - size.width - 12, y, size.width, size.height);
        }
    }

    public static int getCloseOffset() {
        return AllIcons.Ide.Notification.Close.getIconWidth() + 6;
    }

    public static int getAllActionsOffset() {
        return 50;
    }

    @NotNull
    public static Icon icon(@NotNull Icon icon) {
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/ui/NotificationBalloonActionProvider", "icon"));
        }
        Icon icon2 = icon;
        if (icon2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/NotificationBalloonActionProvider", "icon"));
        }
        return icon2;
    }
}

