/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.content.impl;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.ActiveRunnable;
import com.intellij.openapi.util.BusyObject;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.FocusCommand;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.ContentUI;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.ui.switcher.SwitchProvider;
import com.intellij.ui.switcher.SwitchTarget;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContentManagerImpl
implements ContentManager,
PropertyChangeListener,
Disposable.Parent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.content.impl.ContentManagerImpl");
    private ContentUI myUI;
    private final List<Content> myContents;
    private final EventDispatcher<ContentManagerListener> myDispatcher;
    private final List<Content> mySelection;
    private final boolean myCanCloseContents;
    private Wrapper.FocusHolder myFocusProxy;
    private MyNonOpaquePanel myComponent;
    private final Set<Content> myContentWithChangedComponent;
    private boolean myDisposed;
    private final Project myProject;
    private final List<DataProvider> dataProviders;
    private ArrayList<Content> mySelectionHistory;

    public ContentManagerImpl(@NotNull ContentUI contentUI, boolean canCloseContents, @NotNull Project project2) {
        if (contentUI == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentUI", "com/intellij/ui/content/impl/ContentManagerImpl", "<init>"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ui/content/impl/ContentManagerImpl", "<init>"));
        }
        this.myContents = new ArrayList<Content>();
        this.myDispatcher = EventDispatcher.create(ContentManagerListener.class);
        this.mySelection = new ArrayList<Content>();
        this.myContentWithChangedComponent = new HashSet<Content>();
        this.dataProviders = new SmartList();
        this.mySelectionHistory = new ArrayList();
        this.myProject = project2;
        this.myCanCloseContents = canCloseContents;
        this.myUI = contentUI;
        this.myUI.setManager((ContentManager)this);
        Disposer.register((Disposable)project2, (Disposable)this);
        Disposer.register((Disposable)this, (Disposable)contentUI);
    }

    public boolean canCloseContents() {
        return this.myCanCloseContents;
    }

    @NotNull
    public JComponent getComponent() {
        if (this.myComponent == null) {
            this.myComponent = new MyNonOpaquePanel();
            this.myFocusProxy = new Wrapper.FocusHolder();
            this.myFocusProxy.setOpaque(false);
            this.myFocusProxy.setPreferredSize((Dimension)JBUI.emptySize());
            MyContentComponent contentComponent = new MyContentComponent();
            contentComponent.setContent(this.myUI.getComponent());
            contentComponent.setFocusCycleRoot(true);
            this.myComponent.add((Component)this.myFocusProxy, "North");
            this.myComponent.add((Component)((Object)contentComponent), "Center");
        }
        MyNonOpaquePanel myNonOpaquePanel = this.myComponent;
        if (myNonOpaquePanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "getComponent"));
        }
        return myNonOpaquePanel;
    }

    @NotNull
    public ActionCallback getReady(@NotNull Object requestor) {
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/ui/content/impl/ContentManagerImpl", "getReady"));
        }
        Content selected = this.getSelectedContent();
        if (selected == null) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "getReady"));
            }
            return actionCallback;
        }
        BusyObject busyObject = selected.getBusyObject();
        ActionCallback actionCallback = busyObject != null ? busyObject.getReady(requestor) : ActionCallback.DONE;
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "getReady"));
        }
        return actionCallback;
    }

    public void addContent(@NotNull Content content, int order) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/content/impl/ContentManagerImpl", "addContent"));
        }
        this.doAddContent(content, order);
    }

    public void addContent(@NotNull Content content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/content/impl/ContentManagerImpl", "addContent"));
        }
        this.doAddContent(content, -1);
    }

    public void addContent(@NotNull Content content, Object constraints) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/content/impl/ContentManagerImpl", "addContent"));
        }
        this.doAddContent(content, -1);
    }

    private void doAddContent(@NotNull Content content, int index) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/content/impl/ContentManagerImpl", "doAddContent"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myContents.contains(content)) {
            this.myContents.remove(content);
            this.myContents.add(index == -1 ? this.myContents.size() : index, content);
            return;
        }
        ((ContentImpl)content).setManager(this);
        int insertIndex = index == -1 ? this.myContents.size() : index;
        this.myContents.add(insertIndex, content);
        content.addPropertyChangeListener((PropertyChangeListener)this);
        this.fireContentAdded(content, insertIndex);
        if (this.myUI.isToSelectAddedContent() || this.mySelection.isEmpty() && !this.myUI.canBeEmptySelection()) {
            if (this.myUI.isSingleSelection()) {
                this.setSelectedContent(content);
            } else {
                this.addSelectedContent(content);
            }
        }
        Disposer.register((Disposable)this, (Disposable)content);
    }

    public boolean removeContent(@NotNull Content content, boolean dispose) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/content/impl/ContentManagerImpl", "removeContent"));
        }
        return this.removeContent(content, true, dispose).isDone();
    }

    @NotNull
    public ActionCallback removeContent(@NotNull Content content, boolean dispose, final boolean trackFocus, final boolean forcedFocus) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/content/impl/ContentManagerImpl", "removeContent"));
        }
        final ActionCallback result = new ActionCallback();
        this.removeContent(content, true, dispose).doWhenDone(new Runnable(){

            @Override
            public void run() {
                if (trackFocus) {
                    Content current = ContentManagerImpl.this.getSelectedContent();
                    if (current != null) {
                        ContentManagerImpl.this.setSelectedContent(current, true, true, !forcedFocus);
                    } else {
                        result.setDone();
                    }
                } else {
                    result.setDone();
                }
            }
        });
        ActionCallback actionCallback = result;
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "removeContent"));
        }
        return actionCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private ActionCallback removeContent(@NotNull Content content, boolean trackSelection, boolean dispose) {
        int newSize;
        int indexToSelect;
        int indexToBeRemoved;
        block28: {
            int selectedIndex;
            block27: {
                if (content == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/content/impl/ContentManagerImpl", "removeContent"));
                }
                ApplicationManager.getApplication().assertIsDispatchThread();
                indexToBeRemoved = this.getIndexOfContent(content);
                if (indexToBeRemoved == -1) {
                    ActionCallback actionCallback = ActionCallback.REJECTED;
                    if (actionCallback == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "removeContent"));
                    }
                    return actionCallback;
                }
                Content selection = this.mySelection.isEmpty() ? null : this.mySelection.get(this.mySelection.size() - 1);
                int n = selectedIndex = selection != null ? this.myContents.indexOf(selection) : -1;
                if (!this.fireContentRemoveQuery(content, indexToBeRemoved, ContentManagerEvent.ContentOperation.undefined)) {
                    ActionCallback actionCallback = ActionCallback.REJECTED;
                    ActionCallback actionCallback2 = actionCallback;
                    if (actionCallback2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "removeContent"));
                    }
                    return actionCallback2;
                }
                if (!content.isValid()) {
                    ActionCallback actionCallback = ActionCallback.REJECTED;
                    ActionCallback actionCallback3 = actionCallback;
                    if (actionCallback3 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "removeContent"));
                    }
                    return actionCallback3;
                }
                boolean wasSelected = this.isSelected(content);
                if (wasSelected) {
                    this.removeFromSelection(content);
                }
                indexToSelect = -1;
                if (!wasSelected) break block27;
                int i = indexToBeRemoved - 1;
                if (i >= 0) {
                    indexToSelect = i;
                    break block28;
                } else if (this.getContentCount() > 1) {
                    indexToSelect = 0;
                }
                break block28;
            }
            if (selectedIndex > indexToBeRemoved) {
                indexToSelect = selectedIndex - 1;
            }
        }
        this.mySelectionHistory.remove(content);
        this.myContents.remove(content);
        content.removePropertyChangeListener((PropertyChangeListener)this);
        this.fireContentRemoved(content, indexToBeRemoved);
        ((ContentImpl)content).setManager(null);
        if (dispose) {
            Disposer.dispose((Disposable)content);
        }
        if ((newSize = this.myContents.size()) > 0 && trackSelection) {
            ActionCallback result = new ActionCallback();
            if (indexToSelect > -1) {
                Content toSelect;
                Content content2 = toSelect = this.mySelectionHistory.size() > 0 ? this.mySelectionHistory.get(0) : this.myContents.get(indexToSelect);
                if (!this.isSelected(toSelect)) {
                    if (this.myUI.isSingleSelection()) {
                        this.setSelectedContentCB(toSelect).notify(result);
                    } else {
                        this.addSelectedContent(toSelect);
                        result.setDone();
                    }
                }
            }
            ActionCallback actionCallback = result;
            ActionCallback actionCallback4 = actionCallback;
            if (actionCallback4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "removeContent"));
            }
            return actionCallback4;
        }
        this.mySelection.clear();
        ActionCallback actionCallback = ActionCallback.DONE;
        ActionCallback actionCallback5 = actionCallback;
        if (actionCallback5 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "removeContent"));
        }
        return actionCallback5;
        finally {
            if (ApplicationManager.getApplication().isDispatchThread() && !this.myDisposed) {
                this.myUI.getComponent().updateUI();
            }
        }
    }

    public void removeAllContents(boolean dispose) {
        Content[] contents;
        for (Content content : contents = this.getContents()) {
            this.removeContent(content, dispose);
        }
    }

    public int getContentCount() {
        return this.myContents.size();
    }

    @NotNull
    public Content[] getContents() {
        Content[] contentArray = this.myContents.toArray(new Content[this.myContents.size()]);
        if (contentArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "getContents"));
        }
        return contentArray;
    }

    public Content findContent(String displayName) {
        for (Content content : this.myContents) {
            if (!content.getDisplayName().equals(displayName)) continue;
            return content;
        }
        return null;
    }

    public Content getContent(int index) {
        return index >= 0 && index < this.myContents.size() ? this.myContents.get(index) : null;
    }

    public Content getContent(JComponent component) {
        Content[] contents;
        for (Content content : contents = this.getContents()) {
            if (!Comparing.equal((Object)component, (Object)content.getComponent())) continue;
            return content;
        }
        return null;
    }

    public int getIndexOfContent(Content content) {
        return this.myContents.indexOf(content);
    }

    @NotNull
    public String getCloseActionName() {
        String string = this.myUI.getCloseActionName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "getCloseActionName"));
        }
        return string;
    }

    @NotNull
    public String getCloseAllButThisActionName() {
        String string = this.myUI.getCloseAllButThisActionName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "getCloseAllButThisActionName"));
        }
        return string;
    }

    @NotNull
    public String getPreviousContentActionName() {
        String string = this.myUI.getPreviousContentActionName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "getPreviousContentActionName"));
        }
        return string;
    }

    @NotNull
    public String getNextContentActionName() {
        String string = this.myUI.getNextContentActionName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "getNextContentActionName"));
        }
        return string;
    }

    public List<AnAction> getAdditionalPopupActions(@NotNull Content content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/content/impl/ContentManagerImpl", "getAdditionalPopupActions"));
        }
        return null;
    }

    public boolean canCloseAllContents() {
        if (!this.canCloseContents()) {
            return false;
        }
        for (Content content : this.myContents) {
            if (!content.isCloseable()) continue;
            return true;
        }
        return false;
    }

    public void addSelectedContent(@NotNull Content content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/content/impl/ContentManagerImpl", "addSelectedContent"));
        }
        if (!this.checkSelectionChangeShouldBeProcessed(content, false)) {
            return;
        }
        if (this.getIndexOfContent(content) == -1) {
            throw new IllegalArgumentException("content not found: " + content);
        }
        if (!this.isSelected(content)) {
            this.mySelection.add(content);
            this.fireSelectionChanged(content, ContentManagerEvent.ContentOperation.add);
        }
    }

    private boolean checkSelectionChangeShouldBeProcessed(Content content, boolean implicit) {
        if (!this.myUI.canChangeSelectionTo(content, implicit)) {
            return false;
        }
        boolean result = !this.isSelected(content) || this.myContentWithChangedComponent.contains(content);
        this.myContentWithChangedComponent.remove(content);
        return result;
    }

    public void removeFromSelection(@NotNull Content content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/content/impl/ContentManagerImpl", "removeFromSelection"));
        }
        if (!this.isSelected(content)) {
            return;
        }
        this.mySelection.remove(content);
        this.fireSelectionChanged(content, ContentManagerEvent.ContentOperation.remove);
    }

    public boolean isSelected(@NotNull Content content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/content/impl/ContentManagerImpl", "isSelected"));
        }
        return this.mySelection.contains(content);
    }

    @NotNull
    public Content[] getSelectedContents() {
        Content[] contentArray = this.mySelection.toArray(new Content[this.mySelection.size()]);
        if (contentArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "getSelectedContents"));
        }
        return contentArray;
    }

    @Nullable
    public Content getSelectedContent() {
        return this.mySelection.isEmpty() ? null : this.mySelection.get(0);
    }

    public void setSelectedContent(@NotNull Content content, boolean requestFocus) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/content/impl/ContentManagerImpl", "setSelectedContent"));
        }
        this.setSelectedContentCB(content, requestFocus);
    }

    @NotNull
    public ActionCallback setSelectedContentCB(@NotNull Content content, boolean requestFocus) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/content/impl/ContentManagerImpl", "setSelectedContentCB"));
        }
        ActionCallback actionCallback = this.setSelectedContentCB(content, requestFocus, true);
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "setSelectedContentCB"));
        }
        return actionCallback;
    }

    public void setSelectedContent(@NotNull Content content, boolean requestFocus, boolean forcedFocus) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/content/impl/ContentManagerImpl", "setSelectedContent"));
        }
        this.setSelectedContentCB(content, requestFocus, forcedFocus);
    }

    @NotNull
    public ActionCallback setSelectedContentCB(@NotNull Content content, boolean requestFocus, boolean forcedFocus) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/content/impl/ContentManagerImpl", "setSelectedContentCB"));
        }
        ActionCallback actionCallback = this.setSelectedContent(content, requestFocus, forcedFocus, false);
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "setSelectedContentCB"));
        }
        return actionCallback;
    }

    @NotNull
    public ActionCallback setSelectedContent(final @NotNull Content content, final boolean requestFocus, final boolean forcedFocus, boolean implicit) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/content/impl/ContentManagerImpl", "setSelectedContent"));
        }
        this.mySelectionHistory.remove(content);
        this.mySelectionHistory.add(0, content);
        if (this.isSelected(content) && requestFocus) {
            ActionCallback actionCallback = this.requestFocus(content, forcedFocus);
            if (actionCallback == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "setSelectedContent"));
            }
            return actionCallback;
        }
        if (!this.checkSelectionChangeShouldBeProcessed(content, implicit)) {
            ActionCallback actionCallback = ActionCallback.REJECTED;
            if (actionCallback == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "setSelectedContent"));
            }
            return actionCallback;
        }
        if (!this.myContents.contains(content)) {
            throw new IllegalArgumentException("Cannot find content:" + content.getDisplayName());
        }
        boolean focused = this.isSelectionHoldsFocus();
        final Content[] old = this.getSelectedContents();
        final ActiveRunnable selection = new ActiveRunnable(){

            @NotNull
            public ActionCallback run() {
                if (ContentManagerImpl.this.myDisposed || ContentManagerImpl.this.getIndexOfContent(content) == -1) {
                    ActionCallback actionCallback = ActionCallback.REJECTED;
                    if (actionCallback == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl$2", "run"));
                    }
                    return actionCallback;
                }
                for (Content each : old) {
                    ContentManagerImpl.this.removeFromSelection(each);
                }
                ContentManagerImpl.this.addSelectedContent(content);
                if (requestFocus) {
                    ActionCallback actionCallback = ContentManagerImpl.this.requestFocus(content, forcedFocus);
                    if (actionCallback == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl$2", "run"));
                    }
                    return actionCallback;
                }
                ActionCallback actionCallback = ActionCallback.DONE;
                if (actionCallback == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl$2", "run"));
                }
                return actionCallback;
            }
        };
        final ActionCallback result = new ActionCallback();
        boolean enabledFocus = this.getFocusManager().isFocusTransferEnabled();
        if (focused || requestFocus) {
            if (enabledFocus) {
                ActionCallback actionCallback = this.getFocusManager().requestFocus((Component)this.myFocusProxy, true).doWhenProcessed(new Runnable(){

                    @Override
                    public void run() {
                        selection.run().notify(result);
                    }
                });
                if (actionCallback == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "setSelectedContent"));
                }
                return actionCallback;
            }
            ActionCallback actionCallback = selection.run().notify(result);
            if (actionCallback == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "setSelectedContent"));
            }
            return actionCallback;
        }
        ActionCallback actionCallback = selection.run().notify(result);
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "setSelectedContent"));
        }
        return actionCallback;
    }

    private boolean isSelectionHoldsFocus() {
        Content[] selection;
        boolean focused = false;
        for (Content each : selection = this.getSelectedContents()) {
            if (!UIUtil.isFocusAncestor((JComponent)each.getComponent())) continue;
            focused = true;
            break;
        }
        return focused;
    }

    @NotNull
    public ActionCallback setSelectedContentCB(@NotNull Content content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/content/impl/ContentManagerImpl", "setSelectedContentCB"));
        }
        ActionCallback actionCallback = this.setSelectedContentCB(content, false);
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "setSelectedContentCB"));
        }
        return actionCallback;
    }

    public void setSelectedContent(@NotNull Content content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/content/impl/ContentManagerImpl", "setSelectedContent"));
        }
        this.setSelectedContentCB(content);
    }

    public ActionCallback selectPreviousContent() {
        int contentCount = this.getContentCount();
        LOG.assertTrue(contentCount > 1);
        Content selectedContent = this.getSelectedContent();
        int index = this.getIndexOfContent(selectedContent);
        index = (index - 1 + contentCount) % contentCount;
        Content content = this.getContent(index);
        if (content == null) {
            return null;
        }
        return this.setSelectedContentCB(content, true);
    }

    public ActionCallback selectNextContent() {
        int contentCount = this.getContentCount();
        LOG.assertTrue(contentCount > 1);
        Content selectedContent = this.getSelectedContent();
        int index = this.getIndexOfContent(selectedContent);
        index = (index + 1) % contentCount;
        Content content = this.getContent(index);
        if (content == null) {
            return null;
        }
        return this.setSelectedContentCB(content, true);
    }

    public void addContentManagerListener(@NotNull ContentManagerListener l) {
        if (l == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l", "com/intellij/ui/content/impl/ContentManagerImpl", "addContentManagerListener"));
        }
        this.myDispatcher.getListeners().add(0, l);
    }

    public void removeContentManagerListener(@NotNull ContentManagerListener l) {
        if (l == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l", "com/intellij/ui/content/impl/ContentManagerImpl", "removeContentManagerListener"));
        }
        this.myDispatcher.removeListener((EventListener)l);
    }

    private void fireContentAdded(Content content, int newIndex) {
        ContentManagerEvent e = new ContentManagerEvent((Object)this, content, newIndex, ContentManagerEvent.ContentOperation.add);
        ((ContentManagerListener)this.myDispatcher.getMulticaster()).contentAdded(e);
    }

    private void fireContentRemoved(Content content, int oldIndex) {
        ContentManagerEvent e = new ContentManagerEvent((Object)this, content, oldIndex, ContentManagerEvent.ContentOperation.remove);
        ((ContentManagerListener)this.myDispatcher.getMulticaster()).contentRemoved(e);
    }

    private void fireSelectionChanged(Content content, ContentManagerEvent.ContentOperation operation) {
        ContentManagerEvent e = new ContentManagerEvent((Object)this, content, this.getIndexOfContent(content), operation);
        ((ContentManagerListener)this.myDispatcher.getMulticaster()).selectionChanged(e);
    }

    private boolean fireContentRemoveQuery(Content content, int oldIndex, ContentManagerEvent.ContentOperation operation) {
        ContentManagerEvent event = new ContentManagerEvent((Object)this, content, oldIndex, operation);
        for (ContentManagerListener listener : this.myDispatcher.getListeners()) {
            listener.contentRemoveQuery(event);
            if (!event.isConsumed()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ActionCallback requestFocus(Content content, boolean forced) {
        Content toSelect;
        Content content2 = toSelect = content == null ? this.getSelectedContent() : content;
        if (toSelect == null) {
            ActionCallback actionCallback = ActionCallback.REJECTED;
            if (actionCallback == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "requestFocus"));
            }
            return actionCallback;
        }
        assert (this.myContents.contains(toSelect));
        ActionCallback actionCallback = this.getFocusManager().requestFocus(new FocusCommand(content, toSelect.getPreferredFocusableComponent()){

            @NotNull
            public ActionCallback run() {
                ActionCallback actionCallback = ContentManagerImpl.doRequestFocus(toSelect);
                if (actionCallback == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl$4", "run"));
                }
                return actionCallback;
            }
        }, forced);
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "requestFocus"));
        }
        return actionCallback;
    }

    private IdeFocusManager getFocusManager() {
        return IdeFocusManager.getInstance((Project)this.myProject);
    }

    private static ActionCallback doRequestFocus(Content toSelect) {
        JComponent toFocus = ContentManagerImpl.computeWillFocusComponent(toSelect);
        if (toFocus != null) {
            toFocus.requestFocus();
        }
        return ActionCallback.DONE;
    }

    private static JComponent computeWillFocusComponent(Content toSelect) {
        JComponent toFocus = toSelect.getPreferredFocusableComponent();
        if (toFocus != null) {
            toFocus = IdeFocusTraversalPolicy.getPreferredFocusedComponent(toFocus);
        }
        if (toFocus == null) {
            toFocus = toSelect.getPreferredFocusableComponent();
        }
        return toFocus;
    }

    public void addDataProvider(@NotNull DataProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/ui/content/impl/ContentManagerImpl", "addDataProvider"));
        }
        this.dataProviders.add(provider);
    }

    @Override
    public void propertyChange(@NotNull PropertyChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ui/content/impl/ContentManagerImpl", "propertyChange"));
        }
        if ("component".equals(event.getPropertyName())) {
            this.myContentWithChangedComponent.add((Content)event.getSource());
        }
    }

    @NotNull
    public ContentFactory getFactory() {
        ContentFactory contentFactory = (ContentFactory)ServiceManager.getService(ContentFactory.class);
        if (contentFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "getFactory"));
        }
        return contentFactory;
    }

    public void beforeTreeDispose() {
        this.myUI.beforeDispose();
    }

    public void dispose() {
        this.myDisposed = true;
        this.myContents.clear();
        this.mySelection.clear();
        this.myContentWithChangedComponent.clear();
        this.myUI = null;
        this.myDispatcher.getListeners().clear();
        this.dataProviders.clear();
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public boolean isSingleSelection() {
        return this.myUI.isSingleSelection();
    }

    private class MyContentComponent
    extends NonOpaquePanel
    implements SwitchProvider {
        private MyContentComponent() {
        }

        public List<SwitchTarget> getTargets(boolean onlyVisible, boolean originalProvider) {
            if (ContentManagerImpl.this.myUI instanceof SwitchProvider) {
                return ((SwitchProvider)ContentManagerImpl.this.myUI).getTargets(onlyVisible, false);
            }
            return new SmartList();
        }

        public SwitchTarget getCurrentTarget() {
            return ContentManagerImpl.this.myUI instanceof SwitchProvider ? ((SwitchProvider)ContentManagerImpl.this.myUI).getCurrentTarget() : null;
        }

        public JComponent getComponent() {
            return ContentManagerImpl.this.myUI instanceof SwitchProvider ? ContentManagerImpl.this.myUI.getComponent() : this;
        }

        public boolean isCycleRoot() {
            return ContentManagerImpl.this.myUI instanceof SwitchProvider && ((SwitchProvider)ContentManagerImpl.this.myUI).isCycleRoot();
        }
    }

    private class MyNonOpaquePanel
    extends NonOpaquePanel
    implements DataProvider {
        public MyNonOpaquePanel() {
            super((LayoutManager)new BorderLayout());
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            if (PlatformDataKeys.CONTENT_MANAGER.is(dataId) || PlatformDataKeys.NONEMPTY_CONTENT_MANAGER.is(dataId) && ContentManagerImpl.this.getContentCount() > 1) {
                return ContentManagerImpl.this;
            }
            for (DataProvider dataProvider : ContentManagerImpl.this.dataProviders) {
                Object data = dataProvider.getData(dataId);
                if (data == null) continue;
                return data;
            }
            if (ContentManagerImpl.this.myUI instanceof DataProvider) {
                return ((DataProvider)ContentManagerImpl.this.myUI).getData(dataId);
            }
            DataProvider provider = DataManager.getDataProvider((JComponent)((Object)this));
            return provider == null ? null : provider.getData(dataId);
        }
    }
}

