/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogHashMap;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.DataGetter;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.VcsCommitCache;
import com.intellij.vcs.log.ui.tables.GraphTableModel;
import com.intellij.vcs.log.util.SequentialLimitedLifoExecutor;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractDataGetter<T extends VcsShortCommitDetails>
implements Disposable,
DataGetter<T> {
    private static final Logger LOG = Logger.getInstance(AbstractDataGetter.class);
    private static final int UP_PRELOAD_COUNT = 20;
    private static final int DOWN_PRELOAD_COUNT = 40;
    private static final int MAX_LOADING_TASKS = 10;
    @NotNull
    protected final VcsLogHashMap myHashMap;
    @NotNull
    private final Map<VirtualFile, VcsLogProvider> myLogProviders;
    @NotNull
    private final VcsCommitCache<Integer, T> myCache;
    @NotNull
    private final SequentialLimitedLifoExecutor<TaskDescriptor> myLoader;
    private long myCurrentTaskIndex;
    @NotNull
    private final Collection<Runnable> myLoadingFinishedListeners;

    AbstractDataGetter(@NotNull VcsLogHashMap hashMap, @NotNull Map<VirtualFile, VcsLogProvider> logProviders, @NotNull VcsCommitCache<Integer, T> cache, @NotNull Disposable parentDisposable) {
        if (hashMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashMap", "com/intellij/vcs/log/data/AbstractDataGetter", "<init>"));
        }
        if (logProviders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logProviders", "com/intellij/vcs/log/data/AbstractDataGetter", "<init>"));
        }
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "com/intellij/vcs/log/data/AbstractDataGetter", "<init>"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/vcs/log/data/AbstractDataGetter", "<init>"));
        }
        this.myCurrentTaskIndex = 0L;
        this.myLoadingFinishedListeners = new ArrayList<Runnable>();
        this.myHashMap = hashMap;
        this.myLogProviders = logProviders;
        this.myCache = cache;
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.myLoader = new SequentialLimitedLifoExecutor<TaskDescriptor>(this, 10, new ThrowableConsumer<TaskDescriptor, VcsException>(){

            public void consume(TaskDescriptor task) throws VcsException {
                AbstractDataGetter.this.preLoadCommitData((MultiMap<VirtualFile, Integer>)task.myCommits);
                AbstractDataGetter.this.notifyLoaded();
            }
        });
    }

    private void notifyLoaded() {
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                for (Runnable loadingFinishedListener : AbstractDataGetter.this.myLoadingFinishedListeners) {
                    loadingFinishedListener.run();
                }
            }
        });
    }

    public void dispose() {
        this.myLoadingFinishedListeners.clear();
    }

    @Override
    @NotNull
    public T getCommitData(int row, @NotNull GraphTableModel tableModel) {
        if (tableModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tableModel", "com/intellij/vcs/log/data/AbstractDataGetter", "getCommitData"));
        }
        assert (EventQueue.isDispatchThread());
        Integer hash = tableModel.getIdAtRow(row);
        T details = this.getFromCache(hash);
        if (details != null) {
            T t = details;
            if (t == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/AbstractDataGetter", "getCommitData"));
            }
            return t;
        }
        this.runLoadCommitsData(tableModel, AbstractDataGetter.createRowsIterable(row, 20, 40, tableModel.getRowCount()));
        T result = this.myCache.get(hash);
        assert (result != null);
        T t = result;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/AbstractDataGetter", "getCommitData"));
        }
        return t;
    }

    private static Iterable<Integer> createRowsIterable(final int row, final int above, final int below, final int maxRows) {
        return new Iterable<Integer>(){

            @Override
            @NotNull
            public Iterator<Integer> iterator() {
                Iterator<Integer> iterator = new Iterator<Integer>(){
                    private int myIndex;
                    {
                        this.myIndex = Math.max(0, row - above);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.myIndex < row + below && this.myIndex < maxRows;
                    }

                    @Override
                    public Integer next() {
                        int next = this.myIndex++;
                        return next;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Removing elements is not supported.");
                    }
                };
                if (iterator == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/AbstractDataGetter$3", "iterator"));
                }
                return iterator;
            }
        };
    }

    @Override
    public void loadCommitsData(@NotNull List<Integer> rows, @NotNull GraphTableModel tableModel, @NotNull Consumer<List<T>> consumer, @Nullable ProgressIndicator indicator) {
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/vcs/log/data/AbstractDataGetter", "loadCommitsData"));
        }
        if (tableModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tableModel", "com/intellij/vcs/log/data/AbstractDataGetter", "loadCommitsData"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/vcs/log/data/AbstractDataGetter", "loadCommitsData"));
        }
        assert (EventQueue.isDispatchThread());
        this.loadCommitsData(AbstractDataGetter.getCommitsForRows(rows, tableModel), consumer, indicator);
    }

    private void loadCommitsData(final @NotNull Map<Pair<VirtualFile, Integer>, Integer> commits, final @NotNull Consumer<List<T>> consumer, @Nullable ProgressIndicator indicator) {
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "com/intellij/vcs/log/data/AbstractDataGetter", "loadCommitsData"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/vcs/log/data/AbstractDataGetter", "loadCommitsData"));
        }
        final ArrayList result = ContainerUtil.newArrayList();
        final MultiMap toLoad = MultiMap.create();
        long taskNumber = this.myCurrentTaskIndex++;
        for (Pair<VirtualFile, Integer> rootAndCommit : commits.keySet()) {
            VirtualFile root = (VirtualFile)rootAndCommit.getFirst();
            Integer commitId = (Integer)rootAndCommit.getSecond();
            T details = this.getFromCache(commitId);
            if (details == null || details instanceof LoadingDetails) {
                toLoad.putValue((Object)root, (Object)commitId);
                this.cacheCommit(commitId, root, taskNumber);
                continue;
            }
            result.add(details);
        }
        if (toLoad.isEmpty()) {
            this.sortCommitsByRow(result, commits);
            consumer.consume((Object)result);
        } else {
            Task.Backgroundable task = new Task.Backgroundable(null, "Loading Selected Details", true, PerformInBackgroundOption.ALWAYS_BACKGROUND){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/vcs/log/data/AbstractDataGetter$4", "run"));
                    }
                    indicator.checkCanceled();
                    try {
                        result.addAll(AbstractDataGetter.this.preLoadCommitData((MultiMap<VirtualFile, Integer>)toLoad));
                        AbstractDataGetter.this.sortCommitsByRow(result, commits);
                        AbstractDataGetter.this.notifyLoaded();
                    }
                    catch (VcsException e) {
                        LOG.error((Throwable)e);
                    }
                }

                public void onSuccess() {
                    consumer.consume((Object)result);
                }
            };
            if (indicator != null) {
                ProgressManager.getInstance().runProcessWithProgressAsynchronously(task, indicator);
            } else {
                ProgressManager.getInstance().run((Task)task);
            }
        }
    }

    private void sortCommitsByRow(@NotNull List<T> result, final @NotNull Map<Pair<VirtualFile, Integer>, Integer> rowsForCommits) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/vcs/log/data/AbstractDataGetter", "sortCommitsByRow"));
        }
        if (rowsForCommits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rowsForCommits", "com/intellij/vcs/log/data/AbstractDataGetter", "sortCommitsByRow"));
        }
        ContainerUtil.sort(result, (Comparator)new Comparator<T>(){

            @Override
            public int compare(T details1, T details2) {
                Integer row1 = (Integer)rowsForCommits.get(Pair.create((Object)details1.getRoot(), (Object)AbstractDataGetter.this.myHashMap.getCommitIndex((Hash)details1.getId(), details1.getRoot())));
                Integer row2 = (Integer)rowsForCommits.get(Pair.create((Object)details2.getRoot(), (Object)AbstractDataGetter.this.myHashMap.getCommitIndex((Hash)details2.getId(), details2.getRoot())));
                return Comparing.compare((Comparable)row1, (Comparable)row2);
            }
        });
    }

    @Override
    @Nullable
    public T getCommitDataIfAvailable(int hash) {
        return this.getFromCache(hash);
    }

    @Nullable
    private T getFromCache(@NotNull Integer commitId) {
        if (commitId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitId", "com/intellij/vcs/log/data/AbstractDataGetter", "getFromCache"));
        }
        T details = this.myCache.get(commitId);
        if (details != null) {
            if (details instanceof LoadingDetails && ((LoadingDetails)details).getLoadingTaskIndex() <= this.myCurrentTaskIndex - 10L) {
                this.myCache.remove(commitId);
                return null;
            }
            return details;
        }
        return this.getFromAdditionalCache(commitId);
    }

    @Nullable
    protected abstract T getFromAdditionalCache(int var1);

    private void runLoadCommitsData(@NotNull GraphTableModel tableModel, @NotNull Iterable<Integer> rows) {
        if (tableModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tableModel", "com/intellij/vcs/log/data/AbstractDataGetter", "runLoadCommitsData"));
        }
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/vcs/log/data/AbstractDataGetter", "runLoadCommitsData"));
        }
        long taskNumber = this.myCurrentTaskIndex++;
        Map<Pair<VirtualFile, Integer>, Integer> commits = AbstractDataGetter.getCommitsForRows(rows, tableModel);
        MultiMap toLoad = MultiMap.create();
        for (Pair<VirtualFile, Integer> rootAndCommit : commits.keySet()) {
            VirtualFile root = (VirtualFile)rootAndCommit.getFirst();
            Integer commitId = (Integer)rootAndCommit.getSecond();
            this.cacheCommit(commitId, root, taskNumber);
            toLoad.putValue((Object)root, (Object)commitId);
        }
        this.myLoader.queue(new TaskDescriptor(toLoad));
    }

    private void cacheCommit(final int commitId, VirtualFile root, long taskNumber) {
        if (!this.myCache.isKeyCached(commitId)) {
            this.myCache.put(commitId, new LoadingDetails(new Computable<Hash>(){

                public Hash compute() {
                    return AbstractDataGetter.this.myHashMap.getCommitId(commitId).getHash();
                }
            }, taskNumber, root));
        }
    }

    @NotNull
    private static Map<Pair<VirtualFile, Integer>, Integer> getCommitsForRows(@NotNull Iterable<Integer> rows, @NotNull GraphTableModel model) {
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/vcs/log/data/AbstractDataGetter", "getCommitsForRows"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/vcs/log/data/AbstractDataGetter", "getCommitsForRows"));
        }
        HashMap commits = ContainerUtil.newHashMap();
        for (int row : rows) {
            Integer commitId = model.getIdAtRow(row);
            VirtualFile root = model.getRoot(row);
            commits.put(Pair.create((Object)root, (Object)commitId), row);
        }
        HashMap hashMap = commits;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/AbstractDataGetter", "getCommitsForRows"));
        }
        return hashMap;
    }

    private Set<T> preLoadCommitData(@NotNull MultiMap<VirtualFile, Integer> commits) throws VcsException {
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "com/intellij/vcs/log/data/AbstractDataGetter", "preLoadCommitData"));
        }
        HashSet result = ContainerUtil.newHashSet();
        for (Map.Entry entry : commits.entrySet()) {
            List hashStrings = ContainerUtil.map((Collection)((Collection)entry.getValue()), (Function)new Function<Integer, String>(){

                public String fun(Integer commitId) {
                    return AbstractDataGetter.this.myHashMap.getCommitId(commitId).getHash().asString();
                }
            });
            List<T> details = this.readDetails(this.myLogProviders.get(entry.getKey()), (VirtualFile)entry.getKey(), hashStrings);
            result.addAll(details);
            this.saveInCache(details);
        }
        return result;
    }

    public void saveInCache(final List<? extends T> details) {
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                for (VcsShortCommitDetails data : details) {
                    AbstractDataGetter.this.myCache.put(AbstractDataGetter.this.myHashMap.getCommitIndex((Hash)data.getId(), data.getRoot()), data);
                }
            }
        });
    }

    @NotNull
    protected abstract List<? extends T> readDetails(@NotNull VcsLogProvider var1, @NotNull VirtualFile var2, @NotNull List<String> var3) throws VcsException;

    public void addDetailsLoadedListener(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/vcs/log/data/AbstractDataGetter", "addDetailsLoadedListener"));
        }
        this.myLoadingFinishedListeners.add(runnable2);
    }

    private static class TaskDescriptor {
        @NotNull
        private final MultiMap<VirtualFile, Integer> myCommits;

        private TaskDescriptor(@NotNull MultiMap<VirtualFile, Integer> commits) {
            if (commits == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "com/intellij/vcs/log/data/AbstractDataGetter$TaskDescriptor", "<init>"));
            }
            this.myCommits = commits;
        }
    }
}

